/*
 * Decompiled with CFR 0.152.
 */
package ca.sqlpower.architect.transformation;

import ca.sqlpower.architect.transformation.ReportTransformer;
import ca.sqlpower.architect.transformation.UnknowTemplateTypeException;
import ca.sqlpower.architect.transformation.VelocityTransformation;
import ca.sqlpower.architect.transformation.XsltTransformation;
import java.io.File;

public class TransformerFactory {
    public static ReportTransformer getTransformer(File template) throws UnknowTemplateTypeException {
        if (template == null) {
            return new XsltTransformation();
        }
        String fullname = template.getAbsolutePath();
        int pos = fullname.lastIndexOf(46);
        if (pos == -1) {
            throw new UnknowTemplateTypeException();
        }
        String ext = fullname.substring(pos + 1).toLowerCase();
        if (ext.equals("xslt") || ext.equals("xsl")) {
            return new XsltTransformation();
        }
        if (ext.equals("vm")) {
            return new VelocityTransformation();
        }
        throw new UnknowTemplateTypeException();
    }
}

