require '_h2ph_pre.ph';

no warnings qw(redefine misc);

unless(defined(&HEADER_OCSP_H)) {
    eval 'sub HEADER_OCSP_H () {1;}' unless defined(&HEADER_OCSP_H);
    require 'openssl/ossl_typ.ph';
    require 'openssl/x509.ph';
    require 'openssl/x509v3.ph';
    require 'openssl/safestack.ph';
    if(defined(&__cplusplus)) {
    }
    eval 'sub OCSP_DEFAULT_NONCE_LENGTH () {16;}' unless defined(&OCSP_DEFAULT_NONCE_LENGTH);
    eval 'sub OCSP_NOCERTS () {0x1;}' unless defined(&OCSP_NOCERTS);
    eval 'sub OCSP_NOINTERN () {0x2;}' unless defined(&OCSP_NOINTERN);
    eval 'sub OCSP_NOSIGS () {0x4;}' unless defined(&OCSP_NOSIGS);
    eval 'sub OCSP_NOCHAIN () {0x8;}' unless defined(&OCSP_NOCHAIN);
    eval 'sub OCSP_NOVERIFY () {0x10;}' unless defined(&OCSP_NOVERIFY);
    eval 'sub OCSP_NOEXPLICIT () {0x20;}' unless defined(&OCSP_NOEXPLICIT);
    eval 'sub OCSP_NOCASIGN () {0x40;}' unless defined(&OCSP_NOCASIGN);
    eval 'sub OCSP_NODELEGATED () {0x80;}' unless defined(&OCSP_NODELEGATED);
    eval 'sub OCSP_NOCHECKS () {0x100;}' unless defined(&OCSP_NOCHECKS);
    eval 'sub OCSP_TRUSTOTHER () {0x200;}' unless defined(&OCSP_TRUSTOTHER);
    eval 'sub OCSP_RESPID_KEY () {0x400;}' unless defined(&OCSP_RESPID_KEY);
    eval 'sub OCSP_NOTIME () {0x800;}' unless defined(&OCSP_NOTIME);
    eval 'sub OCSP_RESPONSE_STATUS_SUCCESSFUL () {0;}' unless defined(&OCSP_RESPONSE_STATUS_SUCCESSFUL);
    eval 'sub OCSP_RESPONSE_STATUS_MALFORMEDREQUEST () {1;}' unless defined(&OCSP_RESPONSE_STATUS_MALFORMEDREQUEST);
    eval 'sub OCSP_RESPONSE_STATUS_INTERNALERROR () {2;}' unless defined(&OCSP_RESPONSE_STATUS_INTERNALERROR);
    eval 'sub OCSP_RESPONSE_STATUS_TRYLATER () {3;}' unless defined(&OCSP_RESPONSE_STATUS_TRYLATER);
    eval 'sub OCSP_RESPONSE_STATUS_SIGREQUIRED () {5;}' unless defined(&OCSP_RESPONSE_STATUS_SIGREQUIRED);
    eval 'sub OCSP_RESPONSE_STATUS_UNAUTHORIZED () {6;}' unless defined(&OCSP_RESPONSE_STATUS_UNAUTHORIZED);
    eval 'sub V_OCSP_RESPID_NAME () {0;}' unless defined(&V_OCSP_RESPID_NAME);
    eval 'sub V_OCSP_RESPID_KEY () {1;}' unless defined(&V_OCSP_RESPID_KEY);
    eval 'sub V_OCSP_CERTSTATUS_GOOD () {0;}' unless defined(&V_OCSP_CERTSTATUS_GOOD);
    eval 'sub V_OCSP_CERTSTATUS_REVOKED () {1;}' unless defined(&V_OCSP_CERTSTATUS_REVOKED);
    eval 'sub V_OCSP_CERTSTATUS_UNKNOWN () {2;}' unless defined(&V_OCSP_CERTSTATUS_UNKNOWN);
    eval 'sub OCSP_REVOKED_STATUS_NOSTATUS () {-1;}' unless defined(&OCSP_REVOKED_STATUS_NOSTATUS);
    eval 'sub OCSP_REVOKED_STATUS_UNSPECIFIED () {0;}' unless defined(&OCSP_REVOKED_STATUS_UNSPECIFIED);
    eval 'sub OCSP_REVOKED_STATUS_KEYCOMPROMISE () {1;}' unless defined(&OCSP_REVOKED_STATUS_KEYCOMPROMISE);
    eval 'sub OCSP_REVOKED_STATUS_CACOMPROMISE () {2;}' unless defined(&OCSP_REVOKED_STATUS_CACOMPROMISE);
    eval 'sub OCSP_REVOKED_STATUS_AFFILIATIONCHANGED () {3;}' unless defined(&OCSP_REVOKED_STATUS_AFFILIATIONCHANGED);
    eval 'sub OCSP_REVOKED_STATUS_SUPERSEDED () {4;}' unless defined(&OCSP_REVOKED_STATUS_SUPERSEDED);
    eval 'sub OCSP_REVOKED_STATUS_CESSATIONOFOPERATION () {5;}' unless defined(&OCSP_REVOKED_STATUS_CESSATIONOFOPERATION);
    eval 'sub OCSP_REVOKED_STATUS_CERTIFICATEHOLD () {6;}' unless defined(&OCSP_REVOKED_STATUS_CERTIFICATEHOLD);
    eval 'sub OCSP_REVOKED_STATUS_REMOVEFROMCRL () {8;}' unless defined(&OCSP_REVOKED_STATUS_REMOVEFROMCRL);
    eval 'sub PEM_STRING_OCSP_REQUEST () {"OCSP REQUEST";}' unless defined(&PEM_STRING_OCSP_REQUEST);
    eval 'sub PEM_STRING_OCSP_RESPONSE () {"OCSP RESPONSE";}' unless defined(&PEM_STRING_OCSP_RESPONSE);
    eval 'sub d2i_OCSP_REQUEST_bio {
        my($bp,$p) = @_;
	    eval q( &ASN1_d2i_bio_of( &OCSP_REQUEST, &OCSP_REQUEST_new, &d2i_OCSP_REQUEST,$bp,$p));
    }' unless defined(&d2i_OCSP_REQUEST_bio);
    eval 'sub d2i_OCSP_RESPONSE_bio {
        my($bp,$p) = @_;
	    eval q( &ASN1_d2i_bio_of( &OCSP_RESPONSE, &OCSP_RESPONSE_new, &d2i_OCSP_RESPONSE,$bp,$p));
    }' unless defined(&d2i_OCSP_RESPONSE_bio);
    eval 'sub PEM_read_bio_OCSP_REQUEST {
        my($bp,$x,$cb) = @_;
	    eval q(( &OCSP_REQUEST *) &PEM_ASN1_read_bio((\'char\' *(*)()) &d2i_OCSP_REQUEST,  &PEM_STRING_OCSP_REQUEST,$bp,$x,$cb, &NULL));
    }' unless defined(&PEM_read_bio_OCSP_REQUEST);
    eval 'sub PEM_read_bio_OCSP_RESPONSE {
        my($bp,$x,$cb) = @_;
	    eval q(( &OCSP_RESPONSE *) &PEM_ASN1_read_bio((\'char\' *(*)()) &d2i_OCSP_RESPONSE,  &PEM_STRING_OCSP_RESPONSE,$bp,$x,$cb, &NULL));
    }' unless defined(&PEM_read_bio_OCSP_RESPONSE);
    eval 'sub PEM_write_bio_OCSP_REQUEST {
        my($bp,$o) = @_;
	    eval q( &PEM_ASN1_write_bio(( &int (*)()) &i2d_OCSP_REQUEST, &PEM_STRING_OCSP_REQUEST, $bp,$o,  &NULL, &NULL,0, &NULL, &NULL));
    }' unless defined(&PEM_write_bio_OCSP_REQUEST);
    eval 'sub PEM_write_bio_OCSP_RESPONSE {
        my($bp,$o) = @_;
	    eval q( &PEM_ASN1_write_bio(( &int (*)()) &i2d_OCSP_RESPONSE, &PEM_STRING_OCSP_RESPONSE, $bp,$o,  &NULL, &NULL,0, &NULL, &NULL));
    }' unless defined(&PEM_write_bio_OCSP_RESPONSE);
    eval 'sub i2d_OCSP_RESPONSE_bio {
        my($bp,$o) = @_;
	    eval q( &ASN1_i2d_bio_of( &OCSP_RESPONSE, &i2d_OCSP_RESPONSE,$bp,$o));
    }' unless defined(&i2d_OCSP_RESPONSE_bio);
    eval 'sub i2d_OCSP_REQUEST_bio {
        my($bp,$o) = @_;
	    eval q( &ASN1_i2d_bio_of( &OCSP_REQUEST, &i2d_OCSP_REQUEST,$bp,$o));
    }' unless defined(&i2d_OCSP_REQUEST_bio);
    eval 'sub OCSP_REQUEST_sign {
        my($o,$pkey,$md) = @_;
	    eval q( &ASN1_item_sign( &ASN1_ITEM_rptr( &OCSP_REQINFO),  ($o->{optionalSignature}->{signatureAlgorithm}), &NULL,  ($o->{optionalSignature}->{signature}), ($o->{tbsRequest}),$pkey,$md));
    }' unless defined(&OCSP_REQUEST_sign);
    eval 'sub OCSP_BASICRESP_sign {
        my($o,$pkey,$md,$d) = @_;
	    eval q( &ASN1_item_sign( &ASN1_ITEM_rptr( &OCSP_RESPDATA), ($o->{signatureAlgorithm}), &NULL,  ($o->{signature}), ($o->{tbsResponseData}),$pkey,$md));
    }' unless defined(&OCSP_BASICRESP_sign);
    eval 'sub OCSP_REQUEST_verify {
        my($a,$r) = @_;
	    eval q( &ASN1_item_verify( &ASN1_ITEM_rptr( &OCSP_REQINFO),  ($a->{optionalSignature}->{signatureAlgorithm}),  ($a->{optionalSignature}->{signature}), ($a->{tbsRequest}),$r));
    }' unless defined(&OCSP_REQUEST_verify);
    eval 'sub OCSP_BASICRESP_verify {
        my($a,$r,$d) = @_;
	    eval q( &ASN1_item_verify( &ASN1_ITEM_rptr( &OCSP_RESPDATA),  ($a->{signatureAlgorithm}), ($a->{signature}), ($a->{tbsResponseData}),$r));
    }' unless defined(&OCSP_BASICRESP_verify);
    eval 'sub ASN1_BIT_STRING_digest {
        my($data,$type,$md,$len) = @_;
	    eval q( &ASN1_item_digest( &ASN1_ITEM_rptr( &ASN1_BIT_STRING),$type,$data,$md,$len));
    }' unless defined(&ASN1_BIT_STRING_digest);
    eval 'sub OCSP_CERTSTATUS_dup {
        my($cs) = @_;
	    eval q( &ASN1_item_dup( &OCSP_CERTSTATUS_it, $cs));
    }' unless defined(&OCSP_CERTSTATUS_dup);
    eval 'sub OCSP_F_ASN1_STRING_ENCODE () {100;}' unless defined(&OCSP_F_ASN1_STRING_ENCODE);
    eval 'sub OCSP_F_D2I_OCSP_NONCE () {102;}' unless defined(&OCSP_F_D2I_OCSP_NONCE);
    eval 'sub OCSP_F_OCSP_BASIC_ADD1_STATUS () {103;}' unless defined(&OCSP_F_OCSP_BASIC_ADD1_STATUS);
    eval 'sub OCSP_F_OCSP_BASIC_SIGN () {104;}' unless defined(&OCSP_F_OCSP_BASIC_SIGN);
    eval 'sub OCSP_F_OCSP_BASIC_VERIFY () {105;}' unless defined(&OCSP_F_OCSP_BASIC_VERIFY);
    eval 'sub OCSP_F_OCSP_CERT_ID_NEW () {101;}' unless defined(&OCSP_F_OCSP_CERT_ID_NEW);
    eval 'sub OCSP_F_OCSP_CHECK_DELEGATED () {106;}' unless defined(&OCSP_F_OCSP_CHECK_DELEGATED);
    eval 'sub OCSP_F_OCSP_CHECK_IDS () {107;}' unless defined(&OCSP_F_OCSP_CHECK_IDS);
    eval 'sub OCSP_F_OCSP_CHECK_ISSUER () {108;}' unless defined(&OCSP_F_OCSP_CHECK_ISSUER);
    eval 'sub OCSP_F_OCSP_CHECK_VALIDITY () {115;}' unless defined(&OCSP_F_OCSP_CHECK_VALIDITY);
    eval 'sub OCSP_F_OCSP_MATCH_ISSUERID () {109;}' unless defined(&OCSP_F_OCSP_MATCH_ISSUERID);
    eval 'sub OCSP_F_OCSP_PARSE_URL () {114;}' unless defined(&OCSP_F_OCSP_PARSE_URL);
    eval 'sub OCSP_F_OCSP_REQUEST_SIGN () {110;}' unless defined(&OCSP_F_OCSP_REQUEST_SIGN);
    eval 'sub OCSP_F_OCSP_REQUEST_VERIFY () {116;}' unless defined(&OCSP_F_OCSP_REQUEST_VERIFY);
    eval 'sub OCSP_F_OCSP_RESPONSE_GET1_BASIC () {111;}' unless defined(&OCSP_F_OCSP_RESPONSE_GET1_BASIC);
    eval 'sub OCSP_F_OCSP_SENDREQ_BIO () {112;}' unless defined(&OCSP_F_OCSP_SENDREQ_BIO);
    eval 'sub OCSP_F_OCSP_SENDREQ_NBIO () {117;}' unless defined(&OCSP_F_OCSP_SENDREQ_NBIO);
    eval 'sub OCSP_F_PARSE_HTTP_LINE1 () {118;}' unless defined(&OCSP_F_PARSE_HTTP_LINE1);
    eval 'sub OCSP_F_REQUEST_VERIFY () {113;}' unless defined(&OCSP_F_REQUEST_VERIFY);
    eval 'sub OCSP_R_BAD_DATA () {100;}' unless defined(&OCSP_R_BAD_DATA);
    eval 'sub OCSP_R_CERTIFICATE_VERIFY_ERROR () {101;}' unless defined(&OCSP_R_CERTIFICATE_VERIFY_ERROR);
    eval 'sub OCSP_R_DIGEST_ERR () {102;}' unless defined(&OCSP_R_DIGEST_ERR);
    eval 'sub OCSP_R_ERROR_IN_NEXTUPDATE_FIELD () {122;}' unless defined(&OCSP_R_ERROR_IN_NEXTUPDATE_FIELD);
    eval 'sub OCSP_R_ERROR_IN_THISUPDATE_FIELD () {123;}' unless defined(&OCSP_R_ERROR_IN_THISUPDATE_FIELD);
    eval 'sub OCSP_R_ERROR_PARSING_URL () {121;}' unless defined(&OCSP_R_ERROR_PARSING_URL);
    eval 'sub OCSP_R_MISSING_OCSPSIGNING_USAGE () {103;}' unless defined(&OCSP_R_MISSING_OCSPSIGNING_USAGE);
    eval 'sub OCSP_R_NEXTUPDATE_BEFORE_THISUPDATE () {124;}' unless defined(&OCSP_R_NEXTUPDATE_BEFORE_THISUPDATE);
    eval 'sub OCSP_R_NOT_BASIC_RESPONSE () {104;}' unless defined(&OCSP_R_NOT_BASIC_RESPONSE);
    eval 'sub OCSP_R_NO_CERTIFICATES_IN_CHAIN () {105;}' unless defined(&OCSP_R_NO_CERTIFICATES_IN_CHAIN);
    eval 'sub OCSP_R_NO_CONTENT () {106;}' unless defined(&OCSP_R_NO_CONTENT);
    eval 'sub OCSP_R_NO_PUBLIC_KEY () {107;}' unless defined(&OCSP_R_NO_PUBLIC_KEY);
    eval 'sub OCSP_R_NO_RESPONSE_DATA () {108;}' unless defined(&OCSP_R_NO_RESPONSE_DATA);
    eval 'sub OCSP_R_NO_REVOKED_TIME () {109;}' unless defined(&OCSP_R_NO_REVOKED_TIME);
    eval 'sub OCSP_R_PRIVATE_KEY_DOES_NOT_MATCH_CERTIFICATE () {110;}' unless defined(&OCSP_R_PRIVATE_KEY_DOES_NOT_MATCH_CERTIFICATE);
    eval 'sub OCSP_R_REQUEST_NOT_SIGNED () {128;}' unless defined(&OCSP_R_REQUEST_NOT_SIGNED);
    eval 'sub OCSP_R_RESPONSE_CONTAINS_NO_REVOCATION_DATA () {111;}' unless defined(&OCSP_R_RESPONSE_CONTAINS_NO_REVOCATION_DATA);
    eval 'sub OCSP_R_ROOT_CA_NOT_TRUSTED () {112;}' unless defined(&OCSP_R_ROOT_CA_NOT_TRUSTED);
    eval 'sub OCSP_R_SERVER_READ_ERROR () {113;}' unless defined(&OCSP_R_SERVER_READ_ERROR);
    eval 'sub OCSP_R_SERVER_RESPONSE_ERROR () {114;}' unless defined(&OCSP_R_SERVER_RESPONSE_ERROR);
    eval 'sub OCSP_R_SERVER_RESPONSE_PARSE_ERROR () {115;}' unless defined(&OCSP_R_SERVER_RESPONSE_PARSE_ERROR);
    eval 'sub OCSP_R_SERVER_WRITE_ERROR () {116;}' unless defined(&OCSP_R_SERVER_WRITE_ERROR);
    eval 'sub OCSP_R_SIGNATURE_FAILURE () {117;}' unless defined(&OCSP_R_SIGNATURE_FAILURE);
    eval 'sub OCSP_R_SIGNER_CERTIFICATE_NOT_FOUND () {118;}' unless defined(&OCSP_R_SIGNER_CERTIFICATE_NOT_FOUND);
    eval 'sub OCSP_R_STATUS_EXPIRED () {125;}' unless defined(&OCSP_R_STATUS_EXPIRED);
    eval 'sub OCSP_R_STATUS_NOT_YET_VALID () {126;}' unless defined(&OCSP_R_STATUS_NOT_YET_VALID);
    eval 'sub OCSP_R_STATUS_TOO_OLD () {127;}' unless defined(&OCSP_R_STATUS_TOO_OLD);
    eval 'sub OCSP_R_UNKNOWN_MESSAGE_DIGEST () {119;}' unless defined(&OCSP_R_UNKNOWN_MESSAGE_DIGEST);
    eval 'sub OCSP_R_UNKNOWN_NID () {120;}' unless defined(&OCSP_R_UNKNOWN_NID);
    eval 'sub OCSP_R_UNSUPPORTED_REQUESTORNAME_TYPE () {129;}' unless defined(&OCSP_R_UNSUPPORTED_REQUESTORNAME_TYPE);
    if(defined(&__cplusplus)) {
    }
}
1;
