untrusted comment: signature from openbsd 5.7 base secret key
RWSvUZXnw9gUb7LsFgSrQ2cEEMLLd5O+80Cq0cAPVVKWxX+D8JdSRVKs/Vg4KOCUdPQ2smJZwK/ESOvPxY90Yiw1gpElQgHNQgk=

OpenBSD 5.7 errata 5, Apr 30, 2015:

Logging to a log file is only possible after the logging system was
initialized. Trying to log too early allows a remote user to crash
httpd.

Apply by doing:
    cd /usr/src
    signify -Vep /etc/signify/openbsd-57-base.pub -x 005_httpd.patch.sig -m - | \
        patch -p0

And then rebuild and install httpd:
    cd usr.sbin/httpd
    make obj
    make
    make install

Index: usr.sbin/httpd/server.c
===================================================================
RCS file: /cvs/src/usr.sbin/httpd/server.c,v
retrieving revision 1.60
diff -u -p -r1.60 server.c
--- usr.sbin/httpd/server.c	23 Feb 2015 09:52:28 -0000	1.60
+++ usr.sbin/httpd/server.c	23 Apr 2015 17:32:46 -0000
@@ -851,6 +851,11 @@ server_accept(int fd, short event, void 
 	if ((clt = calloc(1, sizeof(*clt))) == NULL)
 		goto err;
 
+	/* Pre-allocate log buffer */
+	clt->clt_log = evbuffer_new();
+	if (clt->clt_log == NULL)
+		goto err;
+
 	clt->clt_s = s;
 	clt->clt_fd = -1;
 	clt->clt_toread = TOREAD_UNLIMITED;
@@ -895,13 +900,6 @@ server_accept(int fd, short event, void 
 	clt->clt_output = evbuffer_new();
 	if (clt->clt_output == NULL) {
 		server_close(clt, "failed to allocate output buffer");
-		return;
-	}
-
-	/* Pre-allocate log buffer */
-	clt->clt_log = evbuffer_new();
-	if (clt->clt_log == NULL) {
-		server_close(clt, "failed to allocate log buffer");
 		return;
 	}
 
