untrusted comment: signature from openbsd 5.5 base secret key
RWRGy8gxk9N93z0uERun06gnUvsfcC1KpQB7tmX6DIhpmLZG9J7BRtekstcTAujL+VXaTpreU58UMTDACvJT4LRjREzVnZWcoA0=

OpenBSD 5.5 errata 12, Oct 20, 2014

Two remotely triggerable memory leaks in OpenSSL can lead to a denial of
service in server applications.

Apply patch using:

    signify -Vep /etc/signify/openbsd-55-base.pub -x 012_openssl.patch.sig \
	-m - | (cd /usr/src && patch -p0)

Then build and install libssl

    cd /usr/src/lib/libssl/ssl
    make obj
    make
    make install


Index: lib/libssl/src/ssl/d1_srtp.c
===================================================================
RCS file: /cvs/src/lib/libssl/src/ssl/d1_srtp.c,v
retrieving revision 1.1.1.1
diff -u -p -r1.1.1.1 d1_srtp.c
--- lib/libssl/src/ssl/d1_srtp.c	13 Oct 2012 21:23:49 -0000	1.1.1.1
+++ lib/libssl/src/ssl/d1_srtp.c	17 Oct 2014 19:57:51 -0000
@@ -213,6 +213,7 @@ static int ssl_ctx_make_profiles(const c
 		else
 			{
 			SSLerr(SSL_F_SSL_CTX_MAKE_PROFILES,SSL_R_SRTP_UNKNOWN_PROTECTION_PROFILE);
+			sk_SRTP_PROTECTION_PROFILE_free(profiles);
 			return 1;
 			}
 
Index: lib/libssl/src/ssl/t1_lib.c
===================================================================
RCS file: /cvs/src/lib/libssl/src/ssl/t1_lib.c,v
retrieving revision 1.12.8.2
diff -u -p -r1.12.8.2 t1_lib.c
--- lib/libssl/src/ssl/t1_lib.c	9 Aug 2014 16:54:58 -0000	1.12.8.2
+++ lib/libssl/src/ssl/t1_lib.c	17 Oct 2014 19:56:17 -0000
@@ -2188,8 +2188,10 @@ static int tls_decrypt_ticket(SSL *s, co
 	HMAC_Update(&hctx, etick, eticklen);
 	HMAC_Final(&hctx, tick_hmac, NULL);
 	HMAC_CTX_cleanup(&hctx);
-	if (timingsafe_bcmp(tick_hmac, etick + eticklen, mlen))
+	if (timingsafe_bcmp(tick_hmac, etick + eticklen, mlen)) {
+		EVP_CIPHER_CTX_cleanup(&ctx);
 		return 2;
+	}
 	/* Attempt to decrypt session data */
 	/* Move p after IV to start of encrypted ticket, update length */
 	p = etick + 16 + EVP_CIPHER_CTX_iv_length(&ctx);
