/* (c) Copyright 2001, 2002, 2003, 2004, 2005, 2006 Stijn van Dongen
 *
 * This file is part of Zoem. You can redistribute and/or modify Zoem under the
 * terms of the GNU General Public License;  either version 2 of the License or
 * (at your option) any later  version.  You should have received a copy of the
 * GPL along with Zoem, in the file COPYING.
*/

#ifndef zoem_dict_h
#define zoem_dict_h

#include "util/ting.h"
#include "util/io.h"
#include "util/types.h"
#include "util/hash.h"


typedef struct keyDict
{  struct keyDict*   down
;  mcxHash*          table
;  mcxTing*          name
;
}  keyDict           ;


typedef struct
{  keyDict*    bottom
;  keyDict*    top
;  int         n_dict
;  int         N_dict
;
}  dictStack   ;


dictStack* dictStackNew
(  int         dict_size
,  int         n_dict_max
)  ;


/* Does not free stack itself */
void dictStackFree
(  dictStack** stack
)  ;

mcxstatus dictStackPush
(  dictStack* stack
,  int dict_size
,  const char* name
)  ;

mcxstatus dictStackPop
(  dictStack* stack
,  const char* type
,  const char* name
)  ;


void mod_dict_init
(  int n
)  ;

void mod_dict_exit
(  void
)  ;


#endif



#if 0

/* Creates if not existing */
dictStack* dictStackGet
(  const char* name
)  ;


/* Make this the current default dollar stack */
void stackNamePush
(  dictStack* stack
)  ;

#endif


