/*            Copyright (C) 2001, 2002, 2003 Stijn van Dongen
 *
 * This file is part of Zoem. You can redistribute and/or modify Zoem under the
 * terms of the GNU General Public License;  either version 2 of the License or
 * (at your option) any later  version.  You should have received a copy of the
 * GPL along with Zoem, in the file COPYING.
*/

#ifndef zoem_segment_h__
#define zoem_segment_h__

#include "util/ting.h"

#define SEGMENT_CONSTANT   1
#define SEGMENT_DIGEST     2

typedef struct yamSeg
{  mcxTing           *txt
;  int               offset   /* consider txt only from offset onwards  */
;  int               idx      /* index of seg itself */
;  struct yamSeg*    prev
;  int               flags    /* magic/miscellaneous. hacked in later */
;
}  yamSeg            ;

void yamSegUlimit
(  int   segment
,  int   stack
)  ;

yamSeg* yamSegPush
(  yamSeg*     prev_seg
,  mcxTing      *txt
)  ;

yamSeg* yamSegPushx
(  yamSeg*  prev_seg
,  mcxTing*  txt
,  int      flags
)  ;

void yamSegInit
(  yamSeg*  this_seg
,  mcxTing*  txt
)  ;

void  yamSegFree
(  yamSeg   **segpp
)  ;

void yamStackFree
(  yamSeg   **segpp
)  ;

int yamStackIdx
(  void
)  ;

typedef yamSeg* (*xpnfnc)(yamSeg* seg);


#endif

