/*            Copyright (C) 2001, 2002, 2003 Stijn van Dongen
 *
 * This file is part of Zoem. You can redistribute and/or modify Zoem under the
 * terms of the GNU General Public License;  either version 2 of the License or
 * (at your option) any later  version.  You should have received a copy of the
 * GPL along with Zoem, in the file COPYING.
*/

#ifndef zoem_filter_h__
#define zoem_filter_h__


/*
 *    The filter manipulation code is a bit hackish, but works well.
 *    It's main shortcoming is the lack of documentation.
*/

#include <stdio.h>

#include "segment.h"

#include "util/ting.h"
#include "util/types.h"
#include "util/io.h"

typedef struct yamFilterData yamFilterData;


yamFilterData* yamFilterDataNew
(  FILE* fp
)  ;

void yamFilterDataFree
(  yamFilterData* fd
)  ;

mcxstatus yamFilterPlain
(  yamFilterData* fd
,  mcxTing*       txt
,  int            offset
,  int            bound
)  ;


typedef mcxstatus  (*fltfnc)(yamFilterData* fd, mcxTing* txt, int offset, int length);

extern fltfnc flts[5];

void yamputc
(  yamFilterData*   fd
,  unsigned char  c
,  int            atcall
)  ;

void yamSpecialSet
(  long c
,  const char* str
)  ;


void yamFilterInitialize
(  int            n
)  ;

void yamFilterExit
(  void
)  ;

void yamFilterList
(  const char* mode
)  ;


extern int ZOEM_FILTER_NONE   ;
extern int ZOEM_FILTER_DEFAULT;
extern int ZOEM_FILTER_DEVICE ;
extern int ZOEM_FILTER_TXT    ;
extern int ZOEM_FILTER_COPY   ;

void yamFilterSetDefaults
(  mcxIO*            xfout
,  int               index
)  ;

yamFilterData* yamFilterGetDefaultFd
(  void
)  ;

mcxTing* yamFilterGetDefaultFname
(  void
)  ;
         
#if 0
fltfnc yamFilterGetDefaultFilter
(  void
)  ;
#endif

void yamSpecialClean
(  void
)  ;

struct yamFilterData
{  int            indent
;  int            n_newlines
;  int            s_spaces
;  int            doformat
;  int            level
;  FILE*          fp
;
}  ;

#endif

