/*            Copyright (C) 2001, 2002, 2003 Stijn van Dongen
 *
 * This file is part of Zoem. You can redistribute and/or modify Zoem under the
 * terms of the GNU General Public License;  either version 2 of the License or
 * (at your option) any later  version.  You should have received a copy of the
 * GPL along with Zoem, in the file COPYING.
*/

#ifndef zoem_file_h__
#define zoem_file_h__

#include "filter.h"

#include "util/io.h"
#include "util/ting.h"

mcxIO* yamOutputNew
(  const char*  fname
)  ;

void yamOutputClose
(  const char*  fname
)  ;

/*
 * This module maintains a stack of input files. The files are parsed
 * depth-first.
*/

mcxstatus yamInputPush
(  const char* str
,  const mcxTing* txt
)  ;
mcxstatus yamInputPop
(  void
)  ;
void yamInputIncrLc
(  const mcxTing* txt
,  int   d
)  ;
int yamInputGetLc
(  void
)  ;
const char* yamInputGetName
(  void
)  ;
mcxTing* yamInputGetPath
(  void
)  ;
mcxbool yamInputCanPush
(  void
)  ;

void yamFileInitialize
(  int   n
)  ;

void yamFileExit
(  void
)  ;

#if 0
void yamOutputFDSync
(  void
)  ;
void yamOutputFDClose
(  void
)  ;
#endif

#endif

