/*            Copyright (C) 2001, 2002, 2003 Stijn van Dongen
 *
 * This file is part of Zoem. You can redistribute and/or modify Zoem under the
 * terms of the GNU General Public License;  either version 2 of the License or
 * (at your option) any later  version.  You should have received a copy of the
 * GPL along with Zoem, in the file COPYING.
*/

#ifndef zoem_digest_h__
#define zoem_digest_h__

#include "filter.h"

#include "util/ting.h"
#include "util/types.h"


/*
 * yamOutput expands and filters. It can be given the arguments
 * yamFilterDefaultFilter() and yamFilterDefaultFd(), which must have
 * been set previously by yamFilterSetDefaults().
 *
 * An output file is fully described by its yamFilterData descriptor.
 * This descriptor is stored in the 'ufo' member of an mcxIO descriptor.
*/

mcxstatus yamOutput
(  mcxTing         *txtin
,  int              fltidx
,  yamFilterData*   fd
)  ;


/*
 * yamDigest only expands and does not filter.  txtout can be the same as
 * txtin; in that case, txtin is overwritten with its expanded image.
 *
*/

mcxstatus  yamDigest
(  mcxTing         *txtin
,  mcxTing         *txtout
)  ;

#endif

