/*            Copyright (C) 2001, 2002, 2003 Stijn van Dongen
 *
 * This file is part of Zoem. You can redistribute and/or modify Zoem under the
 * terms of the GNU General Public License;  either version 2 of the License or
 * (at your option) any later  version.  You should have received a copy of the
 * GPL along with Zoem, in the file COPYING.
*/

#ifndef zoem_curly_h__
#define zoem_curly_h__

#include "segment.h"

#include "util/ting.h"
#include "util/types.h"

#define  CURLY_NOLEFT       -1
#define  CURLY_NORIGHT      -2

/*
 *    txt->str[offset] must be '{', returns CURLY_NOLEFT if not.
 *    otherwise returns l such that txt->str[offset+l] is matching '}',
 *    or CURLY_NORIGHT if the latter does not exist.
 *    Keeps track of things in global variables.
*/

int yamClosingCurly
(  mcxTing     *txt
,  int         offset
,  int*        linect
,  mcxOnFail   ON_FAIL
)  ;


void yamScopeErr
(  yamSeg      *seg
,  const char  *caller
,  int         error
)  ;

#endif

