/*            Copyright (C) 2001, 2002, 2003 Stijn van Dongen
 *
 * This file is part of Zoem. You can redistribute and/or modify Zoem under the
 * terms of the GNU General Public License;  either version 2 of the License or
 * (at your option) any later  version.  You should have received a copy of the
 * GPL along with Zoem, in the file COPYING.
*/

#include "curly.h"
#include "util.h"
#include "file.h"

#include "util/ting.h"
#include "util/types.h"

/*
 *    txt->str[offset] must be '{'.
 *    returns l such that txt->str[offset+l] == '}'.
*/

int yamClosingCurly
(  mcxTing     *txt
,  int         offset
,  int*        linect
,  mcxOnFail   ON_FAIL
)
   {  char* o     =  txt->str + offset
   ;  char* p     =  o
   ;  char* z     =  txt->str + txt->len

   ;  int   n     =  1           /* 1 open bracket */
   ;  int   lc    =  0
   ;  int   esc   =  0
   ;  int   q

   ;  if (*p != '{')
      q = CURLY_NOLEFT

   ;  else
      {  while(++p < z)
         {
            if (*p == '\n')
            lc++

         ;  if (esc)
            {  esc   =  0           /* no checks for validity */
            ;  continue
         ;  }

            switch(*p)
            {
         case
         '\\'  :  esc = 1
               ;  break
               ;
         case
         '{'   :  n++
               ;  break
               ;
         case
         '}'   :  n--
               ;  break
               ;
            }

         ;  if (!n)
            break
      ;  }
         q = n ? CURLY_NORIGHT : p-o
   ;  }

      if (linect)
      *linect += lc

   ;  if (q<0 && ON_FAIL == EXIT_ON_FAIL)
      yamScopeErr(NULL, "yamClosingCurly", q)

   ;  return q
;  }


void  yamScopeErr
(  yamSeg      *seg
,  const char  *caller
,  int         error
)
   {  if (error == CURLY_NORIGHT)
      yamErr
      (  caller
      ,  "unable to close scope (starting around line <%d> in file <%s>)"
      ,  yamInputGetLc()
      ,  yamInputGetName()
      )
   ;  else if (error == CURLY_NOLEFT)
         yamErr
         (  caller
         ,  "scope error (around input line <%d> in file <%s>)"
         ,  yamInputGetLc()
         ,  yamInputGetName()
         )
      ,  yamErr(caller, "expected to see an opening '{'.")
   ;  mcxExit(1)
;  }


