/*            Copyright (C) 2001, 2002, 2003 Stijn van Dongen
 *
 * This file is part of Zoem. You can redistribute and/or modify Zoem under the
 * terms of the GNU General Public License;  either version 2 of the License or
 * (at your option) any later  version.  You should have received a copy of the
 * GPL along with Zoem, in the file COPYING.
*/

#ifndef zoem_counter_h__
#define zoem_counter_h__

#include "util/ting.h"

/*
 * This module is still a bit shaky and needs a better design.
 * Since it is so small, this is best forgotten until the module grows.
 * Mind the funny yamCtrMake semantics though.
*/


/*
 *  The return value of yamGetCtr should never be freed by caller
*/ 
mcxTing* yamCtrGet
(  mcxTing*  key
)  ;

/*
 * The two below act on counters, not on labels/keys mapping to counters.
*/
void yamCtrSet
(  mcxTing* ctr
,  int   c
)  ;
void yamCtrWrite
(  mcxTing* ctr
,  const char* str
)  ;

/*
 * This one is a bit funny, should only be called if ctr <label>
 * does not yet exist. Returns the new counter associated with label.
*/
mcxTing* yamCtrMake
(  mcxTing* label
)  ;


void yamCounterInitialize   /* library wide init */
(  int   n
)  ;

void yamCounterExit
(  void
)  ;


#endif

