/*            Copyright (C) 2001, 2002, 2003 Stijn van Dongen
 *
 * This file is part of Zoem. You can redistribute and/or modify Zoem under the
 * terms of the GNU General Public License;  either version 2 of the License or
 * (at your option) any later  version.  You should have received a copy of the
 * GPL along with Zoem, in the file COPYING.
*/

#include "constant.h"
#include "filter.h"
#include "util.h"

#include "util/hash.h"
#include "util/ting.h"

static   mcxHash*    cstTable_g        =  NULL;    /* constants         */


int   eoconstant
(  mcxTing     *txt
,  int         offset
)
   {  char* o     =  txt->str + offset
   ;  char* p     =  o
   ;  char* z     =  txt->str + txt->len

   ;  if (*p != '*')
      return(CONSTANT_NOLEFT)

   ;  while(++p < z)
      {
         if (*p == '\\' || *p == '{' || *p == '}')
         return (CONSTANT_ILLCHAR)

      ;  if (*p == '*')
         break
   ;  }
   ;  return(*p == '*' ? p-o : CONSTANT_NORIGHT)
;  }


mcxTing* yamConstantGet
(  mcxTing* key
)
   {  mcxKV*   kv =  (mcxKV*) mcxHashSearch(key, cstTable_g, MCX_DATUM_FIND)
   ;  return kv ? (mcxTing*) kv->val : NULL
;  }


/* fixme
 * is key really owned by  yCN?
*/

mcxTing* yamConstantNew
(  mcxTing* key
,  const char* val
)
   {  mcxKV*   kv =  (mcxKV*) mcxHashSearch(key, cstTable_g, MCX_DATUM_INSERT)

   ;  if ((mcxTing*) kv->key != key)
      mcxTingWrite((mcxTing*)kv->val, val)
   ;  else
      kv->val = mcxTingNew(val)

   ;  return (mcxTing*) kv->key
;  }


void yamConstantInitialize
(  int n
)
   {  cstTable_g           =  yamHashNew(n)
;  }


void yamConstantExit
(  void
)
   {  mcxHashFree(&cstTable_g, mcxTingFree_v, mcxTingFree_v)
;  }


