/*
 * Safer version of system for interactive programs
 * $Id: system.c,v 1.5 2002/03/06 00:37:52 ian Exp $ 
 */

#include <stdio.h>
#include <stdlib.h>
#include <unistd.h>
#include <fcntl.h>
#include <signal.h>
#include <sys/wait.h>

#include "zap.h"

int
system(const char *s)	/* run command line s */
{
	int status, pid, w, tty;
	void (*istat)(int), (*qstat)(int);

	fflush(stdout);
	tty = open("/dev/tty", 2);
	if (tty == -1) {
		die("can't open /dev/tty", "");
	}
	if ((pid = fork()) == 0) {
		close(0); dup(tty);
		close(1); dup(tty);
		close(2); dup(tty);
		close(tty);
		execlp("sh", "sh", "-c", s, (char *) 0);
		exit(127);
	}
	close(tty);
	istat = signal(SIGINT, SIG_IGN);
	qstat = signal(SIGQUIT, SIG_IGN);
	while ((w = wait(&status)) != pid && w != -1)
		;
	if (w == -1)
		status = -1;
	signal(SIGINT, istat);
	signal(SIGQUIT, qstat);
	return status;
}
