/*
 * map strings to numbers, for kill & zap commands.
 * $Id: signame.c,v 1.2 2002/03/06 00:37:52 ian Exp $
 */

#include <string.h>

static struct ent {
	char *name;
	int  num;
} data[] = {
	{ "hup",	1 },	/* hangup */
	{ "int",	2 },	/* interrupt */
	{ "quit",	3 },	/* quit */
	{ "ill",	4 },	/* illegal instruction (not reset when caught) */
	{ "trap",	5 },	/* trace trap (not reset when caught) */
	{ "abrt",	6 },	/* abort() */
	{ "iot",	6 },	/* compatibility */
	{ "emt",	7 },	/* EMT instruction */
	{ "fpe",	8 },	/* floating point exception */
	{ "kill",	9 },	/* kill (cannot be caught or ignored) */
	{ "bus",	10 },	/* bus error */
	{ "segv",	11 },	/* segmentation violation */
	{ "sys",	12 },	/* bad argument to system call */
	{ "pipe",	13 },	/* write on a pipe with no one to read it */
	{ "alrm",	14 },	/* alarm clock */
	{ "term",	15 },	/* software termination signal from kill */

#if	!defined(sysv)		/* presumably bsd */
	{ "urg",	16 },	/* urgent condition on IO channel */
	{ "stop",	17 },	/* sendable stop signal not from tty */
	{ "tstp",	18 },	/* stop signal from tty */
	{ "cont",	19 },	/* continue a stopped process */
	{ "cld",	20 },	/* to parent on child stop or exit */
	{ "chld",	20 },	/* to parent on child stop or exit */
	{ "child",	20 },	/* to parent on child stop or exit */
	{ "ttin",	21 },	/* to readers pgrp upon background tty read */
	{ "ttou",	22 },	/* like TTIN for output if (tp->t_local&LTOSTOP) */
	{ "io",		23 },	/* input/output possible signal */
	{ "xcpu",	24 },	/* exceeded CPU time limit */
	{ "xfsz",	25 },	/* exceeded file size limit */
	{ "vtalrm", 26 },	/* virtual time alarm */
	{ "prof",	27 },	/* profiling time alarm */
	{ "winch",	28 },	/* window size changes */
	{ "info",	29 },	/* information request */
	{ "usr1",	30 },	/* user defined signal 1 */
	{ "usr2",	31 },	/* user defined signal 2 */

#else	/* sysv */

	{ "usr1",	16 },	/* user-defined signal 1 */
	{ "usr2",	17 },	/* user-defined signal 2 */
	{ "cld",	18 },	/* child status change */
	{ "chld",	18 },	/* child status change alias (POSIX) */
	{ "child",	18 },	/* child status change alias (POSIX) */
	{ "pwr",	19 },	/* power-fail restart */
	{ "winch",	20 },	/* window size change */
	{ "urg",	21 },	/* urgent socket condition */
	{ "poll",	22 },	/* pollable event occured */
	{ "io",		22 },	/* socket I/O possible (SIGPOLL alias) */
	{ "stop",	23 },	/* stop (cannot be caught or ignored) */
	{ "tstp",	24 },	/* user stop requested from tty */
	{ "cont",	25 },	/* stopped process has been continued */
	{ "ttin",	26 },	/* background tty read attempted */
	{ "ttou",	27 },	/* background tty write attempted */
	{ "vtalrm",	28 },	/* virtual timer expired */
	{ "prof",	29 },	/* profiling timer expired */
	{ "xcpu",	30 },	/* exceeded cpu limit */
	{ "xfsz",	31 },	/* exceeded file size limit */

#endif
};
#define	NSIGS	(sizeof(data)/sizeof(data[0]))

int
signame(char *s) {
	int i;
	for (i=0; i<NSIGS; i++)
		if (strcasecmp(data[i].name, s) == 0)
				return data[i].num;
	return -1;
}
