#!/usr/local/bin/perl

# From: D.G.Jones@scuna.dircon.co.uk (Derek Jones)
# Date: Tue, 22 Nov 1994 17:47:52 +0100 (GMT)

# This one does an interactive zap of ps lines selected by the user.

$SYSV = -f '/unix';
$progname = $0;
$pscmd = $SYSV ? "ps -ef" : "ps -auxww";

open(TTYIN, "</dev/tty") || die "can't read /dev/tty: $!";
open(TTYOUT, ">/dev/tty") || die "can't write /dev/tty: $!";
select(TTYOUT);
$| = 1;
select(STDOUT);
$SIG{'INT'} = 'cleanup';

$sig = 'TERM';
if ($#ARGV >= $[ && $ARGV[0] =~ /^-/) {
    if ($ARGV[0] =~ /-(\w+)$/) { $sig = $1; } 
    else { print STDERR "$0: illegal argument $ARGV[0] ignored\n"; }
    shift;
}

open(PS, "$pscmd|") || die "can't run $pscmd: $!";
$title = <PS>;
print TTYOUT $title;
eval <<'EOF';
while ($cand = <PS>) {
    chop($cand);
    ($user, $pid) = split(' ', $cand);
    next if $pid == $$;
    $found = ($#ARGV < $[) ? 1: 0;
    foreach $pat (@ARGV) { $found = 1 if $cand =~ $pat; }
    next if (!$found);
    print TTYOUT "$cand? ";
    $ans=<TTYIN>;
    print TTYOUT "\n" if ($ans ne "\n");
    if ($ans =~ /^[yY]/) { kill $sig, $pid; }
    if ($ans =~ /^[qQ]/) { last; }
}
EOF
&cleanup;

sub cleanup {
    print "\n";
    exit;
}
