/*
 * zap -- interactive process killer 
 * Based on an earlier program of the same name
 * by Kernighan & Pike, in their classic book
 * The UNIX Programming Environment, 1984.
 *
 * $Id: zap.c,v 1.4 1999/05/31 14:18:17 ian Exp $
 */

#include <stdio.h>
#include <signal.h>

#include "zap.h"

char	*progname;	/* program name for error message */
const char	*ps = PS_ALL;
int		progpid;

main(int argc, char **argv)
{
	FILE *fin, *popen();
	char buf[BUFSIZ];	/* a line to read */
	int errors = 0;		/* for getopt */
	int c = 0;			/* from getopt */
	extern int optind;	/* from getopt */
	extern char* optarg;/* from getopt */
	int pid;			/* target PID */
	int interact = 1;	/* ? ask : just do it */
	int debug = 0;		/* print debugging? (unused) */
	int signum = SIGTERM;	/* how shall I tell thee? */

	progname = argv[0];
	progpid  = getpid();

	while ((c = getopt(argc, argv, "ds:y")) != EOF) {
		switch (c) {
		case 's':
			signum = atoi(optarg);	/* TODO name lookup like kill(1) */
			break;
		case 'd':
			++debug;
			break;
		case 'y':
			interact = 0;
			break;
		case '?':
		default:
			errors++;
			break;
		}
	}
	if (errors || (argc-optind<1)) {
		(void) fprintf(stderr, "usage: %s [-s signum] processname ...\n", progname);
		exit(2);
	}

	if ((fin = popen(ps, "r")) == NULL) {
		fprintf(stderr, "%s: can't run %s\n", progname, ps);
		exit(1);
	}
	fgets(buf, sizeof buf, fin);	/* get header line */
	fprintf(stderr, "%s", buf);

	/* Read a line from ps, process it. */
	while (fgets(buf, sizeof buf, fin) != NULL) {
		buf[strlen(buf)-1] = '\0'; /* suppress \n */
		if (strstr(buf, argv[optind]) != NULL && 
				(pid = atoi(buf)) != progpid) {

			fprintf(stderr, "%s", buf);

			if (interact) {
				fprintf(stderr, "? ");
				if (ttyin() == 'y') {
					if (kill(pid, signum)<0)
						perror(buf);
				}
			} else {
				fprintf(stderr, "\n");
				if (kill(pid, signum)<0)
					perror(buf);
			}
		}
	}
	exit(0);
}
