/*
 * Safer version of system for interactive programs
 * $Id: system.c,v 1.4 1999/05/31 14:19:54 ian Exp $ 
 */

#include <signal.h>
#include <stdio.h>
#include "zap.h"

system(char *s)	/* run command line s */
{
	int status, pid, w, tty;
	void (*istat)(int), (*qstat)(int);

	fflush(stdout);
	tty = open("/dev/tty", 2);
	if (tty == -1) {
		die("can't open /dev/tty", "");
	}
	if ((pid = fork()) == 0) {
		close(0); dup(tty);
		close(1); dup(tty);
		close(2); dup(tty);
		close(tty);
		execlp("sh", "sh", "-c", s, (char *) 0);
		exit(127);
	}
	close(tty);
	istat = signal(SIGINT, SIG_IGN);
	qstat = signal(SIGQUIT, SIG_IGN);
	while ((w = wait(&status)) != pid && w != -1)
		;
	if (w == -1)
		status = -1;
	signal(SIGINT, istat);
	signal(SIGQUIT, qstat);
	return status;
}
