/***************************************************************************
 *
 * $Header: /usr/local/cvsroot/utils/ytree/execute.c,v 1.10 2001/02/03 15:58:51 werner Exp $
 *
 * Ausfuehren von System-Kommandos
 *
 ***************************************************************************/


#include "ytree.h"


extern int chdir(const char *);


int Execute(DirEntry *dir_entry, FileEntry *file_entry)
{
  static char command_line[COMMAND_LINE_LENGTH + 1];
  char cwd[PATH_LENGTH+1];
  char path[PATH_LENGTH+1];
  int  result;

  result = -1;

  if( file_entry )
  {
    if( file_entry->stat_struct.st_mode & 
	( S_IXUSR | S_IXGRP | S_IXOTH ) )
    {
      /* ausfuehrbare Datei */
      /*--------------------*/

      (void) StrCp( command_line, file_entry->name );
    }
  }

  MvAddStr( LINES - 2, 1, "Command:" );
  if( !GetCommandLine( command_line ) )
  {
    if( getcwd( cwd, PATH_LENGTH ) == NULL )
    {
      WARNING( "getcwd failed*\".\"assumed" );
      (void) strcpy( cwd, "." );
    }

    if( mode == DISK_MODE || mode == USER_MODE )
    {
      if( chdir( GetPath( dir_entry, path ) ) )
      {
        (void) sprintf( message, "Can't change directory to*\"%s\"", path );
        MESSAGE( message );
      }
      else
      {
        refresh();
        result = QuerySystemCall( command_line );
      }
      (void) chdir( cwd );
    }
    else
    {
      refresh();
      result = QuerySystemCall( command_line );
    }
  }
  
  return( result );
}




int GetCommandLine(char *command_line)
{
  int result;

  result = -1;

  ClearHelp();

  MvAddStr( LINES - 2, 1, "Command: " );
  if( InputString( command_line, LINES - 2, 10, COLS - 11, "\r\033" ) == CR )
  {
    move( LINES - 2, 1 ); clrtoeol();
    result = 0;
  }

  move( LINES - 2, 1 ); clrtoeol();

  return( result );
}

    


int ExecuteCommand(FileEntry *fe_ptr, WalkingPackage *walking_package)
{
  char command_line[COMMAND_LINE_LENGTH + 1];
  int i, result;
  char c;
  char *cptr;

  command_line[0] = '\0';
  cptr = command_line;

  walking_package->new_fe_ptr = fe_ptr;  /* unchanged */

  for( i=0; (c = walking_package->function_data.execute.command[i]); i++ )
  {
    if( c == '{' && walking_package->function_data.execute.command[i+1] == '}' )
    {
      (void) GetFileNamePath( fe_ptr, cptr );
      cptr = &command_line[ strlen( command_line ) ];
      i++;
    }
    else
    {
      *cptr++ = c;
    }
  }
  *cptr = '\0';

  result = SilentSystemCall( command_line );

  /* Ignore Result */
  /*---------------*/

  result = 0;

  return( result );
}
