/***************************************************************************
 *
 * $Header: /usr/local/cvsroot/utils/ytree/main.c,v 1.12 2000/07/13 18:26:06 werner Exp $
 *
 * Hauptmodul
 *
 ***************************************************************************/


#include "ytree.h"



static char buffer[PATH_LENGTH+1];
static char path[PATH_LENGTH+1];



int main(int argc, char **argv)
{
  char *p;

  if (Init())
      exit(1);

  if( argc == 2 ) 
    p = argv[1]; 
  else 
    p = DEFAULT_TREE;

  if( *p != FILE_SEPARATOR_CHAR )
  {
    /* rel. Pfad */
    /*-----------*/

    (void) getcwd( buffer, sizeof( buffer ) - 2 );
    (void) strcat( buffer, FILE_SEPARATOR_STRING );
    (void) strcat( buffer, p );
    p = buffer;
  }

  /* Normalize path */

  NormPath( p, path );

  statistic.login_path[0] = '\0';
  statistic.path[0] = '0';

  if( LoginDisk( path ) == -1 )
  {
    endwin();
#ifdef XCURSES
    XCursesExit();
#endif
    exit( 1 );
  }

  while( 1 )
  {
    if( HandleDirWindow(statistic.tree) == 'q' ) Quit();
  }
}


