/*
-======================== You Sick Me v7 ===========================-

                                   |                                           
           - ----------------------                                          
    _      |                       |             _________________/_     _    
   _\____________   ______         _ __________  |               /             
     \           | _)    /                     \ |              /              
      \          |_\_  _/_______________/_      \|            _/               
                 |) /______________    /         \            |pix.imp         
                   /   \         )/___/         \  /          |                
  _    _\______   /    /__  ____/       - -------\/___________|               
         ` |  /__/        \/                                                   
           |          _      _           _                  __ ________ _      
           |                  )) y( O u  (s(i  C k    m.( E))                  
           |                                                                  
          -- ---------------- ---- -----                                     
                                  |                                            
                                  |                                            
-========================== YSM_Wrappers.c ============================-

YSM (YouSickMe) ICQ Client. An Original Multi-Platform ICQ client.
Copyright (C) 2002 rad2k Argentina.

YSM is free software; you can redistribute it and/or
modify it under the terms of the GNU General Public License
as published by the Free Software Foundation; either version 2
of the License, or (at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.

For Contact information read the AUTHORS file.

*/


#ifndef YSM_WITH_THREADS
void
YSM_Start (
	void
	);
#endif


#include "YSM.h"

void
YSM_Reconnect ( void )
{

	PRINTF(YSM_VERBOSE_FUNCTIONAL,
	"\n" RED "Disconnection detected. Reconnecting in 30 seconds."
	"\n" NORMAL );

#ifdef WIN32
			Sleep(30000);
#elif !defined(BEOS)
			sleep(30);
#endif

		/* Reconnect. If Its the threaded version, this */
		/* is still the networking thread, so just call */
		/* the function again.				*/
#ifdef YSM_WITH_THREADS
			YSM_Start_Network();
#else
			YSM_Start();
#endif

	return;
}


int
YSM_WRITE  (int sock, void *data, int data_len)
{

int	r = 0;

	r = SOCK_WRITE(sock , data, data_len);

	if( r < 0 && sock == YSM_TCPSock)
		YSM_Reconnect();

	return r;
}

int
YSM_READ (int sock, void *buf, int read_len)
{

	int		r=0, rlen = 0, x = 0;
#if !defined (WIN32) && !defined (BEOS)
	long		e = 0;
	int		t = 0;
#else	
	int		n = 0;
#endif


		rlen = read_len;

#if !defined(WIN32) && !defined(BEOS)

		YSM_FDSelect();

		if(!YSM_FDIs_Set(sock))
			usleep(1000);

			/* We Check in MicroSeconds our Timeout. */

			for( r = 0, t = rlen,
			e = YSM_GetMicroTime(0) + MAX_READ_TIMEOUT; r < t &&
			YSM_GetMicroTime(e) > 0;)
			{

				errno = 0;

				x = SOCK_READ( sock, buf+r, rlen);
				if(errno == EAGAIN)
					usleep(1000);

				if(x > 0)
				{
					r += x;
					rlen -= x;
				}
				else
				{
					if( sock == YSM_TCPSock )
						YSM_Reconnect();
				}
			}

#else

		while(read_len > r)
		{
			if(YSM_Logged_In)
			{
				n = YSM_FDIs_Set(sock);
				if(n == 0) return r;
			}

			x = SOCK_READ(sock, (char *)buf+r, rlen);
			if(x > 0) 
			{
				r += x;
				rlen -= x;
			}
			else
			{
				if( sock == YSM_TCPSock )
					YSM_Reconnect();
			}
		}
#endif

	return r;
}

void *
YSM_Malloc (int size, char *file, int line)
{

char	*memory;

	memory = malloc (size);

	if( (size <= 0) || (memory == NULL)) 
	{
		PRINTF(YSM_VERBOSE_BASE,
		"\rYSM_Malloc: Error in block. Probably size error.\n");

		PRINTF(YSM_VERBOSE_BASE,
		"Inform the author! File: %s Line: %d\n", file, line);

		exit(-1);
	}

	return memory;
}

void
YSM_Free (void *what, char *file, int line)
{

	if( what == NULL )
	{
		PRINTF(YSM_VERBOSE_BASE,
		"\rYSM_Free: NULL Block . Probably double free?.\n");

		PRINTF(YSM_VERBOSE_BASE,
		"Inform the author! File: %s Line: %d\n", file, line);

		exit (-1);
	}

	free(what);

	return;
}
