/*	$Id: YSM_Slaves.c,v 1.9 2002/08/18 08:25:34 rad2k Exp $	*/
/*
-======================== You Sick Me v7 ===========================-

                                   |                                           
           - ----------------------                                          
    _      |                       |             _________________/_     _    
   _\____________   ______         _ __________  |               /             
     \           | _)    /                     \ |              /              
      \          |_\_  _/_______________/_      \|            _/               
                 |) /______________    /         \            |pix.imp         
                   /   \         )/___/         \  /          |                
  _    _\______   /    /__  ____/       - -------\/___________|               
         ` |  /__/        \/                                                   
           |          _      _           _                  __ ________ _      
           |                  )) y( O u  (s(i  C k    m.( E))                  
           |                                                                  
          -- ---------------- ---- -----                                     
                                  |                                            
                                  |                                            
-========================= YSM_Slaves.c ===============================-


YSM (YouSickMe) ICQ Client. An Original Multi-Platform ICQ client.
Copyright (C) 2002 rad2k Argentina.

YSM is free software; you can redistribute it and/or
modify it under the terms of the GNU General Public License
as published by the Free Software Foundation; either version 2
of the License, or (at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.

For Contact information read the AUTHORS file.


*/

#include "YSM.h"

YSM_SLAVE *
YSM_FindSlaveinList (
	YSM_SLAVE	*SlavesList,
	char		*Nick,
	unsigned int	Uin,
	int		fl
	);

void
YSM_PrintSlaves (
	YSM_SLAVE	*YSMSlavesList,
	unsigned int	FilterStatus,
	char		*FString
	);

int
YSM_CountSlavesList (
	YSM_SLAVE	*SlavesList
	);

extern YSM_SLAVE *YSMSlaves_First,*YSMSlaves_LastRead,*YSMSlaves_LastSent;
extern unsigned int AmountSlaves;

int arr_status[] = {	YSM_OFFLINE, YSM_INVISIBLE,	YSM_DND,
YSM_OCCUPIED, YSM_FREE_CHAT,  YSM_NA, YSM_AWAY, YSM_ONLINE	};
	

int YSM_CountSlavesList (YSM_SLAVE *SlavesList)
{
	int i;

	for (i=1 ; SlavesList->next != 0; i++)
		SlavesList = SlavesList->next;

	return i;
}

/* 	Instead of behaving the very same way that YSM_PrintSlaves,
	when supplied with -1 (print them all) the output is still
	organized :) 						*/

void
YSM_PrintOrganizedSlaves ( YSM_SLAVE *YSMSlavesList, int FilterStatus,
							char *Fstring)
{

	int x = 0;

	/* We increase x so we skip the first array member (offline) */
	if (FilterStatus != YSM_OFFLINE)
		x++;

	if (FilterStatus == -1 && (Fstring == NULL))
		PRINTF (YSM_VERBOSE_BASE,
			"%s %d SLAVES:\n",MSG_SLAVES_LIST,AmountSlaves);

	else if (Fstring != NULL);

	else
		PRINTF (YSM_VERBOSE_BASE,
			"%s\n",MSG_SLAVES_ONLINE);


	for ( ; x < NUM_ELEM_STATUS_ARR(arr_status); x++)
			YSM_PrintSlaves(YSMSlavesList, arr_status[x], Fstring);

	return;
}


/*		Let me explain the idea of Filtering (in YSM_PrintSlaves) */
/*		Since PrintSlaves is usually called from PrintOrganizedSlaves*/
/*		function, YSM_PrintSlaves will always filter and only print */
/*		those slaves with status equal to FilterStatus, UNLESS */
/*		-1 (YSM_OFFLINE) is specified. Which means 'PRINT THEM ALL' */
/*		without worring about any order */

/* 		Fstring (FilterString) when specified will make PrintSlaves */
/*		only display those slaves that start with the */
/*		String specified. */


void
YSM_PrintSlaves ( YSM_SLAVE *YSMSlavesList, unsigned int FilterStatus, char *Fstring)
{

	unsigned int x,y=0;
	char SlaveStatus[MAX_STATUS_LEN];

	YSMSlavesList = YSMSlaves_First;


	for(x=0;x<AmountSlaves;x++)
	{

		if( Fstring != NULL)
		{
			if( memcmp(YSMSlavesList->NickName, Fstring,
							strlen(Fstring)) != 0)
			{
			    	if(YSMSlavesList->next != 0)
				{
               				YSMSlavesList = YSMSlavesList->next;
					continue;
				}	
			
				else
					return;
			}

		}

		YSM_WriteStatus(YSMSlavesList->Status,SlaveStatus);


		if (YSMSlavesList->Status == FilterStatus)
		{

			if(y % 2 == 0) PRINTF(YSM_VERBOSE_BASE,"\n");
			y++;

			PRINTF(YSM_VERBOSE_BASE,
			"[%-10.10s"
			"%-1.1s"
			"%s%-7.7s" NORMAL
			"%-1.1s"
			"%-2.2s-%-2.2s-%-2.2s]\t",
				YSMSlavesList->NickName, 
				" ",
				YSM_GetColorStatus(SlaveStatus),
				SlaveStatus,
				" ",
				YSMSlavesList->BudType.IgnoreID ? "IG" : "",
				YSMSlavesList->BudType.InvisibleID ? "IN" : "",
				YSMSlavesList->BudType.VisibleID ? "VI" : "");
		}

        	if(YSMSlavesList->next != 0)
               		YSMSlavesList = YSMSlavesList->next;	
			
		else break;
	}

	if(y>0) PRINTF(YSM_VERBOSE_BASE, "\n");

	return;

}
	

/* 	The fl parameter is a DownloadedFlag, which if TRUE tells the contact
	being added right now was downloaded from the srv. 	*/
	
int YSM_AddSlavetoList (YSM_SLAVE **SlavesList, char *Nick, int Uin, char *c_key, int budID, int grpID, int budtype, int fl)
{
	YSM_SLAVE *new, *res;
	unsigned int x, keylen = 0;
	char StringUIN[MAX_UIN_LEN+1], goodKey[64];
	

	(*SlavesList) = YSMSlaves_First;	

	for (x=0;x<strlen(Nick);x++)
		Nick[x] = tolower(Nick[x]);

	memset(StringUIN,0,MAX_UIN_LEN+1);
	snprintf(StringUIN,MAX_UIN_LEN,"%d",Uin);

	/* First Seek if theres another Slave with the same UIN (Duh!) */

	if((res = YSM_FindSlaveinList(*SlavesList, Nick, Uin, TRUE)) != NULL)
	{
		/* Set it as downloaded ! */
		res->DownloadedFlag = TRUE;	


		/* Updating User Special properties	*/
		switch(budtype)
		{
			case YSM_BUDDY_SLAVE_VIS:	/* Buddy Visible */
				res->BudType.VisibleID = budID;
				break;

			case YSM_BUDDY_SLAVE_INV:	/* Buddy Invisible */
				res->BudType.InvisibleID = budID;
				break;

			case YSM_BUDDY_SLAVE_IGN:	/* Buddy ignored */
				res->BudType.IgnoreID = budID;
				break;

			default:			/* Buddy Normal */
				break;
		}

		/* Set its buddy ID! */	
		res->BudType.BudID = budID;

		/* Now set its group ID (required when deleting from srv) */
		res->BudType.grpID = grpID;

		return FALSE;
	}

	/* Now with the same nick (Conflict!) */
	if(YSM_FindSlaveinList(*SlavesList, Nick, Uin, FALSE) != NULL)
		Nick = &StringUIN[0];
	

	new = (YSM_SLAVE *) YSM_Malloc(sizeof(YSM_SLAVE), __FILE__, __LINE__);

	memset(new,'\0',sizeof(YSM_SLAVE));

	new->Uin = Uin;
	strncpy(new->NickName,Nick,MAX_SLAVE_NICK);
	new->Status = -1L;
	new->LogFlag = 0;
	new->DownloadedFlag = fl;

	new->d_con.rSocket = -1;

	/* Set the encryption key if any */
	if( c_key != NULL ) 
	{
		strncpy(new->EncryptKey, c_key, MAX_KEY_LEN);

		/* process the key */

		keylen = strlen(new->EncryptKey);
	
		for (x=0;x<sizeof goodKey;x++)
			goodKey[x] = new->EncryptKey[x % keylen];

		x=makeKey(&new->cipherKey_out, DIR_ENCRYPT, 256, goodKey);

		if (TRUE != x) {
		PRINTF(YSM_VERBOSE_BASE,
			"Cypher error: processing out key (%x) for slave %s!\n",
							 x, new->NickName);
		}

		x=makeKey(&new->cipherKey_in, DIR_DECRYPT, 256, goodKey);
		
		if (TRUE != x) {
		PRINTF(YSM_VERBOSE_BASE,
			"Cypher error: processing in key (%x) for slave %s!\n",
							 x, new->NickName);
		}

	}

	/* Updating User Special properties	*/
	switch(budtype)
	{
		case YSM_BUDDY_SLAVE_VIS:	/* Buddy Visible */
			new->BudType.VisibleID = budID;
			break;

		case YSM_BUDDY_SLAVE_INV:	/* Buddy Invisible */
			new->BudType.InvisibleID = budID;
			break;

		case YSM_BUDDY_SLAVE_IGN:	/* Buddy ignored */
			new->BudType.IgnoreID = budID;
			break;

		default:			/* Buddy Normal */
			break;
	}


	/* Set its buddy ID! */	
	new->BudType.BudID = budID;

	/* Now set its group ID (required when deleting from srv) */
	new->BudType.grpID = grpID;

	/* el nuevo nodo apunta a lo que era el primer nodo */
	new->next = *SlavesList;

	/* Cambiamos el puntero back del siguiente para que apunte a este */
	new->next->back = new;

	/* ahora el primer nodo es el nuevo nodo */
	*SlavesList = new;

	YSMSlaves_First = *SlavesList;

	return TRUE;
}


void YSM_DeleteSlavefromList (YSM_SLAVE **SlavesList, char *Nick, int Uin)
{
	YSM_SLAVE *new, *res;
	unsigned int x;

	(*SlavesList) = YSMSlaves_First;

	for (x=0;x<strlen(Nick);x++)
		Nick[x] = tolower(Nick[x]);

	/* Pretty important. (for the a and r commands specially) */

	if(YSMSlaves_LastSent != NULL)
	{
		if(!strcmp(YSMSlaves_LastSent->NickName,Nick))
					YSMSlaves_LastSent = NULL;
	}

	if(YSMSlaves_LastRead != NULL)
	{
		if(!strcmp(YSMSlaves_LastRead->NickName,Nick))
					YSMSlaves_LastSent = NULL;
	}

			
	res = YSM_FindSlaveinList(*SlavesList, Nick, Uin, TRUE);

	if(res != NULL)	
	{

		if(res != YSMSlaves_First)
		{

		/* Hacemos que nuestro nodo sea el siguiente de
						quien queremos eliminar. */
			new = res->next;
			res->back->next = new;

			/* Eliminamos el primero */

			YSM_Free(res, __FILE__, __LINE__);

		}

		else
		{
			new = res->next;
		
			YSM_Free(res, __FILE__, __LINE__);

			res = new;

			YSMSlaves_First = res;
		}

	}

	
	return;
}

/*	if fl is TRUE, Find will do a find by UIN. 
	if fl is FALSE, Find will do a find by Nick.	*/

YSM_SLAVE *
YSM_FindSlaveinList (YSM_SLAVE *SlavesList, char *Nick, unsigned int Uin, int fl)
{
	int i;

	

	for (i=1 ; SlavesList->next != 0; i++)
	{
			if(fl)
			{
				if(SlavesList->Uin == Uin)
						return SlavesList;
			}
			else
			{
				if(!strcmp(SlavesList->NickName,Nick))
						return SlavesList;
			}

		SlavesList = SlavesList->next;
	}

	return NULL;
}

int YSM_ParseSlave (char *name)
{
        char *token, *obuf;
        int size,x,y=0;

        size = strlen(name);
        obuf = YSM_Malloc(size+1, __FILE__, __LINE__);
        memset(obuf,'\0',size+1);
        token = strtok(name," ");

        while(token)
        {
                strncat(obuf,token,size);
                token = strtok(NULL," ");
        }

        memset(name,'\0',size);

        for (x=0;x<size;x++)
        {
                if(isalnum(obuf[x]))
                {
                        name[y] = obuf[x];
                        y++;
                }
        }

        YSM_Free(obuf, __FILE__, __LINE__);

        return y;
}

void YSM_RenameSlave ( YSM_SLAVE *old_slave, char *new_name )
{
	/* We remove the slave from the config file but not from memory */
	YSM_DelSlave(old_slave->NickName, 0);

	/* We update the information on memory */
	strncpy(old_slave->NickName,new_name,MAX_SLAVE_NICK);

	/* We re-add the slave in the config file with the new data */
	YSM_AddSlavetoDisk (new_name, old_slave->Uin, NULL);

	return;
}


YSM_SLAVE *	YSM_SlaveCompletition	(char *Name)
{
	int i;
	YSM_SLAVE *node;

	node = YSMSlaves_First;

	for (i=1 ; node->next != 0; i++)
	{
		if(!memcmp(node->NickName,Name,strlen(Name)))
				return node;

		node = node->next;
	}

	return NULL;

}
