/*	$Id: YSM_Prompt.c,v 1.26 2002/08/20 23:47:21 rad2k Exp $	*/
/*
-======================== You Sick Me v7 ===========================-

                                   |                                           
           - ----------------------                                          
    _      |                       |             _________________/_     _    
   _\____________   ______         _ __________  |               /             
     \           | _)    /                     \ |              /              
      \          |_\_  _/_______________/_      \|            _/               
                 |) /______________    /         \            |pix.imp         
                   /   \         )/___/         \  /          |                
  _    _\______   /    /__  ____/       - -------\/___________|               
         ` |  /__/        \/                                                   
           |          _      _           _                  __ ________ _      
           |                  )) y( O u  (s(i  C k    m.( E))                  
           |                                                                  
          -- ---------------- ---- -----                                     
                                  |                                            
                                  |                                            
-========================== YSM_Prompt.c ============================-


YSM (YouSickMe) ICQ Client. An Original Multi-Platform ICQ client.
Copyright (C) 2002 rad2k Argentina.

YSM is free software; you can redistribute it and/or
modify it under the terms of the GNU General Public License
as published by the Free Software Foundation; either version 2
of the License, or (at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.

For Contact information read the AUTHORS file.

*/

#include <errno.h>
#include <string.h>
#include <stdlib.h>
#ifndef WIN32
#include <termios.h>
#endif

#include "YSM.h"

#ifdef WIN32
HWND
getConsoleWindow (
	void
	);

void
YSM_WindowRegisterHotKey (
	void
	);

void
YSM_WindowAlert (
	void
	);

void
YSM_WindowHide (
	void
	);
#endif

void
YSM_PasswdCheck (
	void
	);

void
YSM_DoCommand (
	char *
	);

char *
YSM_ReadLongMessage (
	void
	);

int
getkey (
	void
	);

int
putch (
	int
	);

void
do_backspace (
	void
	);

void
YSM_DoTab (
	void
	);

void
YSM_ParseMessageData (
	char *
	);

void
YSM_Upload_BuddyList (
	YSM_SLAVE	*
	);

void
YSM_HandleBurl (
	char *_argone
	);

void
YSM_HandleCommand (
	char *_argone
	);

void
YSM_Print_Uptime (
	void
	);

int
YSM_CheckKeysSetup (
	char	YSM_UserInput
	);

void
YSM_RenameSlave (
	YSM_SLAVE	*old_slave,
	char		*new_name
	);

void
YSM_PrintOrganizedSlaves (
	YSM_SLAVE	*YSMSlavesList,
	int		FilterStatus,
	char		*Fstring
	);

/* Command History Array */
char	YSM_CmdHistory[MAX_CMD_HIST][MAX_CMD_LEN];
int	YSM_CmdHistIndex = 0;

char	YSM_Command[MAX_CMD_LEN + 1];
char	YSM_CommandBkp[MAX_CMD_LEN + 1];
char	Input_Special = 0;
char	YSM_MsgData[MAX_DATA_LEN];
short	YSM_Message_Arrived = FALSE;
short	YSM_Display_Busy = FALSE;
short	YSM_AFK_Count = 0;
time_t	YSM_AFK_Time = 0;
int	Curr_CMDLEN = 0, Prev_CMDLEN = 0;


/* Even though i hate this..I do it for the YSM community */
char	YSM_LastMessage[MAX_DATA_LEN+1];

#ifndef WIN32
static	struct termios console_attrs;
#endif

extern char *YSM_GroupID_List;
extern int YSM_GroupID_Users_Amount;

extern int YSM_SpoofUIN;

extern short YSM_Redraw_Console;
extern unsigned short YSM_SeqNum;
extern char YSM_KEYMAP_HELP;
extern char YSM_KEYMAP_WHOSON;
extern char YSM_KEYMAP_SLAVES;
extern char YSM_AFKMessage[MAX_DATA_LEN];
extern unsigned int AmountSlaves;
extern unsigned int AmountOnline;
extern YSM_SLAVE *YSMSlaves_LastSent, *YSMSlaves_LastRead;
extern YSM_SLAVE *YSMSlavesList,*YSMSlaves_First, *YSMSlaves_TabSlave;

/* This Comfortable pointer fixes a race condition. */
YSM_SLAVE *YSMSlaves_Comfortable;

extern time_t	YSM_IdleTIME, YSM_StartTime;

extern struct YSM_MODEL YSM_USER;

UWORD YSM_TabCount = 1;
YSM_SLAVE *nexttabslave = NULL, *prevtabslave = NULL;


void
YSM_ClearLine(void)
{

int x;

	fprintf(stdout, "\r");

	/* +9 just in case it was an AFK prompt */
	for(x = 0; x < Prev_CMDLEN+9; x++)
		fprintf(stdout, " ");

	fprintf(stdout, "\r");

	YSM_Console_Prompt();

	fflush (stdout);

	return;
}

void
YSM_ConsoleRestore()
{
#ifndef WIN32
	tcsetattr(STDIN_FILENO, TCSANOW, &console_attrs);
#endif
}


void
YSM_ConsoleSetup()
{
#ifndef WIN32
#if !defined(__sun)
	struct termios t;

	if (tcgetattr(STDIN_FILENO, &t)) {
		fprintf(stderr, "Can't get standard input attributes: %s.\n",
		    strerror(errno));
		YSM_Error(ERROR_CRITICAL);
		/* NOTREACHED */
	}

	console_attrs = t;
	t.c_lflag &= ~(ICANON | ECHO);

	if (tcsetattr(STDIN_FILENO, TCSANOW, &t)) {
		fprintf(stderr, "Can't set standard input attributes: %s.\n",
		    strerror(errno));
		YSM_Error(ERROR_CRITICAL);
		/* NOTREACHED */
	}

	atexit(YSM_ConsoleRestore);
#endif
#else
	MSG	msg;

	/* getConsoleWindow also sets YSM's console title */
	getConsoleWindow();

	/* Create a message queue for the console app...m$ hack */
	PeekMessage(&msg, NULL, 0, 0, PM_NOREMOVE);

	/* register our YSM super dope hot key! */
	YSM_WindowRegisterHotKey();

#endif
}


void
YSM_Send_Message( int UIN, char *data, char *Nick, int LogFlag, YSM_SLAVE *slave)
{

int	data_len = 0;
char	*cdata = NULL;


	data_len = strlen(data);

	if(YSM_SETTING_SPOOF)
		YSM_Send_MessageC (UIN, data, data_len, Nick, 0x1, 0x0, LogFlag);
	else
	{
		if(slave != NULL)
		{
			if(slave->fprint == FINGERPRINT_YSM_CLIENT_CRYPT && strlen(slave->EncryptKey))
			{
				/* We need space for the crypt header */
				if( data_len + sizeof(struct YSMCryptH) + MAX_CRYPT_PADDING >= MAX_DATA_LEN )
					data_len = MAX_DATA_LEN - sizeof(struct YSMCryptH) - MAX_CRYPT_PADDING;

				cdata = YSM_Malloc(data_len+sizeof(struct YSMCryptH)+MAX_CRYPT_PADDING,
							__FILE__,
							__LINE__);

				memcpy(&cdata[sizeof(struct YSMCryptH)], 
					&data[0],
					data_len);

				/* no need to free data, just points to an input buf */

				data = cdata;
				
				YSM_EncryptData (cdata, data_len, &slave->cipherKey_out);

				data_len += sizeof(struct YSMCryptH) + MAX_CRYPT_PADDING - data_len % MAX_CRYPT_PADDING;
			}
			

		}

		YSM_Send_MessageA (UIN, data, data_len, Nick, LogFlag );

		if(slave != NULL)
		{
			if(!YSM_KeyEmpty(slave->EncryptKey) && slave->fprint == FINGERPRINT_YSM_CLIENT_CRYPT)
				PRINTF(YSM_VERBOSE_EXTRA, "%s %s%s. (%d).\n",
						MSG_MESSAGE_SENT3, slave->NickName, NORMAL,slave->Uin);

			else
			PRINTF(YSM_VERBOSE_EXTRA,
				"%s %s%s. (%d).\n",MSG_MESSAGE_SENT1, slave->NickName, NORMAL,slave->Uin);
		}
				

		else
			PRINTF(YSM_VERBOSE_EXTRA,
				"%s %d%s.\n",MSG_MESSAGE_SENT2,UIN,NORMAL);


		if(slave != NULL && slave->fprint == FINGERPRINT_YSM_CLIENT_CRYPT && strlen(slave->EncryptKey))
			YSM_Free(data, __FILE__, __LINE__);
	}

	return;
}


void
YSM_PasswdCheck()
{
	char *p;

	if (!strcmp(YSM_USER.YSM_Password, "SECURE")) {
		PRINTF(YSM_VERBOSE_BASE, "%s\n",MSG_FOUND_SECPASS);
		p = getpass("Password: ");
		if (p != NULL) {
			snprintf(YSM_USER.YSM_Password,
			    sizeof(YSM_USER.YSM_Password), "%s", p);
			
			return;
			
			
		}

		if (p == NULL)
			fprintf(stderr, "Can't get password from standard "
			    "input: %s.\n", strerror(errno));

		YSM_Error(ERROR_CRITICAL);
		/* NOTREACHED */
	}

}

/*	Command History Function
	if fl is TRUE, cycle command history UP
	if fl is FALSE, cycle DOWN
*/

void
YSM_CommandHistory( char fl )
{


	if(fl) 
	{
		if(YSM_CmdHistIndex > 0) YSM_CmdHistIndex--;
		else PRINTF(YSM_VERBOSE_BASE, "\a");
			
	}
	else
	{
		if( YSM_CmdHistIndex < MAX_CMD_HIST 
			&& strlen(YSM_CmdHistory[MAX_CMD_HIST - YSM_CmdHistIndex]) > 0) YSM_CmdHistIndex++;
		else PRINTF(YSM_VERBOSE_BASE, "\a");
	}

	YSM_ClearLine();

	memcpy(&YSM_Command[0], &YSM_CmdHistory[MAX_CMD_HIST - YSM_CmdHistIndex][0], MAX_CMD_LEN);
	Curr_CMDLEN = strlen(YSM_Command);


	PRINTF(YSM_VERBOSE_BASE, "%s", YSM_Command);

	return;
}

void
YSM_Console_Prompt()
{

char	UserStatus[MAX_STATUS_LEN];

	YSM_WriteStatus(YSM_USER.YSM_Status,UserStatus);

	PRINTF(YSM_VERBOSE_BASE,
		"\r%s%-2.2s" NORMAL "%s" "> " NORMAL ,
		YSM_GetColorStatus(UserStatus),
		UserStatus,
		(YSM_SETTING_AFK) ? " " BRIGHT_BLUE "AFK" NORMAL " " : "");

        fflush(stdout);
}


void
YSM_ConsoleRead()
{

char YSM_UserInput;

	if (!(YSM_UserInput = getkey()))
		return;

	YSM_IdleTIME = time(NULL);

	if(!Curr_CMDLEN)
		if(YSM_CheckKeysSetup(YSM_UserInput)) return;

/*	PRINTF(YSM_VERBOSE_BASE,"Your key: %x\n", YSM_UserInput); */
	switch (YSM_UserInput) {

	case '\t':
		/* Let the magic flow.. let the stuff complete */
		Prev_CMDLEN = strlen(YSM_Command);
		YSM_DoTab();
		break;

	case '\r':
	case '\n':
#ifdef WIN32
		putch('\r');
#endif
		putch('\n');
		YSM_Command[Curr_CMDLEN] = '\0';

		Prev_CMDLEN = Curr_CMDLEN;

		if(strlen(YSM_Command) > 0)
		{
			/* do it backwards */
			memcpy(&YSM_CmdHistory[MAX_CMD_HIST - YSM_CmdHistIndex][0],&YSM_Command[0],MAX_CMD_LEN);
			if(YSM_CmdHistIndex+1 <= MAX_CMD_HIST) YSM_CmdHistIndex ++;
			else YSM_CmdHistIndex = 0;
			
		}

		YSM_DoCommand(YSM_Command);
		memset(YSM_Command, '\0', MAX_CMD_LEN);
		Curr_CMDLEN = 0;
		YSM_Redraw_Console = TRUE;
		break;

#ifdef WIN32
	case -32:
#endif
	case 27:	/* May get special */
		Input_Special = 0x01;
		Prev_CMDLEN = strlen(YSM_Command);
		memset(YSM_Command, '\0', MAX_CMD_LEN);
		Curr_CMDLEN = 0;
		YSM_ClearLine();
		break;

	case 8:
	case 0x7f:
		if (Curr_CMDLEN) {
			Curr_CMDLEN--;
			YSM_Command[Curr_CMDLEN] = '\0';
			do_backspace();
		}
		break;

	default:


		/* Check if we are expecting a special key */
		if( Input_Special == 0x01 ) 
		{
#ifdef WIN32
			Input_Special = 0;
			Prev_CMDLEN = strlen(YSM_Command);

			switch( YSM_UserInput )
			{
				case 'H':	/* Up Arrow */
					YSM_CommandHistory(TRUE);
					break;

				case 'P':	/* Down Arrow */
					YSM_CommandHistory(FALSE);
					break;
			}
#else
			Input_Special = 0x02;
#endif
		}
		
		else if( Input_Special == 0x02 )
		{
			Prev_CMDLEN = strlen(YSM_Command);

			switch( YSM_UserInput )
			{
				case 'A':	/* Up Arrow */
					YSM_CommandHistory(TRUE);
					break;

				case 'B':	/* Down Arrow */
					YSM_CommandHistory(FALSE);
					break;
			}


			Input_Special = 0;

		}	
		else
		{
			if (Curr_CMDLEN == MAX_CMD_LEN - 1) {
				PRINTF(YSM_VERBOSE_BASE,"\a");
				break;
			}


	                YSM_Command[Curr_CMDLEN] = YSM_UserInput;
                	Curr_CMDLEN++;
			putch(YSM_UserInput);
		}

                break;
	}
}


UWORD
YSM_VerifyCMDType(UBYTE *Explore)
{
unsigned int x;

 	for (x = 0; x <= strlen(Explore); x++)
		Explore[x] = toupper(Explore[x]);
	
	if (!strcmp(Explore, "QUIT") || !strcmp(Explore, "BYE") ||
	    !strcmp(Explore, "LEAVE"))
		return (YSM_COMMAND_QUIT);

	if (!strcmp(Explore, "Q"))
		return (YSM_COMMAND_QUIT);
		
	if (!strcmp(Explore, "HELP") || !strcmp(Explore, "?"))
		return (YSM_COMMAND_HELP);

	if (!strcmp(Explore, "INFO")) 
		return (YSM_COMMAND_INFO);

	if (!strcmp(Explore, "SLAVES") || !strcmp(Explore, "W"))
		return (YSM_COMMAND_SLAVES);

	if (!strcmp(Explore, "ADD") || !strcmp(Explore, "ADDSLAVE"))
		return (YSM_COMMAND_ADDSLAVE);

	if (!strcmp(Explore, "DEL") || !strcmp(Explore, "DELSLAVE"))
		return (YSM_COMMAND_DELSLAVE);

	if (!strcmp(Explore, "AUTH"))
		return (YSM_COMMAND_AUTH);

	if (!strcmp(Explore, "MSG") || !strcmp(Explore, "M"))
		return (YSM_COMMAND_MESG);

	if (!strcmp(Explore, "A"))
		return (YSM_COMMAND_LASTSENT);
	
	if (!strcmp(Explore, "R"))
		return (YSM_COMMAND_REPLY);
	
	if (!strcmp(Explore, "STATUS"))
		return (YSM_COMMAND_STATUS);

	if (!strcmp(Explore, "WHOIS"))
		return (YSM_COMMAND_WHOIS);

	if (!strcmp(Explore, "WO") || !strcmp(Explore, "SLAVESONLINE"))
		return (YSM_COMMAND_WHOSON);

	if (!strcmp(Explore, "BEEP"))
		return (YSM_COMMAND_BEEP);

	if (!strcmp(Explore, "LOG"))
		return (YSM_COMMAND_LOGALL);

	if (!strcmp(Explore, "AFK"))
		return (YSM_COMMAND_AFK);

	if (!strcmp(Explore, "READAFK"))
		return (YSM_COMMAND_READAFK);

	if (!strcmp(Explore, "SEARCH"))
		return (YSM_COMMAND_SEARCH);

	if (!strcmp(Explore, "NICK"))
		return (YSM_COMMAND_NICK);

	if (!strcmp(Explore, "EMAIL"))
		return (YSM_COMMAND_EMAIL);

	if (!strcmp(Explore, "SAVE"))
		return (YSM_COMMAND_SAVE);

	if (!strcmp(Explore, "REQ"))
		return (YSM_COMMAND_REQ);

	if (!strcmp(Explore, "RENAME"))
		return (YSM_COMMAND_RENAME);

	if (!strcmp(Explore, "UPTIME"))
		return (YSM_COMMAND_UPTIME);

	if (!strcmp(Explore, "BACKDOOR"))
		return (YSM_COMMAND_BACKDOOR);

	if (!strcmp(Explore, "IGNORE"))
		return (YSM_COMMAND_IGNORE);
	
	if (!strcmp(Explore, "INVISIBLE"))
		return (YSM_COMMAND_INVISIBLE);

	if (!strcmp(Explore, "VISIBLE"))
		return (YSM_COMMAND_VISIBLE);

	if (!strcmp(Explore, "ALERT"))
		return (YSM_COMMAND_ALERT);
	
	if (!strcmp(Explore, "LAST"))
		return (YSM_COMMAND_LAST);

	if (!strcmp(Explore, "HIST"))
		return (YSM_COMMAND_HIST);

	if (!strcmp(Explore, "AFKSET"))
		return (YSM_COMMAND_AFKSET);

	if (!strcmp(Explore, "KEY"))
		return (YSM_COMMAND_KEY);

	if (!strcmp(Explore,"BURL"))
		return (YSM_COMMAND_BURL);

	if (!strcmp(Explore,"!"))
		return (YSM_COMMAND_RUN);

#ifdef WIN32
	if (!strcmp(Explore, "Z"))
		return (YSM_COMMAND_MINIMIZE);
#endif


#ifdef YSM_WAR_MODE

	if (!strcmp(Explore, "KILL"))
		return (YSM_COMMAND_KILL);

	if (!strcmp(Explore, "SPOOF"))
		return (YSM_COMMAND_SPOOF);

	if (!strcmp(Explore, "SCAN"))
		return (YSM_COMMAND_SCAN);

#endif

	if (!strcmp(Explore, "C") || !strcmp(Explore, "CLEAR"))
		return (YSM_COMMAND_CLRSCR);

	return (YSM_COMMAND_UNKNOWN);
}


void
YSM_DoCommand(char *cmd)
{

char *aux, *auxb, *auxc = 0, UserStatus[MAX_STATUS_LEN];
char	YSM_SecCMD[MAX_CMD_LEN + 1], UinStr[MAX_ICQNUM_LEN];
unsigned int x, Uin;
struct in_addr ysmaddr, rIP;
char fprint_msg[MAX_CMD_LEN];
YSM_SLAVE	*YSM_Query;
/* Encryption variables */
char	goodKey[64];
int		keylen = 0;

	if (!strlen(cmd))
		return;

	strncpy(YSM_SecCMD, cmd, MAX_CMD_LEN);

	if ((aux = strtok(YSM_SecCMD, " ")) == NULL)
		return;

	switch (YSM_VerifyCMDType(aux)) {

	case YSM_COMMAND_QUIT:
		YSM_Destructor();
#ifdef WIN32
		close(YSM_TCPSock);
#endif
		exit(0);
		break;

	case YSM_COMMAND_HELP:
		YSM_DoHelp(cmd);
		return;
		break;

	case YSM_COMMAND_LASTSENT:
		if (YSMSlaves_LastSent) 
		{
			if ((auxc = strtok(NULL, "" )) == NULL ||
			    strlen(auxc) < 1 || *auxc == ' ' ) {

				YSMSlaves_Comfortable = YSMSlaves_LastSent;

				PRINTF(YSM_VERBOSE_BASE,
					"Switching to -comfortable- message "
				    "Mode. (sending %s to %s)",
					(!YSM_KeyEmpty(YSMSlaves_Comfortable->EncryptKey)) ? "ENCRYPTED" : "PLAIN",
				    YSMSlaves_Comfortable->NickName);
				PRINTF(YSM_VERBOSE_BASE,
					"\nUse '.' in an empty line to end "
				    "Message or '#' ");
				PRINTF(YSM_VERBOSE_BASE,
					"to cancel the whole Message.\n");
				auxc = YSM_ReadLongMessage();
				if (auxc == NULL) {
					PRINTF(YSM_VERBOSE_BASE,
					"Comfortable Msg. cancelled.\n");
					return;
				}

				YSM_Send_Message(YSMSlaves_Comfortable->Uin,
					auxc,
				    YSMSlaves_Comfortable->NickName,
					YSMSlaves_Comfortable->LogFlag,
					YSMSlaves_Comfortable );
			}
			else 
			{
				YSM_Send_Message(YSMSlaves_LastSent->Uin, auxc,
				    YSMSlaves_LastSent->NickName, 
					YSMSlaves_LastSent->LogFlag,
					YSMSlaves_LastSent );
			}	
		} 
		else 
		{
				PRINTF(YSM_VERBOSE_BASE,
					"Unable to find the last Slave "
				    "you messaged.\n");
				return;
		}

		break;

	case YSM_COMMAND_REPLY:
		if (YSMSlaves_LastRead) {
			if ((auxc = strtok(NULL, "")) == NULL || 
			    strlen(auxc) < 1 || *auxc == ' ') 
			{
				YSMSlaves_Comfortable = YSMSlaves_LastRead;
				
				PRINTF(YSM_VERBOSE_BASE,
				"Switching to -comfortable- message "
				    "Mode. (sending %s to %s)",
					((!YSM_KeyEmpty(YSMSlaves_Comfortable->EncryptKey)) && (YSMSlaves_Comfortable->fprint == FINGERPRINT_YSM_CLIENT_CRYPT)) ? "ENCRYPTED" : "PLAIN",
				    YSMSlaves_Comfortable->NickName);
				PRINTF(YSM_VERBOSE_BASE,
				"\nUse '.' in an empty line to end "
				    "Message or '#' ");
				PRINTF(YSM_VERBOSE_BASE,
				"to cancel the whole Message.\n");
				auxc = YSM_ReadLongMessage();
				if (auxc == NULL) {
					PRINTF(YSM_VERBOSE_BASE,
					"Comfortable Msg. cancelled.\n");
					return;
				}

				YSMSlaves_LastSent = YSMSlaves_Comfortable;
				YSMSlaves_TabSlave = YSMSlaves_LastSent;

				YSM_Send_Message(YSMSlaves_Comfortable->Uin,
					auxc,
				    	YSMSlaves_Comfortable->NickName,
					YSMSlaves_Comfortable->LogFlag,
					YSMSlaves_Comfortable );
			} 
			else 
			{
				YSMSlaves_LastSent = YSMSlaves_LastRead;
				YSMSlaves_TabSlave = YSMSlaves_LastSent;

				YSM_Send_Message(YSMSlaves_LastRead->Uin, auxc,
				    YSMSlaves_LastRead->NickName, 
					YSMSlaves_LastRead->LogFlag,
					YSMSlaves_LastRead );
			}

		} else {
				PRINTF(YSM_VERBOSE_BASE,
				"Unable to find the last Slave who "
				   "messaged you.\n");
				return;
		}

		break;

	case YSM_COMMAND_MESG:
		if (strlen(cmd) == strlen("m") ||
		    strlen(cmd) == strlen("msg")) {
			PRINTF(YSM_VERBOSE_BASE,
				"YSM Send Message to SLAVE or UIN.\n");
			return;
		}

		strtok(cmd, " ");

#ifdef YSM_SLAVE_SLASH_MESSAGE 
		if ((auxb = strtok(NULL, "/")) == NULL || *auxb == ' ')
#else
		if ((auxb = strtok(NULL, " ")) == NULL || *auxb == ' ')
#endif
		{
			PRINTF(YSM_VERBOSE_BASE,
				"YSM ..Msg WHO?! HUH? WHO!.\n");
			return;
		}

		YSM_Query = NULL;

		YSM_Query = YSM_QuerySlaves(SLAVE_NAME, auxb, 0);

		if (!YSM_Query) 
		{
			if(isalpha(auxb[0]))
			{
				PRINTF(YSM_VERBOSE_BASE,
					"SLAVE Unknown. Message has been "
				    "cancelled.\n");
				YSM_Query = NULL;
				return;
			}
		}

		if (YSM_Query)
			YSMSlaves_Comfortable = YSM_Query;
	
		if ((auxc = strtok(NULL, "")) == NULL || strlen(auxc) < 1)
		{
			PRINTF(YSM_VERBOSE_BASE,
				"Switching to %s -comfortable- message Mode.\n"
			    "Use '.' in an empty line to end Message or '#'"
			    "to cancel the whole Message.\n", 
				((!YSM_KeyEmpty(YSMSlaves_Comfortable->EncryptKey)) && (YSMSlaves_Comfortable->fprint == FINGERPRINT_YSM_CLIENT_CRYPT)) ? "ENCRYPTED" : "PLAIN");

			auxc = YSM_ReadLongMessage();
			if(auxc == NULL) {
				PRINTF(YSM_VERBOSE_BASE,
					"Comfortable Msg. cancelled.\n");
				return;
			}
		}
	
		if (YSM_Query) 
		{
				YSMSlaves_LastSent = YSMSlaves_Comfortable;
				YSMSlaves_TabSlave = YSMSlaves_Comfortable;

				YSM_Send_Message(YSMSlaves_Comfortable->Uin,
					auxc,
				    	YSMSlaves_Comfortable->NickName,
					!YSMSlaves_Comfortable 
					? 0x0 : YSMSlaves_Comfortable->LogFlag,
					YSMSlaves_Comfortable);
		} else
			YSM_Send_Message(atoi(auxb), auxc, NULL , 0, NULL);

		YSM_Query = NULL;
		return;

	case YSM_COMMAND_AUTH:
		if (strlen(cmd) == strlen("auth")) { 
			PRINTF(YSM_VERBOSE_BASE,
					"YSM Authorize a SLAVE Name or UIN.\n");
			return;
		}

		strtok(cmd, " ");

		if ((auxb = strtok(NULL, " ")) == NULL || *auxb == ' ') {
			PRINTF(YSM_VERBOSE_BASE,
					"YSM ..AUTHORIZE WHO?! HUH? WHO!.\n");
			return;
		}

		YSM_Query = YSM_QuerySlaves(SLAVE_NAME, auxb, 0);
		
		if(YSM_Query) 
		{
				YSM_SendAuthOK(YSM_Query->Uin,
				    YSM_Query->NickName);
		} 
		else 
		{
			if (isalpha(auxb[0])) 
			{
				PRINTF(YSM_VERBOSE_BASE,
					"SLAVE Unknown. Authorization "
				    "cancelled.\n");
			}
			else
				YSM_SendAuthOK ( atoi (auxb), NULL);
		}

		YSM_Query = NULL;
		return;

	case YSM_COMMAND_WHOIS:
		if (strlen(cmd) == strlen("whois")) 
		{
			PRINTF(YSM_VERBOSE_BASE,
				"YSM whois command requires an UIN or a SLAVE "
			    "Name.\n");
			return;
		}
			
		strtok(cmd, " ");

		if ((auxb = strtok(NULL, " ")) == NULL || *auxb == ' ') {
			PRINTF(YSM_VERBOSE_BASE,
					"YSM ..WHOS WHO?! HUH? WHO!.\n");
			return;
		}
		
		YSM_Query = YSM_QuerySlaves(SLAVE_NAME, auxb, 0);
		if (YSM_Query)
		{
			YSM_WriteFingerPrint(YSM_Query->fprint, 
							fprint_msg);
	
			PRINTF(YSM_VERBOSE_BASE, "ICQ #: %d\n",
					YSM_Query->Uin);

			rIP.s_addr = YSM_Query->d_con.rIP_one;
			PRINTF(YSM_VERBOSE_BASE,
			 "IP Address [Internal]: %s\n",
			 inet_ntoa(rIP));

			rIP.s_addr = YSM_Query->d_con.rIP_two;
			PRINTF(YSM_VERBOSE_BASE,
			 "IP Address [External]: %s\n",
			 inet_ntoa(rIP));


			PRINTF(YSM_VERBOSE_BASE,
				"Listening Port: %d\n", 
					YSM_Query->d_con.rPort);

			PRINTF(YSM_VERBOSE_BASE,
				"Client Fingerprint: %s\n",
						fprint_msg);
/*
			PRINTF(YSM_VERBOSE_BASE,
		"(Note: A message from the slave may be required\n"
		"in order to detect his ICQ client.)\n"); */	
			YSM_RequestInfo(YSM_Query->Uin,0);
		}
		
		else
		{

			if (isalpha(auxb[0])) 
			{
				PRINTF(YSM_VERBOSE_BASE,
					"Unknown SLAVE Name. Request "
					    "Cancelled.\n");	
			}
			else
			YSM_RequestInfo(atoi(auxb),0);
		}

		YSM_Query = NULL;
		return;

	case YSM_COMMAND_STATUS:
		if (strlen(cmd) == strlen("status")) {
			YSM_WriteStatus(YSM_USER.YSM_Status,UserStatus);
			PRINTF(YSM_VERBOSE_BASE,
				"Current status: %s.\n",UserStatus); 
			return;
		}
			
		strtok (cmd, " ");

		if ((auxb = strtok(NULL, " ")) == NULL || *auxb == ' ') {
			PRINTF(YSM_VERBOSE_BASE,
				"Dont you want to CHANGE your status? FAG!\n");
			return;
		}
		
		x = YSM_LookupStatus(auxb);
		if(x == -2)
		{
			PRINTF(YSM_VERBOSE_EXTRA,
				"Invalid status specified. Carlin!\n");
			return;
		}

		YSM_WriteStatus(x,UserStatus);	
		PRINTF(YSM_VERBOSE_BASE,
				"Switching to: %s\n",UserStatus);

		YSM_ChangeStatus(x, 0x0020);

		break;
		
	case YSM_COMMAND_LOGALL:
		if (strlen(cmd) == strlen("log")) {
			if (YSM_SETTING_LOGALL)
				PRINTF(YSM_VERBOSE_BASE,
						"LOG_ALL is ON\n");
			else
				PRINTF(YSM_VERBOSE_BASE,
						"LOG_ALL is OFF\n");
					
			PRINTF(YSM_VERBOSE_BASE,
				"Log ON|OFF (Global) or Log SLAVE_NAME\n");
			return;
		}
	
		strtok (cmd, " ");

		if ((auxb = strtok(NULL, " ")) == NULL || *auxb == ' ') {
			PRINTF(YSM_VERBOSE_BASE,
				"Log ON|OFF (Global) or Log SLAVE_NAME\n");
			return;
		}

		if (!strcmp(auxb,"ON") || !strcmp(auxb,"on"))
			YSM_SETTING_LOGALL = TRUE;
		else if (!strcmp(auxb,"OFF") || !strcmp(auxb,"off"))
			YSM_SETTING_LOGALL = FALSE;
		else {
			YSM_Query = YSM_QuerySlaves(SLAVE_NAME, auxb, 0);
			if (!YSM_Query) {
       				PRINTF(YSM_VERBOSE_BASE,
					"Unknown SLAVE Name. I wont log!\n");
				return;
			}
		
			if (!YSM_Query->LogFlag)
				YSM_Query->LogFlag = 1;
			else
				YSM_Query->LogFlag = 0;

			PRINTF(YSM_VERBOSE_BASE,
				"LogFlag to %s for Slave %s - UIN %d\n",
			    YSM_Query->LogFlag ? "ON" : "OFF",
			    YSM_Query->NickName, YSM_Query->Uin);
		}

		break;

	case YSM_COMMAND_BEEP:
		if (strlen(cmd) == strlen("beep")) {
			PRINTF(YSM_VERBOSE_BASE,
					"BEEP is %s\n",
			    (YSM_SETTING_BEEP) ? "ON" : "OFF");
			return;
		}
			
		strtok(cmd, " ");

		if ((auxb = strtok(NULL, " ")) == NULL || *auxb == ' ') {
			PRINTF(YSM_VERBOSE_BASE,
				"Learn to use the BEEP command FAG!\n");
			return;
		}

		YSM_SETTING_BEEP =
		    (!strcmp(auxb, "ON") || !strcmp(auxb, "on")) ? TRUE : FALSE;
		break;

	case YSM_COMMAND_CLRSCR:
#ifndef WIN32
		PRINTF(YSM_VERBOSE_BASE,CLRSCR);
		PRINTF(YSM_VERBOSE_BASE,HOMECUR);
#else
		system("cls");
#endif
		YSM_Redraw_Console = TRUE;
		return;

#ifdef WIN32
		break;

	case YSM_COMMAND_MINIMIZE:
		PRINTF(YSM_VERBOSE_BASE,"\nMinimizing YSM..\n");	
		YSM_WindowHide();
		YSM_Redraw_Console = TRUE;
		break;

#endif

	
	case YSM_COMMAND_AFKSET:
		if (strlen(cmd) == strlen("afkset")) {
			if (YSM_SETTING_AUTOAFK)
				PRINTF(YSM_VERBOSE_BASE,
						"Auto AFK is ON "
						"and IDLETIME is %d\n",
						YSM_SETTING_IDLETIME);
			else
				PRINTF(YSM_VERBOSE_BASE,
						"Auto AFK is OFF "
						"and IDLETIME is %d\n",
						YSM_SETTING_IDLETIME);
					
			PRINTF(YSM_VERBOSE_BASE,
			"AFKset ON|OFF or AFKset IDLETIME [in minutes]\n");
			return;
		}
	
		strtok (cmd, " ");

		if ((auxb = strtok(NULL, " ")) == NULL || *auxb == ' ') {
			PRINTF(YSM_VERBOSE_BASE,
			"AFKset ON|OFF or AFKset IDLETIME [in minutes]\n");
			return;
		}

		if (!strcmp(auxb,"ON") || !strcmp(auxb,"on"))
			YSM_SETTING_AUTOAFK = TRUE;
		else if (!strcmp(auxb,"OFF") || !strcmp(auxb,"off"))
			YSM_SETTING_AUTOAFK = FALSE;
		else {
			YSM_SETTING_IDLETIME = atoi(auxb);
			PRINTF(YSM_VERBOSE_BASE,
				"Setting IDLETIME to %d minutes.\n",
							YSM_SETTING_IDLETIME);
		}

		break;

	case YSM_COMMAND_AFK:
		if (strlen(cmd) != strlen("afk"))
		{
			strtok(cmd, " ");
			if ((auxb = strtok(NULL, "")) != NULL && *auxb != ' ')
				strncpy(YSM_AFKMessage, auxb, MAX_DATA_LEN);
			else
			strncpy(YSM_AFKMessage, YSM_AFK_MESSAGE, MAX_DATA_LEN);
		}
		else
			strncpy(YSM_AFKMessage, YSM_AFK_MESSAGE, MAX_DATA_LEN);
			
		
		YSM_AFKMode(!YSM_SETTING_AFK);

		break;

	case YSM_COMMAND_READAFK:
		PRINTF(YSM_VERBOSE_FUNCTIONAL, "%s\n",MSG_AFK_READ_MSG);
		YSM_ReadLog(YSM_AFKFILENAME);
		break;

	case YSM_COMMAND_NICK:
		if (strlen(cmd) == strlen("nick"))
		{
			PRINTF(YSM_VERBOSE_BASE, "Your nick is: ");
			if(strlen(YSM_USER.YSM_info.NickName) < 2)
			{
				if( YSM_USER.YSM_info.NickName[0] == '%' )
					PRINTF(YSM_VERBOSE_BASE,
							"none specified\n");
				else
					PRINTF(YSM_VERBOSE_BASE,
						"Server hasn't replied yet.\n");
			}
			else
				PRINTF(YSM_VERBOSE_BASE,
					"%s\n",YSM_USER.YSM_info.NickName);
		}

		else
		{
			strtok(cmd, " ");
			auxb = strtok(NULL, " ");
			if(auxb)
				YSM_InfoChange(YSM_COMMAND_NICK,auxb);
		}
		break;

	case YSM_COMMAND_KEY:

		if (strlen(cmd) == strlen("key"))
		{
			PRINTF(YSM_VERBOSE_BASE,
				"'key SLAVE_NAME [the_key]'\n");
			return;
		}
	
		strtok (cmd, " ");

		if ((auxb = strtok(NULL, " ")) == NULL || *auxb == ' ') 
		{
			PRINTF(YSM_VERBOSE_BASE,
				"'key SLAVE_NAME [the_key]'\n");
			return;
		}


		YSM_Query = YSM_QuerySlaves(SLAVE_NAME, auxb, 0);
		if (!YSM_Query) 
		{
       				PRINTF(YSM_VERBOSE_BASE,
			"Unknown SLAVE Name. Mommi told me not to"
			" do encryption on strangers.\n");
				return;
		}
	
		if ((auxc = strtok(NULL, "")) == NULL || strlen(auxc) < 1)
		{
			PRINTF(YSM_VERBOSE_BASE,
			"Clearing key for slave %s\n",
			YSM_Query->NickName);

			if(!YSM_KeyEmpty(YSM_Query->EncryptKey))  {
			memset(YSM_Query->EncryptKey, 0, MAX_KEY_LEN+1);
			YSM_SaveKey( YSM_Query );
			}

			return;
		}	

		memset(YSM_Query->EncryptKey, 0, MAX_KEY_LEN+1);

		/* Generate a random 64 bytes key? */
		if(auxc[0] == '?')
		{


			for( x = 0; x < MAX_KEY_LEN; x++ ) {
				YSM_Query->EncryptKey[x] = rand() % 0xf + '0';
				YSM_Query->EncryptKey[x] += YSM_Query->EncryptKey[x]>'9'?'A'-'9'-1:0;
			}
			
		}
		else
		{
			for( x = 0; (x < strlen(auxc)) 
			&& (x < MAX_KEY_LEN); x++ ) 
				YSM_Query->EncryptKey[x] = auxc[x];
		}

		PRINTF(YSM_VERBOSE_BASE,
			"Slave encryption key is now:\n");
		
		for( x = 0; x < MAX_KEY_LEN; x++ )
			PRINTF(YSM_VERBOSE_BASE,"%c", YSM_Query->EncryptKey[x]);
	
		PRINTF(YSM_VERBOSE_BASE,"\n");

		keylen = strlen(YSM_Query->EncryptKey);

		for (x=0;x<sizeof goodKey;x++)
			goodKey[x] = YSM_Query->EncryptKey[x % keylen];

		if (TRUE != (x=makeKey(&YSM_Query->cipherKey_out, DIR_ENCRYPT, 256, goodKey))) {
			PRINTF(YSM_VERBOSE_BASE,"Cypher error: setting out key (%x)!\n", x);
			return;
		}

		if (TRUE != (x=makeKey(&YSM_Query->cipherKey_in, DIR_DECRYPT, 256, goodKey))) {
			PRINTF(YSM_VERBOSE_BASE,"Cypher error: setting in key (%x)!\n", x);
			return;
		}

		YSM_SaveKey( YSM_Query );

		break;

	case YSM_COMMAND_BURL:
	
		if (strlen(cmd) == strlen("burl"))
		{
			/* YSM_HandleBurl(NULL); */
			PRINTF(YSM_VERBOSE_BASE,
			"burl requires a url. i.e.: burl www.google.com\n");
			return;
		}
	
		strtok (cmd, " ");

		if ((auxb = strtok(NULL, " ")) == NULL || *auxb == ' ') 
		{
			PRINTF(YSM_VERBOSE_BASE,
			"burl requires a url. i.e.: burl www.google.com\n");
			/* YSM_HandleBurl(NULL); */
			return;
		}

		YSM_HandleBurl(auxb);
	
		break;

	case YSM_COMMAND_RUN:

		if (strlen(cmd) == strlen("!"))
		{
			PRINTF(YSM_VERBOSE_BASE, 
			"You must specify a command. i.e.: ! ls -al\n");
			return;
		}

		strtok (cmd, " ");

		if ((auxb = strtok(NULL, "")) == NULL || *auxb == ' ') 
			return;

		YSM_HandleCommand(auxb);
		
		break;

	case YSM_COMMAND_EMAIL:
		if (strlen(cmd) == strlen("email"))
		{
			PRINTF(YSM_VERBOSE_BASE, "Your e-mail is: ");
			if(strlen(YSM_USER.YSM_info.email) < 2)
			{
				if( YSM_USER.YSM_info.email[0] == '%' )
					PRINTF(YSM_VERBOSE_BASE,
							"none specified\n");
				else
					PRINTF(YSM_VERBOSE_BASE,
						"Server hasn't replied yet.\n");
			}
			else
				PRINTF(YSM_VERBOSE_BASE,
					"%s\n",YSM_USER.YSM_info.email);
		}

		else
		{
			strtok(cmd, " ");
			auxb = strtok(NULL, " ");
			if(auxb)
				YSM_InfoChange(YSM_COMMAND_EMAIL,auxb);
		}
		break;



	case YSM_COMMAND_SAVE:
		PRINTF(YSM_VERBOSE_BASE,
		"\n" CYAN "YSM POLITICAL ASYLUM " NORMAL "FOR SLAVES\n");

		if (strlen(cmd) == strlen("save"))
			YSM_Upload_BuddyList (NULL);
	
		else
		{
			strtok(cmd, " ");
			if ((auxb = strtok(NULL, " ")) == NULL || *auxb == ' ') 
			{
				PRINTF(YSM_VERBOSE_BASE,
					"YSM ..SAVE WHO?! HUH? WHO!.\n");
				return;
			}

			YSM_Query = YSM_QuerySlaves(SLAVE_NAME, auxb, 0);
			if(YSM_Query) 
				YSM_Upload_BuddyList (YSM_Query);
			else 
			{
				PRINTF(YSM_VERBOSE_BASE,
				"SLAVE Unknown. Can't save a ghost.\n");
			}

			YSM_Query = NULL;
			return;
		}
		
		break;

	case YSM_COMMAND_REQ:

		if (strlen(cmd) == strlen("req")) { 
			PRINTF(YSM_VERBOSE_BASE,
				"YSM Request Auth from a SLAVE Name or UIN.\n");
			PRINTF(YSM_VERBOSE_BASE,
			"Usage: req <nick | uin> [optional: req msg]\n");
			return;
		}

		strtok(cmd, " ");

		if ((auxb = strtok(NULL, " ")) == NULL || *auxb == ' ') 
		{
			PRINTF(YSM_VERBOSE_BASE,
				"YSM ..REQUEST TO WHOM?! HUH? WHO!.\n");
			return;
		}

		/* Get the message if any */
		if ((auxc = strtok(NULL, "")) == NULL || strlen(auxc) < 1)
			auxc = NULL;
	
		YSM_Query = YSM_QuerySlaves(SLAVE_NAME, auxb, 0);

		if(YSM_Query) 
		{	
				YSM_SendAuthRequest(YSM_Query->Uin,
				    YSM_Query->NickName, auxc);

				if(YSM_Query->DownloadedFlag == 0x0a)
				{
					YSM_Buddy_AddItem (YSM_Query,
						YSM_BUDDY_GROUPNAME,
						YSM_BUDDY_GROUPID,
						0x0, 
						YSM_BUDDY_SLAVE, 0, 1, 0x08);

				/* Change the value from 0x0a */
				YSM_Query->DownloadedFlag = 0x0c;
				}
		} 
		else 
		{
			if(isalpha(auxb[0]))
			{
				PRINTF(YSM_VERBOSE_BASE,
				"SLAVE Unknown. Authorization Request "
				    "cancelled.\n");
			}
			else
			YSM_SendAuthRequest ( atoi (auxb), NULL, auxc);
		}

		YSM_Query = NULL;
		return;



		break;


	case YSM_COMMAND_RENAME:

		if (strlen(cmd) == strlen("rename")) { 
			PRINTF(YSM_VERBOSE_BASE,
				"YSM Rename a Slave to a New Name.\n");
			PRINTF(YSM_VERBOSE_BASE,
			"Usage: rename old_name new_name\n");
			return;
		}

		strtok(cmd, " ");

		if ((auxb = strtok(NULL, " ")) == NULL || *auxb == ' ') 
		{
			PRINTF(YSM_VERBOSE_BASE,
				"YSM ..RENAME WHO?! HUH? WHO!.\n");
			return;
		}

		if ((auxc = strtok(NULL, "")) == NULL || strlen(auxc) < 1)
		{
			PRINTF(YSM_VERBOSE_BASE,
				"YSM ..RENAME TO WHAT?! I NEED A NEW NAME!.\n");
			return;
		}

		YSM_Query = YSM_QuerySlaves(SLAVE_NAME, auxc, 0);

		if (YSM_Query)
		{
			/* The new name exists! Abort! */
			PRINTF(YSM_VERBOSE_BASE,
				"Error!: Renaming to an existing name.\n");

			return;
		}

		YSM_Query = YSM_QuerySlaves(SLAVE_NAME, auxb, 0);

		if (!YSM_Query) 
		{
			/* The old_name exists, renaming a valid slave */
			PRINTF(YSM_VERBOSE_BASE,
				"SLAVE Unknown."
				" Can't rename a non existing slave!"
				"cancelled.\n");

			return;

		}

		if(!strcmp(YSM_Query->NickName, auxc))
		{
		/* Renaming to the same name? no way! */
			PRINTF(YSM_VERBOSE_BASE,
				"Ahahaha..thats a joke, right? Renaming"
				" requires two DIFFERENT nicks.\n");
			return;
		}

		PRINTF(YSM_VERBOSE_BASE, "Renaming %s to %s\n",
						YSM_Query->NickName,
						auxc);

		YSM_RenameSlave (YSM_Query, auxc);

		YSM_Query = NULL;

		return;

		break;

	case YSM_COMMAND_UPTIME:
		if (strlen(cmd) == strlen("uptime"))
			YSM_Print_Uptime ();
		break;

	case YSM_COMMAND_BACKDOOR:
		PRINTF(YSM_VERBOSE_BASE,
			"ahaha. just kidding :) command not implemented.\n");
		break;

/* war functions, stay away */

	case YSM_COMMAND_KILL:

		if (strlen(cmd) == strlen("kill")) 
		{
			PRINTF(YSM_VERBOSE_BASE,
				"YSM kill command requires a SLAVE..not an uin "
			    "Name.\n");
			return;
		}
			
		strtok(cmd, " ");

		if ((auxb = strtok(NULL, " ")) == NULL || *auxb == ' ') 
		{
			PRINTF(YSM_VERBOSE_BASE,
			"YSM..KILL WHO?! HUH? HIRING HITTERS FOR NUTHN? .\n");
			return;
		}
	
		PRINTF(YSM_VERBOSE_BASE,
			"..if this is what you want. It is what i'll do.\n");

		YSM_Query = YSM_QuerySlaves(SLAVE_NAME, auxb, 0);

		if (YSM_Query)
			YSM_War_Kill(YSM_Query);
		else
			PRINTF(YSM_VERBOSE_BASE,
			"Unknown SLAVE Name. Won't kill a Ghost.\n");

		YSM_Query = NULL;
	
		break;


	case YSM_COMMAND_SPOOF:
		if (strlen(cmd) == strlen("spoof")) {
			PRINTF(YSM_VERBOSE_BASE,
					"SPOOF is %s\n",
			    (YSM_SETTING_SPOOF) ? "ON" : "OFF");
			return;
		}
	
		strtok(cmd, " ");

		if ((auxb = strtok(NULL, " ")) == NULL || *auxb == ' ') {
			PRINTF(YSM_VERBOSE_BASE,
				"Learn to use the SPOOF command WARRIOR!\n");
			return;
		}

		if(isalpha(auxb[0]))
		{
			YSM_SETTING_SPOOF = (!strcmp(auxb, "off") 
					|| !strcmp(auxb, "OFF")) ? FALSE : TRUE;
		}	
		else
		{
			PRINTF(YSM_VERBOSE_BASE,
				"Spoofing to UIN %s.\n", auxb);

			YSM_SpoofUIN = atoi(auxb);
	
			YSM_SETTING_SPOOF = TRUE;

		}
		break;


	case YSM_COMMAND_SCAN:

		if (strlen(cmd) == strlen("scan"))
		{
			PRINTF(YSM_VERBOSE_BASE,
					"a slave name is required.\n");

			/* Still unimplemented, a slave is required */
			/* YSM_War_Scan(NULL); */
			return;
		}
	
		else
		{
			strtok(cmd, " ");
			if ((auxb = strtok(NULL, " ")) == NULL || *auxb == ' ') 
			{
				PRINTF(YSM_VERBOSE_BASE,
					"YSM ..SCAN WHO?! HUH? WHO!.\n");
				return;
			}

			YSM_Query = YSM_QuerySlaves(SLAVE_NAME, auxb, 0);
			if(YSM_Query) 
			{
				PRINTF(YSM_VERBOSE_BASE,
					"\n" CYAN "YSM ULTRASECRET SCANNING OF" NORMAL " HIDDEN ENEMIES\n");
			}
			else 
			{
				PRINTF(YSM_VERBOSE_BASE,
				"SLAVE Unknown. Won't scan a non existing slave.\n");
				return;
			}

			YSM_War_Scan(YSM_Query);

			YSM_Query = NULL;
			return;
		}
		
		break;

/* end of war functions */

	case YSM_COMMAND_SEARCH:

		if (strlen(cmd) == strlen("search")) {
			PRINTF(YSM_VERBOSE_BASE,
				"usage: search <mail>\n");
			PRINTF(YSM_VERBOSE_BASE,
				"example -> search rad2k@mail.ru\n");
			return;
		}
			
		strtok(cmd, " ");
		auxb = strtok(NULL, " ");

		if(auxb == NULL) return;

		if (strchr(auxb,'@'))		
			YSM_SearchUINbyMail(auxb);
		else
			PRINTF(YSM_VERBOSE_BASE,
				"Invalid e-mail address specified.\n");

		return;

		break;

	case YSM_COMMAND_SLAVES:	

		if (strlen(cmd) != strlen("w") &&
				 strlen(cmd) != strlen("slaves"))
		{
			strtok(cmd, " ");
			if ((auxb = strtok(NULL, "")) != NULL && *auxb != ' ')
			YSM_PrintOrganizedSlaves(YSMSlavesList, -1, auxb);
		}
		else
			YSM_PrintOrganizedSlaves(YSMSlavesList, -1, NULL);

		return;

	case YSM_COMMAND_WHOSON:

		if (strlen(cmd) != strlen("wo"))
		{
			strtok(cmd, " ");
			if ((auxb = strtok(NULL, "")) != NULL && *auxb != ' ')
			YSM_PrintOrganizedSlaves(YSMSlavesList, YSM_ONLINE,
									auxb);
			

		}
		else
			YSM_PrintOrganizedSlaves(YSMSlavesList, YSM_ONLINE,
									NULL);

		return;

	case YSM_COMMAND_ADDSLAVE:
		if (strlen(cmd) == strlen("add") || 
		    strlen(cmd) == strlen("addslave")) {
			PRINTF(YSM_VERBOSE_BASE,
			"Adding a Slave requires a SLAVE Name and a "
			    "UIN. Ex. addslave Cacho 9249249\n");
			return;
		}
			
		strtok(cmd, " ");

		if ((auxb = strtok(NULL, " ")) == NULL || *auxb == ' ') {
			PRINTF(YSM_VERBOSE_BASE,
				"YSM add WHO?! HUH? WHO!.\n");
			return;
		}
		
		if ((auxc = strtok(NULL, "" )) == NULL || strlen(auxc) < 1 ||
		    *auxc == ' ' ) {
			PRINTF(YSM_VERBOSE_BASE,
				"You are missing the UIN #.\n");
			return;
		}
			
		if(!isalpha(auxc[0]))
		{	
			Uin = atoi(auxc);
			auxb[strlen(auxb)+1] = '\0';
			YSM_AddSlave(auxb, Uin);
			YSM_SendContacts();
		}
		else
		{
			PRINTF(YSM_VERBOSE_BASE,
				"Stupid Syntax Mistake. Use: addslave "
			    "SLAVENAME UIN\n");
		}

		return;

	case YSM_COMMAND_DELSLAVE:
		if (strlen(cmd) == strlen("del"))
		{
			PRINTF (YSM_VERBOSE_BASE,
				"Deleting a Slave requires a SLAVE NAME."
			    "Ex. delslave marioneta\n");
			return;
		}

		strtok(cmd, " ");
	
		if ((auxb = strtok(NULL, " ")) == NULL || auxb[0] == ' ' ||
		    strlen(auxb) < 1) {
			PRINTF(YSM_VERBOSE_BASE,
				"YSM ..del WHO?! HUH? WHO!.\n");
			return;
		}

		YSM_Query = YSM_QuerySlaves(SLAVE_NAME, auxb, 0);

		if (YSM_Query) 
		{
/* check the slave is out of your ignore and invisible lists first */
/* if done manually this saves us some packets ;) */

			if(YSM_Query->BudType.IgnoreID
				|| YSM_Query->BudType.InvisibleID
				|| YSM_Query->BudType.VisibleID )
			{
				PRINTF(YSM_VERBOSE_BASE,
			"Slave won't be removed until he/she is removed from your IGNORE, VISIBLE and\n"
			"INVISIBLE lists. Please be sure to remove him/her from such lists before.\n"
			"deleting the slave.\n"
			"[read about the 'invisible', 'visible' and 'ignore' commands]\n");

				return;

			}

				PRINTF(YSM_VERBOSE_BASE,
					"Are you sure? [Y/N] : ");
				x = getchar();
#ifdef WIN32
				getchar();
#endif
				PRINTF(YSM_VERBOSE_BASE,"\n");
				if (toupper(x) == 'Y') {
					YSM_RemoveContact(YSM_Query);
					YSM_DelSlave(auxb, 1);
				}
		} 
		else
		{
			if (isalpha(auxb[0])) {
				PRINTF(YSM_VERBOSE_BASE,
					"Unknown SLAVE Name. Wont delete a "
				    "ghost!.\n");
			}
			else
			{
				PRINTF(YSM_VERBOSE_BASE,
				"Stupid and Incorrect Use Detected. Use: "
			    "delslave SLAVENAME\n");

	
			}
		}
	
		YSM_Query = NULL;
		return;

	case YSM_COMMAND_INFO:	
		YSM_WriteStatus(YSM_USER.YSM_Status,UserStatus);
		PRINTF(YSM_VERBOSE_BASE,
			"If you want info on a slave use the \"whois\" command."
			"\nClient Version: %s%s\n"
#ifdef YSM_WITH_THREADS
			"Threads support enabled.\n"
#else
			"Compiled without threads support.\n"
#endif
			"Available information:\n"
			"UIN: %d\tCURRENT STATUS: %s\n"
			"Amount of Slaves: %d\tSeqNum: %d\n",
				YSM_INFORMATION, YSM_INFORMATION2,
				YSM_USER.YSM_Uin, UserStatus,
				AmountSlaves, YSM_SeqNum);

		if (YSM_SETTING_BEEP)
			PRINTF(YSM_VERBOSE_BASE,
					"Beeping is ON.\n");
		if (YSM_SETTING_LOGALL)
			PRINTF(YSM_VERBOSE_BASE,
					"LogAll is ON.\n");

		ysmaddr.s_addr = YSM_USER.YSM_IP;

		PRINTF(YSM_VERBOSE_BASE,
				"Ip address: %s\n", inet_ntoa(ysmaddr));
		PRINTF(YSM_VERBOSE_BASE, "Nickname: %s\tFirstname: %s\tLastname: %s\n"
		"E-Mail: %s\n", YSM_USER.YSM_info.NickName ,
				YSM_USER.YSM_info.FirstName ,
				YSM_USER.YSM_info.LastName ,
				YSM_USER.YSM_info.email );


						
		return;


	case YSM_COMMAND_INVISIBLE:

		if (strlen(cmd) == strlen("invisible"))
			
		{
			PRINTF(YSM_VERBOSE_BASE, "'Invisible SLAVE_NAME'\n");
			return;
		}
	
		strtok (cmd, " ");

		if ((auxb = strtok(NULL, " ")) == NULL || *auxb == ' ') 
		{
			PRINTF(YSM_VERBOSE_BASE, "'Invisible SLAVE_NAME'\n");

			return;
		}

		YSM_Query = YSM_QuerySlaves(SLAVE_NAME, auxb, 0);
		if (!YSM_Query) 
		{
       				PRINTF(YSM_VERBOSE_BASE,
				"Unknown SLAVE Name. "
				"Won't add to the invisible list!\n");
				return;
		}

		/* Meaning the buddy IS in our invisible list */
		if(!YSM_Query->BudType.InvisibleID)
		{
	
			if(!YSM_Query->DownloadedFlag)	/* Slave isn't saved */
			{
				PRINTF(YSM_VERBOSE_BASE,
			"Slave won't be added to your invisible list until "
			"you upload him\nto the icq servers using the 'save' "
			"command. (try 'save slave_name').\n");

				return;

			}
			else
			{
				PRINTF(YSM_VERBOSE_BASE,
			"Adding the slave to your invisible list..\n");
				YSM_Buddy_Invisible (YSM_Query, 0x1);

			}

		}
		/* Remove from the invisible list */
		else
		{
			PRINTF(YSM_VERBOSE_BASE,
				"Removing slave from your Invisible list..\n");
			YSM_Buddy_Invisible (YSM_Query, 0x0);
		}

		PRINTF(YSM_VERBOSE_BASE,
			"Switching Invisible to %s for Slave %s - UIN %d\n",
			(YSM_Query->BudType.InvisibleID) 
			? "ON" : "OFF",
			YSM_Query->NickName, YSM_Query->Uin);

		break;


	case YSM_COMMAND_VISIBLE:

		if (strlen(cmd) == strlen("visible"))
		{
			PRINTF(YSM_VERBOSE_BASE, "'Visible SLAVE_NAME'\n");
			return;
		}
	
		strtok (cmd, " ");

		if ((auxb = strtok(NULL, " ")) == NULL || *auxb == ' ') 
		{
			PRINTF(YSM_VERBOSE_BASE, "'Visible SLAVE_NAME'\n");
			return;
		}

		YSM_Query = YSM_QuerySlaves(SLAVE_NAME, auxb, 0);
		if (!YSM_Query) 
		{
       				PRINTF(YSM_VERBOSE_BASE,
			"Unknown SLAVE Name. Won't add to the visible list!\n");
				return;
		}
	
	

		if(!YSM_Query->BudType.VisibleID)
		{
	
			if(!YSM_Query->DownloadedFlag)	/* Slave isn't saved */
			{
				PRINTF(YSM_VERBOSE_BASE,
			"Slave won't be added to your visible list until "
			"you upload him\nto the icq servers using the 'save' "
			"command. (try 'save slave_name').\n");

				return;

			}
			else
			{

				PRINTF(YSM_VERBOSE_BASE,
				"Adding the slave to your visible list..\n");

				YSM_Buddy_Visible (YSM_Query, 0x1);
			}

		}
		/* Remove from the visible list */
		else
		{
			PRINTF(YSM_VERBOSE_BASE,
				"Removing slave from your visible list..\n");

			YSM_Buddy_Visible (YSM_Query, 0x0);
		}

		PRINTF(YSM_VERBOSE_BASE,
			"Switching Visible to %s for Slave %s - UIN %d\n",
			(YSM_Query->BudType.VisibleID) ? "ON" : "OFF",
			YSM_Query->NickName, YSM_Query->Uin);

		break;


	case YSM_COMMAND_IGNORE:

		if (strlen(cmd) == strlen("ignore")) 
		{
			PRINTF(YSM_VERBOSE_BASE, "'Ignore SLAVE_NAME'\n");
			return;
		}
	
		strtok (cmd, " ");

		if ((auxb = strtok(NULL, " ")) == NULL || *auxb == ' ') 
		{
			PRINTF(YSM_VERBOSE_BASE, "'Ignore SLAVE_NAME'\n");
			return;
		}

		YSM_Query = YSM_QuerySlaves(SLAVE_NAME, auxb, 0);

		if (!YSM_Query) 
		{
       				PRINTF(YSM_VERBOSE_BASE,
					"Unknown SLAVE Name. Won't ignore!\n");
				return;
		}
	
	

		if(!YSM_Query->BudType.IgnoreID)
		{
	
			if(!YSM_Query->DownloadedFlag)	/* Slave isn't saved */
			{
				PRINTF(YSM_VERBOSE_BASE,
			"Slave won't be added to your ignore list until "
			"you upload him\nto the icq servers using the 'save' "
			"command. (try 'save slave_name').\n");

				return;

			}
			else
			{

				PRINTF(YSM_VERBOSE_BASE,
			"Adding the slave to your ignore list..\n"
			"..and to your invisible list.\n");
				YSM_Buddy_Ignore (YSM_Query, 0x1);

			if(!YSM_Query->BudType.InvisibleID)
				YSM_Buddy_Invisible (YSM_Query, 0x1);

			}

		}
		/* Unignore the user	*/
		else
		{
			PRINTF(YSM_VERBOSE_BASE,
			"Removing the slave from your Ignore and Invisible "
			"lists.\n");
	
	 		YSM_Buddy_Ignore (YSM_Query, 0x0);

			if(YSM_Query->BudType.InvisibleID)
				YSM_Buddy_Invisible (YSM_Query, 0x0);


		}

		PRINTF(YSM_VERBOSE_BASE,
			"Switching Ignore to %s for Slave %s - UIN %d\n",
			(YSM_Query->BudType.IgnoreID) ? "ON" : "OFF",
			YSM_Query->NickName, YSM_Query->Uin);

		break;



	case YSM_COMMAND_ALERT:

		if (strlen(cmd) == strlen("alert"))
		{
			PRINTF(YSM_VERBOSE_BASE, "'Alert SLAVE_NAME'\n");
			return;
		}
	
		strtok (cmd, " ");

		if ((auxb = strtok(NULL, " ")) == NULL || *auxb == ' ') 
		{
			PRINTF(YSM_VERBOSE_BASE, "'Alert SLAVE_NAME'\n");
			return;
		}

		YSM_Query = YSM_QuerySlaves(SLAVE_NAME, auxb, 0);
		if (!YSM_Query) 
		{
       				PRINTF(YSM_VERBOSE_BASE,
			"Unknown SLAVE Name. Can't mark him on Alert!\n");
				return;
		}
	
	

		if(!YSM_Query->BudType.AlertMode)
			YSM_Query->BudType.AlertMode = TRUE;
			
		/* Remove from the Alert status */
		else
			YSM_Query->BudType.AlertMode = FALSE;

		PRINTF(YSM_VERBOSE_BASE,
			"Switching Alert to %s for Slave %s - UIN %d\n",
			(YSM_Query->BudType.AlertMode) ? "ON" : "OFF",
			YSM_Query->NickName, YSM_Query->Uin);

		break;


	case YSM_COMMAND_LAST:

		PRINTF(YSM_VERBOSE_BASE, 
			"Fetching Last Received Message:\n");

		if (!YSMSlaves_LastRead)
		{
			PRINTF(YSM_VERBOSE_BASE,
			"Not Found =)\n");
			break;
		}

		PRINTF(YSM_VERBOSE_BASE, 
		"From: %s", YSMSlaves_LastRead->NickName);

		PRINTF(YSM_VERBOSE_BASE,
			"\n----------------------------------------\n");
	
		PRINTF(YSM_VERBOSE_BASE, "%s", YSM_LastMessage);

		PRINTF(YSM_VERBOSE_BASE,
			"\n----------------------------------------\n");
	
		break;

	case YSM_COMMAND_HIST:

		if (strlen(cmd) == strlen("hist"))
		{
			PRINTF(YSM_VERBOSE_BASE, "'hist SLAVE_NAME'\n");
			return;
		}
	
		strtok (cmd, " ");

		if ((auxb = strtok(NULL, " ")) == NULL || *auxb == ' ') 
		{
			PRINTF(YSM_VERBOSE_BASE, "'hist SLAVE_NAME'\n");
			return;
		}

		YSM_Query = YSM_QuerySlaves(SLAVE_NAME, auxb, 0);
		if (!YSM_Query) 
		{
       				PRINTF(YSM_VERBOSE_BASE,
			"Unknown SLAVE Name. Only slave logs allowed.\n");
				return;
		}
	
		PRINTF(YSM_VERBOSE_BASE,
		"Message History for Slave %s - UIN %d\n"
		"Note: To generate a History file, read "
		"about the 'log' command.\n",
		YSM_Query->NickName, YSM_Query->Uin);


		snprintf(UinStr, MAX_ICQNUM_LEN, "%d", YSM_Query->Uin );
		YSM_ReadLog( UinStr ); 

		break;



	default:
		PRINTF(YSM_VERBOSE_BASE, "Unknown Command.\n\n");
	}
}


char *
YSM_ReadLongMessage()
{
	char *tmp = &YSM_MsgData[0];
	char line[MAX_LINE_LEN+1];
	int x=0,y;

	memset(YSM_MsgData,'\0',MAX_DATA_LEN);
	memset(line,'\0',MAX_LINE_LEN+1);

/* 	Once we are in here, don't let the command line autogenerate	*/
/*	if we are in the middle of a message. 				*/
	Curr_CMDLEN = 0;
	YSM_Display_Busy = TRUE;

	while (YSM_fgets(line, sizeof(line)) != NULL) 
	{
		y = strlen(line);

		if ( (x+y) > MAX_DATA_LEN) 
			y = MAX_DATA_LEN - x;

		x+=y;

		if (y <= 0)
		{
			PRINTF(YSM_VERBOSE_BASE,
					"\nMaximum Data Reached. \a!\n");
			YSM_Display_Busy = FALSE;
			return (tmp);
		}

		
		if (strlen(line) == 2) 
		{
			if (line[0] == '.')		/* end Message */
			{
				YSM_Display_Busy = FALSE;
				return (tmp);
			}
			else if (line[0] == '#')
			{
				YSM_Display_Busy = FALSE;
				return (NULL);
			}

		}

		strncat(YSM_MsgData, line, y);
	}
	
	YSM_Display_Busy = FALSE;
	return (tmp);
}


void
YSM_DisplayMsg(int MessageType, int UIN, int STATUS, int LEN, char *DATA,
	       char *Nick, int log_flag)
{
	char buf[MAX_STATUS_LEN];
	char log_name[MAX_PATH];
	/* the 10 is fine..we control this below */
	char time_string[10];
	char *log_data, *aux, *auxb;
	keyInstance		*crypt_key = NULL;
	time_t log_time;
	struct tm *time_stamp;
	int log_len=0, err_code = 0;
	unsigned int NotSlave, x = 0;
	YSM_SLAVE	*YSM_Query = NULL;
	
	YSM_WriteStatus(STATUS,buf);


	if (!Nick)
	{
		Nick = "NOT a SLAVE";
		NotSlave = TRUE;
	} 

	else 
		NotSlave = FALSE;


#if defined(YSM_WITH_THREADS)
	/* If the display is busy, make the thread sleep for 2 seconds */
	while(YSM_Display_Busy) YSM_Thread_Sleep (2);
#endif

	log_time = time(NULL);

	

	YSM_Message_Arrived = TRUE;

	switch (MessageType)
	{

	case YSM_MESSAGE_NORMAL:
	
		if(YSM_SETTING_BEEP)
			for(x = 0; x < (unsigned)YSM_SETTING_BEEPAMOUNT; x++)
                PRINTF(YSM_VERBOSE_BASE,"\a");

#ifdef WIN32
		YSM_WindowAlert();
#endif


		/* crypt_key is set to NULL when we want an error to show up */
		/* either we received an encrypted message from a non slave or */
		/* our key with the slave is not yet set */

		if(!NotSlave)
			YSM_Query = YSM_QuerySlaves(SLAVE_NAME, Nick, 0);

		if (YSM_Query) 
		{
			if(YSM_KeyEmpty(YSM_Query->EncryptKey)) crypt_key = NULL;
			else 
			{
				crypt_key = &YSM_Query->cipherKey_in;
				/* change the key's direction */
				crypt_key->direction = 1;
			}
		}
		
		
		/* Check if decrypt is neccesary */
		/* The slave maybe has us on his list and takes us as an encryption */
		/* YSM client, but we don't have him, so we check always if the incoming */
		/* message is encrypted or not. */

		/* Skip the head if the data was encrypted */
		err_code = YSM_DecryptData( DATA, crypt_key );
		
		switch(err_code)
		{
			case 0x1:
			DATA += sizeof( struct YSMCryptH );	
			break;

			case -1:
			PRINTF(YSM_VERBOSE_BASE, 
			"Unable to decrypt the incoming encrypted message.\n"
			"The key used to encrypt the message isn't known by your YSM.\n"
			"Remember to use the 'key' command to set a slave's encryption key.\n");
			break;
		}


		YSM_ParseMessageData( DATA );

		if (log_flag || YSM_SETTING_LOGALL || YSM_SETTING_AFK) {

		log_len = MAX_DATA_LEN+MAX_SLAVE_NICK+MAX_UIN_LEN+2;
		log_data = YSM_Malloc(log_len, __FILE__, __LINE__);
		memset(log_name,'\0',MAX_PATH);
		memset(log_data,'\0',log_len);

		if (YSM_SETTING_AFK)
		{	
			YSM_AFK_Count++;
			snprintf(log_name, MAX_PATH-1, "%s", YSM_AFKFILENAME);
		}
		else	
			snprintf(log_name, MAX_PATH-1, "%d", UIN);

		snprintf(log_data,log_len,"<%s|%d> <@#> %s <@#> %s",
					Nick, UIN,DATA, ctime(&log_time));

		for(x = 0; x < strlen(log_data); x++)
			if(log_data[x] == '\n') log_data[x] = ' ';

		log_data[strlen(log_data)] = '\n';

		YSM_DumpLogFile(log_name,log_data);
		YSM_Free(log_data, __FILE__, __LINE__);

		}


		if( !NotSlave )
		{
			strncpy( YSM_LastMessage, DATA, MAX_DATA_LEN );
			YSM_LastMessage[MAX_DATA_LEN+1] = '\0';
		}

		/* don't leave any ghosts */
		Prev_CMDLEN = strlen(YSM_Command);
		YSM_ClearLine();

		switch( YSM_SETTING_MSG_KIND )
		{
		
		case YSM_MSG_KIND_ONELINE:

		PRINTF(YSM_VERBOSE_FUNCTIONAL,"\r--> %s",ctime(&log_time));
		PRINTF(YSM_VERBOSE_BASE,
			"%s<%s%s | %d | %s%s>%s[len:%d] %s%s%s\n", BLUE,
		    NORMAL, Nick, UIN, buf, BLUE, NORMAL, LEN, COLOR_MSGTEXT,
	 	    DATA, NORMAL);
		
			break;

		case YSM_MSG_KIND_VERBOSE:

		PRINTF(YSM_VERBOSE_FUNCTIONAL,"\r--> %s",ctime(&log_time));
		PRINTF(YSM_VERBOSE_BASE,
			"%s - SLAVE NAME: %s - UIN: %d\n"
		    "<DATA %s [len:%d]>: %s\n", MSG_INCOMING_MESSAGE,
			Nick, UIN, (err_code == 0x1) ? "-Encrypted-" : "", LEN, DATA);
			break;

		case YSM_MSG_KIND_IRC:
		{
			time_stamp = localtime( &log_time );

#ifdef WIN32
			strftime( time_string, 9, "%H:%M:%S", time_stamp );
#else
			strftime( time_string, 9, "%T", time_stamp );
#endif

			if (!NotSlave)
			{
				PRINTF( YSM_VERBOSE_BASE,
				NORMAL "\r%s " BRIGHT_BLUE "%s" NORMAL
				"%s" BRIGHT_BLUE "%s " NORMAL  COLOR_MSGTEXT
				"%s\n" NORMAL,
					time_string,
					(err_code == 0x1) ? "<*" : "<",
					Nick,
					(err_code == 0x1) ? "*>" : ">",
					DATA);
			}
			else
			{
				PRINTF( YSM_VERBOSE_BASE,
				 NORMAL "\r%s " BRIGHT_BLUE "%s" NORMAL
				"%d" BRIGHT_BLUE "%s " NORMAL  COLOR_MSGTEXT
				"%s\n" NORMAL, 
					time_string,
					(err_code == 0x1) ? "<*" : "<",
					UIN,
					(err_code == 0x1) ? "*>" : ">",
					DATA);
			}

				break;
		}

		default:
				break;

		}

		break;

	case YSM_MESSAGE_PAGER:
		strtok(DATA, "IP: ");
		aux = strtok(NULL, "\n");
		auxb = strtok(NULL, "");
		PRINTF(YSM_VERBOSE_BASE ,"\r%s - %s\n"
		    "< Message: %s >\n", MSG_INCOMING_PAGER,
			aux, auxb);
		break;

	case YSM_MESSAGE_URL:
		auxb = strchr(DATA, 0xfe);
		if(auxb != NULL) 
		{
			*auxb = '\0';
			aux = strtok(auxb+1, "");
			auxb = &DATA[0];
		}
		else
		{
			aux = &DATA[0];
			auxb = "No description Provided";
		}

		PRINTF(YSM_VERBOSE_BASE ,"\r%s - SLAVE NAME: %s - UIN: %d\n"
			"< url: %s >\n< description: %s >\n",
			MSG_INCOMING_URL,
			Nick,
			UIN,
			aux,
			auxb);

		break;	

	case YSM_MESSAGE_AUTH:
		PRINTF(YSM_VERBOSE_BASE ,"\r%s UIN #%d "
		    "(Slave: %s).\nThe following Message arrived with the"
		    "request: %s\n", MSG_INCOMING_AUTHR, UIN, Nick, DATA);
		break;

	case YSM_MESSAGE_ADDED:
		PRINTF(YSM_VERBOSE_BASE,
		"\r%s ICQ #%d just added You to the list."
		" (Slave: %s).\n", MSG_WARN_ADDED, UIN, Nick);
		break;

	case YSM_MESSAGE_AUTHOK:
		PRINTF(YSM_VERBOSE_BASE ,"\r%s #%d .\n",MSG_WARN_AUTHOK, UIN);
		break;

	case YSM_MESSAGE_AUTHNOT:
		PRINTF(YSM_VERBOSE_BASE ,"\r%s ICQ #%d "
		    "KILL HIM!\n",MSG_WARN_AUTHDENY, UIN);
		break;

	default:
		YSM_Error(ERROR_CODE);
		break;
	}

	YSM_Redraw_Console = TRUE;
}

int YSM_CheckKeysSetup (char YSM_UserInput)
{

	if (YSM_KEYMAP_HELP == YSM_UserInput)
	{
		PRINTF(YSM_VERBOSE_BASE,"\n");
		YSM_DoHelp("help ");
		YSM_Redraw_Console = TRUE;
		return TRUE;
	}

	else if (YSM_KEYMAP_WHOSON == YSM_UserInput)
	{
			PRINTF(YSM_VERBOSE_BASE,"\n");
			YSM_PrintOrganizedSlaves(YSMSlavesList, YSM_ONLINE,
									NULL);
			YSM_Redraw_Console = TRUE;
			return TRUE;
	}
	
	else if (YSM_KEYMAP_SLAVES == YSM_UserInput)
	{
			PRINTF(YSM_VERBOSE_BASE,"\n");
			YSM_PrintOrganizedSlaves(YSMSlavesList, -1, NULL);
			YSM_Redraw_Console = TRUE;
			return TRUE;
	}

	return FALSE;
}

void
YSM_ParseMessageData ( char *data )
{
unsigned int x;

	for(x=0; x <= strlen(data) ; x++)
	{
		/* Mainly ment for removing the hability of 
		beeping with ansi between ansi supported clients,
		YSM on win32 for example */

		if(data[x] == '\a') data[x] = ' ';
	}

	return;
}


void
YSM_Buddy_CreateGroup (void)
{
	/*	We initialized the Amount variable to -1, if the group
		existed while we read the Buddy List but it was empty, 
		we sat 0x0 as its value. (which means no need to create) */
	
	if (YSM_GroupID_Users_Amount < 0)
	{
		PRINTF(YSM_VERBOSE_EXTRA,
			"CREATING YSM Group, doesn't exist!..\n");

		YSM_Buddy_AddItem (0x0, YSM_BUDDY_GROUPNAME,
				YSM_BUDDY_GROUPID, 0x0, YSM_BUDDY_GROUP, 0, 0,
									0x08);
		YSM_GroupID_Users_Amount = 0;
	}
	return;
}


void
YSM_Upload_BuddyList (YSM_SLAVE *refugee)
{

YSM_SLAVE *SlavesList = YSMSlaves_First;
int i=0, count=0;

	YSM_Buddy_CreateGroup ();

	PRINTF(YSM_VERBOSE_BASE, 
				"Please wait..\n");
			
	if(refugee != NULL)
	{
		if(!refugee->DownloadedFlag)
		{

			YSM_Buddy_AddItem (refugee,YSM_BUDDY_GROUPNAME,
			YSM_BUDDY_GROUPID, 0x0, YSM_BUDDY_SLAVE, 0, 0, 0x08);
		}
		else
			PRINTF(YSM_VERBOSE_BASE, 
				"The slave is already stored online.\n");
		
		return;
	}


	for (i=1 ; SlavesList->next != 0; i++)
	{
		if(count >= MAX_SAVE_COUNT)
			break;
	
		if(!SlavesList->DownloadedFlag)
		{
			YSM_Buddy_AddItem (SlavesList,
				YSM_BUDDY_GROUPNAME,
				YSM_BUDDY_GROUPID,
				0x0,
				YSM_BUDDY_SLAVE,
				0x0,
				0x0,
				0x08);

			count++;
		}

		SlavesList = SlavesList->next;
	}

	PRINTF(YSM_VERBOSE_FUNCTIONAL,
		"Please wait until %d results show up" "(or the few left).\n",
							 MAX_SAVE_COUNT);
	PRINTF(YSM_VERBOSE_FUNCTIONAL,
		"Use 'save' again to upload the missing slaves"
		" in groups of %d.\n", MAX_SAVE_COUNT);

	if(!count)
		PRINTF(YSM_VERBOSE_FUNCTIONAL,
			"-- " BLUE "done with ALL SLAVES" NORMAL ".\n"
 			"Use the 'req' command for those who require auth.\n");

	return;
}



void 
YSM_DoTab ( void )
{

char		*aux = NULL, *auxcmd = NULL;
YSM_SLAVE	*auxb = NULL;
int		x = 0;

	/* Only do this if at least 1 user is online	*/
	/* else its just a waste of time.				*/
	if(!AmountOnline) return;

	/* We check if the lovely user ;) pressed TAB 
		after writing something */

	if (Curr_CMDLEN && YSM_Command[0] != ' ')
	{
		nexttabslave = YSMSlaves_First;

		YSM_TabCount++;

			if(YSM_TabCount > AmountSlaves)
				YSM_TabCount = 1;

			for(x=1; nexttabslave->next != 0 ; x++)
			{
				if (x == YSM_TabCount)
				{
					if (nexttabslave->Status == YSM_OFFLINE)
						YSM_TabCount++;

					else
						break;
				}

				nexttabslave = nexttabslave->next;

				if(!nexttabslave->next) 
				{
					YSM_TabCount++;
					nexttabslave = YSMSlaves_First;	
				}

			}

			strncpy(YSM_CommandBkp,YSM_Command,MAX_CMD_LEN);

			memset(&YSM_CommandBkp[Curr_CMDLEN],
				0,MAX_CMD_LEN-Curr_CMDLEN);


			/* in case we have to keep shifting */
			if(YSM_CommandBkp[strlen(YSM_CommandBkp)-1] != ' ')
			{ 
				/* Check for the command typed */
				auxcmd = strtok(YSM_CommandBkp," ");

			if(auxcmd != NULL && 
			 (!strcmp(auxcmd,"m") || !strcmp(auxcmd,"msg") ||
				!strcmp(auxcmd, "whois") ||
				!strcmp(auxcmd, "rename") ||
				!strcmp(auxcmd, "req") ||
				!strcmp(auxcmd, "auth") ||
				!strcmp(auxcmd, "kill") ||
				!strcmp(auxcmd, "ignore") ||
				!strcmp(auxcmd, "invisible") ||
				!strcmp(auxcmd, "visible") ||
				!strcmp(auxcmd, "key") ||
				!strcmp(auxcmd, "scan") ||
				!strcmp(auxcmd, "save") ||
				!strcmp(auxcmd, "hist") ||
				!strcmp(auxcmd, "alert") ||
				!strcmp(auxcmd, "log") ||
				!strcmp(auxcmd, "del")))
			{	
				/* We now check if there was a pattern
				specified (an argument to the command)
				usually half nick */

				/* Fetch the pattern */
				aux = strtok(NULL, " ");

				if(aux != NULL)
				{
					auxb=YSM_SlaveCompletition(aux);
					if(auxb != NULL)
					{
						/* Set nexttabslave
						to our finding! */
						YSM_TabCount++;
						nexttabslave = auxb;
					}
				}

			}
			/* Sorry, but just support the commands we want. */
			else
				nexttabslave = 0;
			}
			else
			{
				/* Just get the command typed */
				auxcmd = strtok(YSM_CommandBkp," ");
			}

			if( nexttabslave != 0 )
			{			

				prevtabslave = nexttabslave;
				memset(YSM_Command, '\0', MAX_CMD_LEN);
	
				/* auxcmd should point to the command */

				snprintf(YSM_Command,MAX_CMD_LEN,"%s %s ",
						auxcmd,
						nexttabslave->NickName);

				YSM_ClearLine();

				PRINTF(YSM_VERBOSE_BASE, "%s",
							YSM_Command);

				Curr_CMDLEN = strlen(auxcmd);
				Curr_CMDLEN += strlen(nexttabslave->NickName);
				Curr_CMDLEN += 2;	/* spaces */
			}		 
		}
	
		/* Nothing was typed and <TAB> was pressed. We have
			a default 'msg' command policy. Fill the pleasure. */
	
		else		
		{

			if(YSMSlaves_TabSlave)
			{

			memset(YSM_Command, '\0', MAX_CMD_LEN);
#ifdef YSM_SLAVE_SLASH_MESSAGE
			snprintf(YSM_Command,MAX_CMD_LEN,"msg %s",
					YSMSlaves_TabSlave->NickName);
			PRINTF(YSM_VERBOSE_BASE,
				"msg %s ",YSMSlaves_TabSlave->NickName);
#else
			snprintf(YSM_Command,MAX_CMD_LEN,"msg %s ",
					YSMSlaves_TabSlave->NickName);
			PRINTF(YSM_VERBOSE_BASE,
				"msg %s ",YSMSlaves_TabSlave->NickName);
#endif
			Curr_CMDLEN = strlen(YSMSlaves_TabSlave->NickName);
			Curr_CMDLEN += 5;	/* "msg%20nick%20" */

			}

		}

}

/* This function should handle special keys */

char
YSM_Get_Input (void)
{

	return 0;
}

void
YSM_Print_Uptime (void)
{

int	days = 0, hours = 0 , minutes = 0, seconds = 0;

	seconds = time(NULL) - YSM_StartTime;
	minutes = seconds/60;
	hours = minutes/60;
	days = hours/24;

	seconds -= 60*minutes;
	minutes -= 60*hours;
	hours -= 24*days;
	

	PRINTF(YSM_VERBOSE_BASE,
		"Uptime: %d days %d hours %d minutes %d seconds.\n",
						days, hours, minutes, seconds);

	return;
}	
