/*	$Id: YSM_Main.c,v 1.13 2002/08/18 08:33:24 rad2k Exp $	*/
/*
-======================== You Sick Me v7 ===========================-

                                   |                                           
           - ----------------------                                          
    _      |                       |             _________________/_     _    
   _\____________   ______         _ __________  |               /             
     \           | _)    /                     \ |              /              
      \          |_\_  _/_______________/_      \|            _/               
                 |) /______________    /         \            |pix.imp         
                   /   \         )/___/         \  /          |                
  _    _\______   /    /__  ____/       - -------\/___________|               
         ` |  /__/        \/                                                   
           |          _      _           _                  __ ________ _      
           |                  )) y( O u  (s(i  C k    m.( E))                  
           |                                                                  
          -- ---------------- ---- -----                                     
                                  |                                            
                                  |                                            
-========================== YSM_Main.c =============================-

YSM (YouSickMe) ICQ Client. An Original Multi-Platform ICQ client.
Copyright (C) 2002 rad2k Argentina.

YSM is free software; you can redistribute it and/or
modify it under the terms of the GNU General Public License
as published by the Free Software Foundation; either version 2
of the License, or (at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.

For Contact information read the AUTHORS file.

*/

#include <sys/types.h>
#ifndef WIN32
#include <sys/wait.h>
#endif
#include <errno.h>
#include <string.h>

#include "YSM.h"

void
YSM_ConsoleSetup (
	void
	);

void
YSM_Init_LoginA (
	UDWORD		Uin,
	unsigned char	*Password
	);

#ifdef WIN32
void
YSM_WindowShow (
	void
	);
#endif

#ifdef YSM_WITH_THREADS

void
YSM_Start_DC (
	void
	);


#endif

void
YSM_Start_Prompt (
	void
	);

#ifndef YSM_WITH_THREADS

void
YSM_Start (
	void
	);

#endif

void
YSM_CycleChecks (
	void
	);

short	YSM_Reason_To_Suicide = FALSE;
short	YSM_Redraw_Console = FALSE;

short	YSM_SETTING_MSG_KIND = YSM_DEFAULT_MSG_KIND;
short	YSM_SETTING_VERBOSE = 2;
short	YSM_SETTING_BEEP = TRUE;
short	YSM_SETTING_BEEPAMOUNT = 1;
short	YSM_SETTING_LOGALL = FALSE;
short	YSM_SETTING_SPOOF = FALSE;
short	YSM_SETTING_AFK = FALSE;
short	YSM_SETTING_AUTOAFK = TRUE;
short	YSM_SETTING_AFKMAXSHOWN = 3;
/* Default IDLETIME timeout to set in AFK mode */
short	YSM_SETTING_IDLETIME = YSM_DEFAULT_IDLETIME;

short	YSM_SETTING_WINALERT = 0x3;

short	YSM_SETTING_ASK_KEYMAP = 0;
short	YSM_SETTING_ASK_DOWNLOAD = 0;

short	YSM_SETTING_VERSION_CHECK = TRUE;

/* The hot-key is the most amazing thing ever ;) (win32) */
short	YSM_SETTING_HOT_KEY_MAXIMIZE = 's';

char	YSM_KEYMAP_HELP = '1';
char	YSM_KEYMAP_WHOSON = '2';
char	YSM_KEYMAP_SLAVES = '3';

extern	char	YSM_Command[MAX_CMD_LEN + 1];
extern	short	YSM_Message_Arrived;
extern	short	YSM_Display_Busy;
extern	char	YSM_ConfigFile[MAX_PATH];
extern	char	YSM_ConfigDir[MAX_PATH];
extern	int	Curr_CMDLEN;

YSM_SLAVE *YSMSlavesList, *YSMSlaves_First;
YSM_SLAVE *YSMSlaves_LastSent=0, *YSMSlaves_LastRead=0;
YSM_SLAVE *YSMSlaves_TabSlave = NULL;

struct YSM_MODEL YSM_USER;

time_t	YSM_IdleTIME, YSM_LastKA;
time_t	YSM_StartTime;

int
main(int argc, char **argv)
{

#ifdef WIN32
	WSADATA wsaData;
#endif

#ifdef YSM_WITH_THREADS

#ifdef WIN32
	HANDLE	_tnwHandle, _tdcHandle;
	DWORD	_tnwid, _tdcid;
#else
	pthread_t	t_netid, t_dcid;
#endif

#endif

#ifndef WIN32
	YSM_CheckSecurity();
#endif
	YSM_StartTime = time(NULL);

	/* Check for arguments - alternate config file */
	if(argc > 2) 
	{
		if(!strcmp(argv[1],"-c"))
		{
			/* Use this configuration file */
			if(argv[2] != NULL)	
			{
				char *aux;
				strncpy(YSM_ConfigFile,argv[2],MAX_PATH);
				strncpy(YSM_ConfigDir,argv[2],MAX_PATH);
#ifdef WIN32
				aux = strrchr(YSM_ConfigDir,'\\');
#else
				aux = strrchr(YSM_ConfigDir,'/');
#endif
				if(NULL != aux) *(aux+1) = '\0';
				else strncpy(YSM_ConfigDir,".\\",MAX_PATH);
					
			}
		}
	}

	PRINTF(YSM_VERBOSE_FUNCTIONAL,
			"\n" CYAN "%s%s" NORMAL "\n%s\n", YSM_INFORMATION,
						 YSM_INFORMATION2,
						 MSG_STARTING_ONE);
#ifdef WIN32
	if (WSAStartup(0x0101, &wsaData ) != 0) {
		PRINTF(YSM_VERBOSE_BASE,
			"Can't open MS. Windows sockets, exiting..\n");
		exit(-1);
	}
#endif

	YSMSlavesList = (YSM_SLAVE *)YSM_Malloc(sizeof(YSM_SLAVE),
						__FILE__,
						__LINE__);
	if (YSMSlavesList == NULL) 
	{
		fprintf(stderr, "Can't alloc memory: %s.\n", strerror(errno));
		YSM_Error(ERROR_CRITICAL);
		/* NOTREACHED */
	}

	memset(YSMSlavesList, '\0', sizeof(YSM_SLAVE));
	memset(&YSM_USER, '\0', sizeof(YSM_USER));
	YSMSlaves_First = YSMSlavesList;

	YSM_ConsoleSetup();
	YSM_Setup();

        PRINTF(YSM_VERBOSE_FUNCTIONAL,
			"\n%s %d ]\n",MSG_STARTING_TWO, YSM_USER.YSM_Uin);
	PRINTF(YSM_VERBOSE_FUNCTIONAL,
		"Cronica TV hora Actual : %s\n", ctime(&YSM_StartTime));

	YSM_PasswdCheck();

	if(YSM_SETTING_VERSION_CHECK && (atoi(YSM_USER.Proxy_host) == 0))
		YSM_VersionCheck();

	if(YSM_SETTING_ASK_KEYMAP)
		YSM_KeysSetup();


#ifdef YSM_WITH_THREADS

	/* Initialize YSM Networking Thread */

#ifdef WIN32

	/* Initialize YSM Direct Connections Thread */

		_tnwHandle = CreateThread (
				NULL,
				0,
				(LPTHREAD_START_ROUTINE)&YSM_Start_Network,
				NULL,
				0,
				&_tnwid);

		_tdcHandle = CreateThread (
				NULL,
				0,
				(LPTHREAD_START_ROUTINE)&YSM_Start_DC,
				NULL,
				0,	
				&_tdcid);

#else

	pthread_create (&t_netid, NULL, (void *)&YSM_Start_Network, NULL);

	/* Initialize YSM Direct Connections Thread */

	pthread_create (&t_dcid, NULL, (void *)&YSM_Start_DC, NULL);
	
#endif

	/* Take the main thread for the prompt */

	YSM_Start_Prompt();

#else
	YSM_Start ();
#endif

	return (0);
}


void
YSM_Start_Prompt (void)
{

#ifdef YSM_WITH_THREADS

	YSM_IdleTIME = YSM_LastKA = time(NULL);
	
	while (!YSM_Reason_To_Suicide) 
	{

#endif

#ifndef YSM_WITH_THREADS

		YSM_FDSelect_init();

		YSM_FDAdd_rsocket(0);

		YSM_FDSelect();

		if (YSM_FDIs_Set(0))
#endif
			YSM_ConsoleRead ();


		/* Only redraw console if display isn't busy (Threads) */
		if (YSM_Redraw_Console && !YSM_Display_Busy) 
		{
			YSM_Console_Prompt();
			YSM_Redraw_Console = FALSE;

/* So we tell the Prompt to re-draw the command line in case
	we were typing anything, so we dont get confused and loose into
	insanity :) */

			if (Curr_CMDLEN && YSM_Message_Arrived)
			{
				YSM_Message_Arrived = FALSE;
				PRINTF(YSM_VERBOSE_BASE,"%s",YSM_Command);
			} 
			else YSM_Message_Arrived = FALSE;

		}


#ifndef YSM_WITH_THREADS

			YSM_CycleChecks ();
#endif

#ifdef YSM_WITH_THREADS

#ifndef WIN32
                while (waitpid(-1, NULL, WNOHANG) > 0);
#endif

	}
#endif

		return;
}

void
YSM_Start_Network (void)
{

#ifdef YSM_WITH_THREADS

	YSM_Thread_Sleep (5);		/* hold on a few secs =) */

	YSM_TCPSock = YSM_Connect(YSM_USER.SRV_HostName, 0x0, YSM_USER.SRV_Port,
				atoi(YSM_USER.Proxy_host) ? 0x1 : 0x0, 1 );

	if (YSM_TCPSock < 0) 
		YSM_Error(ERROR_NETWORK);

	YSM_Init_LoginA(YSM_USER.YSM_Uin, YSM_USER.YSM_Password);

	while (!YSM_Reason_To_Suicide) 
	{
#else
		YSM_FDSet_timeout(0, 1000);

		YSM_FDSelect_init();
		YSM_FDAdd_rsocket(YSM_TCPSock);

		YSM_FDSelect();

		if (YSM_FDIs_Set(YSM_TCPSock))
#endif
			YSM_SrvResponse();


		/* Only redraw console if display isn't busy (Threads) */
		if (YSM_Redraw_Console && !YSM_Display_Busy) 
		{
			YSM_Console_Prompt();
			YSM_Redraw_Console = FALSE;

/* So we tell the Prompt to re-draw the command line in case
	we were typing anything, so we dont get confused and loose into
	insanity :) */

			if (Curr_CMDLEN && YSM_Message_Arrived)
			{
				YSM_Message_Arrived = FALSE;
				PRINTF(YSM_VERBOSE_BASE,"%s",YSM_Command);
			} 
			else YSM_Message_Arrived = FALSE;

		}




#ifdef YSM_WITH_THREADS
	}
#endif

		return;
}



#ifdef YSM_WITH_THREADS

/*
 * YSM_Start_DC has it's own thread, which scans every 1
 * second if there is any active direct connection 
 * awaiting data. If so, it reads the corresponding socket.
 */

void
YSM_Start_DC (void)
{

int		i = 0;
YSM_SLAVE	*SlavesList = YSMSlavesList;


	while (!YSM_Reason_To_Suicide) 
	{

/* Do the outstanding cycle checks :) */

		YSM_CycleChecks ();

		YSM_Thread_Sleep (10);

		for (i=1 ; SlavesList->next != 0; i++)
		{
			if(SlavesList->d_con.expecting)
			{
				PRINTF(YSM_VERBOSE_BASE,
				"\nFound a slave expecting data. block\n");
				/* Listen in the socket for DC Input */
			}

			SlavesList = SlavesList->next;
		}
	}

	return;
}
#endif

/* 
 * YSM_Start()  used when there is no Threads Support.
 * What it does? Instead of re-writing a big function
 * we only write stuff that needs to be done once, and
 * on each Start function we leave out the while loops.
 * Hence, we make a while in this function. Weird but nice :)
 */

void
YSM_Start (void)
{

	YSM_IdleTIME = YSM_LastKA = time(NULL);

	YSM_TCPSock = YSM_Connect(YSM_USER.SRV_HostName, 0x0, YSM_USER.SRV_Port,
				atoi(YSM_USER.Proxy_host) ? 0x1 : 0x0, 1 );

	if (YSM_TCPSock < 0) 
		YSM_Error(ERROR_NETWORK);

	YSM_Init_LoginA(YSM_USER.YSM_Uin, YSM_USER.YSM_Password);

	while (!YSM_Reason_To_Suicide) 
	{
		YSM_Start_Prompt ();
		YSM_Start_Network ();
	}

	return;
}


/*	This function takes care of the regular checks to be	*/
/*	done every 1, or 2 seconds. cool huh :) 		*/
/*	I havent included the Command line redraw here since	*/
/*	I already tried to :) but even 1 second is already 	*/
/*	too much for the redraw and makes ysm looks slow :)	*/

void
YSM_CycleChecks (void)
{
#ifdef WIN32
	MSG		msg;
#endif

	if(YSM_Logged_In)
	{
		YSM_KeepAlive ();

		if ( YSM_SETTING_AUTOAFK && (YSM_SETTING_IDLETIME)  && !(YSM_SETTING_AFK) &&
		( (time(NULL) - YSM_IdleTIME)/60 >= YSM_SETTING_IDLETIME) )
		{
			if(YSM_USER.YSM_Status != YSM_INVISIBLE &&
					!YSM_SETTING_AFK)
			{
				PRINTF(YSM_VERBOSE_BASE,
					"\n%s",MSG_IDLE_TIME_REACHED);
				YSM_AFKMode(TRUE);
				YSM_Redraw_Console = TRUE;
			}
		}

	}

#ifdef WIN32
	
	if ( PeekMessage( &msg, NULL, 0, 0, PM_REMOVE ) )
	{		
			if( msg.message == WM_HOTKEY ) 
					YSM_WindowShow();

			else 
			{
				TranslateMessage( &msg );
				DispatchMessage( &msg );
			}
	}
#endif


	return;
}
