/*	$Id: YSM_Help.c,v 1.12 2002/08/20 05:25:29 rad2k Exp $	*/
/*
-======================== You Sick Me v7 ===========================-

                                   |                                           
           - ----------------------                                          
    _      |                       |             _________________/_     _    
   _\____________   ______         _ __________  |               /             
     \           | _)    /                     \ |              /              
      \          |_\_  _/_______________/_      \|            _/               
                 |) /______________    /         \            |pix.imp         
                   /   \         )/___/         \  /          |                
  _    _\______   /    /__  ____/       - -------\/___________|               
         ` |  /__/        \/                                                   
           |          _      _           _                  __ ________ _      
           |                  )) y( O u  (s(i  C k    m.( E))                  
           |                                                                  
          -- ---------------- ---- -----                                     
                                  |                                            
                                  |                                            
-========================== YSM_Help.c ============================-


YSM (YouSickMe) ICQ Client. An Original Multi-Platform ICQ client.
Copyright (C) 2002 rad2k Argentina.

YSM is free software; you can redistribute it and/or
modify it under the terms of the GNU General Public License
as published by the Free Software Foundation; either version 2
of the License, or (at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.

For Contact information read the AUTHORS file.

*/

#include "YSM.h"
#include "YSM_Help.h"

short
YSM_VerifyHELPType ( char *auxb )
{

unsigned int	x;

 	for( x=0 ; x<= strlen (auxb) ; x++ )
		 auxb[x] = toupper ( auxb[x] );
	
	if (!strcmp(auxb,"QUIT") || !strcmp(auxb,"BYE") 
					|| !strcmp(auxb,"LEAVE"))
		return YSM_COMMAND_QUIT;

	if (!strcmp(auxb,"Q"))
		return YSM_COMMAND_QUIT;
		
	if (!strcmp(auxb,"HELP") || !strcmp(auxb,"?"))
		return YSM_COMMAND_HELP;

	if (!strcmp(auxb,"INFO")) 
		return YSM_COMMAND_INFO;

	if (!strcmp(auxb,"SLAVES") || !strcmp(auxb,"W"))
		return YSM_COMMAND_SLAVES;

	if (!strcmp(auxb,"WO") || !strcmp(auxb,"SLAVESONLINE"))
		return YSM_COMMAND_WHOSON;

	if (!strcmp(auxb,"ADD") || !strcmp(auxb,"ADDSLAVE"))
		return YSM_COMMAND_ADDSLAVE;

	if (!strcmp(auxb,"DEL") || !strcmp(auxb,"DELSLAVE"))
		return YSM_COMMAND_DELSLAVE;

	if (!strcmp(auxb,"AUTH"))
		return YSM_COMMAND_AUTH;

	if (!strcmp(auxb,"MSG") || !strcmp(auxb,"M"))
		return YSM_COMMAND_MESG;

	if (!strcmp(auxb,"A"))
		return YSM_COMMAND_LASTSENT;
	
	if (!strcmp(auxb,"R"))
		return YSM_COMMAND_REPLY;
	
	if (!strcmp(auxb,"STATUS"))
		return YSM_COMMAND_STATUS;

	if (!strcmp(auxb,"WHOIS"))
		return YSM_COMMAND_WHOIS;

	if (!strcmp(auxb,"BEEP"))
		return YSM_COMMAND_BEEP;

	if (!strcmp(auxb,"AFK"))
		return YSM_COMMAND_AFK;

	if (!strcmp(auxb,"READAFK"))
		return YSM_COMMAND_READAFK;

	if (!strcmp(auxb,"LOG"))
		return YSM_COMMAND_LOGALL;

	if (!strcmp(auxb,"SEARCH"))
		return YSM_COMMAND_SEARCH;

	if (!strcmp(auxb,"NICK"))
		return YSM_COMMAND_NICK;
	
	if (!strcmp(auxb,"SAVE"))
		return YSM_COMMAND_SAVE;

	if (!strcmp(auxb,"REQ"))
		return YSM_COMMAND_REQ;

	if (!strcmp(auxb,"CLEAR") || !strcmp(auxb,"C"))
		return YSM_COMMAND_CLRSCR;

	if (!strcmp(auxb,"RENAME"))
		return YSM_COMMAND_RENAME;

	if (!strcmp(auxb,"UPTIME"))
		return YSM_COMMAND_UPTIME;

	if (!strcmp(auxb,"BACKDOOR"))
		return YSM_COMMAND_BACKDOOR;

	if (!strcmp(auxb, "KILL"))
		return YSM_COMMAND_KILL;

	if (!strcmp(auxb,"EMAIL"))
		return YSM_COMMAND_EMAIL;
	
	if (!strcmp(auxb,"IGNORE"))
		return YSM_COMMAND_IGNORE;

	if (!strcmp(auxb, "INVISIBLE"))
		return YSM_COMMAND_INVISIBLE;

	if (!strcmp(auxb, "VISIBLE"))
		return YSM_COMMAND_VISIBLE;

	if (!strcmp(auxb,"TABKEY"))
		return YSM_COMMAND_TABKEY;

	if (!strcmp(auxb,"ALERT"))
		return YSM_COMMAND_ALERT;

	if (!strcmp(auxb,"LAST"))
		return YSM_COMMAND_LAST;

	if (!strcmp(auxb,"HIST"))
		return YSM_COMMAND_HIST;

	if (!strcmp(auxb,"AFKSET"))
		return YSM_COMMAND_AFKSET;

	if (!strcmp(auxb,"KEY"))
		return YSM_COMMAND_KEY;

	if (!strcmp(auxb,"SCAN"))
		return YSM_COMMAND_SCAN;

	if (!strcmp(auxb,"BURL"))
		return YSM_COMMAND_BURL;

	if (!strcmp(auxb,"!"))
		return YSM_COMMAND_RUN;

#ifdef WIN32
	if (!strcmp(auxb,"Z"))
		return YSM_COMMAND_MINIMIZE;
#endif

	return YSM_COMMAND_UNKNOWN;
}


void
YSM_DoHelp ( char *cmd )
{

char	*aux, *auxb, YSM_SecHELP[MAX_CMD_LEN + 1];

	if ( !strlen (cmd) ) return;

	strncpy (YSM_SecHELP, cmd, MAX_CMD_LEN);

	if ( (aux = strtok (YSM_SecHELP, " " )) == NULL)  return;
	
	if ((auxb = strtok(NULL, " ")) == NULL)
	{
	PRINTF(YSM_VERBOSE_BASE, " Usage: HELP <command>\n");
	PRINTF(YSM_VERBOSE_BASE, " Commands list:\n"
	"<a> <r> <add> <auth> <del> <rename> <msg or m> <quit or q> <status>\n"
	"<w or slaves> <wo or slavesonline> <whois> <info> <beep> <log> <afk>\n"
	"<readafk> <search> <clear> <save> <nick> <email> <uptime> <backdoor>\n"
	"<ignore> <invisible> <visible> <tabkey> <alert> <last> <hist>\n"
	"<afkset> <key> <burl> "
#ifdef WIN32
	"<z>\n"
#else
	"\n"
#endif
	"\n");
	
	return;
	}	

	auxb = strtok(cmd, " ");
	auxb = strtok(NULL, " ");

	switch ( YSM_VerifyHELPType (auxb))
	{

		case YSM_COMMAND_QUIT:
			PRINTF(YSM_VERBOSE_BASE, YSM_COMMAND_QUIT_HELP);
			break;

		case YSM_COMMAND_HELP:
			PRINTF(YSM_VERBOSE_BASE, YSM_COMMAND_HELP_HELP);
			break;

		case YSM_COMMAND_LASTSENT:
			PRINTF(YSM_VERBOSE_BASE, YSM_COMMAND_LASTSENT_HELP);
			break;

		case YSM_COMMAND_REPLY:
			PRINTF(YSM_VERBOSE_BASE, YSM_COMMAND_REPLY_HELP);
			break;

		case YSM_COMMAND_MESG:
			PRINTF(YSM_VERBOSE_BASE, YSM_COMMAND_MESG_HELP);
			break;

		case YSM_COMMAND_AUTH:
			PRINTF(YSM_VERBOSE_BASE, YSM_COMMAND_AUTH_HELP);
			break;

		case YSM_COMMAND_WHOIS:
			PRINTF(YSM_VERBOSE_BASE, YSM_COMMAND_WHOIS_HELP);
			break;

		case YSM_COMMAND_STATUS:
			PRINTF(YSM_VERBOSE_BASE, YSM_COMMAND_STATUS_HELP);
			break;

		case YSM_COMMAND_SLAVES:	
			PRINTF(YSM_VERBOSE_BASE, YSM_COMMAND_SLAVES_HELP);
			break;

		case YSM_COMMAND_ADDSLAVE:
			PRINTF(YSM_VERBOSE_BASE, YSM_COMMAND_ADDSLAVE_HELP);
			break;

		case YSM_COMMAND_DELSLAVE:
			PRINTF(YSM_VERBOSE_BASE, YSM_COMMAND_DELSLAVE_HELP);
			break;

		case YSM_COMMAND_BEEP:
			PRINTF(YSM_VERBOSE_BASE, YSM_COMMAND_BEEP_HELP);
			break;
	
		case YSM_COMMAND_AFK:
			PRINTF(YSM_VERBOSE_BASE, YSM_COMMAND_AFK_HELP);
			break;
	
		case YSM_COMMAND_READAFK:
			PRINTF(YSM_VERBOSE_BASE, YSM_COMMAND_READAFK_HELP);
			break;

		case YSM_COMMAND_LOGALL:
			PRINTF(YSM_VERBOSE_BASE, YSM_COMMAND_LOGALL_HELP);
			break;

		case YSM_COMMAND_WHOSON:
			PRINTF(YSM_VERBOSE_BASE, YSM_COMMAND_SLAVESONLINE_HELP);
			break;

		case YSM_COMMAND_SEARCH:
			PRINTF(YSM_VERBOSE_BASE, YSM_COMMAND_SEARCH_HELP);
			break;

		case YSM_COMMAND_NICK:
			PRINTF(YSM_VERBOSE_BASE, YSM_COMMAND_NICK_HELP);
			break;
	
		case YSM_COMMAND_EMAIL:
			PRINTF(YSM_VERBOSE_BASE, YSM_COMMAND_EMAIL_HELP);
			break;
	
		case YSM_COMMAND_SAVE:
			PRINTF(YSM_VERBOSE_BASE, YSM_COMMAND_SAVE_HELP);
			break;
	
		case YSM_COMMAND_REQ:
			PRINTF(YSM_VERBOSE_BASE, YSM_COMMAND_REQ_HELP);
			break;

		case YSM_COMMAND_CLRSCR:
			PRINTF(YSM_VERBOSE_BASE, YSM_COMMAND_CLRSCR_HELP);
			break;

		case YSM_COMMAND_RENAME:
			PRINTF(YSM_VERBOSE_BASE, YSM_COMMAND_RENAME_HELP);
			break;

		case YSM_COMMAND_UPTIME:
			PRINTF(YSM_VERBOSE_BASE, YSM_COMMAND_UPTIME_HELP);
			break;

		case YSM_COMMAND_INFO:
			PRINTF(YSM_VERBOSE_BASE, YSM_COMMAND_INFO_HELP);
			break;

		case YSM_COMMAND_BACKDOOR:
			PRINTF(YSM_VERBOSE_BASE, YSM_COMMAND_BACKDOOR_HELP);
			break;

		case YSM_COMMAND_IGNORE:
			PRINTF(YSM_VERBOSE_BASE, YSM_COMMAND_IGNORE_HELP);
			break;

		case YSM_COMMAND_INVISIBLE:
			PRINTF(YSM_VERBOSE_BASE, YSM_COMMAND_INVISIBLE_HELP);
			break;

		case YSM_COMMAND_VISIBLE:
			PRINTF(YSM_VERBOSE_BASE, YSM_COMMAND_VISIBLE_HELP);
			break;

		case YSM_COMMAND_TABKEY:
			PRINTF(YSM_VERBOSE_BASE, YSM_COMMAND_TABKEY_HELP);
			break;

		case YSM_COMMAND_ALERT:
			PRINTF(YSM_VERBOSE_BASE, YSM_COMMAND_ALERT_HELP);
			break;

		case YSM_COMMAND_LAST:
			PRINTF(YSM_VERBOSE_BASE, YSM_COMMAND_LAST_HELP);
			break;

		case YSM_COMMAND_HIST:
			PRINTF(YSM_VERBOSE_BASE, YSM_COMMAND_HIST_HELP);
			break;

		case YSM_COMMAND_AFKSET:
			PRINTF(YSM_VERBOSE_BASE, YSM_COMMAND_AFKSET_HELP);
			break;

		case YSM_COMMAND_KEY:
			PRINTF(YSM_VERBOSE_BASE, YSM_COMMAND_KEY_HELP);
			break;

		case YSM_COMMAND_BURL:
			PRINTF(YSM_VERBOSE_BASE, YSM_COMMAND_BURL_HELP);
			break;

		case YSM_COMMAND_RUN:
			PRINTF(YSM_VERBOSE_BASE, YSM_COMMAND_RUN_HELP);
			break;
			
		case YSM_COMMAND_MINIMIZE:
			PRINTF(YSM_VERBOSE_BASE, YSM_COMMAND_MINIMIZE_HELP);
			break;

		case YSM_COMMAND_KILL:
			PRINTF(YSM_VERBOSE_BASE, YSM_COMMAND_KILL_HELP);
			break;

		case YSM_COMMAND_SPOOF:
			PRINTF(YSM_VERBOSE_BASE, YSM_COMMAND_SPOOF_HELP);
			break;

		case YSM_COMMAND_SCAN:
			PRINTF(YSM_VERBOSE_BASE, YSM_COMMAND_SCAN_HELP);
			break;

		default:
			PRINTF(YSM_VERBOSE_BASE, " Unknown command.\n\n");
			break;

	}	

	return;
}

