/*
 * Copyright (c) 1995-2007, Index Data
 * All rights reserved.
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 *
 *     * Redistributions of source code must retain the above copyright
 *       notice, this list of conditions and the following disclaimer.
 *     * Redistributions in binary form must reproduce the above copyright
 *       notice, this list of conditions and the following disclaimer in the
 *       documentation and/or other materials provided with the distribution.
 *     * Neither the name of Index Data nor the names of its contributors
 *       may be used to endorse or promote products derived from this
 *       software without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE REGENTS AND CONTRIBUTORS ``AS IS'' AND ANY
 * EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
 * WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
 * DISCLAIMED. IN NO EVENT SHALL THE REGENTS AND CONTRIBUTORS BE LIABLE FOR ANY
 * DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
 * (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
 * LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
 * ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 * (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF
 * THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 */
/* $Id: ccl_xml.h,v 1.1 2007/01/08 10:48:07 adam Exp $ */

/**
 * \file ccl_xml.h
 * \brief Header for CCL + XML stuff
 */
#ifndef YAZ_CCL_XML_H
#define YAZ_CCL_XML_H

#include <yaz/ccl.h>
#include <yaz/xmltypes.h>

YAZ_BEGIN_CDECL

/** \brief configures CCL bibset using XML configuration
    \param bibset CCL bibliographic profile
    \param ptr xml node pointer pointing to "cclmap" element
    \param addinfo has error message if configuration could not be parsed
    \retval 0 OK
    \retval -1 errors. Inspect addinfo for error message
    
    Configuration example:
    \verbatim
<cclmap defaultattrset="bib-1">
   <qual name="term">
       <attr type="u" value="1016"/>
       <attr type="s" value="pw"/>
   </qual>
   <qual name="title">
       <attr type="u" value="4"/>
   </qual>
   <qual name="distributor">
       <attr attrset="gils" type="u" value="2000"/>
   </qual>
  <directive name="and" value="+"/>
</cclmap>
    \endverbatim
*/
YAZ_EXPORT
int ccl_xml_config(CCL_bibset bibset, const xmlNode *ptr,
                   const char **addinfo);

YAZ_END_CDECL

#endif
/*
 * Local variables:
 * c-basic-offset: 4
 * indent-tabs-mode: nil
 * End:
 * vim: shiftwidth=4 tabstop=8 expandtab
 */

