/* cmd.h -- read and execute commands, this is the main loop
 * 
 * This file is part of Yafc, an ftp client.
 * This program is Copyright (C) 1998-2001 martin HedenfaLk
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#ifndef _cmd_h_included
#define _cmd_h_included

#include "args.h"

#define CMD_AMBIGUOUS (cmd_t *)-1

typedef void (*vfunc)(int argc, char **argv);

typedef struct {
    char *cmd;
	bool needconnect, needlogdin;
	bool auto_unquote;
	int cpltype;
	char *hint;
	vfunc func;
} cmd_t;

/* in commands.c */
cmd_t *find_cmd(const char *name);
cmd_t *find_func(const char *cmd, bool print_error);
int rearrange_redirections(args_t *args);

void command_loop(void);
void exit_yafc(void);

extern cmd_t cmds[];

#endif
