
# Script to test the @irr macro added to sc 6.21 by Marc Meyer
# reads in a test spreadsheet, runs val to fix the numbers and
# compares it with pre-prepared output.

# does this for each test, by passing comparing the output
# (in test.output) generated by passing test.input through
#  prog test.prog with the prepared output in test.cmp.
#

VERSION=6.21
fail=
[ -n "$prog" ] || prog=sc
prog_name=`echo $prog | sed -e 's;.*/;;'`
if [ "$prog_name" = "xspread" ]
then
	ext=sc
else
	ext=$prog_name
fi

for test in $*; do
	echo $prog version $VERSION, $test test..."\c"
 	[ ! -r $test.input ] || [ ! -r $test.$ext ] ||
		[ ! -r $test.cmp ] && {
			echo UNAVAILABLE.
			continue;
		}
	cat $test.input | $prog $flags $test.$ext > /dev/null

	diff $test.output $test.cmp > /dev/null && { 
		echo ok.
	} || {
		echo $test TST FAILED.
		echo Check diffs in $test.output and $test.cmp.
		fail=y
	}
done
[ -n "$fail" ] && exit 1
exit 0
