#include <stdio.h>
#include <X11/Xlib.h>
#include <X11/xpm.h>

#define C_LV 32
#define C_SHIFT 11

int SetPopularXColor(XColor *wcol, int Cgtb[C_LV][C_LV][C_LV]);
int col_sort(int Cgtb[C_LV][C_LV][C_LV]);
void near_color(XColor *wcol, int Cgtb[C_LV][C_LV][C_LV]);
void quicksort(int sort[], int first, int last);

/* 256$BHV?M5$$^$G$N?'$r(B XColor $B$K%;%C%H$9$k(B 
   256$B?'0J2<$J$i$=$N?'?t$rJV$9(B */
int SetPopularXColor(XColor *wcol, int Cgtb[C_LV][C_LV][C_LV])
{
    int l, m, n, k = 0;
    int flags = DoRed | DoGreen | DoBlue;
    int sort256;
    
    sort256 = col_sort(Cgtb);
    for(l=0; l<C_LV; l++)for(m=0; m<C_LV; m++)for(n=0; n<C_LV; n++)
	if(Cgtb[l][m][n] > sort256)
	{
	    Cgtb[l][m][n] = -k-1;
	    wcol[k].flags = flags;
	    wcol[k].red   = l << C_SHIFT;
	    wcol[k].green = m << C_SHIFT;
	    wcol[k].blue  = n << C_SHIFT;
	    wcol[k].pixel = k++;
	    if(k > 255) return k;
	}
    return k;
}

/* 257$BHV?M5$$N?'$N;H$o$l$F$$$k(Bpixel$B?t$rJV$9(B */
int col_sort(int Cgtb[C_LV][C_LV][C_LV])
{
    int l, m, n, k = 0;
    int count = 0;
    int sort256, *sortc;

    for(l=0; l<C_LV; l++)for(m=0; m<C_LV; m++)for(n=0; n<C_LV; n++)
	if(Cgtb[l][m][n]) count++;
    fprintf(stdout,"Count = %d\n",count);
    if(count <= 256) return 0;
    sortc = (int *)malloc(sizeof(int) * count);
    for(l=0; l<C_LV; l++)for(m=0; m<C_LV; m++)for(n=0; n<C_LV; n++)
	if(Cgtb[l][m][n])
	    sortc[k++] = Cgtb[l][m][n];
    quicksort(sortc, 0, count-1);

    sort256 = sortc[256];
    free((char *)sortc);

    return sort256;
}

/* $B%+%i!<%F!<%V%k$N;H$o$l$F$$$kItJ,$K:G$b6a$$?'$rF~$l$k(B */
void near_color(XColor *wcol, int Cgtb[C_LV][C_LV][C_LV])
{
    int l, m, n, s, t, u;
    int count = 0;

    for(l=0; l<C_LV; l++)for(m=0; m<C_LV; m++)for(n=0; n<C_LV; n++)
	if(Cgtb[l][m][n] > 0)
	{
	    t = ((l-(wcol[0].red >>C_SHIFT))*(l-(wcol[0].red  >>C_SHIFT))
	      + (m-(wcol[0].green>>C_SHIFT))*(m-(wcol[0].green>>C_SHIFT))
	      + (n-(wcol[0].blue >>C_SHIFT))*(n-(wcol[0].blue >>C_SHIFT)));
	    Cgtb[l][m][n] = -wcol[0].pixel-1;
	    for(s=1; s<256; s++)
	    {
		if(t < 2) break;
		if(t>(u=((l-(wcol[s].red>>C_SHIFT))
			 *(l-(wcol[s].red>>C_SHIFT))
			 +(m-(wcol[s].green>>C_SHIFT))
			 *(m-(wcol[s].green>>C_SHIFT))
		         +(n-(wcol[s].blue>>C_SHIFT))
			 *(n-(wcol[s].blue>>C_SHIFT)))))
		{
		    t = u;
		    Cgtb[l][m][n] = -wcol[s].pixel-1;
		}
	    }
	}
}

/* $B%/%$%C%/%=!<%H(B ($BBg$-$$=g(B) */
void quicksort(int sort[], int first, int last)
{
    int i, j;
    int x, t;

    x = sort[(first+last)>>1];
    i = first; j = last;
    for(;;){
	while(sort[i] > x) i++;
	while(sort[j] < x) j--;
	if(i >= j) break;
	t = sort[i]; sort[i] = sort[j]; sort[j] = t;
	i++; j--;
    }
    if(first < i-1) quicksort(sort, first, i-1);
    if(last > j+1) quicksort(sort, j+1, last);
}
