.de EX		\"Begin example
.ne 5
.if n .sp 1
.if t .sp .5
.nf
.in +.5i
..
.de EE
.fi
.in -.5i
.if n .sp 1
.if t .sp .5
..
.TH Sonar 1 "3-Nov-98" "X Version 11"
.SH NAME
sonar - display a sonar scope
.SH SYNOPSIS
.B sonar
[\-ping \fIhosts-or-subnets\fP]
[\-background \fIcolor\fP]
[\-sweep\-color \fIcolor\fP]
[\-low\-color \fIcolor\fP] 
[\-scope\-color \fIcolor\fP]
[\-grid\-color \fIcolor\fP]
[\-text\-color \fIcolor\fP]
[\-ttl \fIinteger\fP]
[\-font \fIfont\fP]
[\-ping\-timeout \fIint\fP]
[\-team-a-name \fIstring\fP] 
[\-team-b-name \fIstring\fP]
[\-team-a-count \fIint\fP]
[\-team-b-count \fIint\fP]
[\-debug] 
.SH DESCRIPTION
The \fIsonar\fP program displays a sonar scope on the computer's screen.
This scope polls a sensor as the sweep goes around the scope and displays
what it finds as bogies on the screen.  The program is designed to support
different modes representing different types of sensors.  Currently the
only implemented sensors are a simulator, and a network ping function that
pings hosts and plots the results on the scope.
.SH OPTIONS
.I sonar
understands the following options:
.TP 8
.B \-background \fIColor\fP
The background Color of the screen not covered by the scope.
.TP 8
.B \-sweep\-color \fIColor\fP
The color of the brightest part of the sweep.
.TP 8
.B \-scope\-color \fIColor\fP
The color of the circular part of the scope.
.TP 8
.B \-grid\-color \fIColor\fP
The color to the grid lines overlaying the scope.
.TP 8
.B \-text\-color \fIColor\fP
The color of the text identifying bogies on the scope.
.TP 8
.B \-ttl \fIinteger\fP
"Time to live": visible time of a Bogie. Try values between 10 (very short)
and 100. 
.TP 8
.B \-font \fIfont\fP
The font used to display text on the scope.  Default "fixed".
.TP 8
.B \-ping\-timeout \fIint\fP
The amount of time in milliseconds the program will wait for an answer
to a ping.
.TP 8
.B \-ping \fIhosts-or-subnets\fP
The list of things to ping, separated by commas or spaces. 
Elements of this list may be:
.RS 8
.TP 12
.B simulation
to run in simulation mode, instead of pinging real hosts (this is the default
if the program is not installed setuid);
.TP 12
.I hostname
to ping the given host;
.TP 12
.I A.B.C.D
to ping the given IP address;
.TP 12
.B subnet
to ping the local class C subnet (the nearest 255 addresses);
.TP 12
.B subnet/\fINN\fP
to ping a different-sized local subnet: e.g., \fBsubnet/28\fP would ping
a 4-bit subnet (the nearest 15 addresses);
.TP 12
.I A.B.C.D/NN
to ping an arbitrary other subnet: the IP address specifies the base address,
and the part after the slash is how wide the subnet is.  Typical values
are /24 (for 255 addresses) and /28 (for 15 addresses.)
.TP 12
.I filename
to ping the hosts listed in the given file.  This file can be in the
format used by \fI/etc/hosts\fP, or it can be any file that has host
names as the first element on each line.  If you use ssh, try this:

  sonar -ping $HOME/.ssh/known_hosts
.RE
.TP 8
.B \-team-a-name \fIstring\fP
In simulation mode, the name of team A.
.TP 8
.B \-team-b-name \fIstring\fP
In simulation mode, the name of team B.
.TP 8
.B \-team-a-count \fIint\fP
In simulation mode, the number of bogies on team A.
.TP 8
.B \-team-b-count \fIint\fP
In simulation mode, the number of bogies on team B.
.SH RESOURCES
Configuration of the targets to ping is best done by setting X Resources.
.PP
.TP 8
.B background \fI(Color)\fP
See option \-background, above; default value is \fIblack\fP.
.TP 8
.B sweepColor \fI(Color)\fP
See option \-sweep\-color, above; default value is \fI#00ff00\fP.
.TP 8
.B scopeColor \fI(Color)\fP
See option \-scope\-color, above; default value is \fI#003300\fP.
.TP 8
.B gridColor \fI(Color)\fP
See option \-grid\-color, above; default value is \fI#00aa00\fP.
.TP 8
.B textColor \fI(Color)\fP
See option \-text\-color, above; default value is \fI#ffff00\fP.
.TP 8
.B ttl \fI(integer)\fP
See option \-ttl, above; default value is \fI90\fP or one sweep.
.TP 8
.B ping \fI(string)\fP
See option \-ping, above.  If set to \fBdefault\fP, it will ping
the contents of /etc/hosts if possible, otherwise, will run in
simulation-mode.
.TP 8
.B font \fI(font)\fP
See option \-font, above; default value is \fIfixed\fP.
.TP 8
.B pingTimeout \fI(Integer)\fP
See option \-pingtimeout, above; default value is 3000.
.TP 8
.B teamAName \fIstring\fP
See option \-team\-a\-name, above.  Default value is \fBF18\fP.
.TP 8
.B teamBName \fIstring\fP
See option \-teamBName, above.  Default value is \fBMIG\fP.
.TP 8
.B teamACount \fIint\fP
See option \-teamACount, above.  Default value is 4.
.TP 8
.B teamBCount \fIint\fP
See option \-teamBCount, above.  Default value is 4.
.SH NOTES
In order to use the ping sensor, this program must be installed as 
setuid root, so that it can create an ICMP socket.  Root privileges
are disavowed shortly after startup (just after connecting to the
X server and reading the resource database) so this is \fIbelieved\fP
to be a safe thing to do, but it is usually recommended that you 
have as few setuid programs around as possible, on general principles.
.SH SEE ALSO
.BR X (1),
.BR xscreensaver (1),
.BR ping (8)
.SH COPYRIGHT
Copyright \(co 1998 by Stephen Martin. (smartin@canada.com)

Permission to use, copy, modify, distribute, and sell this software and its
documentation for any purpose is hereby granted without fee, provided that
the above copyright notice appear in all copies and that both that
copyright notice and this permission notice appear in supporting
documentation.  No representations are made about the suitability of this
software for any purpose.  It is provided "as is" without express or 
implied warranty.

.SH AUTHORS
Stephen Martin <smartin@canada.com>, 3-nov-98.

Thanks to Tom Kelly for suggesting a modular approach to the sensor
amoung other things.

Thomas Bahls <thommy@cs.tu-berlin.de> hacked the "ttl" option, 12-jul-98.

Better subnet support and command-line processing by Jamie Zawinski, 17-Jul-00.
