/*
 *  XScrabble - X version of the popular board game, for 1 to 4 players.
 *
 * This software comes with NO warranty whatsoever. I therefore take no
 * responsibility for any damages, losses or problems caused through use
 * or misuse of this program.
 *
 * I hereby grant permission for this program to be freely copied and
 * distributed by any means, provided no charge is made for it.
 *
 * Matthew Chapman, csuoq@csv.warwick.ac.uk
 *    Oct 1994.
 */

/* popup.c - functions for creating and managing the popups */

#include "scrab.h"
#include "globals.h"



/*********************************
 * Letter Scores and Frequencies *
 *********************************/

void LettValuesPopdown(Widget w, XtPointer client_data, XtPointer call_data)
{
	int dnum;
	
	for (dnum=0;lvdismiss[dnum]!=w; dnum++)
		;
	XtUnmapWidget(lvtop[dnum]);

	XtVaSetValues(menu_item[dnum][LETTVAL],XtNleftBitmap,None,NULL);
	menu_status[dnum][LETTVAL]= !menu_status[dnum][LETTVAL];
}

void CreateLettValuesPopup(int dnum)
{
	Widget lvform,lvmain,lvtitle;

	lvtop[dnum] = XtVaAppCreateShell("lvtop","XScrabble",
		applicationShellWidgetClass,dpy[dnum],XtNmappedWhenManaged,False,NULL);
	lvform = XtVaCreateManagedWidget("lvform",formWidgetClass,lvtop[dnum],
		NULL);
	lvtitle = XtVaCreateManagedWidget("lvtitle",labelWidgetClass,lvform,
		NULL);
	lvmain = XtVaCreateManagedWidget("lvmain",labelWidgetClass,lvform,NULL);
	lvdismiss[dnum] = XtVaCreateManagedWidget("lvdismiss",commandWidgetClass,
		lvform,NULL);
	bg_pixmap(lvform);
	XtRealizeWidget(lvtop[dnum]);
	XtAddCallback(lvdismiss[dnum],XtNcallback,LettValuesPopdown,lvtop[dnum]);
}

void LettValuesPopup(int dnum)
{
	if (menu_status[dnum][LETTVAL]==False)
		/* popup is already up */
		XtUnmapWidget(lvtop[dnum]);
	else
		XtMapWidget(lvtop[dnum]);
}


/*******************
 * Highscore Table *
 *******************/

void HiScoresPopdown(Widget w, XtPointer client_data, XtPointer call_data)
{
	int dnum;
	
	for (dnum=0;hi_dismiss[dnum]!=w; dnum++)
		;
	XtUnmapWidget(hi_scoretop[dnum]);

	XtVaSetValues(menu_item[dnum][HISCORES],XtNleftBitmap,None,NULL);
	menu_status[dnum][HISCORES]= !menu_status[dnum][HISCORES];
}

void CreateHiScoresPopup(int dnum)
{
    int j;
    Widget hi_scoref,hi_scoretitle;
    Widget subtitle[MAXPLAYERS];
    char txt[512],wname[6];

    /* only create popup if not computer player */
    if (type[dnum]==0)
    {

	hi_scoretop[dnum] = XtVaAppCreateShell("hiscoreshell","XScrabble",
					       applicationShellWidgetClass,dpy[dnum],XtNmappedWhenManaged,False,NULL);
	hi_scoref = XtVaCreateManagedWidget("hiscoref",formWidgetClass,
					    hi_scoretop[dnum],NULL);
	hi_scoretitle = XtVaCreateManagedWidget("hiscoretitle",labelWidgetClass,
						hi_scoref,NULL);
	loadscores();
	for (j=0; j<MAXPLAYERS; j++)
	{
	    showscores(j+1,txt);
	    sprintf(wname,"sub%d",j);
	    subtitle[j]=XtVaCreateManagedWidget(wname,labelWidgetClass,
						hi_scoref,NULL);
	    hi_score_ent[dnum][j]=XtVaCreateManagedWidget("hiscoreent",
							  labelWidgetClass,hi_scoref,XtNfromVert,subtitle[j],NULL);
	    XtVaSetValues(hi_score_ent[dnum][j], XtNlabel, txt, NULL);
	    if (j%2==1)
	    {
		XtVaSetValues(subtitle[j],XtNfromHoriz,hi_score_ent[dnum][j-1],NULL);
		XtVaSetValues(hi_score_ent[dnum][j],XtNfromHoriz,hi_score_ent[dnum][j-1],NULL);
	    }
	    if (j>1)
		XtVaSetValues(subtitle[j],XtNfromVert,hi_score_ent[dnum][j-2],
			      XtNvertDistance,10,NULL);
	    else
		XtVaSetValues(subtitle[j],XtNfromVert,hi_scoretitle,NULL);
	}
	hi_dismiss[dnum] = XtVaCreateManagedWidget("hidismiss",commandWidgetClass,
						   hi_scoref,NULL);
	bg_pixmap(hi_scoref);
	bg_pixmap(hi_scoretitle);
	XtRealizeWidget(hi_scoretop[dnum]);
	XtAddCallback(hi_dismiss[dnum],XtNcallback,HiScoresPopdown,hi_scoretop[dnum]);
    }
}

void HiScoresPopup(int dnum)
{
    int j;
    char txt[512];

    /* only if not computer */
    if (type[dnum]==0)
    {
	if (menu_status[dnum][HISCORES]==False)
	    /* popup is already up */
	    XtUnmapWidget(hi_scoretop[dnum]);
	else
	{
	    loadscores();
	    for (j=0; j<MAXPLAYERS; j++)
	    {
		showscores(j+1,txt);
		XtVaSetValues(hi_score_ent[dnum][j], XtNlabel, txt, NULL);
	    }
	    XtMapWidget(hi_scoretop[dnum]);
	}
    }
}

/*******************
 * Best plays list *
 *******************/

void BestgoPopdown(Widget w, XtPointer client_data, XtPointer call_data)
{
	int dnum;
	
	for (dnum=0;bestgodismiss[dnum]!=w; dnum++)
		;
	XtUnmapWidget(bestgotop[dnum]);

	XtVaSetValues(menu_item[dnum][BESTGOES],XtNleftBitmap,None,NULL);
	menu_status[dnum][BESTGOES]= !menu_status[dnum][BESTGOES];
}


void CreateBestgoPopup(int dnum)
{
	char txt[1000];
	Widget bestgof,bestgotitle;
	
	bestgotop[dnum] = XtVaAppCreateShell("bestgoshell","XScrabble",
		applicationShellWidgetClass,dpy[dnum],XtNmappedWhenManaged,False,NULL);
	bestgof = XtVaCreateManagedWidget("bestgof",formWidgetClass,
		bestgotop[dnum],NULL);
	bestgotitle = XtVaCreateManagedWidget("bestgotitle",labelWidgetClass,
		bestgof,XtNborderWidth,0,NULL);
	bestgomain[dnum] = XtVaCreateManagedWidget("bestgomain",labelWidgetClass,
		bestgof,XtNfromVert,bestgotitle,NULL);
	
	showgoscores(txt);
	XtVaSetValues(bestgomain[dnum],XtNlabel,txt,NULL);
	bestgodismiss[dnum] = XtVaCreateManagedWidget("bestgodismiss",commandWidgetClass,
		bestgof,XtNfromVert,bestgomain[dnum],NULL);
	bg_pixmap(bestgof);
	bg_pixmap(bestgotitle);
	XtRealizeWidget(bestgotop[dnum]);
	XtAddCallback(bestgodismiss[dnum],XtNcallback,BestgoPopdown,bestgotop[dnum]);
}

void BestgoPopup(int dnum)
{
	if (menu_status[dnum][BESTGOES]==False)
		/* popup is already up */
		XtUnmapWidget(bestgotop[dnum]);
	else
	{
		char txt[1000];
		showgoscores(txt);
		XtVaSetValues(bestgomain[dnum],XtNlabel,txt,NULL);
		XtMapWidget(bestgotop[dnum]);
	}
}

void UpdateBestgo()
{
	int j;
	
	for (j=0; j<num_players; j++)
		if (menu_status[j][BESTGOES]==True)
		{
			/* popup is up - update entry */
			char txt[1000];
			showgoscores(txt);
/*printf("updating for player %d\n",j);*/
			XtVaSetValues(bestgomain[j],XtNlabel,txt,NULL);
		}	
}

/*********
 * About *
 *********/

void AboutPopdown(Widget w, XtPointer client_data, XtPointer call_data)
{
    	int dnum;
	
	for (dnum=0;aboutdismiss[dnum]!=w; dnum++)
		;
	XtUnmapWidget(abouttop[dnum]);

	XtVaSetValues(menu_item[dnum][ABOUT],XtNleftBitmap,None,NULL);
	menu_status[dnum][ABOUT]= !menu_status[dnum][ABOUT];
}

void CreateAboutPopup(int dnum)
{
	Widget aboutbox,abouttitle,abouttext;

	abouttop[dnum] = XtVaAppCreateShell("abouttop","XScrabble",
		applicationShellWidgetClass,dpy[dnum],XtNmappedWhenManaged,
					    False,NULL);

	aboutbox = XtVaCreateManagedWidget("aboutbox",formWidgetClass,
					   abouttop[dnum],NULL);
	abouttitle = XtVaCreateManagedWidget("abouttitle",
					     labelWidgetClass,aboutbox,
					     XtNborderWidth,0,
					     NULL);

	abouttext = XtVaCreateManagedWidget("abouttext",labelWidgetClass,
					    aboutbox,XtNfromVert,abouttitle,
					    NULL);

	aboutdismiss[dnum] = XtVaCreateManagedWidget("aboutdismiss",
				          commandWidgetClass,aboutbox,
					  XtNfromVert,abouttext,NULL);
	bg_pixmap(aboutbox);
	bg_pixmap(abouttitle);

	XtRealizeWidget(abouttop[dnum]);
	XtAddCallback(aboutdismiss[dnum],XtNcallback,AboutPopdown,
		      abouttop[dnum]);
}

void AboutPopup(int dnum)
{
	if (menu_status[dnum][ABOUT]==False)
		/* popup is already up */
		XtUnmapWidget(abouttop[dnum]);
	else
		XtMapWidget(abouttop[dnum]);
}


/***********
 * The Key *
 ***********/

void KeyPopdown(Widget w, XtPointer client_data, XtPointer call_data)
{
	int dnum;
	
	for (dnum=0;keydismiss[dnum]!=w; dnum++)
		;
	XtUnmapWidget(keytop[dnum]);

	XtVaSetValues(menu_item[dnum][KEY],XtNleftBitmap,None,NULL);
	menu_status[dnum][KEY]= !menu_status[dnum][KEY];
}

void CreateKeyPopup(int dnum)
{
	Widget keybox,keytitle,keysq[4],keylb[4];
	int i;
	char wname[6];

	keytop[dnum] = XtVaAppCreateShell("keytop","XScrabble",
		applicationShellWidgetClass,dpy[dnum],XtNmappedWhenManaged,False,NULL);

	keybox = XtVaCreateManagedWidget("keybox",formWidgetClass,keytop[dnum],NULL);
	keytitle = XtVaCreateManagedWidget("keytitle",labelWidgetClass,keybox,
		NULL);

	for (i=0; i<4; i++)
	{
		sprintf(wname,"ksq%d",i);
		keysq[i] = XtVaCreateManagedWidget(wname, labelWidgetClass, keybox,
			XtNlabel," ",SETBG(colours[i+1]),NULL);
		sprintf(wname,"klb%d",i);
		keylb[i] = XtVaCreateManagedWidget(wname, labelWidgetClass, keybox,
			XtNfromHoriz,keysq[i],NULL);
		if (i>0)
		{
			XtVaSetValues(keysq[i],XtNfromVert,keysq[i-1],NULL);
			XtVaSetValues(keylb[i],XtNfromVert,keylb[i-1],NULL);
		}
	}
	keydismiss[dnum] = XtVaCreateManagedWidget("keydismiss",commandWidgetClass,
		keybox,NULL);
	bg_pixmap(keybox);

	XtRealizeWidget(keytop[dnum]);
	XtAddCallback(keydismiss[dnum],XtNcallback,KeyPopdown,keytop[dnum]);
}

void KeyPopup(int dnum)
{
	if (menu_status[dnum][KEY]==False)
		/* popup is already up */
		XtUnmapWidget(keytop[dnum]);
	else
		XtMapWidget(keytop[dnum]);
}
