#
# spec file for package xscrabble (Version 2.12)
#
# Copyright (c) 2005 SUSE LINUX Products GmbH, Nuernberg, Germany.
# This file and all modifications and additions to the pristine
# package are under the same license as the package itself.
#
# Please submit bugfixes or comments via http://www.suse.de/feedback/
#

# norootforbuild
# neededforbuild  XFree86 x-devel-packages

BuildRequires: aaa_base acl attr bash bind-utils bison bzip2 coreutils cpio cpp cracklib cvs cyrus-sasl db devs diffutils e2fsprogs file filesystem fillup findutils flex gawk gdbm-devel glibc glibc-devel glibc-locale gpm grep groff gzip info insserv klogd less libacl libattr libgcc libnscd libselinux libstdc++ libxcrypt libzio m4 make man mktemp module-init-tools ncurses ncurses-devel net-tools netcfg openldap2-client openssl pam pam-modules patch permissions popt procinfo procps psmisc pwdutils rcs readline sed strace syslogd sysvinit tar tcpd texinfo timezone unzip util-linux vim zlib zlib-devel autoconf automake binutils expat fontconfig fontconfig-devel gcc gdbm gettext libtool perl rpm xorg-x11 xorg-x11-devel xorg-x11-libs

Name:         xscrabble
Summary:      X version of the popular board game, for 1 to 4 players
Group:        Amusements/Games/Board/Other
PreReq:       permissions
License:      GPL
Version:      2.12
Release:      1
URL:          ftp://ftp.ac-grenoble.fr/ge/educational_games
Source0:      %{name}-%{version}.tar.bz2
Source1:      %{name}_en.tgz
Source2:      %{name}_fr.tgz
Patch:        %{name}-%{version}.patch
BuildRoot:    %{_tmppath}/%{name}-%{version}-build

%description
X version of the popular board game, for 1 to 4 players.



Authors:
--------
    matt@belgarath.demon.co.uk

%debug_package
%prep
%setup -a1 -a2
%patch

%build
./build bin

%install
export PATH="/usr/X11R6/bin/:$PATH"
rm -rf $RPM_BUILD_ROOT
DESTDIR=$RPM_BUILD_ROOT ./build install
DESTDIR=$RPM_BUILD_ROOT ./build lang fr 
DESTDIR=$RPM_BUILD_ROOT ./build lang en

%clean
rm -rf $RPM_BUILD_ROOT

%post
%run_permissions

%verifyscript
%verify_permissions -e /usr/games/xscrab

%files
%defattr(-,root,root)
%doc CHANGES LICENSE README
%verify(not mode) %attr(0755,games,games) /usr/games/xscrab
/usr/games/xscrabble
/usr/share/games/scrabble/
/etc/X11/app-defaults/*
%config(noreplace) %attr(664,games,games) /var/games/scrabble*

%changelog -n xscrabble
* Mon Jan 12 2004 - adrian@suse.de
- fix build again
* Sun Jan 11 2004 - adrian@suse.de
- use x-devel-packages
* Mon Nov 03 2003 - ltinkl@suse.cz
- package according to permissions.secure and call run_permissions
* Sun Aug 04 2002 - ro@suse.de
- group name changed "game" -> "games"
* Wed Jun 26 2002 - pmladek@suse.cz
- score files:
  * moved from /usr/share/games/... to /var/games/
  * fixed rights to 664
  * fixed owner to games:game
  * marked as %%config(noreplace)
- set group ID for /usr/games/xscrab to enable to write in score files
- merged rights patch
* Tue Mar 05 2002 - pmladek@suse.cz
- fixed rights for directories [#14414]
* Fri Feb 22 2002 - pmladek@suse.cz
- fixed paths to /usr/share/games
- fixed font settings
- default language is English now
* Fri Jan 11 2002 - ro@suse.de
- no subdirs in /usr/games
* Fri Oct 26 2001 - pmladek@suse.cz
- package created, version 2.10
- default language is French
