/*
 *  XScrabble - X version of the popular board game, for 1 to 4 players.
 *
 * This software comes with NO warranty whatsoever. I therefore take no
 * responsibility for any damages, losses or problems caused through use
 * or misuse of this program.
 *
 * I hereby grant permission for this program to be freely copied and
 * distributed by any means, provided no charge is made for it.
 *
 * Matthew Chapman, csuoq@csv.warwick.ac.uk
 *    Oct 1994.
 */

/* xscrab.h - includes, defines and structures for X interface */


#include <X11/Intrinsic.h>
#include <X11/StringDefs.h>
#include <X11/cursorfont.h>

#include <X11/Xaw/Label.h>
#include <X11/Xaw/Command.h>
#include <X11/Xaw/Form.h>
#include <X11/Xaw/Toggle.h>
#include <X11/Xaw/AsciiText.h>
#include <X11/Xaw/MenuButton.h>
#include <X11/Xaw/SimpleMenu.h>
#include <X11/Xaw/Sme.h>
#include <X11/Xaw/SmeBSB.h>

#include <X11/Xatom.h>
#include <X11/Shell.h>
#include <X11/xpm.h>

#include "CircPerc.h"
#include <X11/Xc/BarGraf.h>

#include <stdio.h>

/*
 * Version number is defined in config.h during the build process
 * and is used to make sure that X resources are correctly settled
 */
#include "config.h"

#define SETBG(x) XtVaTypedArg,XtNbackground,XtRString,x,strlen((char *)x)+1
#define SETFG(x) XtVaTypedArg,XtNforeground,XtRString,x,strlen((char *)x)+1
#define LETTERCOL "black"
#define TILECOL "lightgoldenrodyellow"
#define BRIGHTCOL "white"
#define BARCOL "forestgreen"
#define LONGBAR 13

#define NUM_TYPES 8

#define MENU_ITEMS 7
enum { KEY, LETTVAL, RULES, HISCORES, BESTGOES, MESSAGE, ABOUT };

#define HELP_ITEMS 6
enum { MANUAL, BAG, CHECK, PLACE, LIST, SUGGESTION };

#define MESS_DELAY 4000

/* messages */
#define LETTERSEQ	 0  /* List of letters */
#define FREQSEQ		 1  /* List of letter frequencies */
#define SCORESEQ	 2  /* List of letter scores */
#define BLANKTILES       3  /* List of blanktiles */
#define LABLVMAIN        4  /* "Letters Scores Frequencies" */
#define LABJOKER         5  /* "Joker letter" */
#define WDPOINT		 6  /* "point" */
#define WDPOINTS	 7  /* "points" */
#define PLAYER		 8  /* "Player" */
#define NAME		 9  /* "Name" */
#define SCORE		10 /* "Score" */
#define BAR		11 /* "Bar" */
#define EMPTY		12  /* "EMPTY" */
#define EMPTY_PAR	13 /* "(empty)" */
#define YOUR_GO		14 /* "Your go %s." */
#define START_GO_ALL	15  /* "%s's go." */
#define GO_ACCEPTED 	16 /* "Go accepted. You score %d %s." */
#define GO_ALL		17 /* "%s scores %d %s." */
#define WOULD_SCORE 	18 /* "That go would score %d %s." */
#define TILES_LEFT	19 /* "Tiles left: " */
#define SPAM		20 /* "*** SPAM! ***" */
#define LOST_GO		21 /* "Word is not valid - you lose your go." */
#define LOST_GO_ALL	22 /* "%s makes an invalid word." */
#define CANNOT_CHANGE 	23 /* "Not enough tiles left to change that many." */
#define PLAYER_CHANGE 	24 /* "%s changes tiles." */
#define USE_CENTRE	25 /* "You must use the centre square." */
#define ARRANGEMENT	26 /* "Incorrect arrangement of tiles." */
#define FIXED_TILE	27 /* "That tile can't be moved." */
#define OCCUPIED	28 /* "Square is occupied." */
#define PASS		29 /* "%s passes." */
#define NOT_ON_BOARD	30 /* "Cannot access board - it is not your go." */
#define GAME_OVER_LOSE	31 /* "Game Over. You lose %d %s." */
#define GAME_OVER_WIN	32 /* "Game Over. You get %d bonus %s." */
#define WINNER		33 /* "%s is the winner!" */
#define DRAWN2		34 /* "%s and %s draw!" */
#define DRAWN3		35 /* "%s, %s and %s draw!" */
#define DRAW_ALL	36 /* "It is a complete draw!" */
#define COMP_SCORE	37 /* "%s scores %d %s." */
#define OUT_TIME_ALL	38 /* "%s runs out of time." */
#define OUT_TIME	39 /* "You are out of time." */
#define TO_END		40 /* "Select quit to end." */
#define MESS_PING	41 /* "%s sends message. See Extras Menu." */
#define STARTING_GAME   42 /* "Starting game" */
#define DISMISS		43 /* "Dismiss" */
#define PING_ALL	44 /* "Ping all" */
#define THINKING	45 /* "Thinking" */
#define HUMAN		46 /* "(Human)" */
#define COMPUTER	47 /* "(computer level )" */
#define START_PAUSE	48 /* "asks for a pause." */
#define STOP_PAUSE	49 /* "comes back to the game." */
#define SORTED_OUT	50 /* "%s has been sorted out to start." */
#define READY		51 /* "%s, are you ready to start?" */
#define OK_HE_STARTS	52 /* "Ok, %s will start the game..." */
#define VALIDWORD	53 /* "Valid word" */
#define INVALIDWORD	54 /* "Invalid word" */

#define NUMPROMPTS      56
