/*
	scrab.h - includes, defines and structures
*/

#include "xscrab.h"
#include <stdio.h>
#include <ctype.h>
#include <time.h>
#include <stdlib.h>
#include <sys/types.h>
#include <unistd.h>

#include <assert.h>

/* make sure this is bigger than the number of words in the dictionary used -
   119000 is okay for the supplied dictionary.
*/

#define NUMCHAR_MAX 256
#define NUMLETTERS_MAX 100
#define NUMBLANKS_MAX 20
#define BAGSIZE_MAX 200

#define NAMELEN 64
#define BARLEN 7
#define BOARDSIZE 15
#define MAXPLAYERS 4

#define SAVENAME "/.xscrabble.save"

#define MAXPATHLEN 256
#define MAGNUM 99 /* magic number for checksum calculation */
#define NUMHIGHSCORES 8
#define NUMGOSCORES 10
#define BESTGOWORDSLEN 30

/* board validation flags */
#define INVALID 0  /* invalid words */
#define VALID 1    /* valid words */
#define HORLICKS 2 /* move was complete horlicks */
#define NOTCENTRE 3 /* first move was not in centre */

/* player statistics structure */
typedef struct { int score;
		 char name[NAMELEN];
		 char bar[BARLEN]; } playerStat;

typedef struct { int score;
		 char name[NAMELEN];
		 time_t date; } scoreStat;
		 
typedef struct { int score;
		 char name[NAMELEN];
		 time_t date;
		 char words[BESTGOWORDSLEN]; } goStat;
