/*
 * Copyright (c) 1997, 1998, 1999, 2000, 2001, Mark Buser.
 * Copyright (c) 2001, 2003, 2004, Danny Backx.
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are
 * met:
 *
 * Redistributions of source code must retain the above copyright notice,
 * this list of conditions and the following disclaimer.
 * Redistributions in binary form must reproduce the above copyright
 * notice, this list of conditions and the following disclaimer in the
 * documentation and/or other materials provided with the distribution.
 * Neither the names the authors (see above), nor the names of other
 * contributors may be used to endorse or promote products derived from
 * this software without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
 * "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
 * LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR
 * A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT
 * OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
 * SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT
 * LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
 * DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY
 * THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 * (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
 * OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *
 * $Header: /pack/anoncvs/xinvest/src/xquote.c,v 1.49 2004/12/27 08:38:57 danny Exp $
 */
#include <stdio.h>
#include <time.h>
#include <unistd.h>

#include <X11/Xlib.h>
#include <Xm/XmAll.h>

#ifdef EDITRES
#include <X11/Xmu/Editres.h>
#endif

#include "xquote.h"

#include "about.h"
#include "color.h"
#include "fileXq.h"
#include "help.h"
#include "optdetail.h"
#include "option.h"
#include "pixmap.h"
#include "server.h"
#include "session.h"
#include "status.h"
#include "tape.h"
#include "view.h"
#include "util.h"
#include "xquoteP.h"
#include "xutil.h"

#include <Xbae/Matrix.h>

/* Externs */
extern Widget Detail_dialog;
extern Widget Fmenu[3];
extern Widget OFmenu[3];
extern void DrawCellCB(Widget, XtPointer, XtPointer);
extern void TrackCellCB(Widget, XtPointer, XtPointer);
extern void EnterCellCB(Widget, XtPointer, XtPointer);
extern void LeaveCellCB(Widget, XtPointer, XtPointer);

static void buttonPressEventHandler(Widget w, XtPointer client_data, XEvent *e, Boolean *cont);

/* Globals */
PerDisplay	Global[2];
PerDisplay	*per = &Global[0];

/* from the popup menu activation */
int		CurrentRow, CurrentColumn;

/* application resources */
AppData appdata;

Widget Menubar;
Widget Viewmenu;
Widget Container;
Widget Tape;
Widget StatusLabel;
Widget ProgressBar;
Widget Mainform;
Widget StatusForm;
Widget LastUpdateLabel;

char version[] = "Xquote 2.6.10";

/*
 * Default ini file
 */
static char *DefaultRCLine[] = {
	"VERSION 2.1 (X11R6)",
	"CURSERVER 2",
	"TICK INTC,Stock,Yahoo Quote,Intel Corp",
	"TICK DELL,Stock,Yahoo Quote,Dell",
	"TICK BE0003565737,stock,EuroNext,KBC",
	"TICK IBM,Stock,Yahoo Quote,IBM",
	"TICK BE0389555039,stock,EuroNext,BEL-20",
	"DETAIL 115911",
	"AUTO 1 5",
	"RANGE 1 0 0",
	"SCROLL 0 12",
	"VIEW 0",
	NULL,		/* Must be the last line */
};

/* These will appear under widget "Filemenu" */
static MENUITEMS file[] = {
 { "button_0",    XmVaPUSHBUTTON, fileCB },
 { "button_1",    XmVaPUSHBUTTON, fileCB },
 { "separator_0", XmVaSEPARATOR,  NULL },
 { "button_2",    XmVaPUSHBUTTON, fileCB },
 { "button_2b",   XmVaPUSHBUTTON, fileCB },
 { "separator_1", XmVaSEPARATOR,  NULL },
 { "button_3",    XmVaPUSHBUTTON, fileCB },
 { "button_4",    XmVaPUSHBUTTON, fileCB },
 { "button_5",    XmVaPUSHBUTTON, fileCB },
 { "separator_2", XmVaSEPARATOR,  NULL },
 { "button_6",    XmVaPUSHBUTTON, fileCB },
};

static MENUITEMS option[] = {
 { "button_0",    XmVaPUSHBUTTON, optionCB },
 { "button_1",    XmVaPUSHBUTTON, optionCB },
 { "button_2",    XmVaPUSHBUTTON, optionCB },
 { "button_3",    XmVaPUSHBUTTON, optionCB },
 { "button_4",    XmVaPUSHBUTTON, optionCB },
 { "button_5",    XmVaPUSHBUTTON, optionCB },
 { "button_6",    XmVaPUSHBUTTON, optionCB }
};

static MENUITEMS view[] = {
 { "button_0",    XmVaRADIOBUTTON, viewCB },
 { "button_1",    XmVaRADIOBUTTON, viewCB },
};

static MENUITEMS help[] = {
 { "button_0",    XmVaPUSHBUTTON, aboutCB },
 { "button_1",    XmVaPUSHBUTTON, helpCB }
};

static MENUITEMS popuptape[] = {
 { "button_0",    XmVaPUSHBUTTON, popupCB },
 { "button_1",    XmVaPUSHBUTTON, popupCB },
 { "separator_0", XmVaSEPARATOR,  NULL },
 { "button_2",    XmVaPUSHBUTTON, popupCB },
 { "separator_1", XmVaSEPARATOR,  NULL },
 { "button_3",    XmVaPUSHBUTTON, popupCB },
 { "button_4",    XmVaPUSHBUTTON, popupCB },
 { "button_5",    XmVaPUSHBUTTON, popupCB },
 { "separator_2", XmVaSEPARATOR,  NULL },
 { "button_6",    XmVaPUSHBUTTON, popupCB },
 { "button_7",    XmVaPUSHBUTTON, popupCB },
 { "button_8",    XmVaPUSHBUTTON, popupCB },
 { "button_9",    XmVaPUSHBUTTON, popupCB },
 { "button_10",   XmVaPUSHBUTTON, popupCB },
 { "button_11",   XmVaPUSHBUTTON, popupCB },
 { "separator_3", XmVaSEPARATOR,  NULL },
 { "button_12",   XmVaPUSHBUTTON, popupCB },
 { "button_13",   XmVaPUSHBUTTON, popupCB },
};

static MENUITEMS popupdetail[] = {
 { "button_0",    XmVaPUSHBUTTON, popupDetailCB },
 { "button_1",    XmVaPUSHBUTTON, popupDetailCB },
 { "button_2",    XmVaPUSHBUTTON, popupDetailCB },
 { "button_3",    XmVaPUSHBUTTON, popupDetailCB },
 { "button_4",    XmVaPUSHBUTTON, popupDetailCB },
 { "button_5",    XmVaPUSHBUTTON, popupDetailCB },
 { "button_6",    XmVaPUSHBUTTON, popupDetailCB },
};

int main (int argc, char **argv)
{

  XtAppContext app;

  /* application resources */
  AppData appdata;

  /* Main Window Widgets */
/*  Widget per->Toplevel; */
/* Widget Menubar; */
    Widget Filemenu;
/*  Widget Viewmenu; */
   Widget Workform;
     Widget popupDetail; 
/*   Widget Container; */
/*  Widget Tape; */
     Widget popup;
     Widget StatusFrame;
/*    Widget StatusLabel; */
     Widget LastUpdateFrame;
     Widget ProgressFrame;
/*    Widget ProgressBar; */

  /* Display */
  Display *dpy;

  /* Window */
  Window win;

  /* Color resources */
  Colormap cmap;
  GC       gc;

  /* Font resources */
  XmFontContext fontContext;

  /* array of resources */
  int n;
  Arg args[15];

  Widget w;  /* temporary widget handle */

  /* Initialize toolkit */
  XtSetLanguageProc (NULL, NULL, NULL);

  /* Clear global structures */
  memset(&Global[0], 0, sizeof(PerDisplay));
  memset(&Global[1], 0, sizeof(PerDisplay));

#if !defined(CDE) && XtSpecificationRelease > 5
  /* R6 session shell supports session management */
  per->Toplevel = XtVaOpenApplication( &app, "Xquote",
                                  options, XtNumber(options), 
                                  &argc, argv, 
                                  getFallbackResource(), 
                                  sessionShellWidgetClass, NULL);
  /* These callbacks are required */
  XtAddCallback (per->Toplevel, XtNsaveCallback, sessSave, 0);
  XtAddCallback (per->Toplevel, XtNcancelCallback, sessResume, 0);
  XtAddCallback (per->Toplevel, XtNsaveCompleteCallback, sessResume, 0);
/*  XtAddCallback (per->Toplevel, XtNdieCallback, sessDie, 0); */

#else
  /* Old style WM_SAVE_YOURSELF property method of save state notification */
  per->Toplevel = XtVaAppInitialize( &app, "Xquote",
                                options, XtNumber(options), &argc, argv, 
                                getFallbackResource(), NULL);
  {
     Atom XaWmSaveYourself = XmInternAtom ( XtDisplay (per->Toplevel), 
		                            "WM_SAVE_YOURSELF", False);
     XmAddWMProtocols ( per->Toplevel, &XaWmSaveYourself, 1);
     XmAddWMProtocolCallback ( per->Toplevel, XaWmSaveYourself, sessSave, 0);
  }
#endif

  XmRepTypeInstallTearOffModelConverter();
  XtVaGetApplicationResources ( per->Toplevel, 
                                &appdata, 
                                resources, 
                                XtNumber( resources ),
                                NULL );

  /* If help, print syntax and exit */
  if (appdata.help) {
    syntax (argc, argv);
    exit(0);
  }

  /* Build database of quote servers and how to access data */
  if (readServerDatabase (per->Toplevel, argv[0]) == 0) {
    fprintf ( stderr, 
	      "%s - No servers in database! This means that Xquote.ad\n"
	      "is missing or corrupt, AND Xquote was built with a corrupt\n"
	      "defaults.h; recommend getting new source and rebuilding.\n",
	      argv[0] );
    exit(1);
  }

#ifdef EDITRES
  XtAddEventHandler( per->Toplevel, 0, True, _XEditResCheckMessages, NULL);
#endif

  per->dpy = XtDisplay( per->Toplevel );
  per->win = RootWindowOfScreen (XtScreen(per->Toplevel));
  per->cmap = DefaultColormapOfScreen (XtScreen(per->Toplevel));
  per->gc = XCreateGC ( per->dpy, per->win, 0, NULL );

  /* Get a color map */
  if (appdata.install)
    cmap = NewColormap (per->dpy, per->cmap );

  { /* Application resource colors get added to color list. */
    Pixel appcolors[COLOR_DEF];

    per->color[0] = GetNamedColor(per, appdata.color0);
    per->color[1] = GetNamedColor(per, appdata.color1);
    per->color[2] = GetNamedColor(per, appdata.color2);
    per->color[3] = GetNamedColor(per, appdata.color3);
    per->color[4] = GetNamedColor(per, appdata.color4);
    per->color[5] = GetNamedColor(per, appdata.color5);
    per->color[6] = GetNamedColor(per, appdata.color6);
    per->color[7] = GetNamedColor(per, appdata.color7);
    per->color[8] = GetNamedColor(per, appdata.colorRed);
    per->color[9] = GetNamedColor(per, appdata.colorGreen);
    per->color[10] = GetNamedColor(per, appdata.colorGrey);
    per->color[11] = GetNamedColor(per, appdata.colorWhite);

    per->cmap = InitColor ( per->Toplevel, per->cmap, per->color );
    if ( per->cmap == (Colormap)NULL) {
      fprintf( stderr, "Error: can't create XColor colormap, exiting.\n");
      exit(1);
    }
   }

  /* Set the colormap */
  XtVaSetValues ( per->Toplevel, XmNcolormap, per->cmap, NULL );

  /* Get fonts for ticker tape */
  per->large = NULL;
  if ( XmFontListInitFontContext ( &fontContext, appdata.font_list ) == True ) {
    XmFontListEntry entry;
    XmFontType      fonttype =  XmFONT_IS_FONT;
    char *tag;

    while ( (entry = XmFontListNextEntry ( fontContext )) != NULL ) {

       tag = XmFontListEntryGetTag ( entry );
       if ( strcmp( tag, "large") == 0 )
         per->large = (XFontStruct *) XmFontListEntryGetFont (entry, &fonttype);

       if ( tag != NULL )
         XtFree (tag);

    }

    XmFontListFreeFontContext ( fontContext );
  }

  if (per->large == NULL) {
    fprintf (stderr, "Error: missing font resource with '=large' tag,\n");
    fprintf (stderr, "Xquote will crash on a ticker tape view!\n");
    fprintf (stderr, "See Help->Application Resources for more information.\n");
  }
  /**********************/

  /* Create the main window */
  Mainform = XtVaCreateWidget( "Mainform", xmMainWindowWidgetClass, per->Toplevel,    
                                XmNresizable, True,
        		        NULL );

  /* Load up all of the pixmaps. Why here? Because Toplevel may have a
  ** bogus background color.  We can't load a "good" colormap till after
  ** its up.  This is the first widget with a likely allocated bg color. 
  */
  per->cmap = InitPixmaps( Mainform, per->cmap);
  if ( per->cmap == (Colormap)NULL) {
     fprintf( stderr, "Error: can't create Pixmap colormap, exiting.\n");
     exit(1);
  }


  /* Set the icon */
  MakeIconWindow ( per->Toplevel );

  /**********************/
 
  if (!appdata.tape) {
    /* Create menu bar and pulldown menus */
    n = 0;
    XtSetArg(args[n], XmNtopAttachment,   XmATTACH_FORM); n++;
    XtSetArg(args[n], XmNleftAttachment,   XmATTACH_FORM); n++;
    XtSetArg(args[n], XmNrightAttachment,   XmATTACH_FORM); n++;
    Menubar =  XmCreateMenuBar ( Mainform, "Menubar", args, n );

    XtVaCreateManagedWidget("button_0",xmCascadeButtonGadgetClass,Menubar,NULL);
    XtVaCreateManagedWidget("button_1",xmCascadeButtonGadgetClass,Menubar,NULL);
    XtVaCreateManagedWidget("button_2",xmCascadeButtonGadgetClass,Menubar,NULL);
    XtVaCreateManagedWidget("button_3",xmCascadeButtonGadgetClass,Menubar,NULL);

    /* Set help menu */
    if ( (w = XtNameToWidget (Menubar, "button_3")) )
      XtVaSetValues( Menubar, XmNmenuHelpWidget, w, NULL);

    /* 
    ** File menu 
    */
    Filemenu = makeMenuPulldown (Menubar, "Filemenu", 0, file, XtNumber(file));
    Fmenu[0] = XtNameToWidget (Filemenu, "button_3");
    if ( (Fmenu[1] = XtNameToWidget (Filemenu, "button_4")) )
      XtSetSensitive (Fmenu[1], False); 
    if ( (Fmenu[2] = XtNameToWidget (Filemenu, "button_5")) )
      XtSetSensitive (Fmenu[2], False); 
    /* 
    ** Option menu 
    */
    makeMenuPulldown ( Menubar, "Optionmenu", 1, option, XtNumber(option) );
    /*
    ** View menu
    */
    Viewmenu = makeMenuPulldown (Menubar, "Viewmenu", 2, view, XtNumber(view));
    /* 
    ** Help menu 
    */
    makeMenuPulldown ( Menubar, "Helpmenu", 3, help, XtNumber(help) );

    XtManageChild (Menubar);
  }
   
  /*
  ** Workform displays either the scrolled window or tape display
  */
  if (!appdata.tape) {
	  extern short *column_widths;
	  extern char **column_labels;

	int	i, count = 5;

	column_widths = (short *)XtCalloc(sizeof(short), DETAIL_NUM_QUERY_VALUES+1);
	column_labels = (char **)XtCalloc(sizeof(char *), DETAIL_NUM_QUERY_VALUES+1);

	for (i=0; i<DETAIL_NUM_QUERY_VALUES; i++) {
		column_widths[i] = 4;	/* This gets overwritten when updating the matrix */
		column_labels[i] = strdup("");
	}

    Container = XtVaCreateWidget("Container", xbaeMatrixWidgetClass, Mainform,
			XmNfill,		True,
			XmNtopAttachment,	XmATTACH_FORM,
			XmNleftAttachment,	XmATTACH_FORM,
			XmNrightAttachment,	XmATTACH_FORM,
#if 0
			XmNvisibleRows,		20,
#endif
			XmNrows,		count,
			XmNcolumns,		DETAIL_NUM_QUERY_VALUES,
			XmNcolumnLabels,	column_labels,
			XmNcolumnWidths,	column_widths,
		NULL);
    XtManageChild (Container);
    XtAddCallback(Container, XmNdrawCellCallback, DrawCellCB, NULL);
    XtAddCallback(Container, XmNleaveCellCallback, LeaveCellCB, NULL);
    XtAddCallback(Container, XmNenterCellCallback, EnterCellCB, NULL);
#if 0
    XtAddCallback(Container, XmNenterCellCallback, TrackCellCB, NULL);
#endif

    /* Make popup menu to allow selecting of URL based on where pointer is */
    popupDetail = makeMenuPulldown ( Container, "Popupdetail", 0, 
		             popupdetail, XtNumber(popupdetail) );

    /* PostIt passes menu's parent user data to menu button callback *
    XtVaSetValues (Scroll, XmNuserData, popupDetail, NULL);
     * FIX ME */

    XtAddEventHandler(Container, ButtonPressMask, False, buttonPressEventHandler, popupDetail);
  }


  /*
  ** Drawing Area to hold ticker tape
  */
  Tape = XtVaCreateWidget ( "Tape",
                            xmDrawingAreaWidgetClass, Mainform,
                            XmNtopAttachment, XmATTACH_FORM,
                            XmNleftAttachment, XmATTACH_FORM,
                            XmNrightAttachment, XmATTACH_FORM,
                            NULL );

  XtAddCallback( Tape, XmNexposeCallback,
                 (XtCallbackProc) drawTape, (XtPointer) NULL);

  /* Tell tape some things it needs to know */
  initTape (Tape, per->gc);

  /* Make popup menu mirroring useful settings from File and Option */
  popup = makeMenuPulldown ( Tape, "Popupmenu", 0, 
		             popuptape, XtNumber(popuptape) );
  /* Make stop/clear log insensitive to match file menu */
  OFmenu[0] = XtNameToWidget (popup, "button_3");
  if ( (OFmenu[1] = XtNameToWidget (popup, "button_4")) )
    XtSetSensitive (OFmenu[1], False); 
  if ( (OFmenu[2] = XtNameToWidget (popup, "button_5")) )
    XtSetSensitive (OFmenu[2], False); 

  XtAddEventHandler (Tape, ButtonPressMask, False, 
                     (XtEventHandler)PostIt, popup );

  /* Build the detail dialog now so we can set heading label */ 
  Detail_dialog = createDetailDialog ();
  detailSetState ( 0xF );

  /*
  ** Status line and progress bar
  */
  StatusForm = XtVaCreateWidget( "StatusForm", xmFormWidgetClass, Mainform,
                           XmNleftAttachment, XmATTACH_FORM,
                           XmNrightAttachment, XmATTACH_FORM,
                           XmNbottomAttachment, XmATTACH_FORM,
                           XmNtopAttachment, XmATTACH_WIDGET,
                           XmNtopWidget, Container,
                           XmNtopOffset, 5,
                           NULL );

  StatusFrame = XtVaCreateManagedWidget( "StatusFrame",
                                   xmFrameWidgetClass, StatusForm,
                                   XmNtopAttachment, XmATTACH_FORM,
                                   XmNleftAttachment, XmATTACH_FORM,
                                   XmNbottomAttachment, XmATTACH_FORM,
				   XmNrightAttachment,	XmATTACH_POSITION,
		/*		   XmNrightPosition,	50,	/* Do this with app resources */
                                   NULL);

  StatusLabel = XtVaCreateManagedWidget("StatusLabel",
                                        xmLabelWidgetClass, StatusFrame,
                                        NULL);


  if (appdata.tape)
    XtVaSetValues ( StatusFrame, XmNrightAttachment, XmATTACH_FORM, NULL);
  else {
    ProgressFrame = XtVaCreateManagedWidget( "ProgressFrame",
                                   xmFrameWidgetClass, StatusForm,
                                   XmNtopAttachment, XmATTACH_FORM,
                                   XmNrightAttachment, XmATTACH_FORM,
                                   XmNbottomAttachment, XmATTACH_FORM,
				   NULL);

  LastUpdateFrame = XtVaCreateManagedWidget( "LastUpdateFrame",
                                   xmFrameWidgetClass, StatusForm,
                                   XmNtopAttachment, XmATTACH_FORM,
				   XmNleftAttachment,	XmATTACH_POSITION,
		/*		   XmNleftPosition,	50,	/* Do this with app resources */
                                   XmNrightAttachment, XmATTACH_WIDGET,
				   XmNrightWidget, ProgressFrame,
                                   XmNbottomAttachment, XmATTACH_FORM,
                                   NULL);
  LastUpdateLabel = XtVaCreateManagedWidget("LastUpdateLabel",
                                        xmLabelWidgetClass, LastUpdateFrame,
                                        NULL);

    /* Keep ProgressFrame from horizontal resize */
    XtVaSetValues ( StatusFrame,
                  XmNrightAttachment, XmATTACH_WIDGET,
                  XmNrightWidget, LastUpdateFrame,
                  NULL);

    ProgressBar = XtVaCreateManagedWidget("ProgressBar",
                           xmScrollBarWidgetClass, ProgressFrame,
                           XmNeditable, False,
                           XmNminimum, 0,
                           XmNmaximum, 100,
                           XmNorientation, XmHORIZONTAL,
                           XmNshowArrows, XmNONE,
                           XmNsliderSize, 100,
                           XmNwidth, 100,
                           XmNshadowThickness, 0,
                           NULL);
  }

  /* Keep Form from vertical resize */
  XtVaSetValues ( Tape,
                  XmNbottomAttachment, XmATTACH_WIDGET,
                  XmNbottomWidget, StatusForm,
                  NULL);

  write_status_line("");

  if (appdata.tape)
    XtManageChild (Tape);

  XtManageChild( StatusForm );
  XtManageChild( Mainform );
  XmMainWindowSetAreas(Mainform, Menubar, StatusForm, NULL, NULL, Container);

  XtRealizeWidget ( per->Toplevel );

  if (appdata.restore) {
    restoreState (appdata.restore);
  } else {
	  /* Get some defaults */
	  int	i;

	  for (i=0; DefaultRCLine[i]; i++) {
		  /*
		   * Need to copy the strings into read/write area, otherwise
		   * the default GCC action of putting initialised strings in
		   * read-only memory will kill us in library calls.
		   */
		  char	*s = strdup(DefaultRCLine[i]);
		  ProcessOneLine(s);
		  free(s);
	  }
  }

  /* Update here since restore may have changed the detail settings */
  detailAddMainWindow();

  XtAppMainLoop ( app );

  return (0);
}

static void buttonPressEventHandler(Widget w, XtPointer client, XEvent *e, Boolean *cont)
{
	XButtonEvent *be = (XButtonEvent*)e;
	Widget	popup = (Widget)client;
	int	row, column;

	if (be->button == 3) {
		XmMenuPosition(popup, be);
		if (! XbaeMatrixGetEventRowColumn(w, e, &row, &column)) {
			/* Not a valid cell -> just abort */
			return;
		}
		CurrentRow = row;
		CurrentColumn = column;
		XtManageChild(popup);
	}
}
