/*
   Copyright (C) 1999 Rocky Bernstein
   
   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2 of the License, or
   (at your option) any later version.
   
   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.
   
   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software
   Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/
static char process_tree_help[] =
"The main part of the display shows processes as a tree or forest, the\n"
"roots of the tree are on the left-hand side and the leaf processes\n"
"(with no children) are on the right-hand side.  Which processes shown\n"
"is determined various settings. Once can select all processes, or a\n"
"specific process owned by specific users, and possibly kernel \n"
"processes as well.\n"
"\n"
"Process status (running, sleeping, stopped, etc.) of shown processes\n"
"is indicated by a color.\n"
"\n"
"Within each level, processes are grouped so that those with the same\n"
"parent process id are grouped together. Within this, processes are\n"
"arranged by userid with lower number uid's appearing towards the top.\n"
"\n"
"This means root processes always appear at the extreme top, assuming\n"
"the processes' parent was also a root process.  Finally, among\n"
"processes that have a common parent (or no parent) and belong to the\n"
"same userid, those with lower process numbers appear towards the\n"
"top. In general, the order of children is the order in which they were\n"
"spawned, with the older processes appearing towards towards the top.\n"
"\n"
"Some effort is made to effectively use the full 2-dimensional area of\n"
"the screen by balancing levels and centering the children of a node\n"
"between their parent.  But since a goal of the program is to visually\n"
"give a picture of what's going on, when possible processes are kept\n"
"close to their parents so one needn't scroll around too much and so\n"
"that doesn't there isn't a lot of redrawing as processes are created\n"
"or destroyed.\n"
"\n"
"One can click on a process to get more information (via \"ps\") about\n"
"that process, send a signal to the process, or set its priority\n"
"(assuming you have the permission to do so).\n"
"\n"
"The majority of processes in a system, one hopes, are sleeping\n"
"processes.  The color to be selected for uid's of sleeping process can\n"
"be specified by X resources.  If however a color is not specified, one\n"
"is chosen at random. Generally, all processes belonging to a given\n"
"user will be a unique color. For certain terminal programs like\n"
"\"xterm\" or \"telnet\", the name if the user is displayed rather than\n"
"the program name.\n"
"\n"
;
