.\" Automatically generated by Pod::Man version 1.12
.\" Thu Jan 25 22:53:06 2001
.\"
.\" Standard preamble:
.\" ======================================================================
.de Sh \" Subsection heading
.br
.if t .Sp
.ne 5
.PP
\fB\\$1\fR
.PP
..
.de Sp \" Vertical space (when we can't use .PP)
.if t .sp .5v
.if n .sp
..
.de Ip \" List item
.br
.ie \\n(.$>=3 .ne \\$3
.el .ne 3
.IP "\\$1" \\$2
..
.de Vb \" Begin verbatim text
.ft CW
.nf
.ne \\$1
..
.de Ve \" End verbatim text
.ft R

.fi
..
.\" Set up some character translations and predefined strings.  \*(-- will
.\" give an unbreakable dash, \*(PI will give pi, \*(L" will give a left
.\" double quote, and \*(R" will give a right double quote.  | will give a
.\" real vertical bar.  \*(C+ will give a nicer C++.  Capital omega is used
.\" to do unbreakable dashes and therefore won't be available.  \*(C` and
.\" \*(C' expand to `' in nroff, nothing in troff, for use with C<>
.tr \(*W-|\(bv\*(Tr
.ds C+ C\v'-.1v'\h'-1p'\s-2+\h'-1p'+\s0\v'.1v'\h'-1p'
.ie n \{\
.    ds -- \(*W-
.    ds PI pi
.    if (\n(.H=4u)&(1m=24u) .ds -- \(*W\h'-12u'\(*W\h'-12u'-\" diablo 10 pitch
.    if (\n(.H=4u)&(1m=20u) .ds -- \(*W\h'-12u'\(*W\h'-8u'-\"  diablo 12 pitch
.    ds L" ""
.    ds R" ""
.    ds C` ""
.    ds C' ""
'br\}
.el\{\
.    ds -- \|\(em\|
.    ds PI \(*p
.    ds L" ``
.    ds R" ''
'br\}
.\"
.\" If the F register is turned on, we'll generate index entries on stderr
.\" for titles (.TH), headers (.SH), subsections (.Sh), items (.Ip), and
.\" index entries marked with X<> in POD.  Of course, you'll have to process
.\" the output yourself in some meaningful fashion.
.if \nF \{\
.    de IX
.    tm Index:\\$1\t\\n%\t"\\$2"
..
.    nr % 0
.    rr F
.\}
.\"
.\" For nroff, turn off justification.  Always turn off hyphenation; it
.\" makes way too many mistakes in technical documents.
.hy 0
.if n .na
.\"
.\" Accent mark definitions (@(#)ms.acc 1.5 88/02/08 SMI; from UCB 4.2).
.\" Fear.  Run.  Save yourself.  No user-serviceable parts.
.bd B 3
.    \" fudge factors for nroff and troff
.if n \{\
.    ds #H 0
.    ds #V .8m
.    ds #F .3m
.    ds #[ \f1
.    ds #] \fP
.\}
.if t \{\
.    ds #H ((1u-(\\\\n(.fu%2u))*.13m)
.    ds #V .6m
.    ds #F 0
.    ds #[ \&
.    ds #] \&
.\}
.    \" simple accents for nroff and troff
.if n \{\
.    ds ' \&
.    ds ` \&
.    ds ^ \&
.    ds , \&
.    ds ~ ~
.    ds /
.\}
.if t \{\
.    ds ' \\k:\h'-(\\n(.wu*8/10-\*(#H)'\'\h"|\\n:u"
.    ds ` \\k:\h'-(\\n(.wu*8/10-\*(#H)'\`\h'|\\n:u'
.    ds ^ \\k:\h'-(\\n(.wu*10/11-\*(#H)'^\h'|\\n:u'
.    ds , \\k:\h'-(\\n(.wu*8/10)',\h'|\\n:u'
.    ds ~ \\k:\h'-(\\n(.wu-\*(#H-.1m)'~\h'|\\n:u'
.    ds / \\k:\h'-(\\n(.wu*8/10-\*(#H)'\z\(sl\h'|\\n:u'
.\}
.    \" troff and (daisy-wheel) nroff accents
.ds : \\k:\h'-(\\n(.wu*8/10-\*(#H+.1m+\*(#F)'\v'-\*(#V'\z.\h'.2m+\*(#F'.\h'|\\n:u'\v'\*(#V'
.ds 8 \h'\*(#H'\(*b\h'-\*(#H'
.ds o \\k:\h'-(\\n(.wu+\w'\(de'u-\*(#H)/2u'\v'-.3n'\*(#[\z\(de\v'.3n'\h'|\\n:u'\*(#]
.ds d- \h'\*(#H'\(pd\h'-\w'~'u'\v'-.25m'\f2\(hy\fP\v'.25m'\h'-\*(#H'
.ds D- D\\k:\h'-\w'D'u'\v'-.11m'\z\(hy\v'.11m'\h'|\\n:u'
.ds th \*(#[\v'.3m'\s+1I\s-1\v'-.3m'\h'-(\w'I'u*2/3)'\s-1o\s+1\*(#]
.ds Th \*(#[\s+2I\s-2\h'-\w'I'u*3/5'\v'-.3m'o\v'.3m'\*(#]
.ds ae a\h'-(\w'a'u*4/10)'e
.ds Ae A\h'-(\w'A'u*4/10)'E
.    \" corrections for vroff
.if v .ds ~ \\k:\h'-(\\n(.wu*9/10-\*(#H)'\s-2\u~\d\s+2\h'|\\n:u'
.if v .ds ^ \\k:\h'-(\\n(.wu*10/11-\*(#H)'\v'-.4m'^\v'.4m'\h'|\\n:u'
.    \" for low resolution devices (crt and lpr)
.if \n(.H>23 .if \n(.V>19 \
\{\
.    ds : e
.    ds 8 ss
.    ds o a
.    ds d- d\h'-1'\(ga
.    ds D- D\h'-1'\(hy
.    ds th \o'bp'
.    ds Th \o'LP'
.    ds ae ae
.    ds Ae AE
.\}
.rm #[ #] #H #V #F C
.\" ======================================================================
.\"
.IX Title "xps xps(1)"
.TH xps xps(1) "perl v5.5.30" "2001-01-25" "User Commands"
.UC
.SH "NAME"
xps \- Process tree display and manipulation for the X Window System.
.SH "SYNOPSIS"
.IX Header "SYNOPSIS"
\&\fBxps\fR [ \f(CW\*(C`\-help\*(C'\fR | \f(CW\*(C`\-version\*(C'\fR ]
.PP
\&\fBxps\fR [\f(CW\*(C`\-interval\*(C'\fR \fItime-in-seconds\fR ]
       [\f(CW\*(C`\-metoo\*(C'\fR]
       [\f(CW\*(C`\-kernel\*(C'\fR]
       [\f(CW\*(C`\-allprocs\*(C'\fR]
       [\f(CW\*(C`\-iconic\*(C'\fR]
       [\f(CW\*(C`\-beep\*(C'\fR]
       [\f(CW\*(C`\-zoomed\*(C'\fR]
       [\f(CW\*(C`\-kill\*(C'\fR]
       [\f(CW\*(C`\-debugging\*(C'\fR  \fIinteger-debug-value\fR]
       [\f(CW\*(C`\-zfont\*(C'\fR \fIX-fontname\fR]
       [\f(CW\*(C`\-zfn\*(C'\fR \fIX-fontname\fR]
       [\f(CW\*(C`\-zgeometry\*(C'\fR \fIX-geometry\fR]
       [\f(CW\*(C`\-swap\*(C'\fR  \fIX-color\fR]
       [\f(CW\*(C`\-waiting\*(C'\fR \fIX-color\fR]
       [\f(CW\*(C`\-active\*(C'\fR \fIX- color\fR]
       [\f(CW\*(C`\-selected\*(C'\fR \fIX-color\fR]
       [\f(CW\*(C`\-running\*(C'\fR \fIX-color\fR]
       [\f(CW\*(C`\-zombie\*(C'\fR \fIX-color\fR]
       [\f(CW\*(C`\-idle\*(C'\fR \fIX-color\fR]
       [\f(CW\*(C`\-stopped\*(C'\fR \fIX-color\fR]
       [\f(CW\*(C`\-pscmdline\*(C'\fR \fIps-command\fR]
       [\f(CW\*(C`\-pscmdinfo\*(C'\fR \fIps-command\fR]
       [\fIX-options...\fR]
.SH "DESCRIPTION"
.IX Header "DESCRIPTION"
\&\fBxps\fR is sort of an X-windows front end to \f(CW\*(C`ps(1)\*(C'\fR, \f(CW\*(C`kill(1)\*(C'\fR, and
\&\f(CW\*(C`nice\*(C'\fR (and maybe \f(CW\*(C`uptime(1)\*(C'\fR too); perhaps an X-windows version of a
continually running \f(CW\*(C`pstree(1)\*(C'\fR with the intent of dynamically
showing in color what process are running or stopped, being spawned or
zombies. The \*(L"sort of\*(R" part in the first sentence of this section is
that for efficiency, \f(CW\*(C`ps\*(C'\fR is not in fact called in generating the
tree display. And for that matter, neither are the command line
versions of \f(CW\*(C`kill(1)\*(C'\fR, or \f(CW\*(C`nice(1)\*(C'\fR.
.PP
The main part of the display show processes as a tree or forest, the
roots of the tree are on the left-hand side and the leaf processes
(with no children) are on the right-hand side.  Which processes shown
is determined various settings. Once can select viewing all processes,
or processes owned by specific users, and possibly kernel processes as
well.
.PP
Process status (running, sleeping, stopped, etc.) of shown processes
is indicated by a color.
.PP
Within each level, processes are grouped so that those with the same
parent process id are grouped together. Within this, processes are
arranged by userid with lower number uid's appearing towards the top.
.PP
This means root processes always appear at the extreme top,
assuming the processes' parent was also a root process.  Finally, among
processes that have a common parent (or no parent) and belong to the
same userid, those with lower process numbers appear towards the
top. In general, the order of children is the order in which they
were spawned, with the older processes appearing towards towards the
top.
.PP
In contrast to \f(CW\*(C`pstree\*(C'\fR and many tree-widget based programs, the
overall tree display uses diagonal lines, and some effort is made to
effectively use the full 2\-dimensional area of the screen by balancing
levels and centering the children of a node between their parent.  But
since a goal of the program is to visually give a picture of
what's going on, when possible processes are kept close to their
parents so one needn't scroll around too much and so that doesn't
there isn't a lot of redrawing as processes are created or destroyed.
.PP
One can click on a process to get more information (via \f(CW\*(C`ps\*(C'\fR) about
that process, send a signal to the process, or set its priority
(assuming you have the permission to do so).
.PP
The majority of processes in a system, one hopes, are sleeping
processes.  The color to be selected for uid's of sleeping process can
be specified in the the X RESOURCES entry elsewhere in this document section. If however a color is not
specified, one is chosen at random. Generally, all processes belonging
to a given user will be a unique color. For certain terminal programs like
\&\f(CW\*(C`xterm\*(C'\fR or \f(CW\*(C`telnet\*(C'\fR, the name if the user is displayed rather than
the program name.
.PP
When the program starts there are basically two windows. A \*(L"normal\*(R"
window and a \*(L"zoomed\*(R" window. Each has a certain state that can 
be set independently.
.Sh "Options"
.IX Subsection "Options"
As the Perl motto goes \*(L"There's more than one way to do it,\*(R" and
that's true here as well.  All of the following options can be set via
the X RESOURCES entry elsewhere in this document, and many values can be toggled in the course of the
execution of the program through the MENUS, DIALOGS, AND BUTTONS entry elsewhere in this document.
.PP
But setting \*(L"help\*(R" or the \*(L"version\*(R" as a resource does not make much
sense as these are typically not done in the normal course of things,
so a couple things are unique to this section.
.PP
Options can be abbreviated to the extent that they are unique. 
So \f(CW\*(C`\-help\*(C'\fR can be abbreviated as short as \f(CW\*(C`\-h\*(C'\fR.
.Ip "\-help" 4
.IX Item "-help"
Print a usage message on standard error and exit with a return code
of 100.
.Ip "\-version" 4
.IX Item "-version"
Print on standard output the version release and various configuration
parameters that have been set for this program and then exit with a
return code of 2.
.Ip "\-interval \fIsecs\fR" 4
.IX Item "-interval secs"
Set the interval in seconds that \fBxps\fR should wait between status
updates.  Obviously this must be an integer greater than 0; it
also has to be less than 64 a number which is compiled into the program.
This value can also set more statically in X using the
\&\f(CW\*(C`interval\*(C'\fR resource, and can be changed via the the Refresh Rate Dialog entry elsewhere in this document.
.Ip "\-metoo" 4
.IX Item "-metoo"
Normally we lie about the state of \fBxps\fR and pretend it is 
sleeping when in fact it's generally running at the time it
is gathering statistics. \fIThis option is not fully functional.\fR
.Ip "\-kernel" 4
.IX Item "-kernel"
Show kernel processes. This may or may not be implemented or even make
sense depending on your architecture.  This value can also set more
statically in X using the \f(CW\*(C`kernel\*(C'\fR resource.
.Ip "\-allprocs" 4
.IX Item "-allprocs"
Show all processes rather than just those that belong to a single
userid.  This value can also set more statically in X using the
\&\f(CW\*(C`allprocs\*(C'\fR resource, and can be changed at runtime through
the \f(CW\*(C`Kernel\*(C'\fR radio buttons.
.Ip "\-beep" 4
.IX Item "-beep"
Beep when the the number of processes change.  This value can also set
more statically in X using the \f(CW\*(C`beep\*(C'\fR resource, and can be
changed at runtime through a \f(CW\*(C`Beep\*(C'\fR toggle button.
.Ip "\-kill" 4
.IX Item "-kill"
Sets the \f(CW\*(C`QuickKill\*(C'\fR button initially on. This value can also set
more statically in X using the \f(CW\*(C`quickkill\*(C'\fR resource.
.Ip "\-zoomed" 4
.IX Item "-zoomed"
Display using a (presumably larger) window rather than the normal
one. This value can also set more statically in X using the \f(CW\*(C`zoom\*(C'\fR
resource, and can be changed at runtime through the \f(CW\*(C`Zoom\*(C'\fR toggle
button.
.Ip "\-stopped \fIcolor\fR" 4
.IX Item "-stopped color"
Set the color for stopped processes. This value can also set more
statically in X using the \f(CW\*(C`stopped\*(C'\fR resource.
.Ip "\-idle \fIcolor\fR" 4
.IX Item "-idle color"
Set the color for idle processes. This value can also set more
statically in X using the \f(CW\*(C`idle\*(C'\fR resource.
.Ip "\-running color" 4
.IX Item "-running color"
Set the color for running processes. This value can also set more
statically in X using the \f(CW\*(C`running\*(C'\fR resource.
.Ip "\-zombie color" 4
.IX Item "-zombie color"
Set the color for zombie processes. This value can also set more
statically in X using the \f(CW\*(C`zombie\*(C'\fR resource.
.Ip "\-selected color" 4
.IX Item "-selected color"
Set the color for the selected process. This value can also set more
statically in X using the \f(CW\*(C`selected\*(C'\fR resource.
.Ip "\-pscmdline \fIps command\fR" 4
.IX Item "-pscmdline ps command"
\&\f(CW\*(C`ps\*(C'\fR command which can be run to give information about a process.
This value can also set more statically in X using the \f(CW\*(C`pscmdline\*(C'\fR
resource. See that section for more information.
.Ip "\-pscmdinfo \fIps command\fR" 4
.IX Item "-pscmdinfo ps command"
\&\f(CW\*(C`ps\*(C'\fR command which can be run to give information about a process.
This value can also set more statically in X using the \f(CW\*(C`pscmdinfo\*(C'\fR
resource. See that section for more information.
.Ip "\fIX-options\fR" 4
.IX Item "X-options"
In addition the standard set of X-Window options are allowed.  For
example things like the window geometry (\f(CW\*(C`\-geometry\*(C'\fR), the window
name (\f(CW\*(C`\-name\*(C'\fR), the foreground and background colors (\f(CW\*(C`\-fg\*(C'\fR,
\&\f(CW\*(C`\-bg\*(C'\fR), the font used (\f(CW\*(C`\-fn\*(C'\fR), whether the window starts out
iconified (\f(CW\*(C`\-iconic\*(C'\fR) and so on.
.SH "MENUS, DIALOGS, AND BUTTONS"
.IX Header "MENUS, DIALOGS, AND BUTTONS"
The main window is divided into three sections:
.Ip "a menu bar" 4
.IX Item "a menu bar"
The menu bar contains a menu selection and various toggle buttons.
.Ip "a process tree display area in the middle" 4
.IX Item "a process tree display area in the middle"
This is the meat of the program.
.Ip "some overall status information." 4
.IX Item "some overall status information."
This contains load average information, how many and a count of the 
number of processes shown. And on another line the version number
and refresh rate.
.PP
Each of the pop up menus has its own context-specific help.
.Sh "Toggle Buttons"
.IX Subsection "Toggle Buttons"
Options \f(CW\*(C`\-allprocs\*(C'\fR, \f(CW\*(C`\-kernel\*(C'\fR, \f(CW\*(C`\-beep\*(C'\fR, and \f(CW\*(C`\-zoomed\*(C'\fR mentioned
above in the Options manpage, set the initial state for various display
parameters.  In addition, there are buttons which allow toggling
between the two states. When a button is depressed (or looks
depressed), the feature described below is \*(L"on.\*(R"
.Ip "Beep" 4
.IX Item "Beep"
The program can arrange to beep when the number of processes grows or
diminishes. The utility of such a feature, I'm not certain of.
Perhaps the night watchman uses to find out when someone's telnet'd
into one his server, or logged out. The keyboard-translation
equivalent of this is \f(CW\*(C`togglebeep()\*(C'\fR. 
.Sp
The tune to play can be set by resources \f(CW\*(C`beepup\*(C'\fR and \f(CW\*(C`beepdown\*(C'\fR.
.Ip "QuickKill" 4
.IX Item "QuickKill"
The program can be arrange to point-and-kill processes. This 
button is like the safety latch on the trigger. Also, the
default behavior is to allow only the right mouse button in 
this endeavor. (I am left-handed.)
.Sp
Depending on the shifting activity of processes, you might have to be
quick though to get the right one!
.Sp
The default behavior is to be nice to the process and send it a
\&\f(CW\*(C`TERM\*(C'\fR signal. However serial killers and die-hard sysadmins can
arrange for the default signal to be \f(CW\*(C`KILL\*(C'\fR (\-9) or another signal
using the the Set Quick Kill Signal Dialog entry elsewhere in this document. 
.Sp
Having QuickKill button depressed will also cause the default signal
in the process popup window to be set to that value.
.Ip "Kernel/All/User" 4
.IX Item "Kernel/All/User"
The program can show all processes, all processes including kernel 
processes or those associated with a particular userid or pattern. 
Buttons may vary depending on the capabilities of your system.
The keyboard-translation functions which roughly correspond are
\&\f(CW\*(C`toggleprocs()\*(C'\fR and \f(CW\*(C`togglekernel()\*(C'\fR. 
.Sp
Only push button in this group can be selected at any given time.
.Ip "Zoom" 4
.IX Item "Zoom"
The program maintains two windows, a \*(L"zoomed\*(R" or maximized window and
a normal one. The geometry, text font, and scrollable canvas window
can all be set independently for the zoomed and normal windows.  The
keyboard-translation equivalent of this is \f(CW\*(C`zoom()\*(C'\fR. 
.PP
There is probably room for much much much more improvement here. I'm
not a guiologist. Some of the \*(L"features\*(R" are inherited that I didn't
have the heart to remove, although I rarely use them: the beep and
zoom \*(L"features\*(R" in particular. And the \s-1GUI\s0 that has been added is
pretty bare bones. For example perhaps a \*(L"combo box\*(R" (combination text
entry and slider) for setting the refresh interval might be more to
folks liking. The debugging options could be a bunch of
push buttons in a menu rather than entering as a number.
.Sh "Process Dialog Box"
.IX Subsection "Process Dialog Box"
When a process name is selected on the process-tree canvas, a dialog
box for that process pops up if it is not already open. If it is already
open and a different process is selected underneath, the process 
information changes. In order to show the which process is selected
on process-tree canvas, the process name changes color to the color
specified by the \f(CW\*(C`selected\*(C'\fR resource.
.PP
The Process Dialog Box lists information about the process. Also it
can be used to set the priority of the process or process group and
can be used to send a signal to the process or process group.
.PP
The top part of the dialog box gives information gathered from \f(CW\*(C`ps\*(C'\fR
command. Since a command invocation may be rather long, this is listed
on a separate line.
.PP
Below that to the left side is scrollable list of signals which can be
sent to the process. This list is automatically generated when the
program was compiled via the program \f(CW\*(C`makesig.pl\*(C'\fR. The list of
signals is in sorted order, but the most common signals are listed at
the top according to my preference. If the \f(CW\*(C`Quick Kill\*(C'\fR toggle button
had been depressed, the signal selected in the the Set Quick Kill Signal Dialog entry elsewhere in this document
is selected. Otherwise \*(L"\s-1NO\s0 \s-1ACTION\s0\*(R" will be selected and you
will have to select a signal if you want to send a signal to a
process.
.PP
To the right of the scrollable list of signals is a slider which can
be used to set the process priority. The initial value is the value at
the time for that process at the time the process was selected.
.PP
There is a notion in Unix called a \fIprocess group\fR which is 
a group of processes that are usually related in some way; perhaps
they were spawned from a common parent. Instead of sending a kill
signal to a specific process, the signal can be sent to the set process
of processes in the process group. Likewise instead of setting the
priority for a single process it can be set for the process group.
The process group toggle button in the process dialog 
is used to indicate that a signal or priority should be applied to the
process group rather than the process that is selected.
.PP
Note that in order for a kill signal or a change in priority to
take effect, you may need sufficient permission to do so. This is no
different than say if you were to run \f(CW\*(C`kill(1)\*(C'\fR or \f(CW\*(C`nice(1)\*(C'\fR from a
shell.
.PP
If there is a problem performing the action requested (and the program
catches you), the old value is kept.
.Sh "Set Quick Kill Signal Dialog"
.IX Subsection "Set Quick Kill Signal Dialog"
In the top line is a \f(CW\*(C`Quick Kill\*(C'\fR toggle button for those of you who
like to massacre processes.
.PP
In order for point-and-kill to work, one has to arrange in advance
what signal will be sent; that is what this menu is for. 
.PP
In contrast to the signal menu found in the the Process Dialog Box entry elsewhere in this document,
there is no \f(CW\*(C`NO ACTION\*(C'\fR signal. Also, this menu remembers the 
signal last used and has this selected in the menu list.
.Sh "Refresh Rate Dialog"
.IX Subsection "Refresh Rate Dialog"
The Set Refresh Rate Menu is used to set how frequently this program
should retrieve process information. The units displayed are in seconds.
.PP
Changing the refresh rate does not have an immediate effect, but
takes effect the next time the polling occurs.
.PP
No matter what the refresh rate interval is set to, the display is updated
only when it is visible\*(--this program can consume lots of \s-1CPU\s0 time.
.Sh "Set ps command Dialog Box"
.IX Subsection "Set ps command Dialog Box"
In the top part of the process popup window, process information is
shown by running a \*(L"ps\*(R"\-like program. What command to invoke is
determined initially by the value associated with the \f(CW\*(C`\-pscmdline\*(C'\fR
option or the pscmdline X resource if it is not set as a command
option, or if neither of these are set then by a platform-specific
\&\f(CW\*(C`ps\*(C'\fR command string set when this xps was configured and compiled.
.PP
Well, this is not the whole truth. Having written all of the above,
you can dynamically change this here as the program is running!
Should you want different information or in a different format, here
is where you can customize.
.PP
The \*(L"ps\*(R"\-like command string should have \f(CW\*(C`%d\*(C'\fR or \f(CW\*(C`%ld\*(C'\fR as a
placeholder for the process id or \*(L"pid\*(R".  Chances are that the command
string will want to refer to the process id somewhere.  The process id
of the selected process will be substituted for the first occurrence of
\&\f(CW\*(C`%d\*(C'\fR or \f(CW\*(C`%ld\*(C'\fR (if any) found. After substitution, the command string
is executed and the output, which might be several lines, will be put
in the scrolled window.
.PP
Example (for Linux):
.PP
.Vb 1
\& /bin/ps w %d
.Ve
If you have \f(CW\*(C`lsof\*(C'\fR installed, another interesting possibility
is:
.PP
.Vb 1
\& lsof -p %d
.Ve
.Sh "Set Watch User Dialog Box"
.IX Subsection "Set Watch User Dialog Box"
When the \f(CW\*(C`All\*(C'\fR radio button is depressed, the program generally shows
all processes.  It is possible that on some systems the program has
not been compiled in a way to show processes other than the ones you
own.  On some systems there is a \f(CW\*(C`Kernel\*(C'\fR button as well and this
shows all processes as well as additional kernel processes.
.PP
When the \f(CW\*(C`User\*(C'\fR radio button is depressed, the program shows only
some portion of all the processes, initially the processes associated
with the userid that invokes the program. However you can change that
with the \*(L"Set Watch User\*(R" dialog box. 
.PP
On systems that have a regular-expression library and where the
program has been compiled to support patterns, there will be a
\&\*(L"pattern\*(R" toggle button which allows one to select a pattern for a
user name. See your system documentation for the regular-expression
syntax. Selection by pattern match may slow the program down a bit, so
it should be used with caution for complex patterns and systems with a
very large number of processes.
.PP
When pattern-match selection is not indicated, the user name only
changes if the newly-entered one is a name known on the system.  If
pattern-match selection the pattern changes if it is syntactically
correct. In case, if there is an error in entry the old value is kept
and method of matching (pattern-match or not) is kept.
.PP
It is possible to set the watch user for the zoomed and normal windows
separately. However if you want to change the view in both windows,
check the \*(L"Set both windows\*(R" box.
.Sh "Set User Color Dialog Box"
.IX Subsection "Set User Color Dialog Box"
The Set User Color Menu can be used to change the color associated
a given user in the process tree display. You enter a user name (not a uid)
and an X color name like \*(L"blue\*(R" or \*(L"#DA7\*(R".
.PP
Each user in the process tree is assigned a color, often a different
color. If a color assignment is not specified explicitly, the program will
generate a color based on a hash of the uid. Sometimes this is a
pleasing color; sometimes it is ghastly. This menu lets you assign the
color for a user interactively.
.PP
However internally, there is a table for a fixed number of associations
between users and colors. The default is 10 but this can be changed
when the program is built. If a color for the user had previously been
set it that color will be overwritten. If the user not in the internal
table yet, the program looks for a free spot and inserts the user in
the table. If however the table is full, a reserved spare slot is
used. After the table is full, each time a new user color is assigned
the last \*(L"spare\*(R" slot is overwritten with the new user and color.
.PP
If you are going to be using the program over and over again on a
system where the user's don't change that frequently, or at least the
important ones that you want to track, you may want to consider
setting the user color via the the X RESOURCES entry elsewhere in this document \f(CW\*(C`uid1\*(C'\fR and
\&\f(CW\*(C`usercolor1\*(C'\fR. The default resource file sets the color for root which
has uid 0 to be black.
.Sh "Debugging Menu"
.IX Subsection "Debugging Menu"
If you should be so unfortunate as to want to debug this program, you
can set this integer value and output should appear on stdout.  So if
you set debugging you should have some way to see stdout of this
program. For example running this command from a window menu is
probably a lose.
.PP
The debug value is interpreted as a bitstring the individual bits
determine what's displayed. The bit values are:
   1  for callbacks and events handling
   2  for display debug messages 
   4  for menu-oriented messages
   8  for the virtual position in the tree-level 
  16  for tree sorting debugging messages 
.PP
Anybody wanna turn this menu into a nice check-box menu? 
.SH "X RESOURCES"
.IX Header "X RESOURCES"
See also \fIXps.ad\fR for a complete example of a full X resources file
for this program.  There are numerous comments in that file too that
mimic what is in here. (I hope the two are consistent and complete!)
.Ip "interval" 4
.IX Item "interval"
Resource associated with the \f(CW\*(C`\-interval\*(C'\fR option, an integer value
greater than 0. 
.Sp
Example:
.Sp
.Vb 1
\&  *interval: 2
.Ve
This value can be changed while running via a pop-up menu.
See the Refresh Rate Dialog entry elsewhere in this document.
.Ip "kernel" 4
.IX Item "kernel"
Resource associated with the \f(CW\*(C`\-kernel\*(C'\fR option. This option may
be machine specific. A Boolean value. When set true kernel
processes are shown, if your platform has and supports this.
.Sp
Example:
.Sp
.Vb 1
\&  *kernel: False
.Ve
.Ip "allprocs" 4
.IX Item "allprocs"
Resource associated with the \f(CW\*(C`\-allprocs\*(C'\fR option, a Boolean value.
This value can be changed while running via a toggle button, 
and selects whether to show all processes or some subset of them.
.Sp
Example:
.Sp
.Vb 1
\&  *allprocs: False
.Ve
.Ip "beep" 4
.IX Item "beep"
Resource associated with the \f(CW\*(C`\-beep\*(C'\fR option and \f(CW\*(C`Beep\*(C'\fR toggle
button, a Boolean value. See \f(CW\*(C`Beep\*(C'\fR for more information.
.Sp
Example:
.Sp
.Vb 1
\&  *beep:  False
.Ve
.Ip "beepup" 4
.IX Item "beepup"
The \*(L"tune\*(R" to place when the number of processes increases This
parameter should be a string.  The format is pitch (Hz), duration
(msec), ...
.Sp
Example:
.Sp
.Vb 1
\&  *beepup: "55 50 110 50 220 50 440 100"
.Ve
The above plays three A-pitches each an octave higher than the last,
ending in A440; each pitch is held for .05 seconds.
.Ip "beepdown" 4
.IX Item "beepdown"
Resource associated with the \f(CW\*(C`\-allprocs\*(C'\fR option.
.Sp
The \*(L"tune\*(R" to place when the number of processes increases This
parameter should be a string.  The format is pitch (Hz), duration
(msec), ...
.Sp
Example:
.Sp
.Vb 1
\&  *beepdown: "440 50 220 50 110 50 55 100"
.Ve
The above plays three A-pitches each an octave lower than the last, 
starting at A44; each pitch is held for .05 seconds.
.Ip "quickkill" 4
.IX Item "quickkill"
Resource associated with the \f(CW\*(C`\-kill\*(C'\fR option and \f(CW\*(C`QuickKill\*(C'\fR toggle
button, a Boolean value. See \f(CW\*(C`QuickKill\*(C'\fR for more information.
This value can be changed while running via the \f(CW\*(C`QuickKill\*(C'\fR toggle button.
.Sp
Example:
.Sp
.Vb 1
\&  *quickkill:  False
.Ve
.Ip "selected" 4
.IX Item "selected"
Resource associated with the \f(CW\*(C`\-selected\*(C'\fR option, an X color name or 
color value. The process name that is under consideration in
the the Process Dialog Box entry elsewhere in this document will have this color.
.Sp
Example:
.Sp
.Vb 1
\&  *selected: cyan
.Ve
.Ip "running" 4
.IX Item "running"
Resource associated with the \f(CW\*(C`\-running\*(C'\fR option, an X color name or
color value. Processes which are currently running will have this
color in the Process Tree Window. You probably won't see \fItoo\fR many
of these, unless your computer is \s-1CPU\s0 bound.
.Sp
Example:
.Sp
.Vb 1
\&  *running:  green
.Ve
.Ip "idle" 4
.IX Item "idle"
Resource associated with the \f(CW\*(C`\-idle\*(C'\fR option, an X color name or value.
.Sp
Example:
.Sp
.Vb 1
\&  *idle: orange
.Ve
.Ip "stopped" 4
.IX Item "stopped"
Resource associated with the \f(CW\*(C`\-stopped\*(C'\fR option, an X color name or value.
Processes whose process state is \*(L"stopped\*(R" (e.g. being debugged or
suspended), will have this color.
.Sp
Example:
.Sp
.Vb 1
\&  *stopped: red
.Ve
.Ip "zombie" 4
.IX Item "zombie"
Resource associated with the \f(CW\*(C`\-zombie\*(C'\fR option, an X color name or value.
Zombie processes will have this color.
.Sp
Example:
.Sp
.Vb 1
\&  *zombie: yellow
.Ve
.Ip "uid1 .. uid9, usercolor1 .. usercolor9" 4
.IX Item "uid1 .. uid9, usercolor1 .. usercolor9"
Sometimes you may want to select a particular color for a particular
userid.  The program allow you to do this for 10 uids. (The source can
be changed for more.)  You assign a color for a specific userid by
adding two lines in your resource file: one for the uid, and another
for the color that that uid should have.
.Sp
Example:
.Sp
.Vb 2
\&  *uid1:       0
\&  *usercolor1: black
.Ve
This ensures that root processes, (those with a 0 uid), 
are displayed in black.
.Sp
This value can be changed at run time via the a popup menu. See
the Set User Color Dialog Box entry elsewhere in this document. Note however that a user is specified via 
a \fIuid\fR, not a user name.
.Ip "pscmdinfo" 4
.IX Item "pscmdinfo"
Resource associated with the \f(CW\*(C`\-pscmdinfo\*(C'\fR option, a string.  When
the program was configured for your platform, a platform-specific
\&\f(CW\*(C`ps\*(C'\fR command is chosen to give lots of information about a
process. This command has \f(CW\*(C`%d\*(C'\fR or \f(CW\*(C`%ld\*(C'\fR as a placeholder for the
process id.  It is replaced by the process id of the selected process.
Should you want different information or in a different format, you
can customize here. 
.Sp
Example (for Solaris):
.Sp
.Vb 1
\&  *pscmdinfo:  "/bin/ps -f -o user,pid,ppid,tty,nice,pcpu -p %ld"
.Ve
.Ip "pscmdline" 4
.IX Item "pscmdline"
Resource associated with the \f(CW\*(C`\-pscmdline\*(C'\fR option, an string.  When
the program was configured for your platform, a platform-specific
\&\f(CW\*(C`ps\*(C'\fR command is chosen to show the command invocation for the
selected process. This command has \f(CW\*(C`%d\*(C'\fR or \f(CW\*(C`%ld\*(C'\fR as a placeholder
for the process id.  It is replaced by the process id of the selected
process.  Should you want different information or in a different
format, you can also customize here.
.Sp
Example (for \s-1BSDI\s0):
.Sp
.Vb 1
\&  *pscmdline:  "/bin/ps -w -w -o command -p %ld"
.Ve
or if you prefer not to have the leading header line listed:
.Sp
.Vb 1
\&  *pscmdline:  "/bin/ps -w -w -o command -p %ld | sed -n '2,$p'"
.Ve
This value can also be changed at run time via the a popup menu. See
the Set ps command Dialog Box entry elsewhere in this document.
.Sh "Default Key/Mouse Bindings"
.IX Subsection "Default Key/Mouse Bindings"
Below are the default key and mouse bindings. They can be
overridden via the X RESOURCES entry elsewhere in this document. See also \fIXps\fR installed
in your \fIapp-defaults\fR directory or \fIXps.ad\fR that comes 
with the distribution.
.PP
.Vb 10
\&   Key         Menu
\&   ------------------------------
\&   c           Set user color menu
\&   d           Debugging menu
\&   h           Help menu
\&   i           Refresh Interval menu
\&   k           Set kill signal
\&   u           User to watch menu
\&   v           Show version and configuration information
\&   w           Show No Warranty
.Ve
The below commands work everywhere except in 
text input menus:
.PP
.Vb 15
\&   Key(s)       function
\&   --------------------------------
\&   a, A         :  toggleprocs()
\&   b, B         :  togglebeep()
\&   -            :  changespeed(-1)
\&   f            :  changespeed(-1)
\&   F            :  changespeed(-5)
\&   Ctrl-k       :  togglekernel()
\&   K            :  togglekill()
\&   +            :  changespeed(1)
\&   s            :  changespeed(1)
\&   S            :  changespeed(5)
\&   r            :  redisplay()
\&   Ctrl-X       :  quit()
\&   z            :  zoom()
.Ve
The below commands work \fIonly\fR in the process-tree
display or canvas area.
.PP
.Vb 2
\&   space, return, mouse:  showprocess()
\&   right mouse         :  showprocess(K)
.Ve
See the X Keyboard Translations entry elsewhere in this document below for more information on functions
such as \f(CW\*(C`toggleprocs\*(C'\fR, \f(CW\*(C`showprocess\*(C'\fR.
.Sh "X Keyboard Translations"
.IX Subsection "X Keyboard Translations"
Listed below are the functions or actions that can be performed by binding
mouse or keyboard events to them.
.Ip "changespeed(num)" 4
.IX Item "changespeed(num)"
Decrease display refresh interval by num \*(L"ticks\*(R".  This can be
positive or negative. A \*(L"tick\*(R" is defined when compiling the program.
The value is of a tick can be shown by running this command with the
\&\f(CW\*(C`\-version\*(C'\fR option.
.Sp
The fastest and slowest value is set in configuring the program.  The
minimum and maximum values can be shown by running this command with
the \f(CW\*(C`\-version\*(C'\fR option.  
.Ip "\fIshowprocess()\fR" 4
.IX Item "showprocess()"
This pops up the process dialog menu over the selected process.  One
can also give a single parameter that starts with the letter 'K'. This
will kill the process over the cursor, provided \f(CW\*(C`QuickKill\*(C'\fR is
set. Otherwise, the same as \f(CW\*(C`showprocess()\*(C'\fR.
.Ip "\fIquit()\fR" 4
.IX Item "quit()"
Terminates this fine program.
.Ip "\fItogglebeep()\fR" 4
.IX Item "togglebeep()"
This is the same as hitting the \f(CW\*(C`Beep\*(C'\fR toggle button.
.Sp
One can also give a single parameter with a value of 0, 1, or 2;
0 means set the state off, 1 means set the state on, and 2 toggle
the state. So \f(CW\*(C`togglebeep()\*(C'\fR is the same as \f(CW\*(C`togglebeep(2)\*(C'\fR.
.Ip "\fItoggleprocs()\fR" 4
.IX Item "toggleprocs()"
This is the same as hitting the \f(CW\*(C`All\*(C'\fR radio button.
.Ip "\fItogglekernel()\fR" 4
.IX Item "togglekernel()"
This is the same as hitting the \f(CW\*(C`Kernel\*(C'\fR radio button assuming 
the \f(CW\*(C`All\*(C'\fR radio button had been depressed. If not, this has no
effect until the next \f(CW\*(C`toggleprocs\*(C'\fR is run. 
.Sp
One can also give a single parameter with a value of 0, 1, or 2;
0 means set the state off, 1 means set the state on, and 2 toggle
the state. So \f(CW\*(C`togglekernel()\*(C'\fR is the same as \f(CW\*(C`togglekernel(2)\*(C'\fR.
.Ip "\fIredisplay()\fR" 4
.IX Item "redisplay()"
This causes a redisplay of all information.
.Ip "\fIzoom()\fR" 4
.IX Item "zoom()"
This is the same as hitting the \f(CW\*(C`Zoom\*(C'\fR toggle button
.SH "LOW-LEVEL DETAILS"
.IX Header "LOW-LEVEL DETAILS"
The program lies about the state of \fBxps\fR itself since it
is always running at the time it checks.
.PP
The program can consume a bit of resources both in itself and in the X
server. Of course, the fewer processes that need to be tracked and the
slower the refresh interval, the less run time consumed. 
.PP
However some effort is made to not gather or redraw the display
when not shown. The program tries to track whether it is iconified or
if the process tree display window is fully obscured. If so, the
program will not try to obtain data or refresh its display.  But
unless I've coded the program properly, it's possible for the program
to think it is not visible when in fact it is.
.PP
As a further measure to reduce overhead, the program takes a sum of
all of the process \s-1ID\s0's, the sum of the process states and number of
nodes and will not update its process-tree display if these sums
haven't changed. But it is possible that the sum can be the same even
though things have changed.
.PP
There is a debug menu; if debug values are set, debugging output will
appear in standard output. Debugging values are a series of bits. 
Look in \fIcommon.h\fR of the source code for the values of the bits.
.SH "SEE ALSO"
.IX Header "SEE ALSO"
\&\fIps\fR\|(1), \fIpstree\fR\|(1), \fIkill\fR\|(1), \fInice\fR\|(1), \fIuptime\fR\|(1).
.PP
Another interesting package similar to this one is 
George MacDonald's (gmd@slip.net) program \f(CW\*(C`treeps\*(C'\fR. That can be obtained at
http://www.slip.net/~gmd/tps/treeps.htm.
.SH "BUGS"
.IX Header "BUGS"
At times, lines from a prodigious parent with a short label name (like
\&\f(CW\*(C`nfsd\*(C'\fR) will cross over a sibling with a longer name (like
\&\f(CW\*(C`rpc.mountd\*(C'\fR). I think the program still core dumps occasionally.
.PP
Some process tables are fixed in size, somewhere at around 1,000
processes. Perhaps some will consider this a bug, but the display
algorithm is not linear. As things grow the redisplay will slow down
the program will consume quite a bit of \s-1CPU\s0 time. The whole paradigm
of this program may not be suitable for displaying thousands of
processes.
.PP
Just about everything could be improved: configuration management,
tree layout, \s-1GUI\s0 design, toolkit used (via gtk+), algorithms, more 
platforms supported. See the file \fI\s-1TODO\s0\fR distributed with 
the source.
.PP
The way process selection is done may be hokey in that the names of the
processes aren't really widgets at all but strings drawn on a canvas
so when you click on a process, in fact the program is doing its own
range searching to figure out what node is meant at the mouse
position.  That is, there is no callback for the \*(L"widget\*(R" just the
overall canvas! That is why for example we can't, say, put a box
around the selected process but change very limited things like the
color (or the font) of the string.
.SH "AUTHORS"
.IX Header "AUTHORS"
The current version is maintained (or not) by rocky@panix.com.
However, this code reflects the work of a number of people.
.PP
Derek Lieber wrote the first version of the code for the now defunct
\&\s-1IBM\s0 \s-1RT/PC\s0. Although just about everything has been rewritten and
extended, many of the key ideas come from this:
showing a process tree from left to right, changing the color of the
process to show process activity, allowing a process to be selected on
the canvas and then renice'd or kill'ed.
.PP
Subsequently Steve James added the first Motif code, although nothing
in the way of command menus, dialog boxes, push buttons, or scroll
windows or signal menus.  Mark Kennedy extended the code to allow
users to customize the pop up list via an X resources file, and allow
a user-specified set of signals that could be sent to processes. (This
code is has been completely replaced although the signal-list data
structure still exists.)  John Prager added the code to list different
userids in different colors, sort by user within tree levels and beep
when the processes change.  Also he put more information in the popup
status and replaced some of the terminal shells (like \f(CW\*(C`aixterm\*(C'\fR) with
user names.
.PP
Rocky Bernstein added code to restrict the process tree to a single
selectable user process, added even more info in the popup about a
process (via \f(CW\*(C`ps\*(C'\fR), all the other dialogs, sorting by userid and
process \s-1ID\s0, the Motif scroll window canvas, toggle buttons, and this
initial manual page. He also ported to Solaris and Linux, wrote the
current tree-layout algorithm, and did major restructuring and
rewriting to separate the code into machine-dependent components in
separate directories. He revised to use \f(CW\*(C`autoconf\*(C'\fR and generate
machine-dependent signal lists.
.PP
Kazuki Sakamoto (sakamoto@cec.co.jp, sakamoto@netbsd.org)
ported to NetBSD. See also the file \fI\s-1THANKS\s0\fR for a more complete
list of contributors.
