/* $Id: acconfig.h,v 1.26 2001/03/25 12:09:42 rocky Exp $ 

    Copyright (C) 1999-2001 Rocky Bernstein

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

*/

#ifndef CONFIG_H
#define CONFIG_H

/* Define to the maximimum number of processes you'll allow this
   program to display. The program display algorithm is not linear,
   so as the number of actual processes displayed increases this program
   will slow down and take up more CPU resources. 
*/
#define XPS_MAX_PROCS 1024

/* Put here a userid that you know will not be used on your system. */
#define BOGUS_UID 9999

/* Put here a bogus process id system. Negative process id's dont'
   generally exist, however we still stay way from -1 since if something
   goes wrong this could mean the process group for 1 = init.
*/
#define BOGUS_PID -5

/* There is an internal table which associates userids to colors.
   These size of the table determines how many different userids can
   be assigned in the user color dialog. After this, the last userid
   assigned will be reused.
   
   Note however that no matter what the size of the table, the program
   assigns based on a hash of the userid for those userids not
   assigned in the table.  */

#define NUM_USER_COLORS 10

/* Define the largest value for the refresh rate that's allowed.
   There are implications in the code that need to be dealt with
   like sizes of integers, if you define above 64. 
   This number is multiplied by XPS_TICK to give a value in milliseconds.
*/
#define XPS_MAX_REFRESH_RATE 64

/* Define the smallest value for the refresh rate that's allowed.
   There are implications in the code that need to be dealt with
   if you define below 1. 
   This number is multiplied by XPS_TICK to give a value in milliseconds.
*/
#define XPS_MIN_REFRESH_RATE 1

/* Define the default refresh rate to use when no valid parameters 
   or X resources are specified. Needs to be a string
*/
#define XPS_DEFAULT_REFRESH_RATE "1"

/* The units of millisecond increments that XPS_MIN/MAX_REFRESH_RATE
   above represent. Be careful with this parameter as it can 
   affect CPU performance if too small. And you may have to change
   existing overflow tests too.
*/
#define XPS_TICK 1000

/* Normally, processes like xterm, ftp, or rlogin, list the user
   name, not the process name. If you don't like this behaviour,
   comment out the below.
*/
#define XPS_RECOLOR_LOGIN_PROCESSES 


/* What's the default signal to send when you *first* select "quick kill."
   See sigmap.h for the order of the list. 
   Generally 1 is HUP, and 2 is TERM, and 3 is KILL.
*/
#define XPS_DEFAULT_QUICK_KILL_SIGNAL 1


/*============================================================
  Warning! Stuff below here, configure may modify
 =============================================================*/

/* Define if you are running Solaris not before 2.6 and 
   want to try the non-setuid code.
*/
#undef SOLARIS_NEW_PROC

@TOP@

/* Defined if your OS, OS release and how we've coded the program
   need to have this program run as root. However if this is defined
   that doesn't mean it *will* installed suid as root. That's 
   decision is also subject to user discretion too.
*/
#undef NEED_SUID_ROOT

/* Define to empty if the const keyword does not work.  
   This keyword is typically used to make variables constant or read-only.
*/
#undef const

/* Define to empty if the inline keyword does not work.  
   This keyword is typically used to allow for subroutines to be 
   expanded in line.
*/
#undef inline

/* Define if the `getloadavg' function needs to be run setuid or setgid.  */
#undef GETLOADAVG_PRIVILEGED

/* Define if your system has its own `getloadavg' function.  */
#undef HAVE_GETLOADAVG

/* Define if you have the strerror function.  
   This is used 
*/
#undef HAVE_STRERROR

/* Define if you have the kstat library (-lkstat).  
   This is used on Solaris to get load average information.
*/
#undef HAVE_LIBKSTAT

/* Define if you have the <stdlib.h> header file.  */
#undef HAVE_STDLIB_H

/* Define if you have the <string.h> header file.  */
#undef HAVE_STRING_H

/* Define if you have the <unistd.h> header file.  */
#undef HAVE_UNISTD_H

/* Define if you have the <sys/resource.h> header file.  */
#undef HAVE_SYS_RESOURCE_H

/* Define if you have the <pwd.h> header file.  */
#undef HAVE_PWD_H

/* Define if you have the <signal.h> header file.  */
#undef HAVE_SIGNAL_H

/* Define if you have the <regex.h> header file.  */
#undef HAVE_REGEX_H

/* Define if you have the <usersec.h> header file.  */
#undef HAVE_USERSEC_H

/* Define if you have the <X11/Xmu/Editres.h> header file.  */
#undef HAVE_X11_XMU_EDITRES_H

/* Define if you have the XEditResCheckMessages() to be able to 
   use the X editres program to view/set Widgets/Resourses in this program. 
*/
#undef HAVE_XEDITRESCHECKMESSAGES

#if defined(HAVE_XEDITRESCHECKMESSAGES) && defined(HAVE_X11_XMU_EDITRES_H)
#define DO_XEDITRESCHECKMESSAGES 1
#endif

/* Define if you have the <linux/tasks.h> header file.  */
#undef HAVE_LINUX_TASKS_H

/* Define if you have the getpriority() to get a processes' priority.  */
#undef HAVE_GETPRIORITY

/* Define if you have the setpriority() to set a processes' priority.  */
#undef HAVE_SETPRIORITY

/* Define if you have the kill() to send a signal to a process.  
   This allows the program to kill a process in the process popup 
   menu.
*/
#undef HAVE_KILL

/* Define if you have IDtouser() file.  
   This is used to convert a uid to a named. getpwuid() extracting
   the pw_name field does the same thing.
*/
#undef HAVE_IDTOUSER

/* Define if you need __STDC__ defined to 0 in order to get certain
   #includes to compile compile correctly. In particular Solaris 2.6
   with older gcc or egcs. 
*/
#undef NEED_STDC_DEFINE

#if defined(NEED_SUID_ROOT) && !defined(SOLARIS_NEW_PROC)
#define RUN_SUID_ROOT 1
#endif

/* Change if you have POSIX regular expression support.
   These are regcomp(), regerror(), and regexec found in 
   header <regex.h>.  This allows selection of processes shown
   n the process-display tree by regular expression. 
*/
#undef HAVE_REGCOMP
#undef HAVE_REGEXEC
#undef HAVE_REGERROR

#if defined(HAVE_REGCOMP) && defined(HAVE_REGEXEC)
#define HAVE_REGEX 1
#endif

@BOTTOM@

#endif /*CONFIG_H*/
