/* $Id: xprobe.c,v 1.9 2001/07/25 02:15:38 fygrave Exp $ */
/*
** Copyright (C) 2001 Fyodor Yarochkin <fygrave@tigerteam.net>,
**                    Ofir Arkin       <ofir@sys-security.com>
**
** This program is free software; you can redistribute it and/or modify
** it under the terms of the GNU General Public License as published by
** the Free Software Foundation; either version 2 of the License, or
** (at your option) any later version.
**
** All material for nonprofit, educational use only.
**
** This program is distributed in the hope that it will be useful,
** but WITHOUT ANY WARRANTY; without even the implied warranty of
** MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
** GNU General Public License for more details.
**
** You should have received a copy of the GNU General Public License
** along with this program; if not, write to the Free Software
** Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
*/

#include "xprobe.h"

TIMEZONE_T tz;

/* global flags */
char verbose = 0;
unsigned short udp_portno = 0;

int main(int argc, char **argv) {
    hstnet_t targnet;
    int c;
    char *iname = NULL;


    fprintf(stderr,"%s\n",BANNER);

    while((c = getopt(argc, argv, "vi:p:h")) !=EOF) 
        switch(c) {
            case 'v':
                verbose++;
                break;
            case 'i':
                iname = optarg; 
                break;
            case 'p':
                udp_portno = (unsigned short)atoi(optarg);
                if (!udp_portno) {
                    fprintf(stderr,"Incorrect port number %s!\n", optarg);
                    usage(argv[0]);
                }
                break;
            case 'h':
            default:
                usage(argv[0]);
        }
    
    if (argc < optind + 1)
        usage(argv[0]);

    if (parse_hostname(argv[optind],&targnet)<0) {
        fprintf(stderr,"error while parsing/resolving: %s\n",
            argv[optind]);
        exit(1);
    }

    if(init_pcap(iname, argv[optind], &targnet) < 0) {
        fprintf(stderr,"Failed to initialize lipcap!\n");
        exit(1);
    }

    srand(time(NULL)); /* let us look random abit */
    do_scan(&targnet);
    
return 0;
}

void usage(char *name) {
    fprintf(stderr,"usage: %s [-p portnum] [-i interface] [-v]"
    " host[/netmask]\n", name);
    exit(1);
}

void do_scan(hstnet_t *targ) {
    struct sockaddr_in to;
    unsigned long targhost;

    to.sin_family = AF_INET;
    bcopy((void *)&targ->addr,(void *)&to.sin_addr,
           sizeof(struct in_addr));
    log_message("Target: %s", inet_ntoa(to.sin_addr));
    bcopy((void *)&targ->netmask,(void *)&to.sin_addr,
           sizeof(struct in_addr));
    log_message("Netmask: %s", inet_ntoa(to.sin_addr));

    targhost = ntohl(targ->addr);
    do {
        scan_host(htonl(targhost));
    } while(htonl(targhost++) != (targ->addr|
                                (targ->netmask^0xffffffff)));
}

int scan_host(unsigned long host) {
    struct sockaddr_in to;

    to.sin_family = AF_INET;
    bcopy((void *)&host,(void *)&to.sin_addr,
           sizeof(struct in_addr));
    log_message("probing: %s", inet_ntoa(to.sin_addr));
    return(do_logic(to));
}
 
