/* $Id: udp_probe.c,v 1.6 2001/07/19 13:00:27 fygrave Exp $ */
/*
** Copyright (C) 2001 Fyodor Yarochkin <fygrave@tigerteam.net>,
**                    Ofir Arkin       <ofir@sys-security.com>
**
** This program is free software; you can redistribute it and/or modify
** it under the terms of the GNU General Public License as published by
** the Free Software Foundation; either version 2 of the License, or
** (at your option) any later version.
**
** All material for nonprofit, educational use only.
**
** This program is distributed in the hope that it will be useful,
** but WITHOUT ANY WARRANTY; without even the implied warranty of
** MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
** GNU General Public License for more details.
**
** You should have received a copy of the GNU General Public License
** along with this program; if not, write to the Free Software
** Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
*/


#include "xprobe.h"

/*
 packet validation correctness is done within the query sending routine.
 NULL is returned if packet is not valid
 caller has to free() retval->pkt and retval when done (otherwise memory
 leak will occur).
 */


rpack_t *send_udp(struct sockaddr_in to) {

    int sndsock;
    int res;
    int port;
    struct ip *ip;
    struct udphdr *udp;
    unsigned char *pack, *recv_pack;
    int on = 1;
    int packlen;
    rpack_t *retval = NULL;
    

    if ((port = udp_find_closed(to)) < 0) {
        fprintf(stderr, "failed to find any closed UDP port.\n");
        exit(1);
    }

    if ((sndsock = socket(AF_INET, SOCK_RAW, IPPROTO_RAW)) < 0) { 
        perror("Can not open raw socket:");
        exit(1);
    }
    
    if (setsockopt(sndsock, IPPROTO_IP, IP_HDRINCL, (char *)&on,
                   sizeof(on)) < 0) {
        perror("IP_HDRINCL");
        exit(1);
    }

    packlen = sizeof(struct ip) + sizeof(struct udphdr) + UDP_DATA_SIZE;

    if((pack = (unsigned char *)calloc( packlen, 1)) == NULL) {
        perror("calloc");
        exit(1);
    }

    ip = (struct ip *)pack;
    udp = (struct udphdr *)(pack + sizeof(struct ip));
    make_ippkt(ip, IPPROTO_UDP, interf.addr, to.sin_addr,
                packlen, IP_DF, 0);
    
    udp->uh_sport = htons(rand());
    udp->uh_dport = htons(port);
    udp->uh_ulen   = htons((unsigned short) packlen - sizeof(struct ip));
    udp->uh_sum    = udp_cksum_calc(ip, udp, sizeof(struct udphdr) +
                    UDP_DATA_SIZE);
    
    fprintf(stderr,"TEST: UDP to %s:%i ", inet_ntoa(to.sin_addr)
                                        , port);
    
   res = sendto(sndsock, (void *)pack, packlen,
                0, (struct sockaddr *)&to, sizeof(struct sockaddr));

   if (res <0) {
       perror("sendto:");
       close(sndsock);
       free(pack);
       return NULL;
   }
   fprintf(stderr,"[%d bytes] sent, waiting for reponse.\n", res);

   recv_pack = read_icmp(&res, ICMP_UNREACH, -1);

   if (recv_pack == NULL || res < sizeof(ip) + 8) {
       fprintf(stderr,"Receive timeout. Quitting..\n");
       close(sndsock);
       free(pack);
       return NULL;
   }


  if ((retval=calloc(sizeof(rpack_t), 1)) == NULL) {
       perror("calloc");
       exit(1);
   }

   retval->packsize = res;

   if((retval->pkt = calloc(res, 1)) == NULL) {
       perror("calloc");
       exit(1);
   }
   memcpy((void *)retval->pkt, (void *)recv_pack, res);

   
#ifdef DEBUG
   fprintf(stderr,"Received %d bytes packet.\n", res);
   hexdump(recv_pack, res);
   fprintf(stderr,"\n----\n");
   hexdump(retval->pkt, res);
#endif    
 
   retval->ip = (struct ip *)retval->pkt;
 /* sanity checks */

#ifdef DEBUG
    fprintf(stderr, "hlen: %d\nlen: %d\n", retval->ip->ip_hl<<2, htons(retval->ip->ip_len));
#endif    
    
   if (res < sizeof(struct ip)      ||
       (retval->ip->ip_hl << 2) > res ||
       ntohs(retval->ip->ip_len) > res ) {
       fprintf(stderr,"Received maliformed packet!\n");
       close(sndsock);
       free(pack);
       free(retval->pkt);
       free(retval);
       return NULL;
   }

   retval->icmp = (struct icmp *)(retval->pkt + (retval->ip->ip_hl<<2));

#ifdef DEBUG
   fprintf(stderr,"type: %d code: %d\n", retval->icmp->icmp_type, retval->icmp->icmp_code);
#endif   
          
   retval->orig_pkt = pack;
   retval->orig_ip = (struct ip *)pack;
   close(sndsock);
   return retval;
}


int udp_find_closed(struct sockaddr_in to) {


    if (udp_portno) return udp_portno;
    return UDP_PORT; /* lets stick with defines for the moment */

}

