//========================================================================
//
// XRef.h
//
// Copyright 1996 Derek B. Noonburg
//
//========================================================================

#ifndef XREF_H
#define XREF_H

#ifdef __GNUC__
#pragma interface
#endif

#include "gtypes.h"
#include "Object.h"

class Dict;
class Stream;

//------------------------------------------------------------------------
// XRef
//------------------------------------------------------------------------

struct XRefEntry {
  int offset;
  int gen;
  GBool used;
};

class XRef {
public:

  // Constructor.  Read xref table from stream.
  XRef(BaseStream *str, GString *userPassword);

  // Destructor.
  ~XRef();

  // Is xref table valid?
  GBool isOk() { return ok; }

  // Is the file encrypted?
#ifndef NO_DECRYPTION
  GBool isEncrypted() { return encrypted; }
#else
  GBool isEncrypted() { return gFalse; }
#endif

  // Check various permissions.
  GBool okToPrint();
  GBool okToChange();
  GBool okToCopy();
  GBool okToAddNotes();

  // Get catalog object.
  Object *getCatalog(Object *obj) { return fetch(rootNum, rootGen, obj); }

  // Fetch an indirect reference.
  Object *fetch(int num, int gen, Object *obj);

  // Return the document's Info dictionary (if any).
  Object *getDocInfo(Object *obj);

  // Return the number of objects in the xref table.
  int getNumObjects() { return size; }

  // Return the offset of the last xref table.
  int getLastXRefPos() { return lastXRefPos; }

  // Return the catalog object reference.
  int getRootNum() { return rootNum; }
  int getRootGen() { return rootGen; }

private:

  BaseStream *str;		// input stream
  int start;			// offset in file (to allow for garbage
				//   at beginning of file)
  XRefEntry *entries;		// xref entries
  int size;			// size of <entries> array
  int rootNum, rootGen;		// catalog dict
  GBool ok;			// true if xref table is valid
  Object trailerDict;		// trailer dictionary
  int lastXRefPos;		// offset of last xref table
#ifndef NO_DECRYPTION
  GBool encrypted;		// true if file is encrypted
  int permFlags;		// permission bits
  Guchar fileKey[16];		// file decryption key
#endif

  int readTrailer();
  GBool readXRef(int *pos);
  GBool constructXRef();
  GBool checkEncrypted(GString *userPassword);
};

//------------------------------------------------------------------------
// The global xref table
//------------------------------------------------------------------------

extern XRef *xref;

#endif
