/*
 * Copyright (c) 2001-2007 International Computer Science Institute
 * See LICENSE file for licensing, conditions, and warranties on use.
 *
 * DO NOT EDIT THIS FILE - IT IS PROGRAMMATICALLY GENERATED
 *
 * Generated by 'tgt-gen'.
 */

#ident "$XORP: xorp/xrl/targets/ospfv2_base.cc,v 1.27 2007/02/16 22:47:52 pavlin Exp $"


#include "ospfv2_base.hh"


XrlOspfv2TargetBase::XrlOspfv2TargetBase(XrlCmdMap* cmds)
    : _cmds(cmds)
{
    if (_cmds)
	add_handlers();
}

XrlOspfv2TargetBase::~XrlOspfv2TargetBase()
{
    if (_cmds)
	remove_handlers();
}

bool
XrlOspfv2TargetBase::set_command_map(XrlCmdMap* cmds)
{
    if (_cmds == 0 && cmds) {
        _cmds = cmds;
        add_handlers();
        return true;
    }
    if (_cmds && cmds == 0) {
	remove_handlers();
        _cmds = cmds;
        return true;
    }
    return false;
}

const XrlCmdError
XrlOspfv2TargetBase::handle_common_0_1_get_target_name(const XrlArgs& xa_inputs, XrlArgs* pxa_outputs)
{
    if (xa_inputs.size() != 0) {
	XLOG_ERROR("Wrong number of arguments (%u != %u) handling %s",
            XORP_UINT_CAST(0), XORP_UINT_CAST(xa_inputs.size()), "common/0.1/get_target_name");
	return XrlCmdError::BAD_ARGS();
    }

    if (pxa_outputs == 0) {
	XLOG_FATAL("Return list empty");
	return XrlCmdError::BAD_ARGS();
    }

    /* Return value declarations */
    string name;
    try {
	XrlCmdError e = common_0_1_get_target_name(
	    name);
	if (e != XrlCmdError::OKAY()) {
	    XLOG_WARNING("Handling method for %s failed: %s",
            		 "common/0.1/get_target_name", e.str().c_str());
	    return e;
        }
    } catch (const XrlArgs::XrlAtomNotFound& e) {
	XLOG_ERROR("Argument not found");
	return XrlCmdError::BAD_ARGS();
    }

    /* Marshall return values */
    try {
	pxa_outputs->add("name", name);
    } catch (const XrlArgs::XrlAtomFound& ) {
	XLOG_FATAL("Duplicate atom name"); /* XXX Should never happen */
    }
    return XrlCmdError::OKAY();
}

const XrlCmdError
XrlOspfv2TargetBase::handle_common_0_1_get_version(const XrlArgs& xa_inputs, XrlArgs* pxa_outputs)
{
    if (xa_inputs.size() != 0) {
	XLOG_ERROR("Wrong number of arguments (%u != %u) handling %s",
            XORP_UINT_CAST(0), XORP_UINT_CAST(xa_inputs.size()), "common/0.1/get_version");
	return XrlCmdError::BAD_ARGS();
    }

    if (pxa_outputs == 0) {
	XLOG_FATAL("Return list empty");
	return XrlCmdError::BAD_ARGS();
    }

    /* Return value declarations */
    string version;
    try {
	XrlCmdError e = common_0_1_get_version(
	    version);
	if (e != XrlCmdError::OKAY()) {
	    XLOG_WARNING("Handling method for %s failed: %s",
            		 "common/0.1/get_version", e.str().c_str());
	    return e;
        }
    } catch (const XrlArgs::XrlAtomNotFound& e) {
	XLOG_ERROR("Argument not found");
	return XrlCmdError::BAD_ARGS();
    }

    /* Marshall return values */
    try {
	pxa_outputs->add("version", version);
    } catch (const XrlArgs::XrlAtomFound& ) {
	XLOG_FATAL("Duplicate atom name"); /* XXX Should never happen */
    }
    return XrlCmdError::OKAY();
}

const XrlCmdError
XrlOspfv2TargetBase::handle_common_0_1_get_status(const XrlArgs& xa_inputs, XrlArgs* pxa_outputs)
{
    if (xa_inputs.size() != 0) {
	XLOG_ERROR("Wrong number of arguments (%u != %u) handling %s",
            XORP_UINT_CAST(0), XORP_UINT_CAST(xa_inputs.size()), "common/0.1/get_status");
	return XrlCmdError::BAD_ARGS();
    }

    if (pxa_outputs == 0) {
	XLOG_FATAL("Return list empty");
	return XrlCmdError::BAD_ARGS();
    }

    /* Return value declarations */
    uint32_t status;
    string reason;
    try {
	XrlCmdError e = common_0_1_get_status(
	    status,
	    reason);
	if (e != XrlCmdError::OKAY()) {
	    XLOG_WARNING("Handling method for %s failed: %s",
            		 "common/0.1/get_status", e.str().c_str());
	    return e;
        }
    } catch (const XrlArgs::XrlAtomNotFound& e) {
	XLOG_ERROR("Argument not found");
	return XrlCmdError::BAD_ARGS();
    }

    /* Marshall return values */
    try {
	pxa_outputs->add("status", status);
	pxa_outputs->add("reason", reason);
    } catch (const XrlArgs::XrlAtomFound& ) {
	XLOG_FATAL("Duplicate atom name"); /* XXX Should never happen */
    }
    return XrlCmdError::OKAY();
}

const XrlCmdError
XrlOspfv2TargetBase::handle_common_0_1_shutdown(const XrlArgs& xa_inputs, XrlArgs* /* pxa_outputs */)
{
    if (xa_inputs.size() != 0) {
	XLOG_ERROR("Wrong number of arguments (%u != %u) handling %s",
            XORP_UINT_CAST(0), XORP_UINT_CAST(xa_inputs.size()), "common/0.1/shutdown");
	return XrlCmdError::BAD_ARGS();
    }

    /* Return value declarations */
    try {
	XrlCmdError e = common_0_1_shutdown();
	if (e != XrlCmdError::OKAY()) {
	    XLOG_WARNING("Handling method for %s failed: %s",
            		 "common/0.1/shutdown", e.str().c_str());
	    return e;
        }
    } catch (const XrlArgs::XrlAtomNotFound& e) {
	XLOG_ERROR("Argument not found");
	return XrlCmdError::BAD_ARGS();
    }
    return XrlCmdError::OKAY();
}

const XrlCmdError
XrlOspfv2TargetBase::handle_raw_packet4_client_0_1_recv(const XrlArgs& xa_inputs, XrlArgs* /* pxa_outputs */)
{
    if (xa_inputs.size() != 9) {
	XLOG_ERROR("Wrong number of arguments (%u != %u) handling %s",
            XORP_UINT_CAST(9), XORP_UINT_CAST(xa_inputs.size()), "raw_packet4_client/0.1/recv");
	return XrlCmdError::BAD_ARGS();
    }

    /* Return value declarations */
    try {
	XrlCmdError e = raw_packet4_client_0_1_recv(
	    xa_inputs.get_string("if_name"),
	    xa_inputs.get_string("vif_name"),
	    xa_inputs.get_ipv4("src_address"),
	    xa_inputs.get_ipv4("dst_address"),
	    xa_inputs.get_uint32("ip_protocol"),
	    xa_inputs.get_int32("ip_ttl"),
	    xa_inputs.get_int32("ip_tos"),
	    xa_inputs.get_bool("ip_router_alert"),
	    xa_inputs.get_binary("payload"));
	if (e != XrlCmdError::OKAY()) {
	    XLOG_WARNING("Handling method for %s failed: %s",
            		 "raw_packet4_client/0.1/recv", e.str().c_str());
	    return e;
        }
    } catch (const XrlArgs::XrlAtomNotFound& e) {
	XLOG_ERROR("Argument not found");
	return XrlCmdError::BAD_ARGS();
    }
    return XrlCmdError::OKAY();
}

const XrlCmdError
XrlOspfv2TargetBase::handle_policy_backend_0_1_configure(const XrlArgs& xa_inputs, XrlArgs* /* pxa_outputs */)
{
    if (xa_inputs.size() != 2) {
	XLOG_ERROR("Wrong number of arguments (%u != %u) handling %s",
            XORP_UINT_CAST(2), XORP_UINT_CAST(xa_inputs.size()), "policy_backend/0.1/configure");
	return XrlCmdError::BAD_ARGS();
    }

    /* Return value declarations */
    try {
	XrlCmdError e = policy_backend_0_1_configure(
	    xa_inputs.get_uint32("filter"),
	    xa_inputs.get_string("conf"));
	if (e != XrlCmdError::OKAY()) {
	    XLOG_WARNING("Handling method for %s failed: %s",
            		 "policy_backend/0.1/configure", e.str().c_str());
	    return e;
        }
    } catch (const XrlArgs::XrlAtomNotFound& e) {
	XLOG_ERROR("Argument not found");
	return XrlCmdError::BAD_ARGS();
    }
    return XrlCmdError::OKAY();
}

const XrlCmdError
XrlOspfv2TargetBase::handle_policy_backend_0_1_reset(const XrlArgs& xa_inputs, XrlArgs* /* pxa_outputs */)
{
    if (xa_inputs.size() != 1) {
	XLOG_ERROR("Wrong number of arguments (%u != %u) handling %s",
            XORP_UINT_CAST(1), XORP_UINT_CAST(xa_inputs.size()), "policy_backend/0.1/reset");
	return XrlCmdError::BAD_ARGS();
    }

    /* Return value declarations */
    try {
	XrlCmdError e = policy_backend_0_1_reset(
	    xa_inputs.get_uint32("filter"));
	if (e != XrlCmdError::OKAY()) {
	    XLOG_WARNING("Handling method for %s failed: %s",
            		 "policy_backend/0.1/reset", e.str().c_str());
	    return e;
        }
    } catch (const XrlArgs::XrlAtomNotFound& e) {
	XLOG_ERROR("Argument not found");
	return XrlCmdError::BAD_ARGS();
    }
    return XrlCmdError::OKAY();
}

const XrlCmdError
XrlOspfv2TargetBase::handle_policy_backend_0_1_push_routes(const XrlArgs& xa_inputs, XrlArgs* /* pxa_outputs */)
{
    if (xa_inputs.size() != 0) {
	XLOG_ERROR("Wrong number of arguments (%u != %u) handling %s",
            XORP_UINT_CAST(0), XORP_UINT_CAST(xa_inputs.size()), "policy_backend/0.1/push_routes");
	return XrlCmdError::BAD_ARGS();
    }

    /* Return value declarations */
    try {
	XrlCmdError e = policy_backend_0_1_push_routes();
	if (e != XrlCmdError::OKAY()) {
	    XLOG_WARNING("Handling method for %s failed: %s",
            		 "policy_backend/0.1/push_routes", e.str().c_str());
	    return e;
        }
    } catch (const XrlArgs::XrlAtomNotFound& e) {
	XLOG_ERROR("Argument not found");
	return XrlCmdError::BAD_ARGS();
    }
    return XrlCmdError::OKAY();
}

const XrlCmdError
XrlOspfv2TargetBase::handle_policy_redist4_0_1_add_route4(const XrlArgs& xa_inputs, XrlArgs* /* pxa_outputs */)
{
    if (xa_inputs.size() != 6) {
	XLOG_ERROR("Wrong number of arguments (%u != %u) handling %s",
            XORP_UINT_CAST(6), XORP_UINT_CAST(xa_inputs.size()), "policy_redist4/0.1/add_route4");
	return XrlCmdError::BAD_ARGS();
    }

    /* Return value declarations */
    try {
	XrlCmdError e = policy_redist4_0_1_add_route4(
	    xa_inputs.get_ipv4net("network"),
	    xa_inputs.get_bool("unicast"),
	    xa_inputs.get_bool("multicast"),
	    xa_inputs.get_ipv4("nexthop"),
	    xa_inputs.get_uint32("metric"),
	    xa_inputs.get_list("policytags"));
	if (e != XrlCmdError::OKAY()) {
	    XLOG_WARNING("Handling method for %s failed: %s",
            		 "policy_redist4/0.1/add_route4", e.str().c_str());
	    return e;
        }
    } catch (const XrlArgs::XrlAtomNotFound& e) {
	XLOG_ERROR("Argument not found");
	return XrlCmdError::BAD_ARGS();
    }
    return XrlCmdError::OKAY();
}

const XrlCmdError
XrlOspfv2TargetBase::handle_policy_redist4_0_1_delete_route4(const XrlArgs& xa_inputs, XrlArgs* /* pxa_outputs */)
{
    if (xa_inputs.size() != 3) {
	XLOG_ERROR("Wrong number of arguments (%u != %u) handling %s",
            XORP_UINT_CAST(3), XORP_UINT_CAST(xa_inputs.size()), "policy_redist4/0.1/delete_route4");
	return XrlCmdError::BAD_ARGS();
    }

    /* Return value declarations */
    try {
	XrlCmdError e = policy_redist4_0_1_delete_route4(
	    xa_inputs.get_ipv4net("network"),
	    xa_inputs.get_bool("unicast"),
	    xa_inputs.get_bool("multicast"));
	if (e != XrlCmdError::OKAY()) {
	    XLOG_WARNING("Handling method for %s failed: %s",
            		 "policy_redist4/0.1/delete_route4", e.str().c_str());
	    return e;
        }
    } catch (const XrlArgs::XrlAtomNotFound& e) {
	XLOG_ERROR("Argument not found");
	return XrlCmdError::BAD_ARGS();
    }
    return XrlCmdError::OKAY();
}

const XrlCmdError
XrlOspfv2TargetBase::handle_ospfv2_0_1_set_router_id(const XrlArgs& xa_inputs, XrlArgs* /* pxa_outputs */)
{
    if (xa_inputs.size() != 1) {
	XLOG_ERROR("Wrong number of arguments (%u != %u) handling %s",
            XORP_UINT_CAST(1), XORP_UINT_CAST(xa_inputs.size()), "ospfv2/0.1/set_router_id");
	return XrlCmdError::BAD_ARGS();
    }

    /* Return value declarations */
    try {
	XrlCmdError e = ospfv2_0_1_set_router_id(
	    xa_inputs.get_ipv4("id"));
	if (e != XrlCmdError::OKAY()) {
	    XLOG_WARNING("Handling method for %s failed: %s",
            		 "ospfv2/0.1/set_router_id", e.str().c_str());
	    return e;
        }
    } catch (const XrlArgs::XrlAtomNotFound& e) {
	XLOG_ERROR("Argument not found");
	return XrlCmdError::BAD_ARGS();
    }
    return XrlCmdError::OKAY();
}

const XrlCmdError
XrlOspfv2TargetBase::handle_ospfv2_0_1_set_rfc1583_compatibility(const XrlArgs& xa_inputs, XrlArgs* /* pxa_outputs */)
{
    if (xa_inputs.size() != 1) {
	XLOG_ERROR("Wrong number of arguments (%u != %u) handling %s",
            XORP_UINT_CAST(1), XORP_UINT_CAST(xa_inputs.size()), "ospfv2/0.1/set_rfc1583_compatibility");
	return XrlCmdError::BAD_ARGS();
    }

    /* Return value declarations */
    try {
	XrlCmdError e = ospfv2_0_1_set_rfc1583_compatibility(
	    xa_inputs.get_bool("compatibility"));
	if (e != XrlCmdError::OKAY()) {
	    XLOG_WARNING("Handling method for %s failed: %s",
            		 "ospfv2/0.1/set_rfc1583_compatibility", e.str().c_str());
	    return e;
        }
    } catch (const XrlArgs::XrlAtomNotFound& e) {
	XLOG_ERROR("Argument not found");
	return XrlCmdError::BAD_ARGS();
    }
    return XrlCmdError::OKAY();
}

const XrlCmdError
XrlOspfv2TargetBase::handle_ospfv2_0_1_set_ip_router_alert(const XrlArgs& xa_inputs, XrlArgs* /* pxa_outputs */)
{
    if (xa_inputs.size() != 1) {
	XLOG_ERROR("Wrong number of arguments (%u != %u) handling %s",
            XORP_UINT_CAST(1), XORP_UINT_CAST(xa_inputs.size()), "ospfv2/0.1/set_ip_router_alert");
	return XrlCmdError::BAD_ARGS();
    }

    /* Return value declarations */
    try {
	XrlCmdError e = ospfv2_0_1_set_ip_router_alert(
	    xa_inputs.get_bool("ip_router_alert"));
	if (e != XrlCmdError::OKAY()) {
	    XLOG_WARNING("Handling method for %s failed: %s",
            		 "ospfv2/0.1/set_ip_router_alert", e.str().c_str());
	    return e;
        }
    } catch (const XrlArgs::XrlAtomNotFound& e) {
	XLOG_ERROR("Argument not found");
	return XrlCmdError::BAD_ARGS();
    }
    return XrlCmdError::OKAY();
}

const XrlCmdError
XrlOspfv2TargetBase::handle_ospfv2_0_1_create_area_router(const XrlArgs& xa_inputs, XrlArgs* /* pxa_outputs */)
{
    if (xa_inputs.size() != 2) {
	XLOG_ERROR("Wrong number of arguments (%u != %u) handling %s",
            XORP_UINT_CAST(2), XORP_UINT_CAST(xa_inputs.size()), "ospfv2/0.1/create_area_router");
	return XrlCmdError::BAD_ARGS();
    }

    /* Return value declarations */
    try {
	XrlCmdError e = ospfv2_0_1_create_area_router(
	    xa_inputs.get_ipv4("area"),
	    xa_inputs.get_string("type"));
	if (e != XrlCmdError::OKAY()) {
	    XLOG_WARNING("Handling method for %s failed: %s",
            		 "ospfv2/0.1/create_area_router", e.str().c_str());
	    return e;
        }
    } catch (const XrlArgs::XrlAtomNotFound& e) {
	XLOG_ERROR("Argument not found");
	return XrlCmdError::BAD_ARGS();
    }
    return XrlCmdError::OKAY();
}

const XrlCmdError
XrlOspfv2TargetBase::handle_ospfv2_0_1_change_area_router_type(const XrlArgs& xa_inputs, XrlArgs* /* pxa_outputs */)
{
    if (xa_inputs.size() != 2) {
	XLOG_ERROR("Wrong number of arguments (%u != %u) handling %s",
            XORP_UINT_CAST(2), XORP_UINT_CAST(xa_inputs.size()), "ospfv2/0.1/change_area_router_type");
	return XrlCmdError::BAD_ARGS();
    }

    /* Return value declarations */
    try {
	XrlCmdError e = ospfv2_0_1_change_area_router_type(
	    xa_inputs.get_ipv4("area"),
	    xa_inputs.get_string("type"));
	if (e != XrlCmdError::OKAY()) {
	    XLOG_WARNING("Handling method for %s failed: %s",
            		 "ospfv2/0.1/change_area_router_type", e.str().c_str());
	    return e;
        }
    } catch (const XrlArgs::XrlAtomNotFound& e) {
	XLOG_ERROR("Argument not found");
	return XrlCmdError::BAD_ARGS();
    }
    return XrlCmdError::OKAY();
}

const XrlCmdError
XrlOspfv2TargetBase::handle_ospfv2_0_1_destroy_area_router(const XrlArgs& xa_inputs, XrlArgs* /* pxa_outputs */)
{
    if (xa_inputs.size() != 1) {
	XLOG_ERROR("Wrong number of arguments (%u != %u) handling %s",
            XORP_UINT_CAST(1), XORP_UINT_CAST(xa_inputs.size()), "ospfv2/0.1/destroy_area_router");
	return XrlCmdError::BAD_ARGS();
    }

    /* Return value declarations */
    try {
	XrlCmdError e = ospfv2_0_1_destroy_area_router(
	    xa_inputs.get_ipv4("area"));
	if (e != XrlCmdError::OKAY()) {
	    XLOG_WARNING("Handling method for %s failed: %s",
            		 "ospfv2/0.1/destroy_area_router", e.str().c_str());
	    return e;
        }
    } catch (const XrlArgs::XrlAtomNotFound& e) {
	XLOG_ERROR("Argument not found");
	return XrlCmdError::BAD_ARGS();
    }
    return XrlCmdError::OKAY();
}

const XrlCmdError
XrlOspfv2TargetBase::handle_ospfv2_0_1_create_peer(const XrlArgs& xa_inputs, XrlArgs* /* pxa_outputs */)
{
    if (xa_inputs.size() != 5) {
	XLOG_ERROR("Wrong number of arguments (%u != %u) handling %s",
            XORP_UINT_CAST(5), XORP_UINT_CAST(xa_inputs.size()), "ospfv2/0.1/create_peer");
	return XrlCmdError::BAD_ARGS();
    }

    /* Return value declarations */
    try {
	XrlCmdError e = ospfv2_0_1_create_peer(
	    xa_inputs.get_string("ifname"),
	    xa_inputs.get_string("vifname"),
	    xa_inputs.get_ipv4("addr"),
	    xa_inputs.get_string("type"),
	    xa_inputs.get_ipv4("area"));
	if (e != XrlCmdError::OKAY()) {
	    XLOG_WARNING("Handling method for %s failed: %s",
            		 "ospfv2/0.1/create_peer", e.str().c_str());
	    return e;
        }
    } catch (const XrlArgs::XrlAtomNotFound& e) {
	XLOG_ERROR("Argument not found");
	return XrlCmdError::BAD_ARGS();
    }
    return XrlCmdError::OKAY();
}

const XrlCmdError
XrlOspfv2TargetBase::handle_ospfv2_0_1_delete_peer(const XrlArgs& xa_inputs, XrlArgs* /* pxa_outputs */)
{
    if (xa_inputs.size() != 2) {
	XLOG_ERROR("Wrong number of arguments (%u != %u) handling %s",
            XORP_UINT_CAST(2), XORP_UINT_CAST(xa_inputs.size()), "ospfv2/0.1/delete_peer");
	return XrlCmdError::BAD_ARGS();
    }

    /* Return value declarations */
    try {
	XrlCmdError e = ospfv2_0_1_delete_peer(
	    xa_inputs.get_string("ifname"),
	    xa_inputs.get_string("vifname"));
	if (e != XrlCmdError::OKAY()) {
	    XLOG_WARNING("Handling method for %s failed: %s",
            		 "ospfv2/0.1/delete_peer", e.str().c_str());
	    return e;
        }
    } catch (const XrlArgs::XrlAtomNotFound& e) {
	XLOG_ERROR("Argument not found");
	return XrlCmdError::BAD_ARGS();
    }
    return XrlCmdError::OKAY();
}

const XrlCmdError
XrlOspfv2TargetBase::handle_ospfv2_0_1_set_peer_state(const XrlArgs& xa_inputs, XrlArgs* /* pxa_outputs */)
{
    if (xa_inputs.size() != 3) {
	XLOG_ERROR("Wrong number of arguments (%u != %u) handling %s",
            XORP_UINT_CAST(3), XORP_UINT_CAST(xa_inputs.size()), "ospfv2/0.1/set_peer_state");
	return XrlCmdError::BAD_ARGS();
    }

    /* Return value declarations */
    try {
	XrlCmdError e = ospfv2_0_1_set_peer_state(
	    xa_inputs.get_string("ifname"),
	    xa_inputs.get_string("vifname"),
	    xa_inputs.get_bool("enable"));
	if (e != XrlCmdError::OKAY()) {
	    XLOG_WARNING("Handling method for %s failed: %s",
            		 "ospfv2/0.1/set_peer_state", e.str().c_str());
	    return e;
        }
    } catch (const XrlArgs::XrlAtomNotFound& e) {
	XLOG_ERROR("Argument not found");
	return XrlCmdError::BAD_ARGS();
    }
    return XrlCmdError::OKAY();
}

const XrlCmdError
XrlOspfv2TargetBase::handle_ospfv2_0_1_add_neighbour(const XrlArgs& xa_inputs, XrlArgs* /* pxa_outputs */)
{
    if (xa_inputs.size() != 5) {
	XLOG_ERROR("Wrong number of arguments (%u != %u) handling %s",
            XORP_UINT_CAST(5), XORP_UINT_CAST(xa_inputs.size()), "ospfv2/0.1/add_neighbour");
	return XrlCmdError::BAD_ARGS();
    }

    /* Return value declarations */
    try {
	XrlCmdError e = ospfv2_0_1_add_neighbour(
	    xa_inputs.get_string("ifname"),
	    xa_inputs.get_string("vifname"),
	    xa_inputs.get_ipv4("area"),
	    xa_inputs.get_ipv4("neighbour_address"),
	    xa_inputs.get_ipv4("neighbour_id"));
	if (e != XrlCmdError::OKAY()) {
	    XLOG_WARNING("Handling method for %s failed: %s",
            		 "ospfv2/0.1/add_neighbour", e.str().c_str());
	    return e;
        }
    } catch (const XrlArgs::XrlAtomNotFound& e) {
	XLOG_ERROR("Argument not found");
	return XrlCmdError::BAD_ARGS();
    }
    return XrlCmdError::OKAY();
}

const XrlCmdError
XrlOspfv2TargetBase::handle_ospfv2_0_1_remove_neighbour(const XrlArgs& xa_inputs, XrlArgs* /* pxa_outputs */)
{
    if (xa_inputs.size() != 5) {
	XLOG_ERROR("Wrong number of arguments (%u != %u) handling %s",
            XORP_UINT_CAST(5), XORP_UINT_CAST(xa_inputs.size()), "ospfv2/0.1/remove_neighbour");
	return XrlCmdError::BAD_ARGS();
    }

    /* Return value declarations */
    try {
	XrlCmdError e = ospfv2_0_1_remove_neighbour(
	    xa_inputs.get_string("ifname"),
	    xa_inputs.get_string("vifname"),
	    xa_inputs.get_ipv4("area"),
	    xa_inputs.get_ipv4("neighbour_address"),
	    xa_inputs.get_ipv4("neighbour_id"));
	if (e != XrlCmdError::OKAY()) {
	    XLOG_WARNING("Handling method for %s failed: %s",
            		 "ospfv2/0.1/remove_neighbour", e.str().c_str());
	    return e;
        }
    } catch (const XrlArgs::XrlAtomNotFound& e) {
	XLOG_ERROR("Argument not found");
	return XrlCmdError::BAD_ARGS();
    }
    return XrlCmdError::OKAY();
}

const XrlCmdError
XrlOspfv2TargetBase::handle_ospfv2_0_1_create_virtual_link(const XrlArgs& xa_inputs, XrlArgs* /* pxa_outputs */)
{
    if (xa_inputs.size() != 2) {
	XLOG_ERROR("Wrong number of arguments (%u != %u) handling %s",
            XORP_UINT_CAST(2), XORP_UINT_CAST(xa_inputs.size()), "ospfv2/0.1/create_virtual_link");
	return XrlCmdError::BAD_ARGS();
    }

    /* Return value declarations */
    try {
	XrlCmdError e = ospfv2_0_1_create_virtual_link(
	    xa_inputs.get_ipv4("neighbour_id"),
	    xa_inputs.get_ipv4("area"));
	if (e != XrlCmdError::OKAY()) {
	    XLOG_WARNING("Handling method for %s failed: %s",
            		 "ospfv2/0.1/create_virtual_link", e.str().c_str());
	    return e;
        }
    } catch (const XrlArgs::XrlAtomNotFound& e) {
	XLOG_ERROR("Argument not found");
	return XrlCmdError::BAD_ARGS();
    }
    return XrlCmdError::OKAY();
}

const XrlCmdError
XrlOspfv2TargetBase::handle_ospfv2_0_1_delete_virtual_link(const XrlArgs& xa_inputs, XrlArgs* /* pxa_outputs */)
{
    if (xa_inputs.size() != 1) {
	XLOG_ERROR("Wrong number of arguments (%u != %u) handling %s",
            XORP_UINT_CAST(1), XORP_UINT_CAST(xa_inputs.size()), "ospfv2/0.1/delete_virtual_link");
	return XrlCmdError::BAD_ARGS();
    }

    /* Return value declarations */
    try {
	XrlCmdError e = ospfv2_0_1_delete_virtual_link(
	    xa_inputs.get_ipv4("neighbour_id"));
	if (e != XrlCmdError::OKAY()) {
	    XLOG_WARNING("Handling method for %s failed: %s",
            		 "ospfv2/0.1/delete_virtual_link", e.str().c_str());
	    return e;
        }
    } catch (const XrlArgs::XrlAtomNotFound& e) {
	XLOG_ERROR("Argument not found");
	return XrlCmdError::BAD_ARGS();
    }
    return XrlCmdError::OKAY();
}

const XrlCmdError
XrlOspfv2TargetBase::handle_ospfv2_0_1_transit_area_virtual_link(const XrlArgs& xa_inputs, XrlArgs* /* pxa_outputs */)
{
    if (xa_inputs.size() != 2) {
	XLOG_ERROR("Wrong number of arguments (%u != %u) handling %s",
            XORP_UINT_CAST(2), XORP_UINT_CAST(xa_inputs.size()), "ospfv2/0.1/transit_area_virtual_link");
	return XrlCmdError::BAD_ARGS();
    }

    /* Return value declarations */
    try {
	XrlCmdError e = ospfv2_0_1_transit_area_virtual_link(
	    xa_inputs.get_ipv4("neighbour_id"),
	    xa_inputs.get_ipv4("transit_area"));
	if (e != XrlCmdError::OKAY()) {
	    XLOG_WARNING("Handling method for %s failed: %s",
            		 "ospfv2/0.1/transit_area_virtual_link", e.str().c_str());
	    return e;
        }
    } catch (const XrlArgs::XrlAtomNotFound& e) {
	XLOG_ERROR("Argument not found");
	return XrlCmdError::BAD_ARGS();
    }
    return XrlCmdError::OKAY();
}

const XrlCmdError
XrlOspfv2TargetBase::handle_ospfv2_0_1_set_interface_cost(const XrlArgs& xa_inputs, XrlArgs* /* pxa_outputs */)
{
    if (xa_inputs.size() != 4) {
	XLOG_ERROR("Wrong number of arguments (%u != %u) handling %s",
            XORP_UINT_CAST(4), XORP_UINT_CAST(xa_inputs.size()), "ospfv2/0.1/set_interface_cost");
	return XrlCmdError::BAD_ARGS();
    }

    /* Return value declarations */
    try {
	XrlCmdError e = ospfv2_0_1_set_interface_cost(
	    xa_inputs.get_string("ifname"),
	    xa_inputs.get_string("vifname"),
	    xa_inputs.get_ipv4("area"),
	    xa_inputs.get_uint32("cost"));
	if (e != XrlCmdError::OKAY()) {
	    XLOG_WARNING("Handling method for %s failed: %s",
            		 "ospfv2/0.1/set_interface_cost", e.str().c_str());
	    return e;
        }
    } catch (const XrlArgs::XrlAtomNotFound& e) {
	XLOG_ERROR("Argument not found");
	return XrlCmdError::BAD_ARGS();
    }
    return XrlCmdError::OKAY();
}

const XrlCmdError
XrlOspfv2TargetBase::handle_ospfv2_0_1_set_retransmit_interval(const XrlArgs& xa_inputs, XrlArgs* /* pxa_outputs */)
{
    if (xa_inputs.size() != 4) {
	XLOG_ERROR("Wrong number of arguments (%u != %u) handling %s",
            XORP_UINT_CAST(4), XORP_UINT_CAST(xa_inputs.size()), "ospfv2/0.1/set_retransmit_interval");
	return XrlCmdError::BAD_ARGS();
    }

    /* Return value declarations */
    try {
	XrlCmdError e = ospfv2_0_1_set_retransmit_interval(
	    xa_inputs.get_string("ifname"),
	    xa_inputs.get_string("vifname"),
	    xa_inputs.get_ipv4("area"),
	    xa_inputs.get_uint32("interval"));
	if (e != XrlCmdError::OKAY()) {
	    XLOG_WARNING("Handling method for %s failed: %s",
            		 "ospfv2/0.1/set_retransmit_interval", e.str().c_str());
	    return e;
        }
    } catch (const XrlArgs::XrlAtomNotFound& e) {
	XLOG_ERROR("Argument not found");
	return XrlCmdError::BAD_ARGS();
    }
    return XrlCmdError::OKAY();
}

const XrlCmdError
XrlOspfv2TargetBase::handle_ospfv2_0_1_set_inftransdelay(const XrlArgs& xa_inputs, XrlArgs* /* pxa_outputs */)
{
    if (xa_inputs.size() != 4) {
	XLOG_ERROR("Wrong number of arguments (%u != %u) handling %s",
            XORP_UINT_CAST(4), XORP_UINT_CAST(xa_inputs.size()), "ospfv2/0.1/set_inftransdelay");
	return XrlCmdError::BAD_ARGS();
    }

    /* Return value declarations */
    try {
	XrlCmdError e = ospfv2_0_1_set_inftransdelay(
	    xa_inputs.get_string("ifname"),
	    xa_inputs.get_string("vifname"),
	    xa_inputs.get_ipv4("area"),
	    xa_inputs.get_uint32("delay"));
	if (e != XrlCmdError::OKAY()) {
	    XLOG_WARNING("Handling method for %s failed: %s",
            		 "ospfv2/0.1/set_inftransdelay", e.str().c_str());
	    return e;
        }
    } catch (const XrlArgs::XrlAtomNotFound& e) {
	XLOG_ERROR("Argument not found");
	return XrlCmdError::BAD_ARGS();
    }
    return XrlCmdError::OKAY();
}

const XrlCmdError
XrlOspfv2TargetBase::handle_ospfv2_0_1_set_router_priority(const XrlArgs& xa_inputs, XrlArgs* /* pxa_outputs */)
{
    if (xa_inputs.size() != 4) {
	XLOG_ERROR("Wrong number of arguments (%u != %u) handling %s",
            XORP_UINT_CAST(4), XORP_UINT_CAST(xa_inputs.size()), "ospfv2/0.1/set_router_priority");
	return XrlCmdError::BAD_ARGS();
    }

    /* Return value declarations */
    try {
	XrlCmdError e = ospfv2_0_1_set_router_priority(
	    xa_inputs.get_string("ifname"),
	    xa_inputs.get_string("vifname"),
	    xa_inputs.get_ipv4("area"),
	    xa_inputs.get_uint32("priority"));
	if (e != XrlCmdError::OKAY()) {
	    XLOG_WARNING("Handling method for %s failed: %s",
            		 "ospfv2/0.1/set_router_priority", e.str().c_str());
	    return e;
        }
    } catch (const XrlArgs::XrlAtomNotFound& e) {
	XLOG_ERROR("Argument not found");
	return XrlCmdError::BAD_ARGS();
    }
    return XrlCmdError::OKAY();
}

const XrlCmdError
XrlOspfv2TargetBase::handle_ospfv2_0_1_set_hello_interval(const XrlArgs& xa_inputs, XrlArgs* /* pxa_outputs */)
{
    if (xa_inputs.size() != 4) {
	XLOG_ERROR("Wrong number of arguments (%u != %u) handling %s",
            XORP_UINT_CAST(4), XORP_UINT_CAST(xa_inputs.size()), "ospfv2/0.1/set_hello_interval");
	return XrlCmdError::BAD_ARGS();
    }

    /* Return value declarations */
    try {
	XrlCmdError e = ospfv2_0_1_set_hello_interval(
	    xa_inputs.get_string("ifname"),
	    xa_inputs.get_string("vifname"),
	    xa_inputs.get_ipv4("area"),
	    xa_inputs.get_uint32("interval"));
	if (e != XrlCmdError::OKAY()) {
	    XLOG_WARNING("Handling method for %s failed: %s",
            		 "ospfv2/0.1/set_hello_interval", e.str().c_str());
	    return e;
        }
    } catch (const XrlArgs::XrlAtomNotFound& e) {
	XLOG_ERROR("Argument not found");
	return XrlCmdError::BAD_ARGS();
    }
    return XrlCmdError::OKAY();
}

const XrlCmdError
XrlOspfv2TargetBase::handle_ospfv2_0_1_set_router_dead_interval(const XrlArgs& xa_inputs, XrlArgs* /* pxa_outputs */)
{
    if (xa_inputs.size() != 4) {
	XLOG_ERROR("Wrong number of arguments (%u != %u) handling %s",
            XORP_UINT_CAST(4), XORP_UINT_CAST(xa_inputs.size()), "ospfv2/0.1/set_router_dead_interval");
	return XrlCmdError::BAD_ARGS();
    }

    /* Return value declarations */
    try {
	XrlCmdError e = ospfv2_0_1_set_router_dead_interval(
	    xa_inputs.get_string("ifname"),
	    xa_inputs.get_string("vifname"),
	    xa_inputs.get_ipv4("area"),
	    xa_inputs.get_uint32("interval"));
	if (e != XrlCmdError::OKAY()) {
	    XLOG_WARNING("Handling method for %s failed: %s",
            		 "ospfv2/0.1/set_router_dead_interval", e.str().c_str());
	    return e;
        }
    } catch (const XrlArgs::XrlAtomNotFound& e) {
	XLOG_ERROR("Argument not found");
	return XrlCmdError::BAD_ARGS();
    }
    return XrlCmdError::OKAY();
}

const XrlCmdError
XrlOspfv2TargetBase::handle_ospfv2_0_1_set_simple_authentication_key(const XrlArgs& xa_inputs, XrlArgs* /* pxa_outputs */)
{
    if (xa_inputs.size() != 4) {
	XLOG_ERROR("Wrong number of arguments (%u != %u) handling %s",
            XORP_UINT_CAST(4), XORP_UINT_CAST(xa_inputs.size()), "ospfv2/0.1/set_simple_authentication_key");
	return XrlCmdError::BAD_ARGS();
    }

    /* Return value declarations */
    try {
	XrlCmdError e = ospfv2_0_1_set_simple_authentication_key(
	    xa_inputs.get_string("ifname"),
	    xa_inputs.get_string("vifname"),
	    xa_inputs.get_ipv4("area"),
	    xa_inputs.get_string("password"));
	if (e != XrlCmdError::OKAY()) {
	    XLOG_WARNING("Handling method for %s failed: %s",
            		 "ospfv2/0.1/set_simple_authentication_key", e.str().c_str());
	    return e;
        }
    } catch (const XrlArgs::XrlAtomNotFound& e) {
	XLOG_ERROR("Argument not found");
	return XrlCmdError::BAD_ARGS();
    }
    return XrlCmdError::OKAY();
}

const XrlCmdError
XrlOspfv2TargetBase::handle_ospfv2_0_1_delete_simple_authentication_key(const XrlArgs& xa_inputs, XrlArgs* /* pxa_outputs */)
{
    if (xa_inputs.size() != 3) {
	XLOG_ERROR("Wrong number of arguments (%u != %u) handling %s",
            XORP_UINT_CAST(3), XORP_UINT_CAST(xa_inputs.size()), "ospfv2/0.1/delete_simple_authentication_key");
	return XrlCmdError::BAD_ARGS();
    }

    /* Return value declarations */
    try {
	XrlCmdError e = ospfv2_0_1_delete_simple_authentication_key(
	    xa_inputs.get_string("ifname"),
	    xa_inputs.get_string("vifname"),
	    xa_inputs.get_ipv4("area"));
	if (e != XrlCmdError::OKAY()) {
	    XLOG_WARNING("Handling method for %s failed: %s",
            		 "ospfv2/0.1/delete_simple_authentication_key", e.str().c_str());
	    return e;
        }
    } catch (const XrlArgs::XrlAtomNotFound& e) {
	XLOG_ERROR("Argument not found");
	return XrlCmdError::BAD_ARGS();
    }
    return XrlCmdError::OKAY();
}

const XrlCmdError
XrlOspfv2TargetBase::handle_ospfv2_0_1_set_md5_authentication_key(const XrlArgs& xa_inputs, XrlArgs* /* pxa_outputs */)
{
    if (xa_inputs.size() != 8) {
	XLOG_ERROR("Wrong number of arguments (%u != %u) handling %s",
            XORP_UINT_CAST(8), XORP_UINT_CAST(xa_inputs.size()), "ospfv2/0.1/set_md5_authentication_key");
	return XrlCmdError::BAD_ARGS();
    }

    /* Return value declarations */
    try {
	XrlCmdError e = ospfv2_0_1_set_md5_authentication_key(
	    xa_inputs.get_string("ifname"),
	    xa_inputs.get_string("vifname"),
	    xa_inputs.get_ipv4("area"),
	    xa_inputs.get_uint32("key_id"),
	    xa_inputs.get_string("password"),
	    xa_inputs.get_string("start_time"),
	    xa_inputs.get_string("end_time"),
	    xa_inputs.get_uint32("max_time_drift"));
	if (e != XrlCmdError::OKAY()) {
	    XLOG_WARNING("Handling method for %s failed: %s",
            		 "ospfv2/0.1/set_md5_authentication_key", e.str().c_str());
	    return e;
        }
    } catch (const XrlArgs::XrlAtomNotFound& e) {
	XLOG_ERROR("Argument not found");
	return XrlCmdError::BAD_ARGS();
    }
    return XrlCmdError::OKAY();
}

const XrlCmdError
XrlOspfv2TargetBase::handle_ospfv2_0_1_delete_md5_authentication_key(const XrlArgs& xa_inputs, XrlArgs* /* pxa_outputs */)
{
    if (xa_inputs.size() != 4) {
	XLOG_ERROR("Wrong number of arguments (%u != %u) handling %s",
            XORP_UINT_CAST(4), XORP_UINT_CAST(xa_inputs.size()), "ospfv2/0.1/delete_md5_authentication_key");
	return XrlCmdError::BAD_ARGS();
    }

    /* Return value declarations */
    try {
	XrlCmdError e = ospfv2_0_1_delete_md5_authentication_key(
	    xa_inputs.get_string("ifname"),
	    xa_inputs.get_string("vifname"),
	    xa_inputs.get_ipv4("area"),
	    xa_inputs.get_uint32("key_id"));
	if (e != XrlCmdError::OKAY()) {
	    XLOG_WARNING("Handling method for %s failed: %s",
            		 "ospfv2/0.1/delete_md5_authentication_key", e.str().c_str());
	    return e;
        }
    } catch (const XrlArgs::XrlAtomNotFound& e) {
	XLOG_ERROR("Argument not found");
	return XrlCmdError::BAD_ARGS();
    }
    return XrlCmdError::OKAY();
}

const XrlCmdError
XrlOspfv2TargetBase::handle_ospfv2_0_1_set_passive(const XrlArgs& xa_inputs, XrlArgs* /* pxa_outputs */)
{
    if (xa_inputs.size() != 4) {
	XLOG_ERROR("Wrong number of arguments (%u != %u) handling %s",
            XORP_UINT_CAST(4), XORP_UINT_CAST(xa_inputs.size()), "ospfv2/0.1/set_passive");
	return XrlCmdError::BAD_ARGS();
    }

    /* Return value declarations */
    try {
	XrlCmdError e = ospfv2_0_1_set_passive(
	    xa_inputs.get_string("ifname"),
	    xa_inputs.get_string("vifname"),
	    xa_inputs.get_ipv4("area"),
	    xa_inputs.get_bool("passive"));
	if (e != XrlCmdError::OKAY()) {
	    XLOG_WARNING("Handling method for %s failed: %s",
            		 "ospfv2/0.1/set_passive", e.str().c_str());
	    return e;
        }
    } catch (const XrlArgs::XrlAtomNotFound& e) {
	XLOG_ERROR("Argument not found");
	return XrlCmdError::BAD_ARGS();
    }
    return XrlCmdError::OKAY();
}

const XrlCmdError
XrlOspfv2TargetBase::handle_ospfv2_0_1_originate_default_route(const XrlArgs& xa_inputs, XrlArgs* /* pxa_outputs */)
{
    if (xa_inputs.size() != 2) {
	XLOG_ERROR("Wrong number of arguments (%u != %u) handling %s",
            XORP_UINT_CAST(2), XORP_UINT_CAST(xa_inputs.size()), "ospfv2/0.1/originate_default_route");
	return XrlCmdError::BAD_ARGS();
    }

    /* Return value declarations */
    try {
	XrlCmdError e = ospfv2_0_1_originate_default_route(
	    xa_inputs.get_ipv4("area"),
	    xa_inputs.get_bool("enable"));
	if (e != XrlCmdError::OKAY()) {
	    XLOG_WARNING("Handling method for %s failed: %s",
            		 "ospfv2/0.1/originate_default_route", e.str().c_str());
	    return e;
        }
    } catch (const XrlArgs::XrlAtomNotFound& e) {
	XLOG_ERROR("Argument not found");
	return XrlCmdError::BAD_ARGS();
    }
    return XrlCmdError::OKAY();
}

const XrlCmdError
XrlOspfv2TargetBase::handle_ospfv2_0_1_stub_default_cost(const XrlArgs& xa_inputs, XrlArgs* /* pxa_outputs */)
{
    if (xa_inputs.size() != 2) {
	XLOG_ERROR("Wrong number of arguments (%u != %u) handling %s",
            XORP_UINT_CAST(2), XORP_UINT_CAST(xa_inputs.size()), "ospfv2/0.1/stub_default_cost");
	return XrlCmdError::BAD_ARGS();
    }

    /* Return value declarations */
    try {
	XrlCmdError e = ospfv2_0_1_stub_default_cost(
	    xa_inputs.get_ipv4("area"),
	    xa_inputs.get_uint32("cost"));
	if (e != XrlCmdError::OKAY()) {
	    XLOG_WARNING("Handling method for %s failed: %s",
            		 "ospfv2/0.1/stub_default_cost", e.str().c_str());
	    return e;
        }
    } catch (const XrlArgs::XrlAtomNotFound& e) {
	XLOG_ERROR("Argument not found");
	return XrlCmdError::BAD_ARGS();
    }
    return XrlCmdError::OKAY();
}

const XrlCmdError
XrlOspfv2TargetBase::handle_ospfv2_0_1_summaries(const XrlArgs& xa_inputs, XrlArgs* /* pxa_outputs */)
{
    if (xa_inputs.size() != 2) {
	XLOG_ERROR("Wrong number of arguments (%u != %u) handling %s",
            XORP_UINT_CAST(2), XORP_UINT_CAST(xa_inputs.size()), "ospfv2/0.1/summaries");
	return XrlCmdError::BAD_ARGS();
    }

    /* Return value declarations */
    try {
	XrlCmdError e = ospfv2_0_1_summaries(
	    xa_inputs.get_ipv4("area"),
	    xa_inputs.get_bool("enable"));
	if (e != XrlCmdError::OKAY()) {
	    XLOG_WARNING("Handling method for %s failed: %s",
            		 "ospfv2/0.1/summaries", e.str().c_str());
	    return e;
        }
    } catch (const XrlArgs::XrlAtomNotFound& e) {
	XLOG_ERROR("Argument not found");
	return XrlCmdError::BAD_ARGS();
    }
    return XrlCmdError::OKAY();
}

const XrlCmdError
XrlOspfv2TargetBase::handle_ospfv2_0_1_area_range_add(const XrlArgs& xa_inputs, XrlArgs* /* pxa_outputs */)
{
    if (xa_inputs.size() != 3) {
	XLOG_ERROR("Wrong number of arguments (%u != %u) handling %s",
            XORP_UINT_CAST(3), XORP_UINT_CAST(xa_inputs.size()), "ospfv2/0.1/area_range_add");
	return XrlCmdError::BAD_ARGS();
    }

    /* Return value declarations */
    try {
	XrlCmdError e = ospfv2_0_1_area_range_add(
	    xa_inputs.get_ipv4("area"),
	    xa_inputs.get_ipv4net("net"),
	    xa_inputs.get_bool("advertise"));
	if (e != XrlCmdError::OKAY()) {
	    XLOG_WARNING("Handling method for %s failed: %s",
            		 "ospfv2/0.1/area_range_add", e.str().c_str());
	    return e;
        }
    } catch (const XrlArgs::XrlAtomNotFound& e) {
	XLOG_ERROR("Argument not found");
	return XrlCmdError::BAD_ARGS();
    }
    return XrlCmdError::OKAY();
}

const XrlCmdError
XrlOspfv2TargetBase::handle_ospfv2_0_1_area_range_delete(const XrlArgs& xa_inputs, XrlArgs* /* pxa_outputs */)
{
    if (xa_inputs.size() != 2) {
	XLOG_ERROR("Wrong number of arguments (%u != %u) handling %s",
            XORP_UINT_CAST(2), XORP_UINT_CAST(xa_inputs.size()), "ospfv2/0.1/area_range_delete");
	return XrlCmdError::BAD_ARGS();
    }

    /* Return value declarations */
    try {
	XrlCmdError e = ospfv2_0_1_area_range_delete(
	    xa_inputs.get_ipv4("area"),
	    xa_inputs.get_ipv4net("net"));
	if (e != XrlCmdError::OKAY()) {
	    XLOG_WARNING("Handling method for %s failed: %s",
            		 "ospfv2/0.1/area_range_delete", e.str().c_str());
	    return e;
        }
    } catch (const XrlArgs::XrlAtomNotFound& e) {
	XLOG_ERROR("Argument not found");
	return XrlCmdError::BAD_ARGS();
    }
    return XrlCmdError::OKAY();
}

const XrlCmdError
XrlOspfv2TargetBase::handle_ospfv2_0_1_area_range_change_state(const XrlArgs& xa_inputs, XrlArgs* /* pxa_outputs */)
{
    if (xa_inputs.size() != 3) {
	XLOG_ERROR("Wrong number of arguments (%u != %u) handling %s",
            XORP_UINT_CAST(3), XORP_UINT_CAST(xa_inputs.size()), "ospfv2/0.1/area_range_change_state");
	return XrlCmdError::BAD_ARGS();
    }

    /* Return value declarations */
    try {
	XrlCmdError e = ospfv2_0_1_area_range_change_state(
	    xa_inputs.get_ipv4("area"),
	    xa_inputs.get_ipv4net("net"),
	    xa_inputs.get_bool("advertise"));
	if (e != XrlCmdError::OKAY()) {
	    XLOG_WARNING("Handling method for %s failed: %s",
            		 "ospfv2/0.1/area_range_change_state", e.str().c_str());
	    return e;
        }
    } catch (const XrlArgs::XrlAtomNotFound& e) {
	XLOG_ERROR("Argument not found");
	return XrlCmdError::BAD_ARGS();
    }
    return XrlCmdError::OKAY();
}

const XrlCmdError
XrlOspfv2TargetBase::handle_ospfv2_0_1_trace(const XrlArgs& xa_inputs, XrlArgs* /* pxa_outputs */)
{
    if (xa_inputs.size() != 2) {
	XLOG_ERROR("Wrong number of arguments (%u != %u) handling %s",
            XORP_UINT_CAST(2), XORP_UINT_CAST(xa_inputs.size()), "ospfv2/0.1/trace");
	return XrlCmdError::BAD_ARGS();
    }

    /* Return value declarations */
    try {
	XrlCmdError e = ospfv2_0_1_trace(
	    xa_inputs.get_string("tvar"),
	    xa_inputs.get_bool("enable"));
	if (e != XrlCmdError::OKAY()) {
	    XLOG_WARNING("Handling method for %s failed: %s",
            		 "ospfv2/0.1/trace", e.str().c_str());
	    return e;
        }
    } catch (const XrlArgs::XrlAtomNotFound& e) {
	XLOG_ERROR("Argument not found");
	return XrlCmdError::BAD_ARGS();
    }
    return XrlCmdError::OKAY();
}

const XrlCmdError
XrlOspfv2TargetBase::handle_ospfv2_0_1_get_lsa(const XrlArgs& xa_inputs, XrlArgs* pxa_outputs)
{
    if (xa_inputs.size() != 2) {
	XLOG_ERROR("Wrong number of arguments (%u != %u) handling %s",
            XORP_UINT_CAST(2), XORP_UINT_CAST(xa_inputs.size()), "ospfv2/0.1/get_lsa");
	return XrlCmdError::BAD_ARGS();
    }

    if (pxa_outputs == 0) {
	XLOG_FATAL("Return list empty");
	return XrlCmdError::BAD_ARGS();
    }

    /* Return value declarations */
    bool valid;
    bool toohigh;
    bool self;
    vector<uint8_t> lsa;
    try {
	XrlCmdError e = ospfv2_0_1_get_lsa(
	    xa_inputs.get_ipv4("area"),
	    xa_inputs.get_uint32("index"),
	    valid,
	    toohigh,
	    self,
	    lsa);
	if (e != XrlCmdError::OKAY()) {
	    XLOG_WARNING("Handling method for %s failed: %s",
            		 "ospfv2/0.1/get_lsa", e.str().c_str());
	    return e;
        }
    } catch (const XrlArgs::XrlAtomNotFound& e) {
	XLOG_ERROR("Argument not found");
	return XrlCmdError::BAD_ARGS();
    }

    /* Marshall return values */
    try {
	pxa_outputs->add("valid", valid);
	pxa_outputs->add("toohigh", toohigh);
	pxa_outputs->add("self", self);
	pxa_outputs->add("lsa", lsa);
    } catch (const XrlArgs::XrlAtomFound& ) {
	XLOG_FATAL("Duplicate atom name"); /* XXX Should never happen */
    }
    return XrlCmdError::OKAY();
}

const XrlCmdError
XrlOspfv2TargetBase::handle_ospfv2_0_1_get_area_list(const XrlArgs& xa_inputs, XrlArgs* pxa_outputs)
{
    if (xa_inputs.size() != 0) {
	XLOG_ERROR("Wrong number of arguments (%u != %u) handling %s",
            XORP_UINT_CAST(0), XORP_UINT_CAST(xa_inputs.size()), "ospfv2/0.1/get_area_list");
	return XrlCmdError::BAD_ARGS();
    }

    if (pxa_outputs == 0) {
	XLOG_FATAL("Return list empty");
	return XrlCmdError::BAD_ARGS();
    }

    /* Return value declarations */
    XrlAtomList areas;
    try {
	XrlCmdError e = ospfv2_0_1_get_area_list(
	    areas);
	if (e != XrlCmdError::OKAY()) {
	    XLOG_WARNING("Handling method for %s failed: %s",
            		 "ospfv2/0.1/get_area_list", e.str().c_str());
	    return e;
        }
    } catch (const XrlArgs::XrlAtomNotFound& e) {
	XLOG_ERROR("Argument not found");
	return XrlCmdError::BAD_ARGS();
    }

    /* Marshall return values */
    try {
	pxa_outputs->add("areas", areas);
    } catch (const XrlArgs::XrlAtomFound& ) {
	XLOG_FATAL("Duplicate atom name"); /* XXX Should never happen */
    }
    return XrlCmdError::OKAY();
}

const XrlCmdError
XrlOspfv2TargetBase::handle_ospfv2_0_1_get_neighbour_list(const XrlArgs& xa_inputs, XrlArgs* pxa_outputs)
{
    if (xa_inputs.size() != 0) {
	XLOG_ERROR("Wrong number of arguments (%u != %u) handling %s",
            XORP_UINT_CAST(0), XORP_UINT_CAST(xa_inputs.size()), "ospfv2/0.1/get_neighbour_list");
	return XrlCmdError::BAD_ARGS();
    }

    if (pxa_outputs == 0) {
	XLOG_FATAL("Return list empty");
	return XrlCmdError::BAD_ARGS();
    }

    /* Return value declarations */
    XrlAtomList areas;
    try {
	XrlCmdError e = ospfv2_0_1_get_neighbour_list(
	    areas);
	if (e != XrlCmdError::OKAY()) {
	    XLOG_WARNING("Handling method for %s failed: %s",
            		 "ospfv2/0.1/get_neighbour_list", e.str().c_str());
	    return e;
        }
    } catch (const XrlArgs::XrlAtomNotFound& e) {
	XLOG_ERROR("Argument not found");
	return XrlCmdError::BAD_ARGS();
    }

    /* Marshall return values */
    try {
	pxa_outputs->add("areas", areas);
    } catch (const XrlArgs::XrlAtomFound& ) {
	XLOG_FATAL("Duplicate atom name"); /* XXX Should never happen */
    }
    return XrlCmdError::OKAY();
}

const XrlCmdError
XrlOspfv2TargetBase::handle_ospfv2_0_1_get_neighbour_info(const XrlArgs& xa_inputs, XrlArgs* pxa_outputs)
{
    if (xa_inputs.size() != 1) {
	XLOG_ERROR("Wrong number of arguments (%u != %u) handling %s",
            XORP_UINT_CAST(1), XORP_UINT_CAST(xa_inputs.size()), "ospfv2/0.1/get_neighbour_info");
	return XrlCmdError::BAD_ARGS();
    }

    if (pxa_outputs == 0) {
	XLOG_FATAL("Return list empty");
	return XrlCmdError::BAD_ARGS();
    }

    /* Return value declarations */
    string address;
    string interface;
    string state;
    IPv4 rid;
    uint32_t priority;
    uint32_t deadtime;
    IPv4 area;
    uint32_t opt;
    IPv4 dr;
    IPv4 bdr;
    uint32_t up;
    uint32_t adjacent;
    try {
	XrlCmdError e = ospfv2_0_1_get_neighbour_info(
	    xa_inputs.get_uint32("nid"),
	    address,
	    interface,
	    state,
	    rid,
	    priority,
	    deadtime,
	    area,
	    opt,
	    dr,
	    bdr,
	    up,
	    adjacent);
	if (e != XrlCmdError::OKAY()) {
	    XLOG_WARNING("Handling method for %s failed: %s",
            		 "ospfv2/0.1/get_neighbour_info", e.str().c_str());
	    return e;
        }
    } catch (const XrlArgs::XrlAtomNotFound& e) {
	XLOG_ERROR("Argument not found");
	return XrlCmdError::BAD_ARGS();
    }

    /* Marshall return values */
    try {
	pxa_outputs->add("address", address);
	pxa_outputs->add("interface", interface);
	pxa_outputs->add("state", state);
	pxa_outputs->add("rid", rid);
	pxa_outputs->add("priority", priority);
	pxa_outputs->add("deadtime", deadtime);
	pxa_outputs->add("area", area);
	pxa_outputs->add("opt", opt);
	pxa_outputs->add("dr", dr);
	pxa_outputs->add("bdr", bdr);
	pxa_outputs->add("up", up);
	pxa_outputs->add("adjacent", adjacent);
    } catch (const XrlArgs::XrlAtomFound& ) {
	XLOG_FATAL("Duplicate atom name"); /* XXX Should never happen */
    }
    return XrlCmdError::OKAY();
}

void
XrlOspfv2TargetBase::add_handlers()
{
	if (_cmds->add_handler("common/0.1/get_target_name",
	    callback(this, &XrlOspfv2TargetBase::handle_common_0_1_get_target_name)) == false) {
	    XLOG_ERROR("Failed to xrl handler finder://%s/%s", "ospfv2", "common/0.1/get_target_name");
	}
	if (_cmds->add_handler("common/0.1/get_version",
	    callback(this, &XrlOspfv2TargetBase::handle_common_0_1_get_version)) == false) {
	    XLOG_ERROR("Failed to xrl handler finder://%s/%s", "ospfv2", "common/0.1/get_version");
	}
	if (_cmds->add_handler("common/0.1/get_status",
	    callback(this, &XrlOspfv2TargetBase::handle_common_0_1_get_status)) == false) {
	    XLOG_ERROR("Failed to xrl handler finder://%s/%s", "ospfv2", "common/0.1/get_status");
	}
	if (_cmds->add_handler("common/0.1/shutdown",
	    callback(this, &XrlOspfv2TargetBase::handle_common_0_1_shutdown)) == false) {
	    XLOG_ERROR("Failed to xrl handler finder://%s/%s", "ospfv2", "common/0.1/shutdown");
	}
	if (_cmds->add_handler("raw_packet4_client/0.1/recv",
	    callback(this, &XrlOspfv2TargetBase::handle_raw_packet4_client_0_1_recv)) == false) {
	    XLOG_ERROR("Failed to xrl handler finder://%s/%s", "ospfv2", "raw_packet4_client/0.1/recv");
	}
	if (_cmds->add_handler("policy_backend/0.1/configure",
	    callback(this, &XrlOspfv2TargetBase::handle_policy_backend_0_1_configure)) == false) {
	    XLOG_ERROR("Failed to xrl handler finder://%s/%s", "ospfv2", "policy_backend/0.1/configure");
	}
	if (_cmds->add_handler("policy_backend/0.1/reset",
	    callback(this, &XrlOspfv2TargetBase::handle_policy_backend_0_1_reset)) == false) {
	    XLOG_ERROR("Failed to xrl handler finder://%s/%s", "ospfv2", "policy_backend/0.1/reset");
	}
	if (_cmds->add_handler("policy_backend/0.1/push_routes",
	    callback(this, &XrlOspfv2TargetBase::handle_policy_backend_0_1_push_routes)) == false) {
	    XLOG_ERROR("Failed to xrl handler finder://%s/%s", "ospfv2", "policy_backend/0.1/push_routes");
	}
	if (_cmds->add_handler("policy_redist4/0.1/add_route4",
	    callback(this, &XrlOspfv2TargetBase::handle_policy_redist4_0_1_add_route4)) == false) {
	    XLOG_ERROR("Failed to xrl handler finder://%s/%s", "ospfv2", "policy_redist4/0.1/add_route4");
	}
	if (_cmds->add_handler("policy_redist4/0.1/delete_route4",
	    callback(this, &XrlOspfv2TargetBase::handle_policy_redist4_0_1_delete_route4)) == false) {
	    XLOG_ERROR("Failed to xrl handler finder://%s/%s", "ospfv2", "policy_redist4/0.1/delete_route4");
	}
	if (_cmds->add_handler("ospfv2/0.1/set_router_id",
	    callback(this, &XrlOspfv2TargetBase::handle_ospfv2_0_1_set_router_id)) == false) {
	    XLOG_ERROR("Failed to xrl handler finder://%s/%s", "ospfv2", "ospfv2/0.1/set_router_id");
	}
	if (_cmds->add_handler("ospfv2/0.1/set_rfc1583_compatibility",
	    callback(this, &XrlOspfv2TargetBase::handle_ospfv2_0_1_set_rfc1583_compatibility)) == false) {
	    XLOG_ERROR("Failed to xrl handler finder://%s/%s", "ospfv2", "ospfv2/0.1/set_rfc1583_compatibility");
	}
	if (_cmds->add_handler("ospfv2/0.1/set_ip_router_alert",
	    callback(this, &XrlOspfv2TargetBase::handle_ospfv2_0_1_set_ip_router_alert)) == false) {
	    XLOG_ERROR("Failed to xrl handler finder://%s/%s", "ospfv2", "ospfv2/0.1/set_ip_router_alert");
	}
	if (_cmds->add_handler("ospfv2/0.1/create_area_router",
	    callback(this, &XrlOspfv2TargetBase::handle_ospfv2_0_1_create_area_router)) == false) {
	    XLOG_ERROR("Failed to xrl handler finder://%s/%s", "ospfv2", "ospfv2/0.1/create_area_router");
	}
	if (_cmds->add_handler("ospfv2/0.1/change_area_router_type",
	    callback(this, &XrlOspfv2TargetBase::handle_ospfv2_0_1_change_area_router_type)) == false) {
	    XLOG_ERROR("Failed to xrl handler finder://%s/%s", "ospfv2", "ospfv2/0.1/change_area_router_type");
	}
	if (_cmds->add_handler("ospfv2/0.1/destroy_area_router",
	    callback(this, &XrlOspfv2TargetBase::handle_ospfv2_0_1_destroy_area_router)) == false) {
	    XLOG_ERROR("Failed to xrl handler finder://%s/%s", "ospfv2", "ospfv2/0.1/destroy_area_router");
	}
	if (_cmds->add_handler("ospfv2/0.1/create_peer",
	    callback(this, &XrlOspfv2TargetBase::handle_ospfv2_0_1_create_peer)) == false) {
	    XLOG_ERROR("Failed to xrl handler finder://%s/%s", "ospfv2", "ospfv2/0.1/create_peer");
	}
	if (_cmds->add_handler("ospfv2/0.1/delete_peer",
	    callback(this, &XrlOspfv2TargetBase::handle_ospfv2_0_1_delete_peer)) == false) {
	    XLOG_ERROR("Failed to xrl handler finder://%s/%s", "ospfv2", "ospfv2/0.1/delete_peer");
	}
	if (_cmds->add_handler("ospfv2/0.1/set_peer_state",
	    callback(this, &XrlOspfv2TargetBase::handle_ospfv2_0_1_set_peer_state)) == false) {
	    XLOG_ERROR("Failed to xrl handler finder://%s/%s", "ospfv2", "ospfv2/0.1/set_peer_state");
	}
	if (_cmds->add_handler("ospfv2/0.1/add_neighbour",
	    callback(this, &XrlOspfv2TargetBase::handle_ospfv2_0_1_add_neighbour)) == false) {
	    XLOG_ERROR("Failed to xrl handler finder://%s/%s", "ospfv2", "ospfv2/0.1/add_neighbour");
	}
	if (_cmds->add_handler("ospfv2/0.1/remove_neighbour",
	    callback(this, &XrlOspfv2TargetBase::handle_ospfv2_0_1_remove_neighbour)) == false) {
	    XLOG_ERROR("Failed to xrl handler finder://%s/%s", "ospfv2", "ospfv2/0.1/remove_neighbour");
	}
	if (_cmds->add_handler("ospfv2/0.1/create_virtual_link",
	    callback(this, &XrlOspfv2TargetBase::handle_ospfv2_0_1_create_virtual_link)) == false) {
	    XLOG_ERROR("Failed to xrl handler finder://%s/%s", "ospfv2", "ospfv2/0.1/create_virtual_link");
	}
	if (_cmds->add_handler("ospfv2/0.1/delete_virtual_link",
	    callback(this, &XrlOspfv2TargetBase::handle_ospfv2_0_1_delete_virtual_link)) == false) {
	    XLOG_ERROR("Failed to xrl handler finder://%s/%s", "ospfv2", "ospfv2/0.1/delete_virtual_link");
	}
	if (_cmds->add_handler("ospfv2/0.1/transit_area_virtual_link",
	    callback(this, &XrlOspfv2TargetBase::handle_ospfv2_0_1_transit_area_virtual_link)) == false) {
	    XLOG_ERROR("Failed to xrl handler finder://%s/%s", "ospfv2", "ospfv2/0.1/transit_area_virtual_link");
	}
	if (_cmds->add_handler("ospfv2/0.1/set_interface_cost",
	    callback(this, &XrlOspfv2TargetBase::handle_ospfv2_0_1_set_interface_cost)) == false) {
	    XLOG_ERROR("Failed to xrl handler finder://%s/%s", "ospfv2", "ospfv2/0.1/set_interface_cost");
	}
	if (_cmds->add_handler("ospfv2/0.1/set_retransmit_interval",
	    callback(this, &XrlOspfv2TargetBase::handle_ospfv2_0_1_set_retransmit_interval)) == false) {
	    XLOG_ERROR("Failed to xrl handler finder://%s/%s", "ospfv2", "ospfv2/0.1/set_retransmit_interval");
	}
	if (_cmds->add_handler("ospfv2/0.1/set_inftransdelay",
	    callback(this, &XrlOspfv2TargetBase::handle_ospfv2_0_1_set_inftransdelay)) == false) {
	    XLOG_ERROR("Failed to xrl handler finder://%s/%s", "ospfv2", "ospfv2/0.1/set_inftransdelay");
	}
	if (_cmds->add_handler("ospfv2/0.1/set_router_priority",
	    callback(this, &XrlOspfv2TargetBase::handle_ospfv2_0_1_set_router_priority)) == false) {
	    XLOG_ERROR("Failed to xrl handler finder://%s/%s", "ospfv2", "ospfv2/0.1/set_router_priority");
	}
	if (_cmds->add_handler("ospfv2/0.1/set_hello_interval",
	    callback(this, &XrlOspfv2TargetBase::handle_ospfv2_0_1_set_hello_interval)) == false) {
	    XLOG_ERROR("Failed to xrl handler finder://%s/%s", "ospfv2", "ospfv2/0.1/set_hello_interval");
	}
	if (_cmds->add_handler("ospfv2/0.1/set_router_dead_interval",
	    callback(this, &XrlOspfv2TargetBase::handle_ospfv2_0_1_set_router_dead_interval)) == false) {
	    XLOG_ERROR("Failed to xrl handler finder://%s/%s", "ospfv2", "ospfv2/0.1/set_router_dead_interval");
	}
	if (_cmds->add_handler("ospfv2/0.1/set_simple_authentication_key",
	    callback(this, &XrlOspfv2TargetBase::handle_ospfv2_0_1_set_simple_authentication_key)) == false) {
	    XLOG_ERROR("Failed to xrl handler finder://%s/%s", "ospfv2", "ospfv2/0.1/set_simple_authentication_key");
	}
	if (_cmds->add_handler("ospfv2/0.1/delete_simple_authentication_key",
	    callback(this, &XrlOspfv2TargetBase::handle_ospfv2_0_1_delete_simple_authentication_key)) == false) {
	    XLOG_ERROR("Failed to xrl handler finder://%s/%s", "ospfv2", "ospfv2/0.1/delete_simple_authentication_key");
	}
	if (_cmds->add_handler("ospfv2/0.1/set_md5_authentication_key",
	    callback(this, &XrlOspfv2TargetBase::handle_ospfv2_0_1_set_md5_authentication_key)) == false) {
	    XLOG_ERROR("Failed to xrl handler finder://%s/%s", "ospfv2", "ospfv2/0.1/set_md5_authentication_key");
	}
	if (_cmds->add_handler("ospfv2/0.1/delete_md5_authentication_key",
	    callback(this, &XrlOspfv2TargetBase::handle_ospfv2_0_1_delete_md5_authentication_key)) == false) {
	    XLOG_ERROR("Failed to xrl handler finder://%s/%s", "ospfv2", "ospfv2/0.1/delete_md5_authentication_key");
	}
	if (_cmds->add_handler("ospfv2/0.1/set_passive",
	    callback(this, &XrlOspfv2TargetBase::handle_ospfv2_0_1_set_passive)) == false) {
	    XLOG_ERROR("Failed to xrl handler finder://%s/%s", "ospfv2", "ospfv2/0.1/set_passive");
	}
	if (_cmds->add_handler("ospfv2/0.1/originate_default_route",
	    callback(this, &XrlOspfv2TargetBase::handle_ospfv2_0_1_originate_default_route)) == false) {
	    XLOG_ERROR("Failed to xrl handler finder://%s/%s", "ospfv2", "ospfv2/0.1/originate_default_route");
	}
	if (_cmds->add_handler("ospfv2/0.1/stub_default_cost",
	    callback(this, &XrlOspfv2TargetBase::handle_ospfv2_0_1_stub_default_cost)) == false) {
	    XLOG_ERROR("Failed to xrl handler finder://%s/%s", "ospfv2", "ospfv2/0.1/stub_default_cost");
	}
	if (_cmds->add_handler("ospfv2/0.1/summaries",
	    callback(this, &XrlOspfv2TargetBase::handle_ospfv2_0_1_summaries)) == false) {
	    XLOG_ERROR("Failed to xrl handler finder://%s/%s", "ospfv2", "ospfv2/0.1/summaries");
	}
	if (_cmds->add_handler("ospfv2/0.1/area_range_add",
	    callback(this, &XrlOspfv2TargetBase::handle_ospfv2_0_1_area_range_add)) == false) {
	    XLOG_ERROR("Failed to xrl handler finder://%s/%s", "ospfv2", "ospfv2/0.1/area_range_add");
	}
	if (_cmds->add_handler("ospfv2/0.1/area_range_delete",
	    callback(this, &XrlOspfv2TargetBase::handle_ospfv2_0_1_area_range_delete)) == false) {
	    XLOG_ERROR("Failed to xrl handler finder://%s/%s", "ospfv2", "ospfv2/0.1/area_range_delete");
	}
	if (_cmds->add_handler("ospfv2/0.1/area_range_change_state",
	    callback(this, &XrlOspfv2TargetBase::handle_ospfv2_0_1_area_range_change_state)) == false) {
	    XLOG_ERROR("Failed to xrl handler finder://%s/%s", "ospfv2", "ospfv2/0.1/area_range_change_state");
	}
	if (_cmds->add_handler("ospfv2/0.1/trace",
	    callback(this, &XrlOspfv2TargetBase::handle_ospfv2_0_1_trace)) == false) {
	    XLOG_ERROR("Failed to xrl handler finder://%s/%s", "ospfv2", "ospfv2/0.1/trace");
	}
	if (_cmds->add_handler("ospfv2/0.1/get_lsa",
	    callback(this, &XrlOspfv2TargetBase::handle_ospfv2_0_1_get_lsa)) == false) {
	    XLOG_ERROR("Failed to xrl handler finder://%s/%s", "ospfv2", "ospfv2/0.1/get_lsa");
	}
	if (_cmds->add_handler("ospfv2/0.1/get_area_list",
	    callback(this, &XrlOspfv2TargetBase::handle_ospfv2_0_1_get_area_list)) == false) {
	    XLOG_ERROR("Failed to xrl handler finder://%s/%s", "ospfv2", "ospfv2/0.1/get_area_list");
	}
	if (_cmds->add_handler("ospfv2/0.1/get_neighbour_list",
	    callback(this, &XrlOspfv2TargetBase::handle_ospfv2_0_1_get_neighbour_list)) == false) {
	    XLOG_ERROR("Failed to xrl handler finder://%s/%s", "ospfv2", "ospfv2/0.1/get_neighbour_list");
	}
	if (_cmds->add_handler("ospfv2/0.1/get_neighbour_info",
	    callback(this, &XrlOspfv2TargetBase::handle_ospfv2_0_1_get_neighbour_info)) == false) {
	    XLOG_ERROR("Failed to xrl handler finder://%s/%s", "ospfv2", "ospfv2/0.1/get_neighbour_info");
	}
	_cmds->finalize();
}

void
XrlOspfv2TargetBase::remove_handlers()
{
	_cmds->remove_handler("common/0.1/get_target_name");
	_cmds->remove_handler("common/0.1/get_version");
	_cmds->remove_handler("common/0.1/get_status");
	_cmds->remove_handler("common/0.1/shutdown");
	_cmds->remove_handler("raw_packet4_client/0.1/recv");
	_cmds->remove_handler("policy_backend/0.1/configure");
	_cmds->remove_handler("policy_backend/0.1/reset");
	_cmds->remove_handler("policy_backend/0.1/push_routes");
	_cmds->remove_handler("policy_redist4/0.1/add_route4");
	_cmds->remove_handler("policy_redist4/0.1/delete_route4");
	_cmds->remove_handler("ospfv2/0.1/set_router_id");
	_cmds->remove_handler("ospfv2/0.1/set_rfc1583_compatibility");
	_cmds->remove_handler("ospfv2/0.1/set_ip_router_alert");
	_cmds->remove_handler("ospfv2/0.1/create_area_router");
	_cmds->remove_handler("ospfv2/0.1/change_area_router_type");
	_cmds->remove_handler("ospfv2/0.1/destroy_area_router");
	_cmds->remove_handler("ospfv2/0.1/create_peer");
	_cmds->remove_handler("ospfv2/0.1/delete_peer");
	_cmds->remove_handler("ospfv2/0.1/set_peer_state");
	_cmds->remove_handler("ospfv2/0.1/add_neighbour");
	_cmds->remove_handler("ospfv2/0.1/remove_neighbour");
	_cmds->remove_handler("ospfv2/0.1/create_virtual_link");
	_cmds->remove_handler("ospfv2/0.1/delete_virtual_link");
	_cmds->remove_handler("ospfv2/0.1/transit_area_virtual_link");
	_cmds->remove_handler("ospfv2/0.1/set_interface_cost");
	_cmds->remove_handler("ospfv2/0.1/set_retransmit_interval");
	_cmds->remove_handler("ospfv2/0.1/set_inftransdelay");
	_cmds->remove_handler("ospfv2/0.1/set_router_priority");
	_cmds->remove_handler("ospfv2/0.1/set_hello_interval");
	_cmds->remove_handler("ospfv2/0.1/set_router_dead_interval");
	_cmds->remove_handler("ospfv2/0.1/set_simple_authentication_key");
	_cmds->remove_handler("ospfv2/0.1/delete_simple_authentication_key");
	_cmds->remove_handler("ospfv2/0.1/set_md5_authentication_key");
	_cmds->remove_handler("ospfv2/0.1/delete_md5_authentication_key");
	_cmds->remove_handler("ospfv2/0.1/set_passive");
	_cmds->remove_handler("ospfv2/0.1/originate_default_route");
	_cmds->remove_handler("ospfv2/0.1/stub_default_cost");
	_cmds->remove_handler("ospfv2/0.1/summaries");
	_cmds->remove_handler("ospfv2/0.1/area_range_add");
	_cmds->remove_handler("ospfv2/0.1/area_range_delete");
	_cmds->remove_handler("ospfv2/0.1/area_range_change_state");
	_cmds->remove_handler("ospfv2/0.1/trace");
	_cmds->remove_handler("ospfv2/0.1/get_lsa");
	_cmds->remove_handler("ospfv2/0.1/get_area_list");
	_cmds->remove_handler("ospfv2/0.1/get_neighbour_list");
	_cmds->remove_handler("ospfv2/0.1/get_neighbour_info");
}
