/*
 * Copyright (c) 2001-2006 International Computer Science Institute
 * See LICENSE file for licensing, conditions, and warranties on use.
 *
 * DO NOT EDIT THIS FILE - IT IS PROGRAMMATICALLY GENERATED
 *
 * Generated by 'clnt-gen'.
 *
 * $XORP: xorp/xrl/interfaces/fea_rawpkt6_client_xif.hh,v 1.8 2006/06/15 06:02:43 pavlin Exp $
 */

#ifndef __XRL_INTERFACES_FEA_RAWPKT6_CLIENT_XIF_HH__
#define __XRL_INTERFACES_FEA_RAWPKT6_CLIENT_XIF_HH__

#undef XORP_LIBRARY_NAME
#define XORP_LIBRARY_NAME "XifFeaRawpkt6Client"

#include "libxorp/xlog.h"
#include "libxorp/callback.hh"

#include "libxipc/xrl.hh"
#include "libxipc/xrl_error.hh"
#include "libxipc/xrl_sender.hh"


class XrlRawPacket6ClientV0p1Client {
public:
    XrlRawPacket6ClientV0p1Client(XrlSender* s) : _sender(s) {}
    virtual ~XrlRawPacket6ClientV0p1Client() {}

    typedef XorpCallback1<void, const XrlError&>::RefPtr RecvCB;
    /**
     *  Send Xrl intended to:
     *
     *  Receive an IPv6 packet from a raw socket.
     *
     *  @param dst_xrl_target_name the Xrl target name of the destination.
     *
     *  @param if_name the interface name the packet arrived on.
     *
     *  @param vif_name the vif name the packet arrived on.
     *
     *  @param src_address the IP source address.
     *
     *  @param dst_address the IP destination address.
     *
     *  @param ip_protocol the IP protocol number.
     *
     *  @param ip_ttl the IP TTL (hop-limit). If it has a negative value, then
     *  the received value is unknown.
     *
     *  @param ip_tos the Type Of Service (IP traffic class for IPv4). If it
     *  has a negative value, then the received value is unknown.
     *
     *  @param ip_router_alert if true, the IP Router Alert option was included
     *  in the IP packet.
     *
     *  @param ext_headers_type a list of u32 integers with the types of the
     *  optional extention headers.
     *
     *  @param ext_headers_payload a list of payload data, one for each
     *  optional extention header. The number of entries must match
     *  ext_headers_type.
     */
    bool send_recv(
	const char*	dst_xrl_target_name,
	const string&	if_name,
	const string&	vif_name,
	const IPv6&	src_address,
	const IPv6&	dst_address,
	const uint32_t&	ip_protocol,
	const int32_t&	ip_ttl,
	const int32_t&	ip_tos,
	const bool&	ip_router_alert,
	const XrlAtomList&	ext_headers_type,
	const XrlAtomList&	ext_headers_payload,
	const vector<uint8_t>&	payload,
	const RecvCB&	cb
    );

protected:
    XrlSender* _sender;

private:
    void unmarshall_recv(
	const XrlError&	e,
	XrlArgs*	a,
	RecvCB		cb
    );

};

#endif /* __XRL_INTERFACES_FEA_RAWPKT6_CLIENT_XIF_HH__ */
