/*
 * Copyright (c) 2001-2005 International Computer Science Institute
 * See LICENSE file for licensing, conditions, and warranties on use.
 *
 * DO NOT EDIT THIS FILE - IT IS PROGRAMMATICALLY GENERATED
 *
 * Generated by 'clnt-gen'.
 */

#ident "$XORP: xorp/xrl/interfaces/ospf_xif.cc,v 1.13 2005/03/25 02:54:50 pavlin Exp $"

#include "ospf_xif.hh"

bool
XrlOspfV0p1Client::send_set_router_id(
	const char*	the_tgt,
	const uint32_t&	id,
	const SetRouterIdCB&	cb
)
{
    Xrl x(the_tgt, "ospf/0.1/set_router_id");
    x.args().add("id", id);
    return _sender->send(x, callback(this, &XrlOspfV0p1Client::unmarshall_set_router_id, cb));
}


/* Unmarshall set_router_id */
void
XrlOspfV0p1Client::unmarshall_set_router_id(
	const XrlError&	e,
	XrlArgs*	a,
	SetRouterIdCB		cb
)
{
    if (e != XrlError::OKAY()) {
	cb->dispatch(e);
	return;
    } else if (a && a->size() != 0) {
	XLOG_ERROR("Wrong number of arguments (%u != %u)", XORP_UINT_CAST(a->size()), XORP_UINT_CAST(0));
	cb->dispatch(XrlError::BAD_ARGS());
	return;
    }
    cb->dispatch(e);
}

bool
XrlOspfV0p1Client::send_get_router_id(
	const char*	the_tgt,
	const GetRouterIdCB&	cb
)
{
    Xrl x(the_tgt, "ospf/0.1/get_router_id");
    return _sender->send(x, callback(this, &XrlOspfV0p1Client::unmarshall_get_router_id, cb));
}


/* Unmarshall get_router_id */
void
XrlOspfV0p1Client::unmarshall_get_router_id(
	const XrlError&	e,
	XrlArgs*	a,
	GetRouterIdCB		cb
)
{
    if (e != XrlError::OKAY()) {
	cb->dispatch(e, 0);
	return;
    } else if (a && a->size() != 1) {
	XLOG_ERROR("Wrong number of arguments (%u != %u)", XORP_UINT_CAST(a->size()), XORP_UINT_CAST(1));
	cb->dispatch(XrlError::BAD_ARGS(), 0);
	return;
    }
    uint32_t id;
    try {
	a->get("id", id);
    } catch (const XrlArgs::XrlAtomNotFound&) {
	XLOG_ERROR("Atom not found");
	cb->dispatch(XrlError::BAD_ARGS(), 0);
	return;
    }
    cb->dispatch(e, &id);
}

bool
XrlOspfV0p1Client::send_set_lsdb_limit(
	const char*	the_tgt,
	const int32_t&	limit,
	const SetLsdbLimitCB&	cb
)
{
    Xrl x(the_tgt, "ospf/0.1/set_lsdb_limit");
    x.args().add("limit", limit);
    return _sender->send(x, callback(this, &XrlOspfV0p1Client::unmarshall_set_lsdb_limit, cb));
}


/* Unmarshall set_lsdb_limit */
void
XrlOspfV0p1Client::unmarshall_set_lsdb_limit(
	const XrlError&	e,
	XrlArgs*	a,
	SetLsdbLimitCB		cb
)
{
    if (e != XrlError::OKAY()) {
	cb->dispatch(e);
	return;
    } else if (a && a->size() != 0) {
	XLOG_ERROR("Wrong number of arguments (%u != %u)", XORP_UINT_CAST(a->size()), XORP_UINT_CAST(0));
	cb->dispatch(XrlError::BAD_ARGS());
	return;
    }
    cb->dispatch(e);
}

bool
XrlOspfV0p1Client::send_get_lsdb_limit(
	const char*	the_tgt,
	const GetLsdbLimitCB&	cb
)
{
    Xrl x(the_tgt, "ospf/0.1/get_lsdb_limit");
    return _sender->send(x, callback(this, &XrlOspfV0p1Client::unmarshall_get_lsdb_limit, cb));
}


/* Unmarshall get_lsdb_limit */
void
XrlOspfV0p1Client::unmarshall_get_lsdb_limit(
	const XrlError&	e,
	XrlArgs*	a,
	GetLsdbLimitCB		cb
)
{
    if (e != XrlError::OKAY()) {
	cb->dispatch(e, 0);
	return;
    } else if (a && a->size() != 1) {
	XLOG_ERROR("Wrong number of arguments (%u != %u)", XORP_UINT_CAST(a->size()), XORP_UINT_CAST(1));
	cb->dispatch(XrlError::BAD_ARGS(), 0);
	return;
    }
    int32_t limit;
    try {
	a->get("limit", limit);
    } catch (const XrlArgs::XrlAtomNotFound&) {
	XLOG_ERROR("Atom not found");
	cb->dispatch(XrlError::BAD_ARGS(), 0);
	return;
    }
    cb->dispatch(e, &limit);
}

bool
XrlOspfV0p1Client::send_set_mospf(
	const char*	the_tgt,
	const bool&	enabled,
	const SetMospfCB&	cb
)
{
    Xrl x(the_tgt, "ospf/0.1/set_mospf");
    x.args().add("enabled", enabled);
    return _sender->send(x, callback(this, &XrlOspfV0p1Client::unmarshall_set_mospf, cb));
}


/* Unmarshall set_mospf */
void
XrlOspfV0p1Client::unmarshall_set_mospf(
	const XrlError&	e,
	XrlArgs*	a,
	SetMospfCB		cb
)
{
    if (e != XrlError::OKAY()) {
	cb->dispatch(e);
	return;
    } else if (a && a->size() != 0) {
	XLOG_ERROR("Wrong number of arguments (%u != %u)", XORP_UINT_CAST(a->size()), XORP_UINT_CAST(0));
	cb->dispatch(XrlError::BAD_ARGS());
	return;
    }
    cb->dispatch(e);
}

bool
XrlOspfV0p1Client::send_get_mospf(
	const char*	the_tgt,
	const GetMospfCB&	cb
)
{
    Xrl x(the_tgt, "ospf/0.1/get_mospf");
    return _sender->send(x, callback(this, &XrlOspfV0p1Client::unmarshall_get_mospf, cb));
}


/* Unmarshall get_mospf */
void
XrlOspfV0p1Client::unmarshall_get_mospf(
	const XrlError&	e,
	XrlArgs*	a,
	GetMospfCB		cb
)
{
    if (e != XrlError::OKAY()) {
	cb->dispatch(e, 0);
	return;
    } else if (a && a->size() != 1) {
	XLOG_ERROR("Wrong number of arguments (%u != %u)", XORP_UINT_CAST(a->size()), XORP_UINT_CAST(1));
	cb->dispatch(XrlError::BAD_ARGS(), 0);
	return;
    }
    bool enabled;
    try {
	a->get("enabled", enabled);
    } catch (const XrlArgs::XrlAtomNotFound&) {
	XLOG_ERROR("Atom not found");
	cb->dispatch(XrlError::BAD_ARGS(), 0);
	return;
    }
    cb->dispatch(e, &enabled);
}

bool
XrlOspfV0p1Client::send_set_interarea_mc(
	const char*	the_tgt,
	const bool&	enabled,
	const SetInterareaMcCB&	cb
)
{
    Xrl x(the_tgt, "ospf/0.1/set_interarea_mc");
    x.args().add("enabled", enabled);
    return _sender->send(x, callback(this, &XrlOspfV0p1Client::unmarshall_set_interarea_mc, cb));
}


/* Unmarshall set_interarea_mc */
void
XrlOspfV0p1Client::unmarshall_set_interarea_mc(
	const XrlError&	e,
	XrlArgs*	a,
	SetInterareaMcCB		cb
)
{
    if (e != XrlError::OKAY()) {
	cb->dispatch(e);
	return;
    } else if (a && a->size() != 0) {
	XLOG_ERROR("Wrong number of arguments (%u != %u)", XORP_UINT_CAST(a->size()), XORP_UINT_CAST(0));
	cb->dispatch(XrlError::BAD_ARGS());
	return;
    }
    cb->dispatch(e);
}

bool
XrlOspfV0p1Client::send_get_interarea_mc(
	const char*	the_tgt,
	const GetInterareaMcCB&	cb
)
{
    Xrl x(the_tgt, "ospf/0.1/get_interarea_mc");
    return _sender->send(x, callback(this, &XrlOspfV0p1Client::unmarshall_get_interarea_mc, cb));
}


/* Unmarshall get_interarea_mc */
void
XrlOspfV0p1Client::unmarshall_get_interarea_mc(
	const XrlError&	e,
	XrlArgs*	a,
	GetInterareaMcCB		cb
)
{
    if (e != XrlError::OKAY()) {
	cb->dispatch(e, 0);
	return;
    } else if (a && a->size() != 1) {
	XLOG_ERROR("Wrong number of arguments (%u != %u)", XORP_UINT_CAST(a->size()), XORP_UINT_CAST(1));
	cb->dispatch(XrlError::BAD_ARGS(), 0);
	return;
    }
    bool enabled;
    try {
	a->get("enabled", enabled);
    } catch (const XrlArgs::XrlAtomNotFound&) {
	XLOG_ERROR("Atom not found");
	cb->dispatch(XrlError::BAD_ARGS(), 0);
	return;
    }
    cb->dispatch(e, &enabled);
}

bool
XrlOspfV0p1Client::send_set_overflow_interval(
	const char*	the_tgt,
	const int32_t&	ovfl_int,
	const SetOverflowIntervalCB&	cb
)
{
    Xrl x(the_tgt, "ospf/0.1/set_overflow_interval");
    x.args().add("ovfl_int", ovfl_int);
    return _sender->send(x, callback(this, &XrlOspfV0p1Client::unmarshall_set_overflow_interval, cb));
}


/* Unmarshall set_overflow_interval */
void
XrlOspfV0p1Client::unmarshall_set_overflow_interval(
	const XrlError&	e,
	XrlArgs*	a,
	SetOverflowIntervalCB		cb
)
{
    if (e != XrlError::OKAY()) {
	cb->dispatch(e);
	return;
    } else if (a && a->size() != 0) {
	XLOG_ERROR("Wrong number of arguments (%u != %u)", XORP_UINT_CAST(a->size()), XORP_UINT_CAST(0));
	cb->dispatch(XrlError::BAD_ARGS());
	return;
    }
    cb->dispatch(e);
}

bool
XrlOspfV0p1Client::send_get_overflow_interval(
	const char*	the_tgt,
	const GetOverflowIntervalCB&	cb
)
{
    Xrl x(the_tgt, "ospf/0.1/get_overflow_interval");
    return _sender->send(x, callback(this, &XrlOspfV0p1Client::unmarshall_get_overflow_interval, cb));
}


/* Unmarshall get_overflow_interval */
void
XrlOspfV0p1Client::unmarshall_get_overflow_interval(
	const XrlError&	e,
	XrlArgs*	a,
	GetOverflowIntervalCB		cb
)
{
    if (e != XrlError::OKAY()) {
	cb->dispatch(e, 0);
	return;
    } else if (a && a->size() != 1) {
	XLOG_ERROR("Wrong number of arguments (%u != %u)", XORP_UINT_CAST(a->size()), XORP_UINT_CAST(1));
	cb->dispatch(XrlError::BAD_ARGS(), 0);
	return;
    }
    int32_t ovfl_int;
    try {
	a->get("ovfl_int", ovfl_int);
    } catch (const XrlArgs::XrlAtomNotFound&) {
	XLOG_ERROR("Atom not found");
	cb->dispatch(XrlError::BAD_ARGS(), 0);
	return;
    }
    cb->dispatch(e, &ovfl_int);
}

bool
XrlOspfV0p1Client::send_set_flood_rate(
	const char*	the_tgt,
	const int32_t&	rate,
	const SetFloodRateCB&	cb
)
{
    Xrl x(the_tgt, "ospf/0.1/set_flood_rate");
    x.args().add("rate", rate);
    return _sender->send(x, callback(this, &XrlOspfV0p1Client::unmarshall_set_flood_rate, cb));
}


/* Unmarshall set_flood_rate */
void
XrlOspfV0p1Client::unmarshall_set_flood_rate(
	const XrlError&	e,
	XrlArgs*	a,
	SetFloodRateCB		cb
)
{
    if (e != XrlError::OKAY()) {
	cb->dispatch(e);
	return;
    } else if (a && a->size() != 0) {
	XLOG_ERROR("Wrong number of arguments (%u != %u)", XORP_UINT_CAST(a->size()), XORP_UINT_CAST(0));
	cb->dispatch(XrlError::BAD_ARGS());
	return;
    }
    cb->dispatch(e);
}

bool
XrlOspfV0p1Client::send_get_flood_rate(
	const char*	the_tgt,
	const GetFloodRateCB&	cb
)
{
    Xrl x(the_tgt, "ospf/0.1/get_flood_rate");
    return _sender->send(x, callback(this, &XrlOspfV0p1Client::unmarshall_get_flood_rate, cb));
}


/* Unmarshall get_flood_rate */
void
XrlOspfV0p1Client::unmarshall_get_flood_rate(
	const XrlError&	e,
	XrlArgs*	a,
	GetFloodRateCB		cb
)
{
    if (e != XrlError::OKAY()) {
	cb->dispatch(e, 0);
	return;
    } else if (a && a->size() != 1) {
	XLOG_ERROR("Wrong number of arguments (%u != %u)", XORP_UINT_CAST(a->size()), XORP_UINT_CAST(1));
	cb->dispatch(XrlError::BAD_ARGS(), 0);
	return;
    }
    int32_t rate;
    try {
	a->get("rate", rate);
    } catch (const XrlArgs::XrlAtomNotFound&) {
	XLOG_ERROR("Atom not found");
	cb->dispatch(XrlError::BAD_ARGS(), 0);
	return;
    }
    cb->dispatch(e, &rate);
}

bool
XrlOspfV0p1Client::send_set_max_rxmt_window(
	const char*	the_tgt,
	const uint32_t&	window,
	const SetMaxRxmtWindowCB&	cb
)
{
    Xrl x(the_tgt, "ospf/0.1/set_max_rxmt_window");
    x.args().add("window", window);
    return _sender->send(x, callback(this, &XrlOspfV0p1Client::unmarshall_set_max_rxmt_window, cb));
}


/* Unmarshall set_max_rxmt_window */
void
XrlOspfV0p1Client::unmarshall_set_max_rxmt_window(
	const XrlError&	e,
	XrlArgs*	a,
	SetMaxRxmtWindowCB		cb
)
{
    if (e != XrlError::OKAY()) {
	cb->dispatch(e);
	return;
    } else if (a && a->size() != 0) {
	XLOG_ERROR("Wrong number of arguments (%u != %u)", XORP_UINT_CAST(a->size()), XORP_UINT_CAST(0));
	cb->dispatch(XrlError::BAD_ARGS());
	return;
    }
    cb->dispatch(e);
}

bool
XrlOspfV0p1Client::send_get_max_rxmt_window(
	const char*	the_tgt,
	const GetMaxRxmtWindowCB&	cb
)
{
    Xrl x(the_tgt, "ospf/0.1/get_max_rxmt_window");
    return _sender->send(x, callback(this, &XrlOspfV0p1Client::unmarshall_get_max_rxmt_window, cb));
}


/* Unmarshall get_max_rxmt_window */
void
XrlOspfV0p1Client::unmarshall_get_max_rxmt_window(
	const XrlError&	e,
	XrlArgs*	a,
	GetMaxRxmtWindowCB		cb
)
{
    if (e != XrlError::OKAY()) {
	cb->dispatch(e, 0);
	return;
    } else if (a && a->size() != 1) {
	XLOG_ERROR("Wrong number of arguments (%u != %u)", XORP_UINT_CAST(a->size()), XORP_UINT_CAST(1));
	cb->dispatch(XrlError::BAD_ARGS(), 0);
	return;
    }
    uint32_t window;
    try {
	a->get("window", window);
    } catch (const XrlArgs::XrlAtomNotFound&) {
	XLOG_ERROR("Atom not found");
	cb->dispatch(XrlError::BAD_ARGS(), 0);
	return;
    }
    cb->dispatch(e, &window);
}

bool
XrlOspfV0p1Client::send_set_max_dds(
	const char*	the_tgt,
	const uint32_t&	max_dds,
	const SetMaxDdsCB&	cb
)
{
    Xrl x(the_tgt, "ospf/0.1/set_max_dds");
    x.args().add("max_dds", max_dds);
    return _sender->send(x, callback(this, &XrlOspfV0p1Client::unmarshall_set_max_dds, cb));
}


/* Unmarshall set_max_dds */
void
XrlOspfV0p1Client::unmarshall_set_max_dds(
	const XrlError&	e,
	XrlArgs*	a,
	SetMaxDdsCB		cb
)
{
    if (e != XrlError::OKAY()) {
	cb->dispatch(e);
	return;
    } else if (a && a->size() != 0) {
	XLOG_ERROR("Wrong number of arguments (%u != %u)", XORP_UINT_CAST(a->size()), XORP_UINT_CAST(0));
	cb->dispatch(XrlError::BAD_ARGS());
	return;
    }
    cb->dispatch(e);
}

bool
XrlOspfV0p1Client::send_get_max_dds(
	const char*	the_tgt,
	const GetMaxDdsCB&	cb
)
{
    Xrl x(the_tgt, "ospf/0.1/get_max_dds");
    return _sender->send(x, callback(this, &XrlOspfV0p1Client::unmarshall_get_max_dds, cb));
}


/* Unmarshall get_max_dds */
void
XrlOspfV0p1Client::unmarshall_get_max_dds(
	const XrlError&	e,
	XrlArgs*	a,
	GetMaxDdsCB		cb
)
{
    if (e != XrlError::OKAY()) {
	cb->dispatch(e, 0);
	return;
    } else if (a && a->size() != 1) {
	XLOG_ERROR("Wrong number of arguments (%u != %u)", XORP_UINT_CAST(a->size()), XORP_UINT_CAST(1));
	cb->dispatch(XrlError::BAD_ARGS(), 0);
	return;
    }
    uint32_t max_dds;
    try {
	a->get("max_dds", max_dds);
    } catch (const XrlArgs::XrlAtomNotFound&) {
	XLOG_ERROR("Atom not found");
	cb->dispatch(XrlError::BAD_ARGS(), 0);
	return;
    }
    cb->dispatch(e, &max_dds);
}

bool
XrlOspfV0p1Client::send_set_lsa_refresh_rate(
	const char*	the_tgt,
	const uint32_t&	rate,
	const SetLsaRefreshRateCB&	cb
)
{
    Xrl x(the_tgt, "ospf/0.1/set_lsa_refresh_rate");
    x.args().add("rate", rate);
    return _sender->send(x, callback(this, &XrlOspfV0p1Client::unmarshall_set_lsa_refresh_rate, cb));
}


/* Unmarshall set_lsa_refresh_rate */
void
XrlOspfV0p1Client::unmarshall_set_lsa_refresh_rate(
	const XrlError&	e,
	XrlArgs*	a,
	SetLsaRefreshRateCB		cb
)
{
    if (e != XrlError::OKAY()) {
	cb->dispatch(e);
	return;
    } else if (a && a->size() != 0) {
	XLOG_ERROR("Wrong number of arguments (%u != %u)", XORP_UINT_CAST(a->size()), XORP_UINT_CAST(0));
	cb->dispatch(XrlError::BAD_ARGS());
	return;
    }
    cb->dispatch(e);
}

bool
XrlOspfV0p1Client::send_get_lsa_refresh_rate(
	const char*	the_tgt,
	const GetLsaRefreshRateCB&	cb
)
{
    Xrl x(the_tgt, "ospf/0.1/get_lsa_refresh_rate");
    return _sender->send(x, callback(this, &XrlOspfV0p1Client::unmarshall_get_lsa_refresh_rate, cb));
}


/* Unmarshall get_lsa_refresh_rate */
void
XrlOspfV0p1Client::unmarshall_get_lsa_refresh_rate(
	const XrlError&	e,
	XrlArgs*	a,
	GetLsaRefreshRateCB		cb
)
{
    if (e != XrlError::OKAY()) {
	cb->dispatch(e, 0);
	return;
    } else if (a && a->size() != 1) {
	XLOG_ERROR("Wrong number of arguments (%u != %u)", XORP_UINT_CAST(a->size()), XORP_UINT_CAST(1));
	cb->dispatch(XrlError::BAD_ARGS(), 0);
	return;
    }
    uint32_t rate;
    try {
	a->get("rate", rate);
    } catch (const XrlArgs::XrlAtomNotFound&) {
	XLOG_ERROR("Atom not found");
	cb->dispatch(XrlError::BAD_ARGS(), 0);
	return;
    }
    cb->dispatch(e, &rate);
}

bool
XrlOspfV0p1Client::send_set_p2p_adj_limit(
	const char*	the_tgt,
	const uint32_t&	max_adj,
	const SetP2PAdjLimitCB&	cb
)
{
    Xrl x(the_tgt, "ospf/0.1/set_p2p_adj_limit");
    x.args().add("max_adj", max_adj);
    return _sender->send(x, callback(this, &XrlOspfV0p1Client::unmarshall_set_p2p_adj_limit, cb));
}


/* Unmarshall set_p2p_adj_limit */
void
XrlOspfV0p1Client::unmarshall_set_p2p_adj_limit(
	const XrlError&	e,
	XrlArgs*	a,
	SetP2PAdjLimitCB		cb
)
{
    if (e != XrlError::OKAY()) {
	cb->dispatch(e);
	return;
    } else if (a && a->size() != 0) {
	XLOG_ERROR("Wrong number of arguments (%u != %u)", XORP_UINT_CAST(a->size()), XORP_UINT_CAST(0));
	cb->dispatch(XrlError::BAD_ARGS());
	return;
    }
    cb->dispatch(e);
}

bool
XrlOspfV0p1Client::send_get_p2p_adj_limit(
	const char*	the_tgt,
	const GetP2PAdjLimitCB&	cb
)
{
    Xrl x(the_tgt, "ospf/0.1/get_p2p_adj_limit");
    return _sender->send(x, callback(this, &XrlOspfV0p1Client::unmarshall_get_p2p_adj_limit, cb));
}


/* Unmarshall get_p2p_adj_limit */
void
XrlOspfV0p1Client::unmarshall_get_p2p_adj_limit(
	const XrlError&	e,
	XrlArgs*	a,
	GetP2PAdjLimitCB		cb
)
{
    if (e != XrlError::OKAY()) {
	cb->dispatch(e, 0);
	return;
    } else if (a && a->size() != 1) {
	XLOG_ERROR("Wrong number of arguments (%u != %u)", XORP_UINT_CAST(a->size()), XORP_UINT_CAST(1));
	cb->dispatch(XrlError::BAD_ARGS(), 0);
	return;
    }
    uint32_t max_adj;
    try {
	a->get("max_adj", max_adj);
    } catch (const XrlArgs::XrlAtomNotFound&) {
	XLOG_ERROR("Atom not found");
	cb->dispatch(XrlError::BAD_ARGS(), 0);
	return;
    }
    cb->dispatch(e, &max_adj);
}

bool
XrlOspfV0p1Client::send_set_random_refresh(
	const char*	the_tgt,
	const bool&	enabled,
	const SetRandomRefreshCB&	cb
)
{
    Xrl x(the_tgt, "ospf/0.1/set_random_refresh");
    x.args().add("enabled", enabled);
    return _sender->send(x, callback(this, &XrlOspfV0p1Client::unmarshall_set_random_refresh, cb));
}


/* Unmarshall set_random_refresh */
void
XrlOspfV0p1Client::unmarshall_set_random_refresh(
	const XrlError&	e,
	XrlArgs*	a,
	SetRandomRefreshCB		cb
)
{
    if (e != XrlError::OKAY()) {
	cb->dispatch(e);
	return;
    } else if (a && a->size() != 0) {
	XLOG_ERROR("Wrong number of arguments (%u != %u)", XORP_UINT_CAST(a->size()), XORP_UINT_CAST(0));
	cb->dispatch(XrlError::BAD_ARGS());
	return;
    }
    cb->dispatch(e);
}

bool
XrlOspfV0p1Client::send_get_random_refresh(
	const char*	the_tgt,
	const GetRandomRefreshCB&	cb
)
{
    Xrl x(the_tgt, "ospf/0.1/get_random_refresh");
    return _sender->send(x, callback(this, &XrlOspfV0p1Client::unmarshall_get_random_refresh, cb));
}


/* Unmarshall get_random_refresh */
void
XrlOspfV0p1Client::unmarshall_get_random_refresh(
	const XrlError&	e,
	XrlArgs*	a,
	GetRandomRefreshCB		cb
)
{
    if (e != XrlError::OKAY()) {
	cb->dispatch(e, 0);
	return;
    } else if (a && a->size() != 1) {
	XLOG_ERROR("Wrong number of arguments (%u != %u)", XORP_UINT_CAST(a->size()), XORP_UINT_CAST(1));
	cb->dispatch(XrlError::BAD_ARGS(), 0);
	return;
    }
    bool enabled;
    try {
	a->get("enabled", enabled);
    } catch (const XrlArgs::XrlAtomNotFound&) {
	XLOG_ERROR("Atom not found");
	cb->dispatch(XrlError::BAD_ARGS(), 0);
	return;
    }
    cb->dispatch(e, &enabled);
}

bool
XrlOspfV0p1Client::send_add_or_configure_area(
	const char*	the_tgt,
	const uint32_t&	area_id,
	const bool&	is_stub,
	const uint32_t&	default_cost,
	const bool&	import_summary_routes,
	const AddOrConfigureAreaCB&	cb
)
{
    Xrl x(the_tgt, "ospf/0.1/add_or_configure_area");
    x.args().add("area_id", area_id);
    x.args().add("is_stub", is_stub);
    x.args().add("default_cost", default_cost);
    x.args().add("import_summary_routes", import_summary_routes);
    return _sender->send(x, callback(this, &XrlOspfV0p1Client::unmarshall_add_or_configure_area, cb));
}


/* Unmarshall add_or_configure_area */
void
XrlOspfV0p1Client::unmarshall_add_or_configure_area(
	const XrlError&	e,
	XrlArgs*	a,
	AddOrConfigureAreaCB		cb
)
{
    if (e != XrlError::OKAY()) {
	cb->dispatch(e);
	return;
    } else if (a && a->size() != 0) {
	XLOG_ERROR("Wrong number of arguments (%u != %u)", XORP_UINT_CAST(a->size()), XORP_UINT_CAST(0));
	cb->dispatch(XrlError::BAD_ARGS());
	return;
    }
    cb->dispatch(e);
}

bool
XrlOspfV0p1Client::send_delete_area(
	const char*	the_tgt,
	const uint32_t&	area_id,
	const DeleteAreaCB&	cb
)
{
    Xrl x(the_tgt, "ospf/0.1/delete_area");
    x.args().add("area_id", area_id);
    return _sender->send(x, callback(this, &XrlOspfV0p1Client::unmarshall_delete_area, cb));
}


/* Unmarshall delete_area */
void
XrlOspfV0p1Client::unmarshall_delete_area(
	const XrlError&	e,
	XrlArgs*	a,
	DeleteAreaCB		cb
)
{
    if (e != XrlError::OKAY()) {
	cb->dispatch(e);
	return;
    } else if (a && a->size() != 0) {
	XLOG_ERROR("Wrong number of arguments (%u != %u)", XORP_UINT_CAST(a->size()), XORP_UINT_CAST(0));
	cb->dispatch(XrlError::BAD_ARGS());
	return;
    }
    cb->dispatch(e);
}

bool
XrlOspfV0p1Client::send_query_area(
	const char*	the_tgt,
	const uint32_t&	area_id,
	const QueryAreaCB&	cb
)
{
    Xrl x(the_tgt, "ospf/0.1/query_area");
    x.args().add("area_id", area_id);
    return _sender->send(x, callback(this, &XrlOspfV0p1Client::unmarshall_query_area, cb));
}


/* Unmarshall query_area */
void
XrlOspfV0p1Client::unmarshall_query_area(
	const XrlError&	e,
	XrlArgs*	a,
	QueryAreaCB		cb
)
{
    if (e != XrlError::OKAY()) {
	cb->dispatch(e, 0, 0, 0);
	return;
    } else if (a && a->size() != 3) {
	XLOG_ERROR("Wrong number of arguments (%u != %u)", XORP_UINT_CAST(a->size()), XORP_UINT_CAST(3));
	cb->dispatch(XrlError::BAD_ARGS(), 0, 0, 0);
	return;
    }
    bool is_stub;
    uint32_t default_cost;
    bool import_summary_routes;
    try {
	a->get("is_stub", is_stub);
	a->get("default_cost", default_cost);
	a->get("import_summary_routes", import_summary_routes);
    } catch (const XrlArgs::XrlAtomNotFound&) {
	XLOG_ERROR("Atom not found");
	cb->dispatch(XrlError::BAD_ARGS(), 0, 0, 0);
	return;
    }
    cb->dispatch(e, &is_stub, &default_cost, &import_summary_routes);
}

bool
XrlOspfV0p1Client::send_list_area_ids(
	const char*	the_tgt,
	const ListAreaIdsCB&	cb
)
{
    Xrl x(the_tgt, "ospf/0.1/list_area_ids");
    return _sender->send(x, callback(this, &XrlOspfV0p1Client::unmarshall_list_area_ids, cb));
}


/* Unmarshall list_area_ids */
void
XrlOspfV0p1Client::unmarshall_list_area_ids(
	const XrlError&	e,
	XrlArgs*	a,
	ListAreaIdsCB		cb
)
{
    if (e != XrlError::OKAY()) {
	cb->dispatch(e, 0);
	return;
    } else if (a && a->size() != 1) {
	XLOG_ERROR("Wrong number of arguments (%u != %u)", XORP_UINT_CAST(a->size()), XORP_UINT_CAST(1));
	cb->dispatch(XrlError::BAD_ARGS(), 0);
	return;
    }
    XrlAtomList area_ids;
    try {
	a->get("area_ids", area_ids);
    } catch (const XrlArgs::XrlAtomNotFound&) {
	XLOG_ERROR("Atom not found");
	cb->dispatch(XrlError::BAD_ARGS(), 0);
	return;
    }
    cb->dispatch(e, &area_ids);
}

bool
XrlOspfV0p1Client::send_add_or_configure_aggregate(
	const char*	the_tgt,
	const uint32_t&	area_id,
	const IPv4&	network,
	const IPv4&	netmask,
	const bool&	suppress_advertisement,
	const AddOrConfigureAggregateCB&	cb
)
{
    Xrl x(the_tgt, "ospf/0.1/add_or_configure_aggregate");
    x.args().add("area_id", area_id);
    x.args().add("network", network);
    x.args().add("netmask", netmask);
    x.args().add("suppress_advertisement", suppress_advertisement);
    return _sender->send(x, callback(this, &XrlOspfV0p1Client::unmarshall_add_or_configure_aggregate, cb));
}


/* Unmarshall add_or_configure_aggregate */
void
XrlOspfV0p1Client::unmarshall_add_or_configure_aggregate(
	const XrlError&	e,
	XrlArgs*	a,
	AddOrConfigureAggregateCB		cb
)
{
    if (e != XrlError::OKAY()) {
	cb->dispatch(e);
	return;
    } else if (a && a->size() != 0) {
	XLOG_ERROR("Wrong number of arguments (%u != %u)", XORP_UINT_CAST(a->size()), XORP_UINT_CAST(0));
	cb->dispatch(XrlError::BAD_ARGS());
	return;
    }
    cb->dispatch(e);
}

bool
XrlOspfV0p1Client::send_delete_aggregate(
	const char*	the_tgt,
	const uint32_t&	area_id,
	const IPv4&	network,
	const IPv4&	netmask,
	const DeleteAggregateCB&	cb
)
{
    Xrl x(the_tgt, "ospf/0.1/delete_aggregate");
    x.args().add("area_id", area_id);
    x.args().add("network", network);
    x.args().add("netmask", netmask);
    return _sender->send(x, callback(this, &XrlOspfV0p1Client::unmarshall_delete_aggregate, cb));
}


/* Unmarshall delete_aggregate */
void
XrlOspfV0p1Client::unmarshall_delete_aggregate(
	const XrlError&	e,
	XrlArgs*	a,
	DeleteAggregateCB		cb
)
{
    if (e != XrlError::OKAY()) {
	cb->dispatch(e);
	return;
    } else if (a && a->size() != 0) {
	XLOG_ERROR("Wrong number of arguments (%u != %u)", XORP_UINT_CAST(a->size()), XORP_UINT_CAST(0));
	cb->dispatch(XrlError::BAD_ARGS());
	return;
    }
    cb->dispatch(e);
}

bool
XrlOspfV0p1Client::send_query_aggregate(
	const char*	the_tgt,
	const uint32_t&	area_id,
	const IPv4&	network,
	const IPv4&	netmask,
	const QueryAggregateCB&	cb
)
{
    Xrl x(the_tgt, "ospf/0.1/query_aggregate");
    x.args().add("area_id", area_id);
    x.args().add("network", network);
    x.args().add("netmask", netmask);
    return _sender->send(x, callback(this, &XrlOspfV0p1Client::unmarshall_query_aggregate, cb));
}


/* Unmarshall query_aggregate */
void
XrlOspfV0p1Client::unmarshall_query_aggregate(
	const XrlError&	e,
	XrlArgs*	a,
	QueryAggregateCB		cb
)
{
    if (e != XrlError::OKAY()) {
	cb->dispatch(e, 0);
	return;
    } else if (a && a->size() != 1) {
	XLOG_ERROR("Wrong number of arguments (%u != %u)", XORP_UINT_CAST(a->size()), XORP_UINT_CAST(1));
	cb->dispatch(XrlError::BAD_ARGS(), 0);
	return;
    }
    bool suppress_advertisement;
    try {
	a->get("suppress_advertisement", suppress_advertisement);
    } catch (const XrlArgs::XrlAtomNotFound&) {
	XLOG_ERROR("Atom not found");
	cb->dispatch(XrlError::BAD_ARGS(), 0);
	return;
    }
    cb->dispatch(e, &suppress_advertisement);
}

bool
XrlOspfV0p1Client::send_list_aggregates(
	const char*	the_tgt,
	const uint32_t&	area_id,
	const ListAggregatesCB&	cb
)
{
    Xrl x(the_tgt, "ospf/0.1/list_aggregates");
    x.args().add("area_id", area_id);
    return _sender->send(x, callback(this, &XrlOspfV0p1Client::unmarshall_list_aggregates, cb));
}


/* Unmarshall list_aggregates */
void
XrlOspfV0p1Client::unmarshall_list_aggregates(
	const XrlError&	e,
	XrlArgs*	a,
	ListAggregatesCB		cb
)
{
    if (e != XrlError::OKAY()) {
	cb->dispatch(e, 0, 0);
	return;
    } else if (a && a->size() != 2) {
	XLOG_ERROR("Wrong number of arguments (%u != %u)", XORP_UINT_CAST(a->size()), XORP_UINT_CAST(2));
	cb->dispatch(XrlError::BAD_ARGS(), 0, 0);
	return;
    }
    XrlAtomList networks;
    XrlAtomList netmasks;
    try {
	a->get("networks", networks);
	a->get("netmasks", netmasks);
    } catch (const XrlArgs::XrlAtomNotFound&) {
	XLOG_ERROR("Atom not found");
	cb->dispatch(XrlError::BAD_ARGS(), 0, 0);
	return;
    }
    cb->dispatch(e, &networks, &netmasks);
}

bool
XrlOspfV0p1Client::send_add_or_configure_host(
	const char*	the_tgt,
	const IPv4&	network,
	const IPv4&	netmask,
	const uint32_t&	area_id,
	const uint32_t&	cost,
	const AddOrConfigureHostCB&	cb
)
{
    Xrl x(the_tgt, "ospf/0.1/add_or_configure_host");
    x.args().add("network", network);
    x.args().add("netmask", netmask);
    x.args().add("area_id", area_id);
    x.args().add("cost", cost);
    return _sender->send(x, callback(this, &XrlOspfV0p1Client::unmarshall_add_or_configure_host, cb));
}


/* Unmarshall add_or_configure_host */
void
XrlOspfV0p1Client::unmarshall_add_or_configure_host(
	const XrlError&	e,
	XrlArgs*	a,
	AddOrConfigureHostCB		cb
)
{
    if (e != XrlError::OKAY()) {
	cb->dispatch(e);
	return;
    } else if (a && a->size() != 0) {
	XLOG_ERROR("Wrong number of arguments (%u != %u)", XORP_UINT_CAST(a->size()), XORP_UINT_CAST(0));
	cb->dispatch(XrlError::BAD_ARGS());
	return;
    }
    cb->dispatch(e);
}

bool
XrlOspfV0p1Client::send_delete_host(
	const char*	the_tgt,
	const IPv4&	network,
	const IPv4&	netmask,
	const uint32_t&	area_id,
	const DeleteHostCB&	cb
)
{
    Xrl x(the_tgt, "ospf/0.1/delete_host");
    x.args().add("network", network);
    x.args().add("netmask", netmask);
    x.args().add("area_id", area_id);
    return _sender->send(x, callback(this, &XrlOspfV0p1Client::unmarshall_delete_host, cb));
}


/* Unmarshall delete_host */
void
XrlOspfV0p1Client::unmarshall_delete_host(
	const XrlError&	e,
	XrlArgs*	a,
	DeleteHostCB		cb
)
{
    if (e != XrlError::OKAY()) {
	cb->dispatch(e);
	return;
    } else if (a && a->size() != 0) {
	XLOG_ERROR("Wrong number of arguments (%u != %u)", XORP_UINT_CAST(a->size()), XORP_UINT_CAST(0));
	cb->dispatch(XrlError::BAD_ARGS());
	return;
    }
    cb->dispatch(e);
}

bool
XrlOspfV0p1Client::send_query_host(
	const char*	the_tgt,
	const IPv4&	network,
	const IPv4&	netmask,
	const uint32_t&	area_id,
	const QueryHostCB&	cb
)
{
    Xrl x(the_tgt, "ospf/0.1/query_host");
    x.args().add("network", network);
    x.args().add("netmask", netmask);
    x.args().add("area_id", area_id);
    return _sender->send(x, callback(this, &XrlOspfV0p1Client::unmarshall_query_host, cb));
}


/* Unmarshall query_host */
void
XrlOspfV0p1Client::unmarshall_query_host(
	const XrlError&	e,
	XrlArgs*	a,
	QueryHostCB		cb
)
{
    if (e != XrlError::OKAY()) {
	cb->dispatch(e, 0);
	return;
    } else if (a && a->size() != 1) {
	XLOG_ERROR("Wrong number of arguments (%u != %u)", XORP_UINT_CAST(a->size()), XORP_UINT_CAST(1));
	cb->dispatch(XrlError::BAD_ARGS(), 0);
	return;
    }
    uint32_t cost;
    try {
	a->get("cost", cost);
    } catch (const XrlArgs::XrlAtomNotFound&) {
	XLOG_ERROR("Atom not found");
	cb->dispatch(XrlError::BAD_ARGS(), 0);
	return;
    }
    cb->dispatch(e, &cost);
}

bool
XrlOspfV0p1Client::send_list_hosts(
	const char*	the_tgt,
	const uint32_t&	area_id,
	const ListHostsCB&	cb
)
{
    Xrl x(the_tgt, "ospf/0.1/list_hosts");
    x.args().add("area_id", area_id);
    return _sender->send(x, callback(this, &XrlOspfV0p1Client::unmarshall_list_hosts, cb));
}


/* Unmarshall list_hosts */
void
XrlOspfV0p1Client::unmarshall_list_hosts(
	const XrlError&	e,
	XrlArgs*	a,
	ListHostsCB		cb
)
{
    if (e != XrlError::OKAY()) {
	cb->dispatch(e, 0, 0);
	return;
    } else if (a && a->size() != 2) {
	XLOG_ERROR("Wrong number of arguments (%u != %u)", XORP_UINT_CAST(a->size()), XORP_UINT_CAST(2));
	cb->dispatch(XrlError::BAD_ARGS(), 0, 0);
	return;
    }
    XrlAtomList networks;
    XrlAtomList netmasks;
    try {
	a->get("networks", networks);
	a->get("netmasks", netmasks);
    } catch (const XrlArgs::XrlAtomNotFound&) {
	XLOG_ERROR("Atom not found");
	cb->dispatch(XrlError::BAD_ARGS(), 0, 0);
	return;
    }
    cb->dispatch(e, &networks, &netmasks);
}

bool
XrlOspfV0p1Client::send_add_vlink(
	const char*	the_tgt,
	const uint32_t&	transit_area,
	const uint32_t&	neighbor_id,
	const AddVlinkCB&	cb
)
{
    Xrl x(the_tgt, "ospf/0.1/add_vlink");
    x.args().add("transit_area", transit_area);
    x.args().add("neighbor_id", neighbor_id);
    return _sender->send(x, callback(this, &XrlOspfV0p1Client::unmarshall_add_vlink, cb));
}


/* Unmarshall add_vlink */
void
XrlOspfV0p1Client::unmarshall_add_vlink(
	const XrlError&	e,
	XrlArgs*	a,
	AddVlinkCB		cb
)
{
    if (e != XrlError::OKAY()) {
	cb->dispatch(e);
	return;
    } else if (a && a->size() != 0) {
	XLOG_ERROR("Wrong number of arguments (%u != %u)", XORP_UINT_CAST(a->size()), XORP_UINT_CAST(0));
	cb->dispatch(XrlError::BAD_ARGS());
	return;
    }
    cb->dispatch(e);
}

bool
XrlOspfV0p1Client::send_delete_vlink(
	const char*	the_tgt,
	const uint32_t&	transit_area,
	const uint32_t&	neighbor_id,
	const DeleteVlinkCB&	cb
)
{
    Xrl x(the_tgt, "ospf/0.1/delete_vlink");
    x.args().add("transit_area", transit_area);
    x.args().add("neighbor_id", neighbor_id);
    return _sender->send(x, callback(this, &XrlOspfV0p1Client::unmarshall_delete_vlink, cb));
}


/* Unmarshall delete_vlink */
void
XrlOspfV0p1Client::unmarshall_delete_vlink(
	const XrlError&	e,
	XrlArgs*	a,
	DeleteVlinkCB		cb
)
{
    if (e != XrlError::OKAY()) {
	cb->dispatch(e);
	return;
    } else if (a && a->size() != 0) {
	XLOG_ERROR("Wrong number of arguments (%u != %u)", XORP_UINT_CAST(a->size()), XORP_UINT_CAST(0));
	cb->dispatch(XrlError::BAD_ARGS());
	return;
    }
    cb->dispatch(e);
}

bool
XrlOspfV0p1Client::send_vlink_set_transmit_delay(
	const char*	the_tgt,
	const uint32_t&	transit_area,
	const uint32_t&	neighbor_id,
	const uint32_t&	delay_secs,
	const VlinkSetTransmitDelayCB&	cb
)
{
    Xrl x(the_tgt, "ospf/0.1/vlink_set_transmit_delay");
    x.args().add("transit_area", transit_area);
    x.args().add("neighbor_id", neighbor_id);
    x.args().add("delay_secs", delay_secs);
    return _sender->send(x, callback(this, &XrlOspfV0p1Client::unmarshall_vlink_set_transmit_delay, cb));
}


/* Unmarshall vlink_set_transmit_delay */
void
XrlOspfV0p1Client::unmarshall_vlink_set_transmit_delay(
	const XrlError&	e,
	XrlArgs*	a,
	VlinkSetTransmitDelayCB		cb
)
{
    if (e != XrlError::OKAY()) {
	cb->dispatch(e);
	return;
    } else if (a && a->size() != 0) {
	XLOG_ERROR("Wrong number of arguments (%u != %u)", XORP_UINT_CAST(a->size()), XORP_UINT_CAST(0));
	cb->dispatch(XrlError::BAD_ARGS());
	return;
    }
    cb->dispatch(e);
}

bool
XrlOspfV0p1Client::send_vlink_get_transmit_delay(
	const char*	the_tgt,
	const uint32_t&	transit_area,
	const uint32_t&	neighbor_id,
	const VlinkGetTransmitDelayCB&	cb
)
{
    Xrl x(the_tgt, "ospf/0.1/vlink_get_transmit_delay");
    x.args().add("transit_area", transit_area);
    x.args().add("neighbor_id", neighbor_id);
    return _sender->send(x, callback(this, &XrlOspfV0p1Client::unmarshall_vlink_get_transmit_delay, cb));
}


/* Unmarshall vlink_get_transmit_delay */
void
XrlOspfV0p1Client::unmarshall_vlink_get_transmit_delay(
	const XrlError&	e,
	XrlArgs*	a,
	VlinkGetTransmitDelayCB		cb
)
{
    if (e != XrlError::OKAY()) {
	cb->dispatch(e, 0);
	return;
    } else if (a && a->size() != 1) {
	XLOG_ERROR("Wrong number of arguments (%u != %u)", XORP_UINT_CAST(a->size()), XORP_UINT_CAST(1));
	cb->dispatch(XrlError::BAD_ARGS(), 0);
	return;
    }
    uint32_t delay_secs;
    try {
	a->get("delay_secs", delay_secs);
    } catch (const XrlArgs::XrlAtomNotFound&) {
	XLOG_ERROR("Atom not found");
	cb->dispatch(XrlError::BAD_ARGS(), 0);
	return;
    }
    cb->dispatch(e, &delay_secs);
}

bool
XrlOspfV0p1Client::send_vlink_set_retransmit_interval(
	const char*	the_tgt,
	const uint32_t&	transit_area,
	const uint32_t&	neighbor_id,
	const uint32_t&	interval_secs,
	const VlinkSetRetransmitIntervalCB&	cb
)
{
    Xrl x(the_tgt, "ospf/0.1/vlink_set_retransmit_interval");
    x.args().add("transit_area", transit_area);
    x.args().add("neighbor_id", neighbor_id);
    x.args().add("interval_secs", interval_secs);
    return _sender->send(x, callback(this, &XrlOspfV0p1Client::unmarshall_vlink_set_retransmit_interval, cb));
}


/* Unmarshall vlink_set_retransmit_interval */
void
XrlOspfV0p1Client::unmarshall_vlink_set_retransmit_interval(
	const XrlError&	e,
	XrlArgs*	a,
	VlinkSetRetransmitIntervalCB		cb
)
{
    if (e != XrlError::OKAY()) {
	cb->dispatch(e);
	return;
    } else if (a && a->size() != 0) {
	XLOG_ERROR("Wrong number of arguments (%u != %u)", XORP_UINT_CAST(a->size()), XORP_UINT_CAST(0));
	cb->dispatch(XrlError::BAD_ARGS());
	return;
    }
    cb->dispatch(e);
}

bool
XrlOspfV0p1Client::send_vlink_get_retransmit_interval(
	const char*	the_tgt,
	const uint32_t&	transit_area,
	const uint32_t&	neighbor_id,
	const VlinkGetRetransmitIntervalCB&	cb
)
{
    Xrl x(the_tgt, "ospf/0.1/vlink_get_retransmit_interval");
    x.args().add("transit_area", transit_area);
    x.args().add("neighbor_id", neighbor_id);
    return _sender->send(x, callback(this, &XrlOspfV0p1Client::unmarshall_vlink_get_retransmit_interval, cb));
}


/* Unmarshall vlink_get_retransmit_interval */
void
XrlOspfV0p1Client::unmarshall_vlink_get_retransmit_interval(
	const XrlError&	e,
	XrlArgs*	a,
	VlinkGetRetransmitIntervalCB		cb
)
{
    if (e != XrlError::OKAY()) {
	cb->dispatch(e, 0);
	return;
    } else if (a && a->size() != 1) {
	XLOG_ERROR("Wrong number of arguments (%u != %u)", XORP_UINT_CAST(a->size()), XORP_UINT_CAST(1));
	cb->dispatch(XrlError::BAD_ARGS(), 0);
	return;
    }
    uint32_t interval_secs;
    try {
	a->get("interval_secs", interval_secs);
    } catch (const XrlArgs::XrlAtomNotFound&) {
	XLOG_ERROR("Atom not found");
	cb->dispatch(XrlError::BAD_ARGS(), 0);
	return;
    }
    cb->dispatch(e, &interval_secs);
}

bool
XrlOspfV0p1Client::send_vlink_set_hello_interval(
	const char*	the_tgt,
	const uint32_t&	transit_area,
	const uint32_t&	neighbor_id,
	const uint32_t&	interval_secs,
	const VlinkSetHelloIntervalCB&	cb
)
{
    Xrl x(the_tgt, "ospf/0.1/vlink_set_hello_interval");
    x.args().add("transit_area", transit_area);
    x.args().add("neighbor_id", neighbor_id);
    x.args().add("interval_secs", interval_secs);
    return _sender->send(x, callback(this, &XrlOspfV0p1Client::unmarshall_vlink_set_hello_interval, cb));
}


/* Unmarshall vlink_set_hello_interval */
void
XrlOspfV0p1Client::unmarshall_vlink_set_hello_interval(
	const XrlError&	e,
	XrlArgs*	a,
	VlinkSetHelloIntervalCB		cb
)
{
    if (e != XrlError::OKAY()) {
	cb->dispatch(e);
	return;
    } else if (a && a->size() != 0) {
	XLOG_ERROR("Wrong number of arguments (%u != %u)", XORP_UINT_CAST(a->size()), XORP_UINT_CAST(0));
	cb->dispatch(XrlError::BAD_ARGS());
	return;
    }
    cb->dispatch(e);
}

bool
XrlOspfV0p1Client::send_vlink_get_hello_interval(
	const char*	the_tgt,
	const uint32_t&	transit_area,
	const uint32_t&	neighbor_id,
	const VlinkGetHelloIntervalCB&	cb
)
{
    Xrl x(the_tgt, "ospf/0.1/vlink_get_hello_interval");
    x.args().add("transit_area", transit_area);
    x.args().add("neighbor_id", neighbor_id);
    return _sender->send(x, callback(this, &XrlOspfV0p1Client::unmarshall_vlink_get_hello_interval, cb));
}


/* Unmarshall vlink_get_hello_interval */
void
XrlOspfV0p1Client::unmarshall_vlink_get_hello_interval(
	const XrlError&	e,
	XrlArgs*	a,
	VlinkGetHelloIntervalCB		cb
)
{
    if (e != XrlError::OKAY()) {
	cb->dispatch(e, 0);
	return;
    } else if (a && a->size() != 1) {
	XLOG_ERROR("Wrong number of arguments (%u != %u)", XORP_UINT_CAST(a->size()), XORP_UINT_CAST(1));
	cb->dispatch(XrlError::BAD_ARGS(), 0);
	return;
    }
    uint32_t interval_secs;
    try {
	a->get("interval_secs", interval_secs);
    } catch (const XrlArgs::XrlAtomNotFound&) {
	XLOG_ERROR("Atom not found");
	cb->dispatch(XrlError::BAD_ARGS(), 0);
	return;
    }
    cb->dispatch(e, &interval_secs);
}

bool
XrlOspfV0p1Client::send_vlink_set_router_dead_interval(
	const char*	the_tgt,
	const uint32_t&	transit_area,
	const uint32_t&	neighbor_id,
	const uint32_t&	interval_secs,
	const VlinkSetRouterDeadIntervalCB&	cb
)
{
    Xrl x(the_tgt, "ospf/0.1/vlink_set_router_dead_interval");
    x.args().add("transit_area", transit_area);
    x.args().add("neighbor_id", neighbor_id);
    x.args().add("interval_secs", interval_secs);
    return _sender->send(x, callback(this, &XrlOspfV0p1Client::unmarshall_vlink_set_router_dead_interval, cb));
}


/* Unmarshall vlink_set_router_dead_interval */
void
XrlOspfV0p1Client::unmarshall_vlink_set_router_dead_interval(
	const XrlError&	e,
	XrlArgs*	a,
	VlinkSetRouterDeadIntervalCB		cb
)
{
    if (e != XrlError::OKAY()) {
	cb->dispatch(e);
	return;
    } else if (a && a->size() != 0) {
	XLOG_ERROR("Wrong number of arguments (%u != %u)", XORP_UINT_CAST(a->size()), XORP_UINT_CAST(0));
	cb->dispatch(XrlError::BAD_ARGS());
	return;
    }
    cb->dispatch(e);
}

bool
XrlOspfV0p1Client::send_vlink_get_router_dead_interval(
	const char*	the_tgt,
	const uint32_t&	transit_area,
	const uint32_t&	neighbor_id,
	const VlinkGetRouterDeadIntervalCB&	cb
)
{
    Xrl x(the_tgt, "ospf/0.1/vlink_get_router_dead_interval");
    x.args().add("transit_area", transit_area);
    x.args().add("neighbor_id", neighbor_id);
    return _sender->send(x, callback(this, &XrlOspfV0p1Client::unmarshall_vlink_get_router_dead_interval, cb));
}


/* Unmarshall vlink_get_router_dead_interval */
void
XrlOspfV0p1Client::unmarshall_vlink_get_router_dead_interval(
	const XrlError&	e,
	XrlArgs*	a,
	VlinkGetRouterDeadIntervalCB		cb
)
{
    if (e != XrlError::OKAY()) {
	cb->dispatch(e, 0);
	return;
    } else if (a && a->size() != 1) {
	XLOG_ERROR("Wrong number of arguments (%u != %u)", XORP_UINT_CAST(a->size()), XORP_UINT_CAST(1));
	cb->dispatch(XrlError::BAD_ARGS(), 0);
	return;
    }
    uint32_t interval_secs;
    try {
	a->get("interval_secs", interval_secs);
    } catch (const XrlArgs::XrlAtomNotFound&) {
	XLOG_ERROR("Atom not found");
	cb->dispatch(XrlError::BAD_ARGS(), 0);
	return;
    }
    cb->dispatch(e, &interval_secs);
}

bool
XrlOspfV0p1Client::send_vlink_set_authentication(
	const char*	the_tgt,
	const uint32_t&	transit_area,
	const uint32_t&	neighbor_id,
	const string&	type,
	const string&	key,
	const VlinkSetAuthenticationCB&	cb
)
{
    Xrl x(the_tgt, "ospf/0.1/vlink_set_authentication");
    x.args().add("transit_area", transit_area);
    x.args().add("neighbor_id", neighbor_id);
    x.args().add("type", type);
    x.args().add("key", key);
    return _sender->send(x, callback(this, &XrlOspfV0p1Client::unmarshall_vlink_set_authentication, cb));
}


/* Unmarshall vlink_set_authentication */
void
XrlOspfV0p1Client::unmarshall_vlink_set_authentication(
	const XrlError&	e,
	XrlArgs*	a,
	VlinkSetAuthenticationCB		cb
)
{
    if (e != XrlError::OKAY()) {
	cb->dispatch(e);
	return;
    } else if (a && a->size() != 0) {
	XLOG_ERROR("Wrong number of arguments (%u != %u)", XORP_UINT_CAST(a->size()), XORP_UINT_CAST(0));
	cb->dispatch(XrlError::BAD_ARGS());
	return;
    }
    cb->dispatch(e);
}

bool
XrlOspfV0p1Client::send_vlink_get_authentication(
	const char*	the_tgt,
	const uint32_t&	transit_area,
	const uint32_t&	neighbor_id,
	const VlinkGetAuthenticationCB&	cb
)
{
    Xrl x(the_tgt, "ospf/0.1/vlink_get_authentication");
    x.args().add("transit_area", transit_area);
    x.args().add("neighbor_id", neighbor_id);
    return _sender->send(x, callback(this, &XrlOspfV0p1Client::unmarshall_vlink_get_authentication, cb));
}


/* Unmarshall vlink_get_authentication */
void
XrlOspfV0p1Client::unmarshall_vlink_get_authentication(
	const XrlError&	e,
	XrlArgs*	a,
	VlinkGetAuthenticationCB		cb
)
{
    if (e != XrlError::OKAY()) {
	cb->dispatch(e, 0, 0);
	return;
    } else if (a && a->size() != 2) {
	XLOG_ERROR("Wrong number of arguments (%u != %u)", XORP_UINT_CAST(a->size()), XORP_UINT_CAST(2));
	cb->dispatch(XrlError::BAD_ARGS(), 0, 0);
	return;
    }
    string type;
    string key;
    try {
	a->get("type", type);
	a->get("key", key);
    } catch (const XrlArgs::XrlAtomNotFound&) {
	XLOG_ERROR("Atom not found");
	cb->dispatch(XrlError::BAD_ARGS(), 0, 0);
	return;
    }
    cb->dispatch(e, &type, &key);
}

bool
XrlOspfV0p1Client::send_list_vlinks(
	const char*	the_tgt,
	const uint32_t&	transit_id,
	const ListVlinksCB&	cb
)
{
    Xrl x(the_tgt, "ospf/0.1/list_vlinks");
    x.args().add("transit_id", transit_id);
    return _sender->send(x, callback(this, &XrlOspfV0p1Client::unmarshall_list_vlinks, cb));
}


/* Unmarshall list_vlinks */
void
XrlOspfV0p1Client::unmarshall_list_vlinks(
	const XrlError&	e,
	XrlArgs*	a,
	ListVlinksCB		cb
)
{
    if (e != XrlError::OKAY()) {
	cb->dispatch(e, 0);
	return;
    } else if (a && a->size() != 1) {
	XLOG_ERROR("Wrong number of arguments (%u != %u)", XORP_UINT_CAST(a->size()), XORP_UINT_CAST(1));
	cb->dispatch(XrlError::BAD_ARGS(), 0);
	return;
    }
    XrlAtomList neighbor_ids;
    try {
	a->get("neighbor_ids", neighbor_ids);
    } catch (const XrlArgs::XrlAtomNotFound&) {
	XLOG_ERROR("Atom not found");
	cb->dispatch(XrlError::BAD_ARGS(), 0);
	return;
    }
    cb->dispatch(e, &neighbor_ids);
}

bool
XrlOspfV0p1Client::send_add_or_configure_external_route(
	const char*	the_tgt,
	const IPv4Net&	network,
	const IPv4&	gateway,
	const uint32_t&	type,
	const uint32_t&	cost,
	const bool&	multicast,
	const uint32_t&	external_route_tag,
	const AddOrConfigureExternalRouteCB&	cb
)
{
    Xrl x(the_tgt, "ospf/0.1/add_or_configure_external_route");
    x.args().add("network", network);
    x.args().add("gateway", gateway);
    x.args().add("type", type);
    x.args().add("cost", cost);
    x.args().add("multicast", multicast);
    x.args().add("external_route_tag", external_route_tag);
    return _sender->send(x, callback(this, &XrlOspfV0p1Client::unmarshall_add_or_configure_external_route, cb));
}


/* Unmarshall add_or_configure_external_route */
void
XrlOspfV0p1Client::unmarshall_add_or_configure_external_route(
	const XrlError&	e,
	XrlArgs*	a,
	AddOrConfigureExternalRouteCB		cb
)
{
    if (e != XrlError::OKAY()) {
	cb->dispatch(e);
	return;
    } else if (a && a->size() != 0) {
	XLOG_ERROR("Wrong number of arguments (%u != %u)", XORP_UINT_CAST(a->size()), XORP_UINT_CAST(0));
	cb->dispatch(XrlError::BAD_ARGS());
	return;
    }
    cb->dispatch(e);
}

bool
XrlOspfV0p1Client::send_delete_external_route(
	const char*	the_tgt,
	const IPv4Net&	network,
	const IPv4&	gateway,
	const DeleteExternalRouteCB&	cb
)
{
    Xrl x(the_tgt, "ospf/0.1/delete_external_route");
    x.args().add("network", network);
    x.args().add("gateway", gateway);
    return _sender->send(x, callback(this, &XrlOspfV0p1Client::unmarshall_delete_external_route, cb));
}


/* Unmarshall delete_external_route */
void
XrlOspfV0p1Client::unmarshall_delete_external_route(
	const XrlError&	e,
	XrlArgs*	a,
	DeleteExternalRouteCB		cb
)
{
    if (e != XrlError::OKAY()) {
	cb->dispatch(e);
	return;
    } else if (a && a->size() != 0) {
	XLOG_ERROR("Wrong number of arguments (%u != %u)", XORP_UINT_CAST(a->size()), XORP_UINT_CAST(0));
	cb->dispatch(XrlError::BAD_ARGS());
	return;
    }
    cb->dispatch(e);
}

bool
XrlOspfV0p1Client::send_query_external_route(
	const char*	the_tgt,
	const IPv4Net&	network,
	const IPv4&	gateway,
	const QueryExternalRouteCB&	cb
)
{
    Xrl x(the_tgt, "ospf/0.1/query_external_route");
    x.args().add("network", network);
    x.args().add("gateway", gateway);
    return _sender->send(x, callback(this, &XrlOspfV0p1Client::unmarshall_query_external_route, cb));
}


/* Unmarshall query_external_route */
void
XrlOspfV0p1Client::unmarshall_query_external_route(
	const XrlError&	e,
	XrlArgs*	a,
	QueryExternalRouteCB		cb
)
{
    if (e != XrlError::OKAY()) {
	cb->dispatch(e, 0, 0, 0, 0);
	return;
    } else if (a && a->size() != 4) {
	XLOG_ERROR("Wrong number of arguments (%u != %u)", XORP_UINT_CAST(a->size()), XORP_UINT_CAST(4));
	cb->dispatch(XrlError::BAD_ARGS(), 0, 0, 0, 0);
	return;
    }
    uint32_t type;
    uint32_t cost;
    bool multicast;
    uint32_t external_route_tag;
    try {
	a->get("type", type);
	a->get("cost", cost);
	a->get("multicast", multicast);
	a->get("external_route_tag", external_route_tag);
    } catch (const XrlArgs::XrlAtomNotFound&) {
	XLOG_ERROR("Atom not found");
	cb->dispatch(XrlError::BAD_ARGS(), 0, 0, 0, 0);
	return;
    }
    cb->dispatch(e, &type, &cost, &multicast, &external_route_tag);
}

bool
XrlOspfV0p1Client::send_list_external_routes(
	const char*	the_tgt,
	const IPv4Net&	network,
	const ListExternalRoutesCB&	cb
)
{
    Xrl x(the_tgt, "ospf/0.1/list_external_routes");
    x.args().add("network", network);
    return _sender->send(x, callback(this, &XrlOspfV0p1Client::unmarshall_list_external_routes, cb));
}


/* Unmarshall list_external_routes */
void
XrlOspfV0p1Client::unmarshall_list_external_routes(
	const XrlError&	e,
	XrlArgs*	a,
	ListExternalRoutesCB		cb
)
{
    if (e != XrlError::OKAY()) {
	cb->dispatch(e, 0);
	return;
    } else if (a && a->size() != 1) {
	XLOG_ERROR("Wrong number of arguments (%u != %u)", XORP_UINT_CAST(a->size()), XORP_UINT_CAST(1));
	cb->dispatch(XrlError::BAD_ARGS(), 0);
	return;
    }
    XrlAtomList gateways;
    try {
	a->get("gateways", gateways);
    } catch (const XrlArgs::XrlAtomNotFound&) {
	XLOG_ERROR("Atom not found");
	cb->dispatch(XrlError::BAD_ARGS(), 0);
	return;
    }
    cb->dispatch(e, &gateways);
}

bool
XrlOspfV0p1Client::send_add_interface(
	const char*	the_tgt,
	const string&	identifier,
	const uint32_t&	if_index,
	const uint32_t&	area_id,
	const uint32_t&	cost,
	const uint32_t&	mtu,
	const string&	type,
	const bool&	on_demand,
	const bool&	passive,
	const AddInterfaceCB&	cb
)
{
    Xrl x(the_tgt, "ospf/0.1/add_interface");
    x.args().add("identifier", identifier);
    x.args().add("if_index", if_index);
    x.args().add("area_id", area_id);
    x.args().add("cost", cost);
    x.args().add("mtu", mtu);
    x.args().add("type", type);
    x.args().add("on_demand", on_demand);
    x.args().add("passive", passive);
    return _sender->send(x, callback(this, &XrlOspfV0p1Client::unmarshall_add_interface, cb));
}


/* Unmarshall add_interface */
void
XrlOspfV0p1Client::unmarshall_add_interface(
	const XrlError&	e,
	XrlArgs*	a,
	AddInterfaceCB		cb
)
{
    if (e != XrlError::OKAY()) {
	cb->dispatch(e);
	return;
    } else if (a && a->size() != 0) {
	XLOG_ERROR("Wrong number of arguments (%u != %u)", XORP_UINT_CAST(a->size()), XORP_UINT_CAST(0));
	cb->dispatch(XrlError::BAD_ARGS());
	return;
    }
    cb->dispatch(e);
}

bool
XrlOspfV0p1Client::send_interface_set_if_index(
	const char*	the_tgt,
	const string&	identifier,
	const uint32_t&	index,
	const InterfaceSetIfIndexCB&	cb
)
{
    Xrl x(the_tgt, "ospf/0.1/interface_set_if_index");
    x.args().add("identifier", identifier);
    x.args().add("index", index);
    return _sender->send(x, callback(this, &XrlOspfV0p1Client::unmarshall_interface_set_if_index, cb));
}


/* Unmarshall interface_set_if_index */
void
XrlOspfV0p1Client::unmarshall_interface_set_if_index(
	const XrlError&	e,
	XrlArgs*	a,
	InterfaceSetIfIndexCB		cb
)
{
    if (e != XrlError::OKAY()) {
	cb->dispatch(e);
	return;
    } else if (a && a->size() != 0) {
	XLOG_ERROR("Wrong number of arguments (%u != %u)", XORP_UINT_CAST(a->size()), XORP_UINT_CAST(0));
	cb->dispatch(XrlError::BAD_ARGS());
	return;
    }
    cb->dispatch(e);
}

bool
XrlOspfV0p1Client::send_interface_get_if_index(
	const char*	the_tgt,
	const string&	identifier,
	const InterfaceGetIfIndexCB&	cb
)
{
    Xrl x(the_tgt, "ospf/0.1/interface_get_if_index");
    x.args().add("identifier", identifier);
    return _sender->send(x, callback(this, &XrlOspfV0p1Client::unmarshall_interface_get_if_index, cb));
}


/* Unmarshall interface_get_if_index */
void
XrlOspfV0p1Client::unmarshall_interface_get_if_index(
	const XrlError&	e,
	XrlArgs*	a,
	InterfaceGetIfIndexCB		cb
)
{
    if (e != XrlError::OKAY()) {
	cb->dispatch(e, 0);
	return;
    } else if (a && a->size() != 1) {
	XLOG_ERROR("Wrong number of arguments (%u != %u)", XORP_UINT_CAST(a->size()), XORP_UINT_CAST(1));
	cb->dispatch(XrlError::BAD_ARGS(), 0);
	return;
    }
    uint32_t index;
    try {
	a->get("index", index);
    } catch (const XrlArgs::XrlAtomNotFound&) {
	XLOG_ERROR("Atom not found");
	cb->dispatch(XrlError::BAD_ARGS(), 0);
	return;
    }
    cb->dispatch(e, &index);
}

bool
XrlOspfV0p1Client::send_interface_set_area_id(
	const char*	the_tgt,
	const string&	identifier,
	const uint32_t&	area_id,
	const InterfaceSetAreaIdCB&	cb
)
{
    Xrl x(the_tgt, "ospf/0.1/interface_set_area_id");
    x.args().add("identifier", identifier);
    x.args().add("area_id", area_id);
    return _sender->send(x, callback(this, &XrlOspfV0p1Client::unmarshall_interface_set_area_id, cb));
}


/* Unmarshall interface_set_area_id */
void
XrlOspfV0p1Client::unmarshall_interface_set_area_id(
	const XrlError&	e,
	XrlArgs*	a,
	InterfaceSetAreaIdCB		cb
)
{
    if (e != XrlError::OKAY()) {
	cb->dispatch(e);
	return;
    } else if (a && a->size() != 0) {
	XLOG_ERROR("Wrong number of arguments (%u != %u)", XORP_UINT_CAST(a->size()), XORP_UINT_CAST(0));
	cb->dispatch(XrlError::BAD_ARGS());
	return;
    }
    cb->dispatch(e);
}

bool
XrlOspfV0p1Client::send_interface_get_area_id(
	const char*	the_tgt,
	const string&	identifier,
	const InterfaceGetAreaIdCB&	cb
)
{
    Xrl x(the_tgt, "ospf/0.1/interface_get_area_id");
    x.args().add("identifier", identifier);
    return _sender->send(x, callback(this, &XrlOspfV0p1Client::unmarshall_interface_get_area_id, cb));
}


/* Unmarshall interface_get_area_id */
void
XrlOspfV0p1Client::unmarshall_interface_get_area_id(
	const XrlError&	e,
	XrlArgs*	a,
	InterfaceGetAreaIdCB		cb
)
{
    if (e != XrlError::OKAY()) {
	cb->dispatch(e, 0);
	return;
    } else if (a && a->size() != 1) {
	XLOG_ERROR("Wrong number of arguments (%u != %u)", XORP_UINT_CAST(a->size()), XORP_UINT_CAST(1));
	cb->dispatch(XrlError::BAD_ARGS(), 0);
	return;
    }
    uint32_t area_id;
    try {
	a->get("area_id", area_id);
    } catch (const XrlArgs::XrlAtomNotFound&) {
	XLOG_ERROR("Atom not found");
	cb->dispatch(XrlError::BAD_ARGS(), 0);
	return;
    }
    cb->dispatch(e, &area_id);
}

bool
XrlOspfV0p1Client::send_interface_set_cost(
	const char*	the_tgt,
	const string&	identifier,
	const uint32_t&	cost,
	const InterfaceSetCostCB&	cb
)
{
    Xrl x(the_tgt, "ospf/0.1/interface_set_cost");
    x.args().add("identifier", identifier);
    x.args().add("cost", cost);
    return _sender->send(x, callback(this, &XrlOspfV0p1Client::unmarshall_interface_set_cost, cb));
}


/* Unmarshall interface_set_cost */
void
XrlOspfV0p1Client::unmarshall_interface_set_cost(
	const XrlError&	e,
	XrlArgs*	a,
	InterfaceSetCostCB		cb
)
{
    if (e != XrlError::OKAY()) {
	cb->dispatch(e);
	return;
    } else if (a && a->size() != 0) {
	XLOG_ERROR("Wrong number of arguments (%u != %u)", XORP_UINT_CAST(a->size()), XORP_UINT_CAST(0));
	cb->dispatch(XrlError::BAD_ARGS());
	return;
    }
    cb->dispatch(e);
}

bool
XrlOspfV0p1Client::send_interface_get_cost(
	const char*	the_tgt,
	const string&	identifier,
	const InterfaceGetCostCB&	cb
)
{
    Xrl x(the_tgt, "ospf/0.1/interface_get_cost");
    x.args().add("identifier", identifier);
    return _sender->send(x, callback(this, &XrlOspfV0p1Client::unmarshall_interface_get_cost, cb));
}


/* Unmarshall interface_get_cost */
void
XrlOspfV0p1Client::unmarshall_interface_get_cost(
	const XrlError&	e,
	XrlArgs*	a,
	InterfaceGetCostCB		cb
)
{
    if (e != XrlError::OKAY()) {
	cb->dispatch(e, 0);
	return;
    } else if (a && a->size() != 1) {
	XLOG_ERROR("Wrong number of arguments (%u != %u)", XORP_UINT_CAST(a->size()), XORP_UINT_CAST(1));
	cb->dispatch(XrlError::BAD_ARGS(), 0);
	return;
    }
    uint32_t cost;
    try {
	a->get("cost", cost);
    } catch (const XrlArgs::XrlAtomNotFound&) {
	XLOG_ERROR("Atom not found");
	cb->dispatch(XrlError::BAD_ARGS(), 0);
	return;
    }
    cb->dispatch(e, &cost);
}

bool
XrlOspfV0p1Client::send_interface_set_mtu(
	const char*	the_tgt,
	const string&	identifier,
	const uint32_t&	mtu,
	const InterfaceSetMtuCB&	cb
)
{
    Xrl x(the_tgt, "ospf/0.1/interface_set_mtu");
    x.args().add("identifier", identifier);
    x.args().add("mtu", mtu);
    return _sender->send(x, callback(this, &XrlOspfV0p1Client::unmarshall_interface_set_mtu, cb));
}


/* Unmarshall interface_set_mtu */
void
XrlOspfV0p1Client::unmarshall_interface_set_mtu(
	const XrlError&	e,
	XrlArgs*	a,
	InterfaceSetMtuCB		cb
)
{
    if (e != XrlError::OKAY()) {
	cb->dispatch(e);
	return;
    } else if (a && a->size() != 0) {
	XLOG_ERROR("Wrong number of arguments (%u != %u)", XORP_UINT_CAST(a->size()), XORP_UINT_CAST(0));
	cb->dispatch(XrlError::BAD_ARGS());
	return;
    }
    cb->dispatch(e);
}

bool
XrlOspfV0p1Client::send_interface_get_mtu(
	const char*	the_tgt,
	const string&	identifier,
	const InterfaceGetMtuCB&	cb
)
{
    Xrl x(the_tgt, "ospf/0.1/interface_get_mtu");
    x.args().add("identifier", identifier);
    return _sender->send(x, callback(this, &XrlOspfV0p1Client::unmarshall_interface_get_mtu, cb));
}


/* Unmarshall interface_get_mtu */
void
XrlOspfV0p1Client::unmarshall_interface_get_mtu(
	const XrlError&	e,
	XrlArgs*	a,
	InterfaceGetMtuCB		cb
)
{
    if (e != XrlError::OKAY()) {
	cb->dispatch(e, 0);
	return;
    } else if (a && a->size() != 1) {
	XLOG_ERROR("Wrong number of arguments (%u != %u)", XORP_UINT_CAST(a->size()), XORP_UINT_CAST(1));
	cb->dispatch(XrlError::BAD_ARGS(), 0);
	return;
    }
    uint32_t mtu;
    try {
	a->get("mtu", mtu);
    } catch (const XrlArgs::XrlAtomNotFound&) {
	XLOG_ERROR("Atom not found");
	cb->dispatch(XrlError::BAD_ARGS(), 0);
	return;
    }
    cb->dispatch(e, &mtu);
}

bool
XrlOspfV0p1Client::send_interface_set_type(
	const char*	the_tgt,
	const string&	identifier,
	const string&	type,
	const InterfaceSetTypeCB&	cb
)
{
    Xrl x(the_tgt, "ospf/0.1/interface_set_type");
    x.args().add("identifier", identifier);
    x.args().add("type", type);
    return _sender->send(x, callback(this, &XrlOspfV0p1Client::unmarshall_interface_set_type, cb));
}


/* Unmarshall interface_set_type */
void
XrlOspfV0p1Client::unmarshall_interface_set_type(
	const XrlError&	e,
	XrlArgs*	a,
	InterfaceSetTypeCB		cb
)
{
    if (e != XrlError::OKAY()) {
	cb->dispatch(e);
	return;
    } else if (a && a->size() != 0) {
	XLOG_ERROR("Wrong number of arguments (%u != %u)", XORP_UINT_CAST(a->size()), XORP_UINT_CAST(0));
	cb->dispatch(XrlError::BAD_ARGS());
	return;
    }
    cb->dispatch(e);
}

bool
XrlOspfV0p1Client::send_interface_get_type(
	const char*	the_tgt,
	const string&	identifier,
	const InterfaceGetTypeCB&	cb
)
{
    Xrl x(the_tgt, "ospf/0.1/interface_get_type");
    x.args().add("identifier", identifier);
    return _sender->send(x, callback(this, &XrlOspfV0p1Client::unmarshall_interface_get_type, cb));
}


/* Unmarshall interface_get_type */
void
XrlOspfV0p1Client::unmarshall_interface_get_type(
	const XrlError&	e,
	XrlArgs*	a,
	InterfaceGetTypeCB		cb
)
{
    if (e != XrlError::OKAY()) {
	cb->dispatch(e, 0);
	return;
    } else if (a && a->size() != 1) {
	XLOG_ERROR("Wrong number of arguments (%u != %u)", XORP_UINT_CAST(a->size()), XORP_UINT_CAST(1));
	cb->dispatch(XrlError::BAD_ARGS(), 0);
	return;
    }
    string type;
    try {
	a->get("type", type);
    } catch (const XrlArgs::XrlAtomNotFound&) {
	XLOG_ERROR("Atom not found");
	cb->dispatch(XrlError::BAD_ARGS(), 0);
	return;
    }
    cb->dispatch(e, &type);
}

bool
XrlOspfV0p1Client::send_interface_set_dr_priority(
	const char*	the_tgt,
	const string&	identifier,
	const uint32_t&	dr_priority,
	const InterfaceSetDrPriorityCB&	cb
)
{
    Xrl x(the_tgt, "ospf/0.1/interface_set_dr_priority");
    x.args().add("identifier", identifier);
    x.args().add("dr_priority", dr_priority);
    return _sender->send(x, callback(this, &XrlOspfV0p1Client::unmarshall_interface_set_dr_priority, cb));
}


/* Unmarshall interface_set_dr_priority */
void
XrlOspfV0p1Client::unmarshall_interface_set_dr_priority(
	const XrlError&	e,
	XrlArgs*	a,
	InterfaceSetDrPriorityCB		cb
)
{
    if (e != XrlError::OKAY()) {
	cb->dispatch(e);
	return;
    } else if (a && a->size() != 0) {
	XLOG_ERROR("Wrong number of arguments (%u != %u)", XORP_UINT_CAST(a->size()), XORP_UINT_CAST(0));
	cb->dispatch(XrlError::BAD_ARGS());
	return;
    }
    cb->dispatch(e);
}

bool
XrlOspfV0p1Client::send_interface_get_dr_priority(
	const char*	the_tgt,
	const string&	identifier,
	const InterfaceGetDrPriorityCB&	cb
)
{
    Xrl x(the_tgt, "ospf/0.1/interface_get_dr_priority");
    x.args().add("identifier", identifier);
    return _sender->send(x, callback(this, &XrlOspfV0p1Client::unmarshall_interface_get_dr_priority, cb));
}


/* Unmarshall interface_get_dr_priority */
void
XrlOspfV0p1Client::unmarshall_interface_get_dr_priority(
	const XrlError&	e,
	XrlArgs*	a,
	InterfaceGetDrPriorityCB		cb
)
{
    if (e != XrlError::OKAY()) {
	cb->dispatch(e, 0);
	return;
    } else if (a && a->size() != 1) {
	XLOG_ERROR("Wrong number of arguments (%u != %u)", XORP_UINT_CAST(a->size()), XORP_UINT_CAST(1));
	cb->dispatch(XrlError::BAD_ARGS(), 0);
	return;
    }
    uint32_t dr_priority;
    try {
	a->get("dr_priority", dr_priority);
    } catch (const XrlArgs::XrlAtomNotFound&) {
	XLOG_ERROR("Atom not found");
	cb->dispatch(XrlError::BAD_ARGS(), 0);
	return;
    }
    cb->dispatch(e, &dr_priority);
}

bool
XrlOspfV0p1Client::send_interface_set_transit_delay(
	const char*	the_tgt,
	const string&	identifier,
	const uint32_t&	delay_secs,
	const InterfaceSetTransitDelayCB&	cb
)
{
    Xrl x(the_tgt, "ospf/0.1/interface_set_transit_delay");
    x.args().add("identifier", identifier);
    x.args().add("delay_secs", delay_secs);
    return _sender->send(x, callback(this, &XrlOspfV0p1Client::unmarshall_interface_set_transit_delay, cb));
}


/* Unmarshall interface_set_transit_delay */
void
XrlOspfV0p1Client::unmarshall_interface_set_transit_delay(
	const XrlError&	e,
	XrlArgs*	a,
	InterfaceSetTransitDelayCB		cb
)
{
    if (e != XrlError::OKAY()) {
	cb->dispatch(e);
	return;
    } else if (a && a->size() != 0) {
	XLOG_ERROR("Wrong number of arguments (%u != %u)", XORP_UINT_CAST(a->size()), XORP_UINT_CAST(0));
	cb->dispatch(XrlError::BAD_ARGS());
	return;
    }
    cb->dispatch(e);
}

bool
XrlOspfV0p1Client::send_interface_get_transit_delay(
	const char*	the_tgt,
	const string&	identifier,
	const InterfaceGetTransitDelayCB&	cb
)
{
    Xrl x(the_tgt, "ospf/0.1/interface_get_transit_delay");
    x.args().add("identifier", identifier);
    return _sender->send(x, callback(this, &XrlOspfV0p1Client::unmarshall_interface_get_transit_delay, cb));
}


/* Unmarshall interface_get_transit_delay */
void
XrlOspfV0p1Client::unmarshall_interface_get_transit_delay(
	const XrlError&	e,
	XrlArgs*	a,
	InterfaceGetTransitDelayCB		cb
)
{
    if (e != XrlError::OKAY()) {
	cb->dispatch(e, 0);
	return;
    } else if (a && a->size() != 1) {
	XLOG_ERROR("Wrong number of arguments (%u != %u)", XORP_UINT_CAST(a->size()), XORP_UINT_CAST(1));
	cb->dispatch(XrlError::BAD_ARGS(), 0);
	return;
    }
    uint32_t delay_secs;
    try {
	a->get("delay_secs", delay_secs);
    } catch (const XrlArgs::XrlAtomNotFound&) {
	XLOG_ERROR("Atom not found");
	cb->dispatch(XrlError::BAD_ARGS(), 0);
	return;
    }
    cb->dispatch(e, &delay_secs);
}

bool
XrlOspfV0p1Client::send_interface_set_retransmit_interval(
	const char*	the_tgt,
	const string&	identifier,
	const uint32_t&	interval_secs,
	const InterfaceSetRetransmitIntervalCB&	cb
)
{
    Xrl x(the_tgt, "ospf/0.1/interface_set_retransmit_interval");
    x.args().add("identifier", identifier);
    x.args().add("interval_secs", interval_secs);
    return _sender->send(x, callback(this, &XrlOspfV0p1Client::unmarshall_interface_set_retransmit_interval, cb));
}


/* Unmarshall interface_set_retransmit_interval */
void
XrlOspfV0p1Client::unmarshall_interface_set_retransmit_interval(
	const XrlError&	e,
	XrlArgs*	a,
	InterfaceSetRetransmitIntervalCB		cb
)
{
    if (e != XrlError::OKAY()) {
	cb->dispatch(e);
	return;
    } else if (a && a->size() != 0) {
	XLOG_ERROR("Wrong number of arguments (%u != %u)", XORP_UINT_CAST(a->size()), XORP_UINT_CAST(0));
	cb->dispatch(XrlError::BAD_ARGS());
	return;
    }
    cb->dispatch(e);
}

bool
XrlOspfV0p1Client::send_interface_get_retransmit_interval(
	const char*	the_tgt,
	const string&	identifier,
	const InterfaceGetRetransmitIntervalCB&	cb
)
{
    Xrl x(the_tgt, "ospf/0.1/interface_get_retransmit_interval");
    x.args().add("identifier", identifier);
    return _sender->send(x, callback(this, &XrlOspfV0p1Client::unmarshall_interface_get_retransmit_interval, cb));
}


/* Unmarshall interface_get_retransmit_interval */
void
XrlOspfV0p1Client::unmarshall_interface_get_retransmit_interval(
	const XrlError&	e,
	XrlArgs*	a,
	InterfaceGetRetransmitIntervalCB		cb
)
{
    if (e != XrlError::OKAY()) {
	cb->dispatch(e, 0);
	return;
    } else if (a && a->size() != 1) {
	XLOG_ERROR("Wrong number of arguments (%u != %u)", XORP_UINT_CAST(a->size()), XORP_UINT_CAST(1));
	cb->dispatch(XrlError::BAD_ARGS(), 0);
	return;
    }
    uint32_t interval_secs;
    try {
	a->get("interval_secs", interval_secs);
    } catch (const XrlArgs::XrlAtomNotFound&) {
	XLOG_ERROR("Atom not found");
	cb->dispatch(XrlError::BAD_ARGS(), 0);
	return;
    }
    cb->dispatch(e, &interval_secs);
}

bool
XrlOspfV0p1Client::send_interface_set_router_dead_interval(
	const char*	the_tgt,
	const string&	identifier,
	const uint32_t&	interval_secs,
	const InterfaceSetRouterDeadIntervalCB&	cb
)
{
    Xrl x(the_tgt, "ospf/0.1/interface_set_router_dead_interval");
    x.args().add("identifier", identifier);
    x.args().add("interval_secs", interval_secs);
    return _sender->send(x, callback(this, &XrlOspfV0p1Client::unmarshall_interface_set_router_dead_interval, cb));
}


/* Unmarshall interface_set_router_dead_interval */
void
XrlOspfV0p1Client::unmarshall_interface_set_router_dead_interval(
	const XrlError&	e,
	XrlArgs*	a,
	InterfaceSetRouterDeadIntervalCB		cb
)
{
    if (e != XrlError::OKAY()) {
	cb->dispatch(e);
	return;
    } else if (a && a->size() != 0) {
	XLOG_ERROR("Wrong number of arguments (%u != %u)", XORP_UINT_CAST(a->size()), XORP_UINT_CAST(0));
	cb->dispatch(XrlError::BAD_ARGS());
	return;
    }
    cb->dispatch(e);
}

bool
XrlOspfV0p1Client::send_interface_get_router_dead_interval(
	const char*	the_tgt,
	const string&	identifier,
	const InterfaceGetRouterDeadIntervalCB&	cb
)
{
    Xrl x(the_tgt, "ospf/0.1/interface_get_router_dead_interval");
    x.args().add("identifier", identifier);
    return _sender->send(x, callback(this, &XrlOspfV0p1Client::unmarshall_interface_get_router_dead_interval, cb));
}


/* Unmarshall interface_get_router_dead_interval */
void
XrlOspfV0p1Client::unmarshall_interface_get_router_dead_interval(
	const XrlError&	e,
	XrlArgs*	a,
	InterfaceGetRouterDeadIntervalCB		cb
)
{
    if (e != XrlError::OKAY()) {
	cb->dispatch(e, 0);
	return;
    } else if (a && a->size() != 1) {
	XLOG_ERROR("Wrong number of arguments (%u != %u)", XORP_UINT_CAST(a->size()), XORP_UINT_CAST(1));
	cb->dispatch(XrlError::BAD_ARGS(), 0);
	return;
    }
    uint32_t interval_secs;
    try {
	a->get("interval_secs", interval_secs);
    } catch (const XrlArgs::XrlAtomNotFound&) {
	XLOG_ERROR("Atom not found");
	cb->dispatch(XrlError::BAD_ARGS(), 0);
	return;
    }
    cb->dispatch(e, &interval_secs);
}

bool
XrlOspfV0p1Client::send_interface_set_poll_interval(
	const char*	the_tgt,
	const string&	identifier,
	const uint32_t&	interval_secs,
	const InterfaceSetPollIntervalCB&	cb
)
{
    Xrl x(the_tgt, "ospf/0.1/interface_set_poll_interval");
    x.args().add("identifier", identifier);
    x.args().add("interval_secs", interval_secs);
    return _sender->send(x, callback(this, &XrlOspfV0p1Client::unmarshall_interface_set_poll_interval, cb));
}


/* Unmarshall interface_set_poll_interval */
void
XrlOspfV0p1Client::unmarshall_interface_set_poll_interval(
	const XrlError&	e,
	XrlArgs*	a,
	InterfaceSetPollIntervalCB		cb
)
{
    if (e != XrlError::OKAY()) {
	cb->dispatch(e);
	return;
    } else if (a && a->size() != 0) {
	XLOG_ERROR("Wrong number of arguments (%u != %u)", XORP_UINT_CAST(a->size()), XORP_UINT_CAST(0));
	cb->dispatch(XrlError::BAD_ARGS());
	return;
    }
    cb->dispatch(e);
}

bool
XrlOspfV0p1Client::send_interface_get_poll_interval(
	const char*	the_tgt,
	const string&	identifier,
	const InterfaceGetPollIntervalCB&	cb
)
{
    Xrl x(the_tgt, "ospf/0.1/interface_get_poll_interval");
    x.args().add("identifier", identifier);
    return _sender->send(x, callback(this, &XrlOspfV0p1Client::unmarshall_interface_get_poll_interval, cb));
}


/* Unmarshall interface_get_poll_interval */
void
XrlOspfV0p1Client::unmarshall_interface_get_poll_interval(
	const XrlError&	e,
	XrlArgs*	a,
	InterfaceGetPollIntervalCB		cb
)
{
    if (e != XrlError::OKAY()) {
	cb->dispatch(e, 0);
	return;
    } else if (a && a->size() != 1) {
	XLOG_ERROR("Wrong number of arguments (%u != %u)", XORP_UINT_CAST(a->size()), XORP_UINT_CAST(1));
	cb->dispatch(XrlError::BAD_ARGS(), 0);
	return;
    }
    uint32_t interval_secs;
    try {
	a->get("interval_secs", interval_secs);
    } catch (const XrlArgs::XrlAtomNotFound&) {
	XLOG_ERROR("Atom not found");
	cb->dispatch(XrlError::BAD_ARGS(), 0);
	return;
    }
    cb->dispatch(e, &interval_secs);
}

bool
XrlOspfV0p1Client::send_interface_set_authentication(
	const char*	the_tgt,
	const string&	identifier,
	const string&	type,
	const string&	key,
	const InterfaceSetAuthenticationCB&	cb
)
{
    Xrl x(the_tgt, "ospf/0.1/interface_set_authentication");
    x.args().add("identifier", identifier);
    x.args().add("type", type);
    x.args().add("key", key);
    return _sender->send(x, callback(this, &XrlOspfV0p1Client::unmarshall_interface_set_authentication, cb));
}


/* Unmarshall interface_set_authentication */
void
XrlOspfV0p1Client::unmarshall_interface_set_authentication(
	const XrlError&	e,
	XrlArgs*	a,
	InterfaceSetAuthenticationCB		cb
)
{
    if (e != XrlError::OKAY()) {
	cb->dispatch(e);
	return;
    } else if (a && a->size() != 0) {
	XLOG_ERROR("Wrong number of arguments (%u != %u)", XORP_UINT_CAST(a->size()), XORP_UINT_CAST(0));
	cb->dispatch(XrlError::BAD_ARGS());
	return;
    }
    cb->dispatch(e);
}

bool
XrlOspfV0p1Client::send_interface_get_authentication(
	const char*	the_tgt,
	const string&	identifier,
	const InterfaceGetAuthenticationCB&	cb
)
{
    Xrl x(the_tgt, "ospf/0.1/interface_get_authentication");
    x.args().add("identifier", identifier);
    return _sender->send(x, callback(this, &XrlOspfV0p1Client::unmarshall_interface_get_authentication, cb));
}


/* Unmarshall interface_get_authentication */
void
XrlOspfV0p1Client::unmarshall_interface_get_authentication(
	const XrlError&	e,
	XrlArgs*	a,
	InterfaceGetAuthenticationCB		cb
)
{
    if (e != XrlError::OKAY()) {
	cb->dispatch(e, 0, 0);
	return;
    } else if (a && a->size() != 2) {
	XLOG_ERROR("Wrong number of arguments (%u != %u)", XORP_UINT_CAST(a->size()), XORP_UINT_CAST(2));
	cb->dispatch(XrlError::BAD_ARGS(), 0, 0);
	return;
    }
    string type;
    string key;
    try {
	a->get("type", type);
	a->get("key", key);
    } catch (const XrlArgs::XrlAtomNotFound&) {
	XLOG_ERROR("Atom not found");
	cb->dispatch(XrlError::BAD_ARGS(), 0, 0);
	return;
    }
    cb->dispatch(e, &type, &key);
}

bool
XrlOspfV0p1Client::send_interface_set_multicast_forwarding(
	const char*	the_tgt,
	const string&	identifier,
	const string&	type,
	const InterfaceSetMulticastForwardingCB&	cb
)
{
    Xrl x(the_tgt, "ospf/0.1/interface_set_multicast_forwarding");
    x.args().add("identifier", identifier);
    x.args().add("type", type);
    return _sender->send(x, callback(this, &XrlOspfV0p1Client::unmarshall_interface_set_multicast_forwarding, cb));
}


/* Unmarshall interface_set_multicast_forwarding */
void
XrlOspfV0p1Client::unmarshall_interface_set_multicast_forwarding(
	const XrlError&	e,
	XrlArgs*	a,
	InterfaceSetMulticastForwardingCB		cb
)
{
    if (e != XrlError::OKAY()) {
	cb->dispatch(e);
	return;
    } else if (a && a->size() != 0) {
	XLOG_ERROR("Wrong number of arguments (%u != %u)", XORP_UINT_CAST(a->size()), XORP_UINT_CAST(0));
	cb->dispatch(XrlError::BAD_ARGS());
	return;
    }
    cb->dispatch(e);
}

bool
XrlOspfV0p1Client::send_interface_get_multicast_forwarding(
	const char*	the_tgt,
	const string&	identifier,
	const InterfaceGetMulticastForwardingCB&	cb
)
{
    Xrl x(the_tgt, "ospf/0.1/interface_get_multicast_forwarding");
    x.args().add("identifier", identifier);
    return _sender->send(x, callback(this, &XrlOspfV0p1Client::unmarshall_interface_get_multicast_forwarding, cb));
}


/* Unmarshall interface_get_multicast_forwarding */
void
XrlOspfV0p1Client::unmarshall_interface_get_multicast_forwarding(
	const XrlError&	e,
	XrlArgs*	a,
	InterfaceGetMulticastForwardingCB		cb
)
{
    if (e != XrlError::OKAY()) {
	cb->dispatch(e, 0);
	return;
    } else if (a && a->size() != 1) {
	XLOG_ERROR("Wrong number of arguments (%u != %u)", XORP_UINT_CAST(a->size()), XORP_UINT_CAST(1));
	cb->dispatch(XrlError::BAD_ARGS(), 0);
	return;
    }
    string type;
    try {
	a->get("type", type);
    } catch (const XrlArgs::XrlAtomNotFound&) {
	XLOG_ERROR("Atom not found");
	cb->dispatch(XrlError::BAD_ARGS(), 0);
	return;
    }
    cb->dispatch(e, &type);
}

bool
XrlOspfV0p1Client::send_interface_set_on_demand(
	const char*	the_tgt,
	const string&	identifier,
	const bool&	on_demand,
	const InterfaceSetOnDemandCB&	cb
)
{
    Xrl x(the_tgt, "ospf/0.1/interface_set_on_demand");
    x.args().add("identifier", identifier);
    x.args().add("on_demand", on_demand);
    return _sender->send(x, callback(this, &XrlOspfV0p1Client::unmarshall_interface_set_on_demand, cb));
}


/* Unmarshall interface_set_on_demand */
void
XrlOspfV0p1Client::unmarshall_interface_set_on_demand(
	const XrlError&	e,
	XrlArgs*	a,
	InterfaceSetOnDemandCB		cb
)
{
    if (e != XrlError::OKAY()) {
	cb->dispatch(e);
	return;
    } else if (a && a->size() != 0) {
	XLOG_ERROR("Wrong number of arguments (%u != %u)", XORP_UINT_CAST(a->size()), XORP_UINT_CAST(0));
	cb->dispatch(XrlError::BAD_ARGS());
	return;
    }
    cb->dispatch(e);
}

bool
XrlOspfV0p1Client::send_interface_get_on_demand(
	const char*	the_tgt,
	const string&	identifier,
	const InterfaceGetOnDemandCB&	cb
)
{
    Xrl x(the_tgt, "ospf/0.1/interface_get_on_demand");
    x.args().add("identifier", identifier);
    return _sender->send(x, callback(this, &XrlOspfV0p1Client::unmarshall_interface_get_on_demand, cb));
}


/* Unmarshall interface_get_on_demand */
void
XrlOspfV0p1Client::unmarshall_interface_get_on_demand(
	const XrlError&	e,
	XrlArgs*	a,
	InterfaceGetOnDemandCB		cb
)
{
    if (e != XrlError::OKAY()) {
	cb->dispatch(e, 0);
	return;
    } else if (a && a->size() != 1) {
	XLOG_ERROR("Wrong number of arguments (%u != %u)", XORP_UINT_CAST(a->size()), XORP_UINT_CAST(1));
	cb->dispatch(XrlError::BAD_ARGS(), 0);
	return;
    }
    bool on_demand;
    try {
	a->get("on_demand", on_demand);
    } catch (const XrlArgs::XrlAtomNotFound&) {
	XLOG_ERROR("Atom not found");
	cb->dispatch(XrlError::BAD_ARGS(), 0);
	return;
    }
    cb->dispatch(e, &on_demand);
}

bool
XrlOspfV0p1Client::send_interface_set_passive(
	const char*	the_tgt,
	const string&	identifier,
	const bool&	passive,
	const InterfaceSetPassiveCB&	cb
)
{
    Xrl x(the_tgt, "ospf/0.1/interface_set_passive");
    x.args().add("identifier", identifier);
    x.args().add("passive", passive);
    return _sender->send(x, callback(this, &XrlOspfV0p1Client::unmarshall_interface_set_passive, cb));
}


/* Unmarshall interface_set_passive */
void
XrlOspfV0p1Client::unmarshall_interface_set_passive(
	const XrlError&	e,
	XrlArgs*	a,
	InterfaceSetPassiveCB		cb
)
{
    if (e != XrlError::OKAY()) {
	cb->dispatch(e);
	return;
    } else if (a && a->size() != 0) {
	XLOG_ERROR("Wrong number of arguments (%u != %u)", XORP_UINT_CAST(a->size()), XORP_UINT_CAST(0));
	cb->dispatch(XrlError::BAD_ARGS());
	return;
    }
    cb->dispatch(e);
}

bool
XrlOspfV0p1Client::send_interface_get_passive(
	const char*	the_tgt,
	const string&	identifier,
	const InterfaceGetPassiveCB&	cb
)
{
    Xrl x(the_tgt, "ospf/0.1/interface_get_passive");
    x.args().add("identifier", identifier);
    return _sender->send(x, callback(this, &XrlOspfV0p1Client::unmarshall_interface_get_passive, cb));
}


/* Unmarshall interface_get_passive */
void
XrlOspfV0p1Client::unmarshall_interface_get_passive(
	const XrlError&	e,
	XrlArgs*	a,
	InterfaceGetPassiveCB		cb
)
{
    if (e != XrlError::OKAY()) {
	cb->dispatch(e, 0);
	return;
    } else if (a && a->size() != 1) {
	XLOG_ERROR("Wrong number of arguments (%u != %u)", XORP_UINT_CAST(a->size()), XORP_UINT_CAST(1));
	cb->dispatch(XrlError::BAD_ARGS(), 0);
	return;
    }
    bool passive;
    try {
	a->get("passive", passive);
    } catch (const XrlArgs::XrlAtomNotFound&) {
	XLOG_ERROR("Atom not found");
	cb->dispatch(XrlError::BAD_ARGS(), 0);
	return;
    }
    cb->dispatch(e, &passive);
}

bool
XrlOspfV0p1Client::send_interface_set_igmp(
	const char*	the_tgt,
	const string&	identifier,
	const bool&	enabled,
	const InterfaceSetIgmpCB&	cb
)
{
    Xrl x(the_tgt, "ospf/0.1/interface_set_igmp");
    x.args().add("identifier", identifier);
    x.args().add("enabled", enabled);
    return _sender->send(x, callback(this, &XrlOspfV0p1Client::unmarshall_interface_set_igmp, cb));
}


/* Unmarshall interface_set_igmp */
void
XrlOspfV0p1Client::unmarshall_interface_set_igmp(
	const XrlError&	e,
	XrlArgs*	a,
	InterfaceSetIgmpCB		cb
)
{
    if (e != XrlError::OKAY()) {
	cb->dispatch(e);
	return;
    } else if (a && a->size() != 0) {
	XLOG_ERROR("Wrong number of arguments (%u != %u)", XORP_UINT_CAST(a->size()), XORP_UINT_CAST(0));
	cb->dispatch(XrlError::BAD_ARGS());
	return;
    }
    cb->dispatch(e);
}

bool
XrlOspfV0p1Client::send_interface_get_igmp(
	const char*	the_tgt,
	const string&	identifier,
	const InterfaceGetIgmpCB&	cb
)
{
    Xrl x(the_tgt, "ospf/0.1/interface_get_igmp");
    x.args().add("identifier", identifier);
    return _sender->send(x, callback(this, &XrlOspfV0p1Client::unmarshall_interface_get_igmp, cb));
}


/* Unmarshall interface_get_igmp */
void
XrlOspfV0p1Client::unmarshall_interface_get_igmp(
	const XrlError&	e,
	XrlArgs*	a,
	InterfaceGetIgmpCB		cb
)
{
    if (e != XrlError::OKAY()) {
	cb->dispatch(e, 0);
	return;
    } else if (a && a->size() != 1) {
	XLOG_ERROR("Wrong number of arguments (%u != %u)", XORP_UINT_CAST(a->size()), XORP_UINT_CAST(1));
	cb->dispatch(XrlError::BAD_ARGS(), 0);
	return;
    }
    bool enabled;
    try {
	a->get("enabled", enabled);
    } catch (const XrlArgs::XrlAtomNotFound&) {
	XLOG_ERROR("Atom not found");
	cb->dispatch(XrlError::BAD_ARGS(), 0);
	return;
    }
    cb->dispatch(e, &enabled);
}

bool
XrlOspfV0p1Client::send_delete_interface(
	const char*	the_tgt,
	const string&	identifier,
	const DeleteInterfaceCB&	cb
)
{
    Xrl x(the_tgt, "ospf/0.1/delete_interface");
    x.args().add("identifier", identifier);
    return _sender->send(x, callback(this, &XrlOspfV0p1Client::unmarshall_delete_interface, cb));
}


/* Unmarshall delete_interface */
void
XrlOspfV0p1Client::unmarshall_delete_interface(
	const XrlError&	e,
	XrlArgs*	a,
	DeleteInterfaceCB		cb
)
{
    if (e != XrlError::OKAY()) {
	cb->dispatch(e);
	return;
    } else if (a && a->size() != 0) {
	XLOG_ERROR("Wrong number of arguments (%u != %u)", XORP_UINT_CAST(a->size()), XORP_UINT_CAST(0));
	cb->dispatch(XrlError::BAD_ARGS());
	return;
    }
    cb->dispatch(e);
}

bool
XrlOspfV0p1Client::send_list_interfaces(
	const char*	the_tgt,
	const ListInterfacesCB&	cb
)
{
    Xrl x(the_tgt, "ospf/0.1/list_interfaces");
    return _sender->send(x, callback(this, &XrlOspfV0p1Client::unmarshall_list_interfaces, cb));
}


/* Unmarshall list_interfaces */
void
XrlOspfV0p1Client::unmarshall_list_interfaces(
	const XrlError&	e,
	XrlArgs*	a,
	ListInterfacesCB		cb
)
{
    if (e != XrlError::OKAY()) {
	cb->dispatch(e, 0);
	return;
    } else if (a && a->size() != 1) {
	XLOG_ERROR("Wrong number of arguments (%u != %u)", XORP_UINT_CAST(a->size()), XORP_UINT_CAST(1));
	cb->dispatch(XrlError::BAD_ARGS(), 0);
	return;
    }
    XrlAtomList identifiers;
    try {
	a->get("identifiers", identifiers);
    } catch (const XrlArgs::XrlAtomNotFound&) {
	XLOG_ERROR("Atom not found");
	cb->dispatch(XrlError::BAD_ARGS(), 0);
	return;
    }
    cb->dispatch(e, &identifiers);
}

bool
XrlOspfV0p1Client::send_interface_add_md5_key(
	const char*	the_tgt,
	const string&	identifier,
	const uint32_t&	key_id,
	const string&	md5key,
	const string&	start_receive,
	const string&	stop_receive,
	const string&	start_transmit,
	const string&	stop_transmit,
	const InterfaceAddMd5KeyCB&	cb
)
{
    Xrl x(the_tgt, "ospf/0.1/interface_add_md5_key");
    x.args().add("identifier", identifier);
    x.args().add("key_id", key_id);
    x.args().add("md5key", md5key);
    x.args().add("start_receive", start_receive);
    x.args().add("stop_receive", stop_receive);
    x.args().add("start_transmit", start_transmit);
    x.args().add("stop_transmit", stop_transmit);
    return _sender->send(x, callback(this, &XrlOspfV0p1Client::unmarshall_interface_add_md5_key, cb));
}


/* Unmarshall interface_add_md5_key */
void
XrlOspfV0p1Client::unmarshall_interface_add_md5_key(
	const XrlError&	e,
	XrlArgs*	a,
	InterfaceAddMd5KeyCB		cb
)
{
    if (e != XrlError::OKAY()) {
	cb->dispatch(e);
	return;
    } else if (a && a->size() != 0) {
	XLOG_ERROR("Wrong number of arguments (%u != %u)", XORP_UINT_CAST(a->size()), XORP_UINT_CAST(0));
	cb->dispatch(XrlError::BAD_ARGS());
	return;
    }
    cb->dispatch(e);
}

bool
XrlOspfV0p1Client::send_interface_get_md5_key(
	const char*	the_tgt,
	const string&	identifier,
	const uint32_t&	key_id,
	const InterfaceGetMd5KeyCB&	cb
)
{
    Xrl x(the_tgt, "ospf/0.1/interface_get_md5_key");
    x.args().add("identifier", identifier);
    x.args().add("key_id", key_id);
    return _sender->send(x, callback(this, &XrlOspfV0p1Client::unmarshall_interface_get_md5_key, cb));
}


/* Unmarshall interface_get_md5_key */
void
XrlOspfV0p1Client::unmarshall_interface_get_md5_key(
	const XrlError&	e,
	XrlArgs*	a,
	InterfaceGetMd5KeyCB		cb
)
{
    if (e != XrlError::OKAY()) {
	cb->dispatch(e, 0, 0, 0, 0, 0);
	return;
    } else if (a && a->size() != 5) {
	XLOG_ERROR("Wrong number of arguments (%u != %u)", XORP_UINT_CAST(a->size()), XORP_UINT_CAST(5));
	cb->dispatch(XrlError::BAD_ARGS(), 0, 0, 0, 0, 0);
	return;
    }
    string md5key;
    string start_receive;
    string stop_receive;
    string start_transmit;
    string stop_transmit;
    try {
	a->get("md5key", md5key);
	a->get("start_receive", start_receive);
	a->get("stop_receive", stop_receive);
	a->get("start_transmit", start_transmit);
	a->get("stop_transmit", stop_transmit);
    } catch (const XrlArgs::XrlAtomNotFound&) {
	XLOG_ERROR("Atom not found");
	cb->dispatch(XrlError::BAD_ARGS(), 0, 0, 0, 0, 0);
	return;
    }
    cb->dispatch(e, &md5key, &start_receive, &stop_receive, &start_transmit, &stop_transmit);
}

bool
XrlOspfV0p1Client::send_interface_delete_md5_key(
	const char*	the_tgt,
	const string&	identifier,
	const uint32_t&	key_id,
	const InterfaceDeleteMd5KeyCB&	cb
)
{
    Xrl x(the_tgt, "ospf/0.1/interface_delete_md5_key");
    x.args().add("identifier", identifier);
    x.args().add("key_id", key_id);
    return _sender->send(x, callback(this, &XrlOspfV0p1Client::unmarshall_interface_delete_md5_key, cb));
}


/* Unmarshall interface_delete_md5_key */
void
XrlOspfV0p1Client::unmarshall_interface_delete_md5_key(
	const XrlError&	e,
	XrlArgs*	a,
	InterfaceDeleteMd5KeyCB		cb
)
{
    if (e != XrlError::OKAY()) {
	cb->dispatch(e);
	return;
    } else if (a && a->size() != 0) {
	XLOG_ERROR("Wrong number of arguments (%u != %u)", XORP_UINT_CAST(a->size()), XORP_UINT_CAST(0));
	cb->dispatch(XrlError::BAD_ARGS());
	return;
    }
    cb->dispatch(e);
}

bool
XrlOspfV0p1Client::send_interface_list_md5_keys(
	const char*	the_tgt,
	const string&	identifier,
	const InterfaceListMd5KeysCB&	cb
)
{
    Xrl x(the_tgt, "ospf/0.1/interface_list_md5_keys");
    x.args().add("identifier", identifier);
    return _sender->send(x, callback(this, &XrlOspfV0p1Client::unmarshall_interface_list_md5_keys, cb));
}


/* Unmarshall interface_list_md5_keys */
void
XrlOspfV0p1Client::unmarshall_interface_list_md5_keys(
	const XrlError&	e,
	XrlArgs*	a,
	InterfaceListMd5KeysCB		cb
)
{
    if (e != XrlError::OKAY()) {
	cb->dispatch(e, 0);
	return;
    } else if (a && a->size() != 1) {
	XLOG_ERROR("Wrong number of arguments (%u != %u)", XORP_UINT_CAST(a->size()), XORP_UINT_CAST(1));
	cb->dispatch(XrlError::BAD_ARGS(), 0);
	return;
    }
    XrlAtomList key_ids;
    try {
	a->get("key_ids", key_ids);
    } catch (const XrlArgs::XrlAtomNotFound&) {
	XLOG_ERROR("Atom not found");
	cb->dispatch(XrlError::BAD_ARGS(), 0);
	return;
    }
    cb->dispatch(e, &key_ids);
}

bool
XrlOspfV0p1Client::send_add_neighbor(
	const char*	the_tgt,
	const IPv4&	nbr_addr,
	const bool&	dr_eligible,
	const AddNeighborCB&	cb
)
{
    Xrl x(the_tgt, "ospf/0.1/add_neighbor");
    x.args().add("nbr_addr", nbr_addr);
    x.args().add("dr_eligible", dr_eligible);
    return _sender->send(x, callback(this, &XrlOspfV0p1Client::unmarshall_add_neighbor, cb));
}


/* Unmarshall add_neighbor */
void
XrlOspfV0p1Client::unmarshall_add_neighbor(
	const XrlError&	e,
	XrlArgs*	a,
	AddNeighborCB		cb
)
{
    if (e != XrlError::OKAY()) {
	cb->dispatch(e);
	return;
    } else if (a && a->size() != 0) {
	XLOG_ERROR("Wrong number of arguments (%u != %u)", XORP_UINT_CAST(a->size()), XORP_UINT_CAST(0));
	cb->dispatch(XrlError::BAD_ARGS());
	return;
    }
    cb->dispatch(e);
}

bool
XrlOspfV0p1Client::send_get_neighbor(
	const char*	the_tgt,
	const IPv4&	nbr_addr,
	const GetNeighborCB&	cb
)
{
    Xrl x(the_tgt, "ospf/0.1/get_neighbor");
    x.args().add("nbr_addr", nbr_addr);
    return _sender->send(x, callback(this, &XrlOspfV0p1Client::unmarshall_get_neighbor, cb));
}


/* Unmarshall get_neighbor */
void
XrlOspfV0p1Client::unmarshall_get_neighbor(
	const XrlError&	e,
	XrlArgs*	a,
	GetNeighborCB		cb
)
{
    if (e != XrlError::OKAY()) {
	cb->dispatch(e, 0);
	return;
    } else if (a && a->size() != 1) {
	XLOG_ERROR("Wrong number of arguments (%u != %u)", XORP_UINT_CAST(a->size()), XORP_UINT_CAST(1));
	cb->dispatch(XrlError::BAD_ARGS(), 0);
	return;
    }
    bool dr_eligible;
    try {
	a->get("dr_eligible", dr_eligible);
    } catch (const XrlArgs::XrlAtomNotFound&) {
	XLOG_ERROR("Atom not found");
	cb->dispatch(XrlError::BAD_ARGS(), 0);
	return;
    }
    cb->dispatch(e, &dr_eligible);
}

bool
XrlOspfV0p1Client::send_delete_neighbor(
	const char*	the_tgt,
	const IPv4&	nbr_addr,
	const DeleteNeighborCB&	cb
)
{
    Xrl x(the_tgt, "ospf/0.1/delete_neighbor");
    x.args().add("nbr_addr", nbr_addr);
    return _sender->send(x, callback(this, &XrlOspfV0p1Client::unmarshall_delete_neighbor, cb));
}


/* Unmarshall delete_neighbor */
void
XrlOspfV0p1Client::unmarshall_delete_neighbor(
	const XrlError&	e,
	XrlArgs*	a,
	DeleteNeighborCB		cb
)
{
    if (e != XrlError::OKAY()) {
	cb->dispatch(e);
	return;
    } else if (a && a->size() != 0) {
	XLOG_ERROR("Wrong number of arguments (%u != %u)", XORP_UINT_CAST(a->size()), XORP_UINT_CAST(0));
	cb->dispatch(XrlError::BAD_ARGS());
	return;
    }
    cb->dispatch(e);
}

bool
XrlOspfV0p1Client::send_list_neighbors(
	const char*	the_tgt,
	const ListNeighborsCB&	cb
)
{
    Xrl x(the_tgt, "ospf/0.1/list_neighbors");
    return _sender->send(x, callback(this, &XrlOspfV0p1Client::unmarshall_list_neighbors, cb));
}


/* Unmarshall list_neighbors */
void
XrlOspfV0p1Client::unmarshall_list_neighbors(
	const XrlError&	e,
	XrlArgs*	a,
	ListNeighborsCB		cb
)
{
    if (e != XrlError::OKAY()) {
	cb->dispatch(e, 0);
	return;
    } else if (a && a->size() != 1) {
	XLOG_ERROR("Wrong number of arguments (%u != %u)", XORP_UINT_CAST(a->size()), XORP_UINT_CAST(1));
	cb->dispatch(XrlError::BAD_ARGS(), 0);
	return;
    }
    XrlAtomList nbr_addrs;
    try {
	a->get("nbr_addrs", nbr_addrs);
    } catch (const XrlArgs::XrlAtomNotFound&) {
	XLOG_ERROR("Atom not found");
	cb->dispatch(XrlError::BAD_ARGS(), 0);
	return;
    }
    cb->dispatch(e, &nbr_addrs);
}
