/*
 * Copyright (c) 2001-2004 International Computer Science Institute
 * See LICENSE file for licensing, conditions, and warranties on use.
 *
 * DO NOT EDIT THIS FILE - IT IS PROGRAMMATICALLY GENERATED
 *
 * Generated by 'tgt-gen'.
 */

#ident "$XORP: xorp/xrl/targets/socket_server_base.cc,v 1.5 2004/06/10 22:42:15 hodson Exp $"


#include "socket_server_base.hh"


XrlSocketServerTargetBase::XrlSocketServerTargetBase(XrlCmdMap* cmds)
    : _cmds(cmds)
{
    if (_cmds)
	add_handlers();
}

XrlSocketServerTargetBase::~XrlSocketServerTargetBase()
{
    if (_cmds)
	remove_handlers();
}

bool
XrlSocketServerTargetBase::set_command_map(XrlCmdMap* cmds)
{
    if (_cmds == 0 && cmds) {
        _cmds = cmds;
        add_handlers();
        return true;
    }
    if (_cmds && cmds == 0) {
	remove_handlers();
        _cmds = cmds;
        return true;
    }
    return false;
}

const XrlCmdError
XrlSocketServerTargetBase::handle_common_0_1_get_target_name(const XrlArgs& xa_inputs, XrlArgs* pxa_outputs)
{
    if (xa_inputs.size() != 0) {
	XLOG_ERROR("Wrong number of arguments (%u != %u) handling %s",
            0, (uint32_t)xa_inputs.size(), "common/0.1/get_target_name");
	return XrlCmdError::BAD_ARGS();
    }

    if (pxa_outputs == 0) {
	XLOG_FATAL("Return list empty");
	return XrlCmdError::BAD_ARGS();
    }

    /* Return value declarations */
    string name;
    try {
	XrlCmdError e = common_0_1_get_target_name(
	    name);
	if (e != XrlCmdError::OKAY()) {
	    XLOG_WARNING("Handling method for %s failed: %s",
            		 "common/0.1/get_target_name", e.str().c_str());
	    return e;
        }
    } catch (const XrlArgs::XrlAtomNotFound& e) {
	XLOG_ERROR("Argument not found");
	return XrlCmdError::BAD_ARGS();
    }

    /* Marshall return values */
    try {
	pxa_outputs->add("name", name);
    } catch (const XrlArgs::XrlAtomFound& ) {
	XLOG_FATAL("Duplicate atom name"); /* XXX Should never happen */
    }
    return XrlCmdError::OKAY();
}

const XrlCmdError
XrlSocketServerTargetBase::handle_common_0_1_get_version(const XrlArgs& xa_inputs, XrlArgs* pxa_outputs)
{
    if (xa_inputs.size() != 0) {
	XLOG_ERROR("Wrong number of arguments (%u != %u) handling %s",
            0, (uint32_t)xa_inputs.size(), "common/0.1/get_version");
	return XrlCmdError::BAD_ARGS();
    }

    if (pxa_outputs == 0) {
	XLOG_FATAL("Return list empty");
	return XrlCmdError::BAD_ARGS();
    }

    /* Return value declarations */
    string version;
    try {
	XrlCmdError e = common_0_1_get_version(
	    version);
	if (e != XrlCmdError::OKAY()) {
	    XLOG_WARNING("Handling method for %s failed: %s",
            		 "common/0.1/get_version", e.str().c_str());
	    return e;
        }
    } catch (const XrlArgs::XrlAtomNotFound& e) {
	XLOG_ERROR("Argument not found");
	return XrlCmdError::BAD_ARGS();
    }

    /* Marshall return values */
    try {
	pxa_outputs->add("version", version);
    } catch (const XrlArgs::XrlAtomFound& ) {
	XLOG_FATAL("Duplicate atom name"); /* XXX Should never happen */
    }
    return XrlCmdError::OKAY();
}

const XrlCmdError
XrlSocketServerTargetBase::handle_common_0_1_get_status(const XrlArgs& xa_inputs, XrlArgs* pxa_outputs)
{
    if (xa_inputs.size() != 0) {
	XLOG_ERROR("Wrong number of arguments (%u != %u) handling %s",
            0, (uint32_t)xa_inputs.size(), "common/0.1/get_status");
	return XrlCmdError::BAD_ARGS();
    }

    if (pxa_outputs == 0) {
	XLOG_FATAL("Return list empty");
	return XrlCmdError::BAD_ARGS();
    }

    /* Return value declarations */
    uint32_t status;
    string reason;
    try {
	XrlCmdError e = common_0_1_get_status(
	    status,
	    reason);
	if (e != XrlCmdError::OKAY()) {
	    XLOG_WARNING("Handling method for %s failed: %s",
            		 "common/0.1/get_status", e.str().c_str());
	    return e;
        }
    } catch (const XrlArgs::XrlAtomNotFound& e) {
	XLOG_ERROR("Argument not found");
	return XrlCmdError::BAD_ARGS();
    }

    /* Marshall return values */
    try {
	pxa_outputs->add("status", status);
	pxa_outputs->add("reason", reason);
    } catch (const XrlArgs::XrlAtomFound& ) {
	XLOG_FATAL("Duplicate atom name"); /* XXX Should never happen */
    }
    return XrlCmdError::OKAY();
}

const XrlCmdError
XrlSocketServerTargetBase::handle_common_0_1_shutdown(const XrlArgs& xa_inputs, XrlArgs* /* pxa_outputs */)
{
    if (xa_inputs.size() != 0) {
	XLOG_ERROR("Wrong number of arguments (%u != %u) handling %s",
            0, (uint32_t)xa_inputs.size(), "common/0.1/shutdown");
	return XrlCmdError::BAD_ARGS();
    }

    /* Return value declarations */
    try {
	XrlCmdError e = common_0_1_shutdown();
	if (e != XrlCmdError::OKAY()) {
	    XLOG_WARNING("Handling method for %s failed: %s",
            		 "common/0.1/shutdown", e.str().c_str());
	    return e;
        }
    } catch (const XrlArgs::XrlAtomNotFound& e) {
	XLOG_ERROR("Argument not found");
	return XrlCmdError::BAD_ARGS();
    }
    return XrlCmdError::OKAY();
}

const XrlCmdError
XrlSocketServerTargetBase::handle_finder_event_observer_0_1_xrl_target_birth(const XrlArgs& xa_inputs, XrlArgs* /* pxa_outputs */)
{
    if (xa_inputs.size() != 2) {
	XLOG_ERROR("Wrong number of arguments (%u != %u) handling %s",
            2, (uint32_t)xa_inputs.size(), "finder_event_observer/0.1/xrl_target_birth");
	return XrlCmdError::BAD_ARGS();
    }

    /* Return value declarations */
    try {
	XrlCmdError e = finder_event_observer_0_1_xrl_target_birth(
	    xa_inputs.get_string("target_class"),
	    xa_inputs.get_string("target_instance"));
	if (e != XrlCmdError::OKAY()) {
	    XLOG_WARNING("Handling method for %s failed: %s",
            		 "finder_event_observer/0.1/xrl_target_birth", e.str().c_str());
	    return e;
        }
    } catch (const XrlArgs::XrlAtomNotFound& e) {
	XLOG_ERROR("Argument not found");
	return XrlCmdError::BAD_ARGS();
    }
    return XrlCmdError::OKAY();
}

const XrlCmdError
XrlSocketServerTargetBase::handle_finder_event_observer_0_1_xrl_target_death(const XrlArgs& xa_inputs, XrlArgs* /* pxa_outputs */)
{
    if (xa_inputs.size() != 2) {
	XLOG_ERROR("Wrong number of arguments (%u != %u) handling %s",
            2, (uint32_t)xa_inputs.size(), "finder_event_observer/0.1/xrl_target_death");
	return XrlCmdError::BAD_ARGS();
    }

    /* Return value declarations */
    try {
	XrlCmdError e = finder_event_observer_0_1_xrl_target_death(
	    xa_inputs.get_string("target_class"),
	    xa_inputs.get_string("target_instance"));
	if (e != XrlCmdError::OKAY()) {
	    XLOG_WARNING("Handling method for %s failed: %s",
            		 "finder_event_observer/0.1/xrl_target_death", e.str().c_str());
	    return e;
        }
    } catch (const XrlArgs::XrlAtomNotFound& e) {
	XLOG_ERROR("Argument not found");
	return XrlCmdError::BAD_ARGS();
    }
    return XrlCmdError::OKAY();
}

const XrlCmdError
XrlSocketServerTargetBase::handle_socket4_0_1_tcp_open_and_bind(const XrlArgs& xa_inputs, XrlArgs* pxa_outputs)
{
    if (xa_inputs.size() != 3) {
	XLOG_ERROR("Wrong number of arguments (%u != %u) handling %s",
            3, (uint32_t)xa_inputs.size(), "socket4/0.1/tcp_open_and_bind");
	return XrlCmdError::BAD_ARGS();
    }

    if (pxa_outputs == 0) {
	XLOG_FATAL("Return list empty");
	return XrlCmdError::BAD_ARGS();
    }

    /* Return value declarations */
    string sockid;
    try {
	XrlCmdError e = socket4_0_1_tcp_open_and_bind(
	    xa_inputs.get_string("creator"),
	    xa_inputs.get_ipv4("local_addr"),
	    xa_inputs.get_uint32("local_port"),
	    sockid);
	if (e != XrlCmdError::OKAY()) {
	    XLOG_WARNING("Handling method for %s failed: %s",
            		 "socket4/0.1/tcp_open_and_bind", e.str().c_str());
	    return e;
        }
    } catch (const XrlArgs::XrlAtomNotFound& e) {
	XLOG_ERROR("Argument not found");
	return XrlCmdError::BAD_ARGS();
    }

    /* Marshall return values */
    try {
	pxa_outputs->add("sockid", sockid);
    } catch (const XrlArgs::XrlAtomFound& ) {
	XLOG_FATAL("Duplicate atom name"); /* XXX Should never happen */
    }
    return XrlCmdError::OKAY();
}

const XrlCmdError
XrlSocketServerTargetBase::handle_socket4_0_1_udp_open_and_bind(const XrlArgs& xa_inputs, XrlArgs* pxa_outputs)
{
    if (xa_inputs.size() != 3) {
	XLOG_ERROR("Wrong number of arguments (%u != %u) handling %s",
            3, (uint32_t)xa_inputs.size(), "socket4/0.1/udp_open_and_bind");
	return XrlCmdError::BAD_ARGS();
    }

    if (pxa_outputs == 0) {
	XLOG_FATAL("Return list empty");
	return XrlCmdError::BAD_ARGS();
    }

    /* Return value declarations */
    string sockid;
    try {
	XrlCmdError e = socket4_0_1_udp_open_and_bind(
	    xa_inputs.get_string("creator"),
	    xa_inputs.get_ipv4("local_addr"),
	    xa_inputs.get_uint32("local_port"),
	    sockid);
	if (e != XrlCmdError::OKAY()) {
	    XLOG_WARNING("Handling method for %s failed: %s",
            		 "socket4/0.1/udp_open_and_bind", e.str().c_str());
	    return e;
        }
    } catch (const XrlArgs::XrlAtomNotFound& e) {
	XLOG_ERROR("Argument not found");
	return XrlCmdError::BAD_ARGS();
    }

    /* Marshall return values */
    try {
	pxa_outputs->add("sockid", sockid);
    } catch (const XrlArgs::XrlAtomFound& ) {
	XLOG_FATAL("Duplicate atom name"); /* XXX Should never happen */
    }
    return XrlCmdError::OKAY();
}

const XrlCmdError
XrlSocketServerTargetBase::handle_socket4_0_1_udp_open_bind_join(const XrlArgs& xa_inputs, XrlArgs* pxa_outputs)
{
    if (xa_inputs.size() != 6) {
	XLOG_ERROR("Wrong number of arguments (%u != %u) handling %s",
            6, (uint32_t)xa_inputs.size(), "socket4/0.1/udp_open_bind_join");
	return XrlCmdError::BAD_ARGS();
    }

    if (pxa_outputs == 0) {
	XLOG_FATAL("Return list empty");
	return XrlCmdError::BAD_ARGS();
    }

    /* Return value declarations */
    string sockid;
    try {
	XrlCmdError e = socket4_0_1_udp_open_bind_join(
	    xa_inputs.get_string("creator"),
	    xa_inputs.get_ipv4("local_addr"),
	    xa_inputs.get_uint32("local_port"),
	    xa_inputs.get_ipv4("mcast_addr"),
	    xa_inputs.get_uint32("ttl"),
	    xa_inputs.get_bool("reuse"),
	    sockid);
	if (e != XrlCmdError::OKAY()) {
	    XLOG_WARNING("Handling method for %s failed: %s",
            		 "socket4/0.1/udp_open_bind_join", e.str().c_str());
	    return e;
        }
    } catch (const XrlArgs::XrlAtomNotFound& e) {
	XLOG_ERROR("Argument not found");
	return XrlCmdError::BAD_ARGS();
    }

    /* Marshall return values */
    try {
	pxa_outputs->add("sockid", sockid);
    } catch (const XrlArgs::XrlAtomFound& ) {
	XLOG_FATAL("Duplicate atom name"); /* XXX Should never happen */
    }
    return XrlCmdError::OKAY();
}

const XrlCmdError
XrlSocketServerTargetBase::handle_socket4_0_1_tcp_open_bind_connect(const XrlArgs& xa_inputs, XrlArgs* pxa_outputs)
{
    if (xa_inputs.size() != 5) {
	XLOG_ERROR("Wrong number of arguments (%u != %u) handling %s",
            5, (uint32_t)xa_inputs.size(), "socket4/0.1/tcp_open_bind_connect");
	return XrlCmdError::BAD_ARGS();
    }

    if (pxa_outputs == 0) {
	XLOG_FATAL("Return list empty");
	return XrlCmdError::BAD_ARGS();
    }

    /* Return value declarations */
    string sockid;
    try {
	XrlCmdError e = socket4_0_1_tcp_open_bind_connect(
	    xa_inputs.get_string("creator"),
	    xa_inputs.get_ipv4("local_addr"),
	    xa_inputs.get_uint32("local_port"),
	    xa_inputs.get_ipv4("remote_addr"),
	    xa_inputs.get_uint32("remote_port"),
	    sockid);
	if (e != XrlCmdError::OKAY()) {
	    XLOG_WARNING("Handling method for %s failed: %s",
            		 "socket4/0.1/tcp_open_bind_connect", e.str().c_str());
	    return e;
        }
    } catch (const XrlArgs::XrlAtomNotFound& e) {
	XLOG_ERROR("Argument not found");
	return XrlCmdError::BAD_ARGS();
    }

    /* Marshall return values */
    try {
	pxa_outputs->add("sockid", sockid);
    } catch (const XrlArgs::XrlAtomFound& ) {
	XLOG_FATAL("Duplicate atom name"); /* XXX Should never happen */
    }
    return XrlCmdError::OKAY();
}

const XrlCmdError
XrlSocketServerTargetBase::handle_socket4_0_1_udp_open_bind_connect(const XrlArgs& xa_inputs, XrlArgs* pxa_outputs)
{
    if (xa_inputs.size() != 5) {
	XLOG_ERROR("Wrong number of arguments (%u != %u) handling %s",
            5, (uint32_t)xa_inputs.size(), "socket4/0.1/udp_open_bind_connect");
	return XrlCmdError::BAD_ARGS();
    }

    if (pxa_outputs == 0) {
	XLOG_FATAL("Return list empty");
	return XrlCmdError::BAD_ARGS();
    }

    /* Return value declarations */
    string sockid;
    try {
	XrlCmdError e = socket4_0_1_udp_open_bind_connect(
	    xa_inputs.get_string("creator"),
	    xa_inputs.get_ipv4("local_addr"),
	    xa_inputs.get_uint32("local_port"),
	    xa_inputs.get_ipv4("remote_addr"),
	    xa_inputs.get_uint32("remote_port"),
	    sockid);
	if (e != XrlCmdError::OKAY()) {
	    XLOG_WARNING("Handling method for %s failed: %s",
            		 "socket4/0.1/udp_open_bind_connect", e.str().c_str());
	    return e;
        }
    } catch (const XrlArgs::XrlAtomNotFound& e) {
	XLOG_ERROR("Argument not found");
	return XrlCmdError::BAD_ARGS();
    }

    /* Marshall return values */
    try {
	pxa_outputs->add("sockid", sockid);
    } catch (const XrlArgs::XrlAtomFound& ) {
	XLOG_FATAL("Duplicate atom name"); /* XXX Should never happen */
    }
    return XrlCmdError::OKAY();
}

const XrlCmdError
XrlSocketServerTargetBase::handle_socket4_0_1_udp_join_group(const XrlArgs& xa_inputs, XrlArgs* /* pxa_outputs */)
{
    if (xa_inputs.size() != 3) {
	XLOG_ERROR("Wrong number of arguments (%u != %u) handling %s",
            3, (uint32_t)xa_inputs.size(), "socket4/0.1/udp_join_group");
	return XrlCmdError::BAD_ARGS();
    }

    /* Return value declarations */
    try {
	XrlCmdError e = socket4_0_1_udp_join_group(
	    xa_inputs.get_string("sockid"),
	    xa_inputs.get_ipv4("mcast_addr"),
	    xa_inputs.get_ipv4("join_if_addr"));
	if (e != XrlCmdError::OKAY()) {
	    XLOG_WARNING("Handling method for %s failed: %s",
            		 "socket4/0.1/udp_join_group", e.str().c_str());
	    return e;
        }
    } catch (const XrlArgs::XrlAtomNotFound& e) {
	XLOG_ERROR("Argument not found");
	return XrlCmdError::BAD_ARGS();
    }
    return XrlCmdError::OKAY();
}

const XrlCmdError
XrlSocketServerTargetBase::handle_socket4_0_1_udp_leave_group(const XrlArgs& xa_inputs, XrlArgs* /* pxa_outputs */)
{
    if (xa_inputs.size() != 3) {
	XLOG_ERROR("Wrong number of arguments (%u != %u) handling %s",
            3, (uint32_t)xa_inputs.size(), "socket4/0.1/udp_leave_group");
	return XrlCmdError::BAD_ARGS();
    }

    /* Return value declarations */
    try {
	XrlCmdError e = socket4_0_1_udp_leave_group(
	    xa_inputs.get_string("sockid"),
	    xa_inputs.get_ipv4("mcast_addr"),
	    xa_inputs.get_ipv4("leave_if_addr"));
	if (e != XrlCmdError::OKAY()) {
	    XLOG_WARNING("Handling method for %s failed: %s",
            		 "socket4/0.1/udp_leave_group", e.str().c_str());
	    return e;
        }
    } catch (const XrlArgs::XrlAtomNotFound& e) {
	XLOG_ERROR("Argument not found");
	return XrlCmdError::BAD_ARGS();
    }
    return XrlCmdError::OKAY();
}

const XrlCmdError
XrlSocketServerTargetBase::handle_socket4_0_1_close(const XrlArgs& xa_inputs, XrlArgs* /* pxa_outputs */)
{
    if (xa_inputs.size() != 1) {
	XLOG_ERROR("Wrong number of arguments (%u != %u) handling %s",
            1, (uint32_t)xa_inputs.size(), "socket4/0.1/close");
	return XrlCmdError::BAD_ARGS();
    }

    /* Return value declarations */
    try {
	XrlCmdError e = socket4_0_1_close(
	    xa_inputs.get_string("sockid"));
	if (e != XrlCmdError::OKAY()) {
	    XLOG_WARNING("Handling method for %s failed: %s",
            		 "socket4/0.1/close", e.str().c_str());
	    return e;
        }
    } catch (const XrlArgs::XrlAtomNotFound& e) {
	XLOG_ERROR("Argument not found");
	return XrlCmdError::BAD_ARGS();
    }
    return XrlCmdError::OKAY();
}

const XrlCmdError
XrlSocketServerTargetBase::handle_socket4_0_1_tcp_listen(const XrlArgs& xa_inputs, XrlArgs* /* pxa_outputs */)
{
    if (xa_inputs.size() != 2) {
	XLOG_ERROR("Wrong number of arguments (%u != %u) handling %s",
            2, (uint32_t)xa_inputs.size(), "socket4/0.1/tcp_listen");
	return XrlCmdError::BAD_ARGS();
    }

    /* Return value declarations */
    try {
	XrlCmdError e = socket4_0_1_tcp_listen(
	    xa_inputs.get_string("sockid"),
	    xa_inputs.get_uint32("backlog"));
	if (e != XrlCmdError::OKAY()) {
	    XLOG_WARNING("Handling method for %s failed: %s",
            		 "socket4/0.1/tcp_listen", e.str().c_str());
	    return e;
        }
    } catch (const XrlArgs::XrlAtomNotFound& e) {
	XLOG_ERROR("Argument not found");
	return XrlCmdError::BAD_ARGS();
    }
    return XrlCmdError::OKAY();
}

const XrlCmdError
XrlSocketServerTargetBase::handle_socket4_0_1_send(const XrlArgs& xa_inputs, XrlArgs* /* pxa_outputs */)
{
    if (xa_inputs.size() != 2) {
	XLOG_ERROR("Wrong number of arguments (%u != %u) handling %s",
            2, (uint32_t)xa_inputs.size(), "socket4/0.1/send");
	return XrlCmdError::BAD_ARGS();
    }

    /* Return value declarations */
    try {
	XrlCmdError e = socket4_0_1_send(
	    xa_inputs.get_string("sockid"),
	    xa_inputs.get_binary("data"));
	if (e != XrlCmdError::OKAY()) {
	    XLOG_WARNING("Handling method for %s failed: %s",
            		 "socket4/0.1/send", e.str().c_str());
	    return e;
        }
    } catch (const XrlArgs::XrlAtomNotFound& e) {
	XLOG_ERROR("Argument not found");
	return XrlCmdError::BAD_ARGS();
    }
    return XrlCmdError::OKAY();
}

const XrlCmdError
XrlSocketServerTargetBase::handle_socket4_0_1_send_with_flags(const XrlArgs& xa_inputs, XrlArgs* /* pxa_outputs */)
{
    if (xa_inputs.size() != 5) {
	XLOG_ERROR("Wrong number of arguments (%u != %u) handling %s",
            5, (uint32_t)xa_inputs.size(), "socket4/0.1/send_with_flags");
	return XrlCmdError::BAD_ARGS();
    }

    /* Return value declarations */
    try {
	XrlCmdError e = socket4_0_1_send_with_flags(
	    xa_inputs.get_string("sockid"),
	    xa_inputs.get_binary("data"),
	    xa_inputs.get_bool("out_of_band"),
	    xa_inputs.get_bool("end_of_record"),
	    xa_inputs.get_bool("end_of_file"));
	if (e != XrlCmdError::OKAY()) {
	    XLOG_WARNING("Handling method for %s failed: %s",
            		 "socket4/0.1/send_with_flags", e.str().c_str());
	    return e;
        }
    } catch (const XrlArgs::XrlAtomNotFound& e) {
	XLOG_ERROR("Argument not found");
	return XrlCmdError::BAD_ARGS();
    }
    return XrlCmdError::OKAY();
}

const XrlCmdError
XrlSocketServerTargetBase::handle_socket4_0_1_send_to(const XrlArgs& xa_inputs, XrlArgs* /* pxa_outputs */)
{
    if (xa_inputs.size() != 4) {
	XLOG_ERROR("Wrong number of arguments (%u != %u) handling %s",
            4, (uint32_t)xa_inputs.size(), "socket4/0.1/send_to");
	return XrlCmdError::BAD_ARGS();
    }

    /* Return value declarations */
    try {
	XrlCmdError e = socket4_0_1_send_to(
	    xa_inputs.get_string("sockid"),
	    xa_inputs.get_ipv4("remote_addr"),
	    xa_inputs.get_uint32("remote_port"),
	    xa_inputs.get_binary("data"));
	if (e != XrlCmdError::OKAY()) {
	    XLOG_WARNING("Handling method for %s failed: %s",
            		 "socket4/0.1/send_to", e.str().c_str());
	    return e;
        }
    } catch (const XrlArgs::XrlAtomNotFound& e) {
	XLOG_ERROR("Argument not found");
	return XrlCmdError::BAD_ARGS();
    }
    return XrlCmdError::OKAY();
}

const XrlCmdError
XrlSocketServerTargetBase::handle_socket4_0_1_send_to_with_flags(const XrlArgs& xa_inputs, XrlArgs* /* pxa_outputs */)
{
    if (xa_inputs.size() != 7) {
	XLOG_ERROR("Wrong number of arguments (%u != %u) handling %s",
            7, (uint32_t)xa_inputs.size(), "socket4/0.1/send_to_with_flags");
	return XrlCmdError::BAD_ARGS();
    }

    /* Return value declarations */
    try {
	XrlCmdError e = socket4_0_1_send_to_with_flags(
	    xa_inputs.get_string("sockid"),
	    xa_inputs.get_ipv4("remote_addr"),
	    xa_inputs.get_uint32("remote_port"),
	    xa_inputs.get_binary("data"),
	    xa_inputs.get_bool("out_of_band"),
	    xa_inputs.get_bool("end_of_record"),
	    xa_inputs.get_bool("end_of_file"));
	if (e != XrlCmdError::OKAY()) {
	    XLOG_WARNING("Handling method for %s failed: %s",
            		 "socket4/0.1/send_to_with_flags", e.str().c_str());
	    return e;
        }
    } catch (const XrlArgs::XrlAtomNotFound& e) {
	XLOG_ERROR("Argument not found");
	return XrlCmdError::BAD_ARGS();
    }
    return XrlCmdError::OKAY();
}

const XrlCmdError
XrlSocketServerTargetBase::handle_socket4_0_1_send_from_multicast_if(const XrlArgs& xa_inputs, XrlArgs* /* pxa_outputs */)
{
    if (xa_inputs.size() != 5) {
	XLOG_ERROR("Wrong number of arguments (%u != %u) handling %s",
            5, (uint32_t)xa_inputs.size(), "socket4/0.1/send_from_multicast_if");
	return XrlCmdError::BAD_ARGS();
    }

    /* Return value declarations */
    try {
	XrlCmdError e = socket4_0_1_send_from_multicast_if(
	    xa_inputs.get_string("sockid"),
	    xa_inputs.get_ipv4("group_addr"),
	    xa_inputs.get_uint32("group_port"),
	    xa_inputs.get_ipv4("ifaddr"),
	    xa_inputs.get_binary("data"));
	if (e != XrlCmdError::OKAY()) {
	    XLOG_WARNING("Handling method for %s failed: %s",
            		 "socket4/0.1/send_from_multicast_if", e.str().c_str());
	    return e;
        }
    } catch (const XrlArgs::XrlAtomNotFound& e) {
	XLOG_ERROR("Argument not found");
	return XrlCmdError::BAD_ARGS();
    }
    return XrlCmdError::OKAY();
}

const XrlCmdError
XrlSocketServerTargetBase::handle_socket4_0_1_set_socket_option(const XrlArgs& xa_inputs, XrlArgs* /* pxa_outputs */)
{
    if (xa_inputs.size() != 3) {
	XLOG_ERROR("Wrong number of arguments (%u != %u) handling %s",
            3, (uint32_t)xa_inputs.size(), "socket4/0.1/set_socket_option");
	return XrlCmdError::BAD_ARGS();
    }

    /* Return value declarations */
    try {
	XrlCmdError e = socket4_0_1_set_socket_option(
	    xa_inputs.get_string("sockid"),
	    xa_inputs.get_string("optname"),
	    xa_inputs.get_uint32("optval"));
	if (e != XrlCmdError::OKAY()) {
	    XLOG_WARNING("Handling method for %s failed: %s",
            		 "socket4/0.1/set_socket_option", e.str().c_str());
	    return e;
        }
    } catch (const XrlArgs::XrlAtomNotFound& e) {
	XLOG_ERROR("Argument not found");
	return XrlCmdError::BAD_ARGS();
    }
    return XrlCmdError::OKAY();
}

const XrlCmdError
XrlSocketServerTargetBase::handle_socket4_0_1_get_socket_option(const XrlArgs& xa_inputs, XrlArgs* pxa_outputs)
{
    if (xa_inputs.size() != 2) {
	XLOG_ERROR("Wrong number of arguments (%u != %u) handling %s",
            2, (uint32_t)xa_inputs.size(), "socket4/0.1/get_socket_option");
	return XrlCmdError::BAD_ARGS();
    }

    if (pxa_outputs == 0) {
	XLOG_FATAL("Return list empty");
	return XrlCmdError::BAD_ARGS();
    }

    /* Return value declarations */
    uint32_t optval;
    try {
	XrlCmdError e = socket4_0_1_get_socket_option(
	    xa_inputs.get_string("sockid"),
	    xa_inputs.get_string("optname"),
	    optval);
	if (e != XrlCmdError::OKAY()) {
	    XLOG_WARNING("Handling method for %s failed: %s",
            		 "socket4/0.1/get_socket_option", e.str().c_str());
	    return e;
        }
    } catch (const XrlArgs::XrlAtomNotFound& e) {
	XLOG_ERROR("Argument not found");
	return XrlCmdError::BAD_ARGS();
    }

    /* Marshall return values */
    try {
	pxa_outputs->add("optval", optval);
    } catch (const XrlArgs::XrlAtomFound& ) {
	XLOG_FATAL("Duplicate atom name"); /* XXX Should never happen */
    }
    return XrlCmdError::OKAY();
}

const XrlCmdError
XrlSocketServerTargetBase::handle_socket6_0_1_tcp_open_and_bind(const XrlArgs& xa_inputs, XrlArgs* pxa_outputs)
{
    if (xa_inputs.size() != 3) {
	XLOG_ERROR("Wrong number of arguments (%u != %u) handling %s",
            3, (uint32_t)xa_inputs.size(), "socket6/0.1/tcp_open_and_bind");
	return XrlCmdError::BAD_ARGS();
    }

    if (pxa_outputs == 0) {
	XLOG_FATAL("Return list empty");
	return XrlCmdError::BAD_ARGS();
    }

    /* Return value declarations */
    string sockid;
    try {
	XrlCmdError e = socket6_0_1_tcp_open_and_bind(
	    xa_inputs.get_string("creator"),
	    xa_inputs.get_ipv6("local_addr"),
	    xa_inputs.get_uint32("local_port"),
	    sockid);
	if (e != XrlCmdError::OKAY()) {
	    XLOG_WARNING("Handling method for %s failed: %s",
            		 "socket6/0.1/tcp_open_and_bind", e.str().c_str());
	    return e;
        }
    } catch (const XrlArgs::XrlAtomNotFound& e) {
	XLOG_ERROR("Argument not found");
	return XrlCmdError::BAD_ARGS();
    }

    /* Marshall return values */
    try {
	pxa_outputs->add("sockid", sockid);
    } catch (const XrlArgs::XrlAtomFound& ) {
	XLOG_FATAL("Duplicate atom name"); /* XXX Should never happen */
    }
    return XrlCmdError::OKAY();
}

const XrlCmdError
XrlSocketServerTargetBase::handle_socket6_0_1_udp_open_and_bind(const XrlArgs& xa_inputs, XrlArgs* pxa_outputs)
{
    if (xa_inputs.size() != 3) {
	XLOG_ERROR("Wrong number of arguments (%u != %u) handling %s",
            3, (uint32_t)xa_inputs.size(), "socket6/0.1/udp_open_and_bind");
	return XrlCmdError::BAD_ARGS();
    }

    if (pxa_outputs == 0) {
	XLOG_FATAL("Return list empty");
	return XrlCmdError::BAD_ARGS();
    }

    /* Return value declarations */
    string sockid;
    try {
	XrlCmdError e = socket6_0_1_udp_open_and_bind(
	    xa_inputs.get_string("creator"),
	    xa_inputs.get_ipv6("local_addr"),
	    xa_inputs.get_uint32("local_port"),
	    sockid);
	if (e != XrlCmdError::OKAY()) {
	    XLOG_WARNING("Handling method for %s failed: %s",
            		 "socket6/0.1/udp_open_and_bind", e.str().c_str());
	    return e;
        }
    } catch (const XrlArgs::XrlAtomNotFound& e) {
	XLOG_ERROR("Argument not found");
	return XrlCmdError::BAD_ARGS();
    }

    /* Marshall return values */
    try {
	pxa_outputs->add("sockid", sockid);
    } catch (const XrlArgs::XrlAtomFound& ) {
	XLOG_FATAL("Duplicate atom name"); /* XXX Should never happen */
    }
    return XrlCmdError::OKAY();
}

const XrlCmdError
XrlSocketServerTargetBase::handle_socket6_0_1_udp_open_bind_join(const XrlArgs& xa_inputs, XrlArgs* pxa_outputs)
{
    if (xa_inputs.size() != 6) {
	XLOG_ERROR("Wrong number of arguments (%u != %u) handling %s",
            6, (uint32_t)xa_inputs.size(), "socket6/0.1/udp_open_bind_join");
	return XrlCmdError::BAD_ARGS();
    }

    if (pxa_outputs == 0) {
	XLOG_FATAL("Return list empty");
	return XrlCmdError::BAD_ARGS();
    }

    /* Return value declarations */
    string sockid;
    try {
	XrlCmdError e = socket6_0_1_udp_open_bind_join(
	    xa_inputs.get_string("creator"),
	    xa_inputs.get_ipv6("local_addr"),
	    xa_inputs.get_uint32("local_port"),
	    xa_inputs.get_ipv6("mcast_addr"),
	    xa_inputs.get_uint32("ttl"),
	    xa_inputs.get_bool("reuse"),
	    sockid);
	if (e != XrlCmdError::OKAY()) {
	    XLOG_WARNING("Handling method for %s failed: %s",
            		 "socket6/0.1/udp_open_bind_join", e.str().c_str());
	    return e;
        }
    } catch (const XrlArgs::XrlAtomNotFound& e) {
	XLOG_ERROR("Argument not found");
	return XrlCmdError::BAD_ARGS();
    }

    /* Marshall return values */
    try {
	pxa_outputs->add("sockid", sockid);
    } catch (const XrlArgs::XrlAtomFound& ) {
	XLOG_FATAL("Duplicate atom name"); /* XXX Should never happen */
    }
    return XrlCmdError::OKAY();
}

const XrlCmdError
XrlSocketServerTargetBase::handle_socket6_0_1_tcp_open_bind_connect(const XrlArgs& xa_inputs, XrlArgs* pxa_outputs)
{
    if (xa_inputs.size() != 5) {
	XLOG_ERROR("Wrong number of arguments (%u != %u) handling %s",
            5, (uint32_t)xa_inputs.size(), "socket6/0.1/tcp_open_bind_connect");
	return XrlCmdError::BAD_ARGS();
    }

    if (pxa_outputs == 0) {
	XLOG_FATAL("Return list empty");
	return XrlCmdError::BAD_ARGS();
    }

    /* Return value declarations */
    string sockid;
    try {
	XrlCmdError e = socket6_0_1_tcp_open_bind_connect(
	    xa_inputs.get_string("creator"),
	    xa_inputs.get_ipv6("local_addr"),
	    xa_inputs.get_uint32("local_port"),
	    xa_inputs.get_ipv6("remote_addr"),
	    xa_inputs.get_uint32("remote_port"),
	    sockid);
	if (e != XrlCmdError::OKAY()) {
	    XLOG_WARNING("Handling method for %s failed: %s",
            		 "socket6/0.1/tcp_open_bind_connect", e.str().c_str());
	    return e;
        }
    } catch (const XrlArgs::XrlAtomNotFound& e) {
	XLOG_ERROR("Argument not found");
	return XrlCmdError::BAD_ARGS();
    }

    /* Marshall return values */
    try {
	pxa_outputs->add("sockid", sockid);
    } catch (const XrlArgs::XrlAtomFound& ) {
	XLOG_FATAL("Duplicate atom name"); /* XXX Should never happen */
    }
    return XrlCmdError::OKAY();
}

const XrlCmdError
XrlSocketServerTargetBase::handle_socket6_0_1_udp_open_bind_connect(const XrlArgs& xa_inputs, XrlArgs* pxa_outputs)
{
    if (xa_inputs.size() != 5) {
	XLOG_ERROR("Wrong number of arguments (%u != %u) handling %s",
            5, (uint32_t)xa_inputs.size(), "socket6/0.1/udp_open_bind_connect");
	return XrlCmdError::BAD_ARGS();
    }

    if (pxa_outputs == 0) {
	XLOG_FATAL("Return list empty");
	return XrlCmdError::BAD_ARGS();
    }

    /* Return value declarations */
    string sockid;
    try {
	XrlCmdError e = socket6_0_1_udp_open_bind_connect(
	    xa_inputs.get_string("creator"),
	    xa_inputs.get_ipv6("local_addr"),
	    xa_inputs.get_uint32("local_port"),
	    xa_inputs.get_ipv6("remote_addr"),
	    xa_inputs.get_uint32("remote_port"),
	    sockid);
	if (e != XrlCmdError::OKAY()) {
	    XLOG_WARNING("Handling method for %s failed: %s",
            		 "socket6/0.1/udp_open_bind_connect", e.str().c_str());
	    return e;
        }
    } catch (const XrlArgs::XrlAtomNotFound& e) {
	XLOG_ERROR("Argument not found");
	return XrlCmdError::BAD_ARGS();
    }

    /* Marshall return values */
    try {
	pxa_outputs->add("sockid", sockid);
    } catch (const XrlArgs::XrlAtomFound& ) {
	XLOG_FATAL("Duplicate atom name"); /* XXX Should never happen */
    }
    return XrlCmdError::OKAY();
}

const XrlCmdError
XrlSocketServerTargetBase::handle_socket6_0_1_udp_join_group(const XrlArgs& xa_inputs, XrlArgs* /* pxa_outputs */)
{
    if (xa_inputs.size() != 3) {
	XLOG_ERROR("Wrong number of arguments (%u != %u) handling %s",
            3, (uint32_t)xa_inputs.size(), "socket6/0.1/udp_join_group");
	return XrlCmdError::BAD_ARGS();
    }

    /* Return value declarations */
    try {
	XrlCmdError e = socket6_0_1_udp_join_group(
	    xa_inputs.get_string("sockid"),
	    xa_inputs.get_ipv6("mcast_addr"),
	    xa_inputs.get_ipv6("join_if_addr"));
	if (e != XrlCmdError::OKAY()) {
	    XLOG_WARNING("Handling method for %s failed: %s",
            		 "socket6/0.1/udp_join_group", e.str().c_str());
	    return e;
        }
    } catch (const XrlArgs::XrlAtomNotFound& e) {
	XLOG_ERROR("Argument not found");
	return XrlCmdError::BAD_ARGS();
    }
    return XrlCmdError::OKAY();
}

const XrlCmdError
XrlSocketServerTargetBase::handle_socket6_0_1_udp_leave_group(const XrlArgs& xa_inputs, XrlArgs* /* pxa_outputs */)
{
    if (xa_inputs.size() != 3) {
	XLOG_ERROR("Wrong number of arguments (%u != %u) handling %s",
            3, (uint32_t)xa_inputs.size(), "socket6/0.1/udp_leave_group");
	return XrlCmdError::BAD_ARGS();
    }

    /* Return value declarations */
    try {
	XrlCmdError e = socket6_0_1_udp_leave_group(
	    xa_inputs.get_string("sockid"),
	    xa_inputs.get_ipv6("mcast_addr"),
	    xa_inputs.get_ipv6("leave_if_addr"));
	if (e != XrlCmdError::OKAY()) {
	    XLOG_WARNING("Handling method for %s failed: %s",
            		 "socket6/0.1/udp_leave_group", e.str().c_str());
	    return e;
        }
    } catch (const XrlArgs::XrlAtomNotFound& e) {
	XLOG_ERROR("Argument not found");
	return XrlCmdError::BAD_ARGS();
    }
    return XrlCmdError::OKAY();
}

const XrlCmdError
XrlSocketServerTargetBase::handle_socket6_0_1_close(const XrlArgs& xa_inputs, XrlArgs* /* pxa_outputs */)
{
    if (xa_inputs.size() != 1) {
	XLOG_ERROR("Wrong number of arguments (%u != %u) handling %s",
            1, (uint32_t)xa_inputs.size(), "socket6/0.1/close");
	return XrlCmdError::BAD_ARGS();
    }

    /* Return value declarations */
    try {
	XrlCmdError e = socket6_0_1_close(
	    xa_inputs.get_string("sockid"));
	if (e != XrlCmdError::OKAY()) {
	    XLOG_WARNING("Handling method for %s failed: %s",
            		 "socket6/0.1/close", e.str().c_str());
	    return e;
        }
    } catch (const XrlArgs::XrlAtomNotFound& e) {
	XLOG_ERROR("Argument not found");
	return XrlCmdError::BAD_ARGS();
    }
    return XrlCmdError::OKAY();
}

const XrlCmdError
XrlSocketServerTargetBase::handle_socket6_0_1_tcp_listen(const XrlArgs& xa_inputs, XrlArgs* /* pxa_outputs */)
{
    if (xa_inputs.size() != 2) {
	XLOG_ERROR("Wrong number of arguments (%u != %u) handling %s",
            2, (uint32_t)xa_inputs.size(), "socket6/0.1/tcp_listen");
	return XrlCmdError::BAD_ARGS();
    }

    /* Return value declarations */
    try {
	XrlCmdError e = socket6_0_1_tcp_listen(
	    xa_inputs.get_string("sockid"),
	    xa_inputs.get_uint32("backlog"));
	if (e != XrlCmdError::OKAY()) {
	    XLOG_WARNING("Handling method for %s failed: %s",
            		 "socket6/0.1/tcp_listen", e.str().c_str());
	    return e;
        }
    } catch (const XrlArgs::XrlAtomNotFound& e) {
	XLOG_ERROR("Argument not found");
	return XrlCmdError::BAD_ARGS();
    }
    return XrlCmdError::OKAY();
}

const XrlCmdError
XrlSocketServerTargetBase::handle_socket6_0_1_send(const XrlArgs& xa_inputs, XrlArgs* /* pxa_outputs */)
{
    if (xa_inputs.size() != 2) {
	XLOG_ERROR("Wrong number of arguments (%u != %u) handling %s",
            2, (uint32_t)xa_inputs.size(), "socket6/0.1/send");
	return XrlCmdError::BAD_ARGS();
    }

    /* Return value declarations */
    try {
	XrlCmdError e = socket6_0_1_send(
	    xa_inputs.get_string("sockid"),
	    xa_inputs.get_binary("data"));
	if (e != XrlCmdError::OKAY()) {
	    XLOG_WARNING("Handling method for %s failed: %s",
            		 "socket6/0.1/send", e.str().c_str());
	    return e;
        }
    } catch (const XrlArgs::XrlAtomNotFound& e) {
	XLOG_ERROR("Argument not found");
	return XrlCmdError::BAD_ARGS();
    }
    return XrlCmdError::OKAY();
}

const XrlCmdError
XrlSocketServerTargetBase::handle_socket6_0_1_send_with_flags(const XrlArgs& xa_inputs, XrlArgs* /* pxa_outputs */)
{
    if (xa_inputs.size() != 5) {
	XLOG_ERROR("Wrong number of arguments (%u != %u) handling %s",
            5, (uint32_t)xa_inputs.size(), "socket6/0.1/send_with_flags");
	return XrlCmdError::BAD_ARGS();
    }

    /* Return value declarations */
    try {
	XrlCmdError e = socket6_0_1_send_with_flags(
	    xa_inputs.get_string("sockid"),
	    xa_inputs.get_binary("data"),
	    xa_inputs.get_bool("out_of_band"),
	    xa_inputs.get_bool("end_of_record"),
	    xa_inputs.get_bool("end_of_file"));
	if (e != XrlCmdError::OKAY()) {
	    XLOG_WARNING("Handling method for %s failed: %s",
            		 "socket6/0.1/send_with_flags", e.str().c_str());
	    return e;
        }
    } catch (const XrlArgs::XrlAtomNotFound& e) {
	XLOG_ERROR("Argument not found");
	return XrlCmdError::BAD_ARGS();
    }
    return XrlCmdError::OKAY();
}

const XrlCmdError
XrlSocketServerTargetBase::handle_socket6_0_1_send_to(const XrlArgs& xa_inputs, XrlArgs* /* pxa_outputs */)
{
    if (xa_inputs.size() != 4) {
	XLOG_ERROR("Wrong number of arguments (%u != %u) handling %s",
            4, (uint32_t)xa_inputs.size(), "socket6/0.1/send_to");
	return XrlCmdError::BAD_ARGS();
    }

    /* Return value declarations */
    try {
	XrlCmdError e = socket6_0_1_send_to(
	    xa_inputs.get_string("sockid"),
	    xa_inputs.get_ipv6("remote_addr"),
	    xa_inputs.get_uint32("remote_port"),
	    xa_inputs.get_binary("data"));
	if (e != XrlCmdError::OKAY()) {
	    XLOG_WARNING("Handling method for %s failed: %s",
            		 "socket6/0.1/send_to", e.str().c_str());
	    return e;
        }
    } catch (const XrlArgs::XrlAtomNotFound& e) {
	XLOG_ERROR("Argument not found");
	return XrlCmdError::BAD_ARGS();
    }
    return XrlCmdError::OKAY();
}

const XrlCmdError
XrlSocketServerTargetBase::handle_socket6_0_1_send_to_with_flags(const XrlArgs& xa_inputs, XrlArgs* /* pxa_outputs */)
{
    if (xa_inputs.size() != 7) {
	XLOG_ERROR("Wrong number of arguments (%u != %u) handling %s",
            7, (uint32_t)xa_inputs.size(), "socket6/0.1/send_to_with_flags");
	return XrlCmdError::BAD_ARGS();
    }

    /* Return value declarations */
    try {
	XrlCmdError e = socket6_0_1_send_to_with_flags(
	    xa_inputs.get_string("sockid"),
	    xa_inputs.get_ipv6("remote_addr"),
	    xa_inputs.get_uint32("remote_port"),
	    xa_inputs.get_binary("data"),
	    xa_inputs.get_bool("out_of_band"),
	    xa_inputs.get_bool("end_of_record"),
	    xa_inputs.get_bool("end_of_file"));
	if (e != XrlCmdError::OKAY()) {
	    XLOG_WARNING("Handling method for %s failed: %s",
            		 "socket6/0.1/send_to_with_flags", e.str().c_str());
	    return e;
        }
    } catch (const XrlArgs::XrlAtomNotFound& e) {
	XLOG_ERROR("Argument not found");
	return XrlCmdError::BAD_ARGS();
    }
    return XrlCmdError::OKAY();
}

const XrlCmdError
XrlSocketServerTargetBase::handle_socket6_0_1_send_from_multicast_if(const XrlArgs& xa_inputs, XrlArgs* /* pxa_outputs */)
{
    if (xa_inputs.size() != 5) {
	XLOG_ERROR("Wrong number of arguments (%u != %u) handling %s",
            5, (uint32_t)xa_inputs.size(), "socket6/0.1/send_from_multicast_if");
	return XrlCmdError::BAD_ARGS();
    }

    /* Return value declarations */
    try {
	XrlCmdError e = socket6_0_1_send_from_multicast_if(
	    xa_inputs.get_string("sockid"),
	    xa_inputs.get_ipv6("group_addr"),
	    xa_inputs.get_uint32("group_port"),
	    xa_inputs.get_ipv6("ifaddr"),
	    xa_inputs.get_binary("data"));
	if (e != XrlCmdError::OKAY()) {
	    XLOG_WARNING("Handling method for %s failed: %s",
            		 "socket6/0.1/send_from_multicast_if", e.str().c_str());
	    return e;
        }
    } catch (const XrlArgs::XrlAtomNotFound& e) {
	XLOG_ERROR("Argument not found");
	return XrlCmdError::BAD_ARGS();
    }
    return XrlCmdError::OKAY();
}

const XrlCmdError
XrlSocketServerTargetBase::handle_socket6_0_1_set_socket_option(const XrlArgs& xa_inputs, XrlArgs* /* pxa_outputs */)
{
    if (xa_inputs.size() != 3) {
	XLOG_ERROR("Wrong number of arguments (%u != %u) handling %s",
            3, (uint32_t)xa_inputs.size(), "socket6/0.1/set_socket_option");
	return XrlCmdError::BAD_ARGS();
    }

    /* Return value declarations */
    try {
	XrlCmdError e = socket6_0_1_set_socket_option(
	    xa_inputs.get_string("sockid"),
	    xa_inputs.get_string("optname"),
	    xa_inputs.get_uint32("optval"));
	if (e != XrlCmdError::OKAY()) {
	    XLOG_WARNING("Handling method for %s failed: %s",
            		 "socket6/0.1/set_socket_option", e.str().c_str());
	    return e;
        }
    } catch (const XrlArgs::XrlAtomNotFound& e) {
	XLOG_ERROR("Argument not found");
	return XrlCmdError::BAD_ARGS();
    }
    return XrlCmdError::OKAY();
}

const XrlCmdError
XrlSocketServerTargetBase::handle_socket6_0_1_get_socket_option(const XrlArgs& xa_inputs, XrlArgs* pxa_outputs)
{
    if (xa_inputs.size() != 2) {
	XLOG_ERROR("Wrong number of arguments (%u != %u) handling %s",
            2, (uint32_t)xa_inputs.size(), "socket6/0.1/get_socket_option");
	return XrlCmdError::BAD_ARGS();
    }

    if (pxa_outputs == 0) {
	XLOG_FATAL("Return list empty");
	return XrlCmdError::BAD_ARGS();
    }

    /* Return value declarations */
    uint32_t optval;
    try {
	XrlCmdError e = socket6_0_1_get_socket_option(
	    xa_inputs.get_string("sockid"),
	    xa_inputs.get_string("optname"),
	    optval);
	if (e != XrlCmdError::OKAY()) {
	    XLOG_WARNING("Handling method for %s failed: %s",
            		 "socket6/0.1/get_socket_option", e.str().c_str());
	    return e;
        }
    } catch (const XrlArgs::XrlAtomNotFound& e) {
	XLOG_ERROR("Argument not found");
	return XrlCmdError::BAD_ARGS();
    }

    /* Marshall return values */
    try {
	pxa_outputs->add("optval", optval);
    } catch (const XrlArgs::XrlAtomFound& ) {
	XLOG_FATAL("Duplicate atom name"); /* XXX Should never happen */
    }
    return XrlCmdError::OKAY();
}

void
XrlSocketServerTargetBase::add_handlers()
{
	if (_cmds->add_handler("common/0.1/get_target_name",
	    callback(this, &XrlSocketServerTargetBase::handle_common_0_1_get_target_name)) == false) {
	    XLOG_ERROR("Failed to xrl handler finder://%s/%s", "socket_server", "common/0.1/get_target_name");
	}
	if (_cmds->add_handler("common/0.1/get_version",
	    callback(this, &XrlSocketServerTargetBase::handle_common_0_1_get_version)) == false) {
	    XLOG_ERROR("Failed to xrl handler finder://%s/%s", "socket_server", "common/0.1/get_version");
	}
	if (_cmds->add_handler("common/0.1/get_status",
	    callback(this, &XrlSocketServerTargetBase::handle_common_0_1_get_status)) == false) {
	    XLOG_ERROR("Failed to xrl handler finder://%s/%s", "socket_server", "common/0.1/get_status");
	}
	if (_cmds->add_handler("common/0.1/shutdown",
	    callback(this, &XrlSocketServerTargetBase::handle_common_0_1_shutdown)) == false) {
	    XLOG_ERROR("Failed to xrl handler finder://%s/%s", "socket_server", "common/0.1/shutdown");
	}
	if (_cmds->add_handler("finder_event_observer/0.1/xrl_target_birth",
	    callback(this, &XrlSocketServerTargetBase::handle_finder_event_observer_0_1_xrl_target_birth)) == false) {
	    XLOG_ERROR("Failed to xrl handler finder://%s/%s", "socket_server", "finder_event_observer/0.1/xrl_target_birth");
	}
	if (_cmds->add_handler("finder_event_observer/0.1/xrl_target_death",
	    callback(this, &XrlSocketServerTargetBase::handle_finder_event_observer_0_1_xrl_target_death)) == false) {
	    XLOG_ERROR("Failed to xrl handler finder://%s/%s", "socket_server", "finder_event_observer/0.1/xrl_target_death");
	}
	if (_cmds->add_handler("socket4/0.1/tcp_open_and_bind",
	    callback(this, &XrlSocketServerTargetBase::handle_socket4_0_1_tcp_open_and_bind)) == false) {
	    XLOG_ERROR("Failed to xrl handler finder://%s/%s", "socket_server", "socket4/0.1/tcp_open_and_bind");
	}
	if (_cmds->add_handler("socket4/0.1/udp_open_and_bind",
	    callback(this, &XrlSocketServerTargetBase::handle_socket4_0_1_udp_open_and_bind)) == false) {
	    XLOG_ERROR("Failed to xrl handler finder://%s/%s", "socket_server", "socket4/0.1/udp_open_and_bind");
	}
	if (_cmds->add_handler("socket4/0.1/udp_open_bind_join",
	    callback(this, &XrlSocketServerTargetBase::handle_socket4_0_1_udp_open_bind_join)) == false) {
	    XLOG_ERROR("Failed to xrl handler finder://%s/%s", "socket_server", "socket4/0.1/udp_open_bind_join");
	}
	if (_cmds->add_handler("socket4/0.1/tcp_open_bind_connect",
	    callback(this, &XrlSocketServerTargetBase::handle_socket4_0_1_tcp_open_bind_connect)) == false) {
	    XLOG_ERROR("Failed to xrl handler finder://%s/%s", "socket_server", "socket4/0.1/tcp_open_bind_connect");
	}
	if (_cmds->add_handler("socket4/0.1/udp_open_bind_connect",
	    callback(this, &XrlSocketServerTargetBase::handle_socket4_0_1_udp_open_bind_connect)) == false) {
	    XLOG_ERROR("Failed to xrl handler finder://%s/%s", "socket_server", "socket4/0.1/udp_open_bind_connect");
	}
	if (_cmds->add_handler("socket4/0.1/udp_join_group",
	    callback(this, &XrlSocketServerTargetBase::handle_socket4_0_1_udp_join_group)) == false) {
	    XLOG_ERROR("Failed to xrl handler finder://%s/%s", "socket_server", "socket4/0.1/udp_join_group");
	}
	if (_cmds->add_handler("socket4/0.1/udp_leave_group",
	    callback(this, &XrlSocketServerTargetBase::handle_socket4_0_1_udp_leave_group)) == false) {
	    XLOG_ERROR("Failed to xrl handler finder://%s/%s", "socket_server", "socket4/0.1/udp_leave_group");
	}
	if (_cmds->add_handler("socket4/0.1/close",
	    callback(this, &XrlSocketServerTargetBase::handle_socket4_0_1_close)) == false) {
	    XLOG_ERROR("Failed to xrl handler finder://%s/%s", "socket_server", "socket4/0.1/close");
	}
	if (_cmds->add_handler("socket4/0.1/tcp_listen",
	    callback(this, &XrlSocketServerTargetBase::handle_socket4_0_1_tcp_listen)) == false) {
	    XLOG_ERROR("Failed to xrl handler finder://%s/%s", "socket_server", "socket4/0.1/tcp_listen");
	}
	if (_cmds->add_handler("socket4/0.1/send",
	    callback(this, &XrlSocketServerTargetBase::handle_socket4_0_1_send)) == false) {
	    XLOG_ERROR("Failed to xrl handler finder://%s/%s", "socket_server", "socket4/0.1/send");
	}
	if (_cmds->add_handler("socket4/0.1/send_with_flags",
	    callback(this, &XrlSocketServerTargetBase::handle_socket4_0_1_send_with_flags)) == false) {
	    XLOG_ERROR("Failed to xrl handler finder://%s/%s", "socket_server", "socket4/0.1/send_with_flags");
	}
	if (_cmds->add_handler("socket4/0.1/send_to",
	    callback(this, &XrlSocketServerTargetBase::handle_socket4_0_1_send_to)) == false) {
	    XLOG_ERROR("Failed to xrl handler finder://%s/%s", "socket_server", "socket4/0.1/send_to");
	}
	if (_cmds->add_handler("socket4/0.1/send_to_with_flags",
	    callback(this, &XrlSocketServerTargetBase::handle_socket4_0_1_send_to_with_flags)) == false) {
	    XLOG_ERROR("Failed to xrl handler finder://%s/%s", "socket_server", "socket4/0.1/send_to_with_flags");
	}
	if (_cmds->add_handler("socket4/0.1/send_from_multicast_if",
	    callback(this, &XrlSocketServerTargetBase::handle_socket4_0_1_send_from_multicast_if)) == false) {
	    XLOG_ERROR("Failed to xrl handler finder://%s/%s", "socket_server", "socket4/0.1/send_from_multicast_if");
	}
	if (_cmds->add_handler("socket4/0.1/set_socket_option",
	    callback(this, &XrlSocketServerTargetBase::handle_socket4_0_1_set_socket_option)) == false) {
	    XLOG_ERROR("Failed to xrl handler finder://%s/%s", "socket_server", "socket4/0.1/set_socket_option");
	}
	if (_cmds->add_handler("socket4/0.1/get_socket_option",
	    callback(this, &XrlSocketServerTargetBase::handle_socket4_0_1_get_socket_option)) == false) {
	    XLOG_ERROR("Failed to xrl handler finder://%s/%s", "socket_server", "socket4/0.1/get_socket_option");
	}
	if (_cmds->add_handler("socket6/0.1/tcp_open_and_bind",
	    callback(this, &XrlSocketServerTargetBase::handle_socket6_0_1_tcp_open_and_bind)) == false) {
	    XLOG_ERROR("Failed to xrl handler finder://%s/%s", "socket_server", "socket6/0.1/tcp_open_and_bind");
	}
	if (_cmds->add_handler("socket6/0.1/udp_open_and_bind",
	    callback(this, &XrlSocketServerTargetBase::handle_socket6_0_1_udp_open_and_bind)) == false) {
	    XLOG_ERROR("Failed to xrl handler finder://%s/%s", "socket_server", "socket6/0.1/udp_open_and_bind");
	}
	if (_cmds->add_handler("socket6/0.1/udp_open_bind_join",
	    callback(this, &XrlSocketServerTargetBase::handle_socket6_0_1_udp_open_bind_join)) == false) {
	    XLOG_ERROR("Failed to xrl handler finder://%s/%s", "socket_server", "socket6/0.1/udp_open_bind_join");
	}
	if (_cmds->add_handler("socket6/0.1/tcp_open_bind_connect",
	    callback(this, &XrlSocketServerTargetBase::handle_socket6_0_1_tcp_open_bind_connect)) == false) {
	    XLOG_ERROR("Failed to xrl handler finder://%s/%s", "socket_server", "socket6/0.1/tcp_open_bind_connect");
	}
	if (_cmds->add_handler("socket6/0.1/udp_open_bind_connect",
	    callback(this, &XrlSocketServerTargetBase::handle_socket6_0_1_udp_open_bind_connect)) == false) {
	    XLOG_ERROR("Failed to xrl handler finder://%s/%s", "socket_server", "socket6/0.1/udp_open_bind_connect");
	}
	if (_cmds->add_handler("socket6/0.1/udp_join_group",
	    callback(this, &XrlSocketServerTargetBase::handle_socket6_0_1_udp_join_group)) == false) {
	    XLOG_ERROR("Failed to xrl handler finder://%s/%s", "socket_server", "socket6/0.1/udp_join_group");
	}
	if (_cmds->add_handler("socket6/0.1/udp_leave_group",
	    callback(this, &XrlSocketServerTargetBase::handle_socket6_0_1_udp_leave_group)) == false) {
	    XLOG_ERROR("Failed to xrl handler finder://%s/%s", "socket_server", "socket6/0.1/udp_leave_group");
	}
	if (_cmds->add_handler("socket6/0.1/close",
	    callback(this, &XrlSocketServerTargetBase::handle_socket6_0_1_close)) == false) {
	    XLOG_ERROR("Failed to xrl handler finder://%s/%s", "socket_server", "socket6/0.1/close");
	}
	if (_cmds->add_handler("socket6/0.1/tcp_listen",
	    callback(this, &XrlSocketServerTargetBase::handle_socket6_0_1_tcp_listen)) == false) {
	    XLOG_ERROR("Failed to xrl handler finder://%s/%s", "socket_server", "socket6/0.1/tcp_listen");
	}
	if (_cmds->add_handler("socket6/0.1/send",
	    callback(this, &XrlSocketServerTargetBase::handle_socket6_0_1_send)) == false) {
	    XLOG_ERROR("Failed to xrl handler finder://%s/%s", "socket_server", "socket6/0.1/send");
	}
	if (_cmds->add_handler("socket6/0.1/send_with_flags",
	    callback(this, &XrlSocketServerTargetBase::handle_socket6_0_1_send_with_flags)) == false) {
	    XLOG_ERROR("Failed to xrl handler finder://%s/%s", "socket_server", "socket6/0.1/send_with_flags");
	}
	if (_cmds->add_handler("socket6/0.1/send_to",
	    callback(this, &XrlSocketServerTargetBase::handle_socket6_0_1_send_to)) == false) {
	    XLOG_ERROR("Failed to xrl handler finder://%s/%s", "socket_server", "socket6/0.1/send_to");
	}
	if (_cmds->add_handler("socket6/0.1/send_to_with_flags",
	    callback(this, &XrlSocketServerTargetBase::handle_socket6_0_1_send_to_with_flags)) == false) {
	    XLOG_ERROR("Failed to xrl handler finder://%s/%s", "socket_server", "socket6/0.1/send_to_with_flags");
	}
	if (_cmds->add_handler("socket6/0.1/send_from_multicast_if",
	    callback(this, &XrlSocketServerTargetBase::handle_socket6_0_1_send_from_multicast_if)) == false) {
	    XLOG_ERROR("Failed to xrl handler finder://%s/%s", "socket_server", "socket6/0.1/send_from_multicast_if");
	}
	if (_cmds->add_handler("socket6/0.1/set_socket_option",
	    callback(this, &XrlSocketServerTargetBase::handle_socket6_0_1_set_socket_option)) == false) {
	    XLOG_ERROR("Failed to xrl handler finder://%s/%s", "socket_server", "socket6/0.1/set_socket_option");
	}
	if (_cmds->add_handler("socket6/0.1/get_socket_option",
	    callback(this, &XrlSocketServerTargetBase::handle_socket6_0_1_get_socket_option)) == false) {
	    XLOG_ERROR("Failed to xrl handler finder://%s/%s", "socket_server", "socket6/0.1/get_socket_option");
	}
	_cmds->finalize();
}

void
XrlSocketServerTargetBase::remove_handlers()
{
	_cmds->remove_handler("common/0.1/get_target_name");
	_cmds->remove_handler("common/0.1/get_version");
	_cmds->remove_handler("common/0.1/get_status");
	_cmds->remove_handler("common/0.1/shutdown");
	_cmds->remove_handler("finder_event_observer/0.1/xrl_target_birth");
	_cmds->remove_handler("finder_event_observer/0.1/xrl_target_death");
	_cmds->remove_handler("socket4/0.1/tcp_open_and_bind");
	_cmds->remove_handler("socket4/0.1/udp_open_and_bind");
	_cmds->remove_handler("socket4/0.1/udp_open_bind_join");
	_cmds->remove_handler("socket4/0.1/tcp_open_bind_connect");
	_cmds->remove_handler("socket4/0.1/udp_open_bind_connect");
	_cmds->remove_handler("socket4/0.1/udp_join_group");
	_cmds->remove_handler("socket4/0.1/udp_leave_group");
	_cmds->remove_handler("socket4/0.1/close");
	_cmds->remove_handler("socket4/0.1/tcp_listen");
	_cmds->remove_handler("socket4/0.1/send");
	_cmds->remove_handler("socket4/0.1/send_with_flags");
	_cmds->remove_handler("socket4/0.1/send_to");
	_cmds->remove_handler("socket4/0.1/send_to_with_flags");
	_cmds->remove_handler("socket4/0.1/send_from_multicast_if");
	_cmds->remove_handler("socket4/0.1/set_socket_option");
	_cmds->remove_handler("socket4/0.1/get_socket_option");
	_cmds->remove_handler("socket6/0.1/tcp_open_and_bind");
	_cmds->remove_handler("socket6/0.1/udp_open_and_bind");
	_cmds->remove_handler("socket6/0.1/udp_open_bind_join");
	_cmds->remove_handler("socket6/0.1/tcp_open_bind_connect");
	_cmds->remove_handler("socket6/0.1/udp_open_bind_connect");
	_cmds->remove_handler("socket6/0.1/udp_join_group");
	_cmds->remove_handler("socket6/0.1/udp_leave_group");
	_cmds->remove_handler("socket6/0.1/close");
	_cmds->remove_handler("socket6/0.1/tcp_listen");
	_cmds->remove_handler("socket6/0.1/send");
	_cmds->remove_handler("socket6/0.1/send_with_flags");
	_cmds->remove_handler("socket6/0.1/send_to");
	_cmds->remove_handler("socket6/0.1/send_to_with_flags");
	_cmds->remove_handler("socket6/0.1/send_from_multicast_if");
	_cmds->remove_handler("socket6/0.1/set_socket_option");
	_cmds->remove_handler("socket6/0.1/get_socket_option");
}
