/*
 * Copyright (c) 2001-2004 International Computer Science Institute
 * See LICENSE file for licensing, conditions, and warranties on use.
 *
 * DO NOT EDIT THIS FILE - IT IS PROGRAMMATICALLY GENERATED
 *
 * Generated by 'tgt-gen'.
 *
 * $XORP: xorp/xrl/targets/pim_base.hh,v 1.40 2004/06/10 22:42:13 hodson Exp $
 */


#ifndef __XRL_INTERFACES_PIM_BASE_HH__
#define __XRL_INTERFACES_PIM_BASE_HH__

#undef XORP_LIBRARY_NAME
#define XORP_LIBRARY_NAME "XrlPimTarget"

#include "libxorp/xlog.h"
#include "libxipc/xrl_cmd_map.hh"

class XrlPimTargetBase {
protected:
    XrlCmdMap* _cmds;

public:
    /**
     * Constructor.
     *
     * @param cmds an XrlCmdMap that the commands associated with the target
     *		   should be added to.  This is typically the XrlRouter
     *		   associated with the target.
     */
    XrlPimTargetBase(XrlCmdMap* cmds = 0);

    /**
     * Destructor.
     *
     * Dissociates instance commands from command map.
     */
    virtual ~XrlPimTargetBase();

    /**
     * Set command map.
     *
     * @param cmds pointer to command map to associate commands with.  This
     * argument is typically a pointer to the XrlRouter associated with the
     * target.
     *
     * @return true on success, false if cmds is null or a command map has
     * already been supplied.
     */
    bool set_command_map(XrlCmdMap* cmds);

    /**
     * Get Xrl instance name associated with command map.
     */
    inline const string& name() const { return _cmds->name(); }

    /**
     * Get version string of instance.
     */
    inline const char* version() const { return "pim/0.0"; }

protected:

    /**
     *  Pure-virtual function that needs to be implemented to:
     *
     *  Get name of Xrl Target
     */
    virtual XrlCmdError common_0_1_get_target_name(
	// Output values,
	string&	name) = 0;

    /**
     *  Pure-virtual function that needs to be implemented to:
     *
     *  Get version string from Xrl Target
     */
    virtual XrlCmdError common_0_1_get_version(
	// Output values,
	string&	version) = 0;

    /**
     *  Pure-virtual function that needs to be implemented to:
     *
     *  Get status of Xrl Target
     */
    virtual XrlCmdError common_0_1_get_status(
	// Output values,
	uint32_t&	status,
	string&	reason) = 0;

    /**
     *  Pure-virtual function that needs to be implemented to:
     *
     *  Request clean shutdown of Xrl Target
     */
    virtual XrlCmdError common_0_1_shutdown() = 0;

    /**
     *  Pure-virtual function that needs to be implemented to:
     *
     *  Process a CLI command.
     *
     *  @param processor_name the processor name for this command.
     *
     *  @param cli_term_name the terminal name the command was entered from.
     *
     *  @param cli_session_id the CLI session ID the command was entered from.
     *
     *  @param command_name the command name to process.
     *
     *  @param command_args the command arguments to process.
     *
     *  @param ret_processor_name the processor name to return back to the CLI.
     *
     *  @param ret_cli_term_name the terminal name to return back.
     *
     *  @param ret_cli_session_id the CLI session ID to return back.
     *
     *  @param ret_command_output the command output to return back.
     */
    virtual XrlCmdError cli_processor_0_1_process_command(
	// Input values,
	const string&	processor_name,
	const string&	cli_term_name,
	const uint32_t&	cli_session_id,
	const string&	command_name,
	const string&	command_args,
	// Output values,
	string&	ret_processor_name,
	string&	ret_cli_term_name,
	uint32_t&	ret_cli_session_id,
	string&	ret_command_output) = 0;

    /**
     *  Pure-virtual function that needs to be implemented to:
     *
     *  Add a new vif.
     *
     *  @param vif_name the name of the new vif.
     *
     *  @param vif_index the index of the new vif.
     */
    virtual XrlCmdError mfea_client_0_1_new_vif(
	// Input values,
	const string&	vif_name,
	const uint32_t&	vif_index) = 0;

    /**
     *  Pure-virtual function that needs to be implemented to:
     *
     *  Delete an existing vif.
     *
     *  @param vif_name the name of the vif to delete.
     */
    virtual XrlCmdError mfea_client_0_1_delete_vif(
	// Input values,
	const string&	vif_name) = 0;

    /**
     *  Pure-virtual function that needs to be implemented to:
     *
     *  Add an address to a vif.
     *
     *  @param vif_name the name of the vif.
     *
     *  @param addr the unicast address to add.
     *
     *  @param subnet the subnet address to add.
     *
     *  @param broadcast the broadcast address (when applicable).
     *
     *  @param peer the peer address (when applicable).
     */
    virtual XrlCmdError mfea_client_0_1_add_vif_addr4(
	// Input values,
	const string&	vif_name,
	const IPv4&	addr,
	const IPv4Net&	subnet,
	const IPv4&	broadcast,
	const IPv4&	peer) = 0;

    virtual XrlCmdError mfea_client_0_1_add_vif_addr6(
	// Input values,
	const string&	vif_name,
	const IPv6&	addr,
	const IPv6Net&	subnet,
	const IPv6&	broadcast,
	const IPv6&	peer) = 0;

    /**
     *  Pure-virtual function that needs to be implemented to:
     *
     *  Delete an address from a vif.
     *
     *  @param vif_name the name of the vif.
     *
     *  @param addr the unicast address to delete.
     */
    virtual XrlCmdError mfea_client_0_1_delete_vif_addr4(
	// Input values,
	const string&	vif_name,
	const IPv4&	addr) = 0;

    virtual XrlCmdError mfea_client_0_1_delete_vif_addr6(
	// Input values,
	const string&	vif_name,
	const IPv6&	addr) = 0;

    /**
     *  Pure-virtual function that needs to be implemented to:
     *
     *  Set flags to a vif.
     *
     *  @param vif_name the name of the vif.
     *
     *  @param is_pim_register true if this is a PIM Register vif.
     *
     *  @param is_p2p true if this is a point-to-point vif.
     *
     *  @param is_loopback true if this is a loopback interface.
     *
     *  @param is_multicast true if the vif is multicast-capable.
     *
     *  @param is_broadcast true if the vif is broadcast-capable.
     *
     *  @param is_up true if the vif is UP and running.
     */
    virtual XrlCmdError mfea_client_0_1_set_vif_flags(
	// Input values,
	const string&	vif_name,
	const bool&	is_pim_register,
	const bool&	is_p2p,
	const bool&	is_loopback,
	const bool&	is_multicast,
	const bool&	is_broadcast,
	const bool&	is_up) = 0;

    /**
     *  Pure-virtual function that needs to be implemented to:
     *
     *  Complete all transactions with vif information.
     */
    virtual XrlCmdError mfea_client_0_1_set_all_vifs_done() = 0;

    /**
     *  Pure-virtual function that needs to be implemented to:
     *
     *  Test if the vif setup is completed.
     *
     *  @param is_completed if true the vif setup is completed.
     */
    virtual XrlCmdError mfea_client_0_1_is_vif_setup_completed(
	// Output values,
	bool&	is_completed) = 0;

    /**
     *  Pure-virtual function that needs to be implemented to:
     *
     *  Receive a protocol message from the MFEA.
     *
     *  @param xrl_sender_name the XRL name of the originator of this XRL.
     *
     *  @param protocol_name the name of the protocol that sends a message.
     *
     *  @param protocol_id the ID of the protocol that sends a message (both
     *  sides must agree on the particular values).
     *
     *  @param vif_name the name of the vif the message was received on.
     *
     *  @param vif_index the index of the vif the message was received on.
     *
     *  @param source_address the address of the sender.
     *
     *  @param dest_address the destination address.
     *
     *  @param ip_ttl the TTL of the received IP packet. If it has a negative
     *  value, it should be ignored.
     *
     *  @param ip_tos the TOS of the received IP packet. If it has a negative
     *  value, it should be ignored.
     *
     *  @param is_router_alert if true, the IP Router Alert option in the IP
     *  packet was set (when applicable).
     *
     *  @param protocol_message the protocol message.
     */
    virtual XrlCmdError mfea_client_0_1_recv_protocol_message4(
	// Input values,
	const string&	xrl_sender_name,
	const string&	protocol_name,
	const uint32_t&	protocol_id,
	const string&	vif_name,
	const uint32_t&	vif_index,
	const IPv4&	source_address,
	const IPv4&	dest_address,
	const int32_t&	ip_ttl,
	const int32_t&	ip_tos,
	const bool&	is_router_alert,
	const vector<uint8_t>&	protocol_message) = 0;

    virtual XrlCmdError mfea_client_0_1_recv_protocol_message6(
	// Input values,
	const string&	xrl_sender_name,
	const string&	protocol_name,
	const uint32_t&	protocol_id,
	const string&	vif_name,
	const uint32_t&	vif_index,
	const IPv6&	source_address,
	const IPv6&	dest_address,
	const int32_t&	ip_ttl,
	const int32_t&	ip_tos,
	const bool&	is_router_alert,
	const vector<uint8_t>&	protocol_message) = 0;

    /**
     *  Pure-virtual function that needs to be implemented to:
     *
     *  Receive a kernel signal message from the MFEA.
     *
     *  @param xrl_sender_name the XRL name of the originator of this XRL.
     *
     *  @param protocol_name the name of the protocol that sends a message.
     *
     *  @param protocol_id the ID of the protocol that sends a message (both
     *  sides must agree on the particular values).
     *
     *  @param message_type the type of the kernel signal message (TODO:
     *  integer for now: the particular types are well-known by both sides).
     *
     *  @param vif_name the name of the vif the message was received on.
     *
     *  @param vif_index the index of the vif the message was received on.
     *
     *  @param source_address the address of the sender.
     *
     *  @param dest_address the destination address.
     *
     *  @param protocol_message the protocol message.
     */
    virtual XrlCmdError mfea_client_0_1_recv_kernel_signal_message4(
	// Input values,
	const string&	xrl_sender_name,
	const string&	protocol_name,
	const uint32_t&	protocol_id,
	const uint32_t&	message_type,
	const string&	vif_name,
	const uint32_t&	vif_index,
	const IPv4&	source_address,
	const IPv4&	dest_address,
	const vector<uint8_t>&	protocol_message) = 0;

    virtual XrlCmdError mfea_client_0_1_recv_kernel_signal_message6(
	// Input values,
	const string&	xrl_sender_name,
	const string&	protocol_name,
	const uint32_t&	protocol_id,
	const uint32_t&	message_type,
	const string&	vif_name,
	const uint32_t&	vif_index,
	const IPv6&	source_address,
	const IPv6&	dest_address,
	const vector<uint8_t>&	protocol_message) = 0;

    /**
     *  Pure-virtual function that needs to be implemented to:
     *
     *  Add Multicast Routing Information Base information.
     *
     *  @param xrl_sender_name the XRL name of the originator of this XRL.
     *
     *  @param dest_prefix the destination prefix to add.
     *
     *  @param next_hop_router_addr the address of the next-hop router toward
     *  the destination prefix.
     *
     *  @param next_hop_vif_name the name of the vif toward the destination
     *  prefix.
     *
     *  @param next_hop_vif_index the index of the vif toward the destination
     *  prefix.
     *
     *  @param metric_preference the metric preference for this entry.
     *
     *  @param metric the metric for this entry.
     */
    virtual XrlCmdError mfea_client_0_1_add_mrib4(
	// Input values,
	const string&	xrl_sender_name,
	const IPv4Net&	dest_prefix,
	const IPv4&	next_hop_router_addr,
	const string&	next_hop_vif_name,
	const uint32_t&	next_hop_vif_index,
	const uint32_t&	metric_preference,
	const uint32_t&	metric) = 0;

    virtual XrlCmdError mfea_client_0_1_add_mrib6(
	// Input values,
	const string&	xrl_sender_name,
	const IPv6Net&	dest_prefix,
	const IPv6&	next_hop_router_addr,
	const string&	next_hop_vif_name,
	const uint32_t&	next_hop_vif_index,
	const uint32_t&	metric_preference,
	const uint32_t&	metric) = 0;

    /**
     *  Pure-virtual function that needs to be implemented to:
     *
     *  Delete Multicast Routing Information Base information.
     *
     *  @param xrl_sender_name the XRL name of the originator of this XRL.
     *
     *  @param dest_prefix the destination prefix to delete.
     */
    virtual XrlCmdError mfea_client_0_1_delete_mrib4(
	// Input values,
	const string&	xrl_sender_name,
	const IPv4Net&	dest_prefix) = 0;

    virtual XrlCmdError mfea_client_0_1_delete_mrib6(
	// Input values,
	const string&	xrl_sender_name,
	const IPv6Net&	dest_prefix) = 0;

    /**
     *  Pure-virtual function that needs to be implemented to:
     *
     *  Complete a transaction with MRIB information.
     *
     *  @param xrl_sender_name the XRL name of the originator of this XRL.
     */
    virtual XrlCmdError mfea_client_0_1_set_mrib_done(
	// Input values,
	const string&	xrl_sender_name) = 0;

    /**
     *  Pure-virtual function that needs to be implemented to:
     *
     *  A signal that a dataflow-related pre-condition is true.
     *
     *  @param xrl_sender_name the XRL name of the originator of this XRL.
     *
     *  @param source_address the source address of the dataflow.
     *
     *  @param group_address the group address of the dataflow.
     *
     *  @param threshold_interval_sec the number of seconds in the interval
     *  requested for measurement.
     *
     *  @param threshold_interval_usec the number of microseconds in the
     *  interval requested for measurement.
     *
     *  @param measured_interval_sec the number of seconds in the last measured
     *  interval that has triggered the signal.
     *
     *  @param measured_interval_usec the number of microseconds in the last
     *  measured interval that has triggered the signal.
     *
     *  @param threshold_packets the threshold value to trigger a signal (in
     *  number of packets).
     *
     *  @param threshold_bytes the threshold value to trigger a signal (in
     *  bytes).
     *
     *  @param measured_packets the number of packets measured within the
     *  measured interval.
     *
     *  @param measured_bytes the number of bytes measured within the measured
     *  interval.
     *
     *  @param is_threshold_in_packets if true, threshold_packets is valid.
     *
     *  @param is_threshold_in_bytes if true, threshold_bytes is valid.
     *
     *  @param is_geq_upcall if true, the operation for comparison is ">=".
     *
     *  @param is_leq_upcall if true, the operation for comparison is "<=".
     */
    virtual XrlCmdError mfea_client_0_1_recv_dataflow_signal4(
	// Input values,
	const string&	xrl_sender_name,
	const IPv4&	source_address,
	const IPv4&	group_address,
	const uint32_t&	threshold_interval_sec,
	const uint32_t&	threshold_interval_usec,
	const uint32_t&	measured_interval_sec,
	const uint32_t&	measured_interval_usec,
	const uint32_t&	threshold_packets,
	const uint32_t&	threshold_bytes,
	const uint32_t&	measured_packets,
	const uint32_t&	measured_bytes,
	const bool&	is_threshold_in_packets,
	const bool&	is_threshold_in_bytes,
	const bool&	is_geq_upcall,
	const bool&	is_leq_upcall) = 0;

    virtual XrlCmdError mfea_client_0_1_recv_dataflow_signal6(
	// Input values,
	const string&	xrl_sender_name,
	const IPv6&	source_address,
	const IPv6&	group_address,
	const uint32_t&	threshold_interval_sec,
	const uint32_t&	threshold_interval_usec,
	const uint32_t&	measured_interval_sec,
	const uint32_t&	measured_interval_usec,
	const uint32_t&	threshold_packets,
	const uint32_t&	threshold_bytes,
	const uint32_t&	measured_packets,
	const uint32_t&	measured_bytes,
	const bool&	is_threshold_in_packets,
	const bool&	is_threshold_in_bytes,
	const bool&	is_geq_upcall,
	const bool&	is_leq_upcall) = 0;

    /**
     *  Pure-virtual function that needs to be implemented to:
     *
     *  Start transaction.
     *
     *  @param tid the transaction ID to use for this transaction.
     */
    virtual XrlCmdError redist_transaction4_0_1_start_transaction(
	// Output values,
	uint32_t&	tid) = 0;

    /**
     *  Pure-virtual function that needs to be implemented to:
     *
     *  Commit transaction.
     *
     *  @param tid the transaction ID of this transaction.
     */
    virtual XrlCmdError redist_transaction4_0_1_commit_transaction(
	// Input values,
	const uint32_t&	tid) = 0;

    /**
     *  Pure-virtual function that needs to be implemented to:
     *
     *  Abort transaction.
     *
     *  @param tid the transaction ID of this transaction.
     */
    virtual XrlCmdError redist_transaction4_0_1_abort_transaction(
	// Input values,
	const uint32_t&	tid) = 0;

    /**
     *  Pure-virtual function that needs to be implemented to:
     *
     *  Add/delete a routing entry.
     *
     *  @param tid the transaction ID of this transaction.
     *
     *  @param dst destination network.
     *
     *  @param nh nexthop router address.
     *
     *  @param ifname interface name associated with nexthop.
     *
     *  @param vifname virtual interface name with nexthop.
     *
     *  @param metric origin routing protocol metric for route.
     *
     *  @param ad administrative distance of origin routing protocol.
     *
     *  @param cookie value set be requestor to identify redistribution source.
     *  Typical value is the originating protocol name.
     *
     *  @param protocol_origin the name of the protocol that originated this
     *  entry.
     */
    virtual XrlCmdError redist_transaction4_0_1_add_route(
	// Input values,
	const uint32_t&	tid,
	const IPv4Net&	dst,
	const IPv4&	nh,
	const string&	ifname,
	const string&	vifname,
	const uint32_t&	metric,
	const uint32_t&	ad,
	const string&	cookie,
	const string&	protocol_origin) = 0;

    virtual XrlCmdError redist_transaction4_0_1_delete_route(
	// Input values,
	const uint32_t&	tid,
	const IPv4Net&	network,
	const string&	cookie) = 0;

    /**
     *  Pure-virtual function that needs to be implemented to:
     *
     *  Start transaction.
     *
     *  @param tid the transaction ID to use for this transaction.
     */
    virtual XrlCmdError redist_transaction6_0_1_start_transaction(
	// Output values,
	uint32_t&	tid) = 0;

    /**
     *  Pure-virtual function that needs to be implemented to:
     *
     *  Commit transaction.
     *
     *  @param tid the transaction ID of this transaction.
     */
    virtual XrlCmdError redist_transaction6_0_1_commit_transaction(
	// Input values,
	const uint32_t&	tid) = 0;

    /**
     *  Pure-virtual function that needs to be implemented to:
     *
     *  Abort transaction.
     *
     *  @param tid the transaction ID of this transaction.
     */
    virtual XrlCmdError redist_transaction6_0_1_abort_transaction(
	// Input values,
	const uint32_t&	tid) = 0;

    /**
     *  Pure-virtual function that needs to be implemented to:
     *
     *  Add/delete a routing entry.
     *
     *  @param tid the transaction ID of this transaction.
     *
     *  @param dst destination network.
     *
     *  @param nh nexthop router address.
     *
     *  @param ifname interface name associated with nexthop.
     *
     *  @param vifname virtual interface name with nexthop.
     *
     *  @param metric origin routing protocol metric for route.
     *
     *  @param ad administrative distance of origin routing protocol.
     *
     *  @param cookie value set be requestor to identify redistribution source.
     *  Typical value is the originating protocol name.
     *
     *  @param protocol_origin the name of the protocol that originated this
     *  entry.
     */
    virtual XrlCmdError redist_transaction6_0_1_add_route(
	// Input values,
	const uint32_t&	tid,
	const IPv6Net&	dst,
	const IPv6&	nh,
	const string&	ifname,
	const string&	vifname,
	const uint32_t&	metric,
	const uint32_t&	ad,
	const string&	cookie,
	const string&	protocol_origin) = 0;

    virtual XrlCmdError redist_transaction6_0_1_delete_route(
	// Input values,
	const uint32_t&	tid,
	const IPv6Net&	network,
	const string&	cookie) = 0;

    /**
     *  Pure-virtual function that needs to be implemented to:
     *
     *  Add/delete membership information.
     *
     *  @param xrl_sender_name the XRL name of the originator of this XRL.
     *
     *  @param vif_name the name of the new vif.
     *
     *  @param vif_index the index of the new vif.
     *
     *  @param source the source address that has been joined/left.
     *
     *  @param group the group address that has been joined/left.
     */
    virtual XrlCmdError mld6igmp_client_0_1_add_membership4(
	// Input values,
	const string&	xrl_sender_name,
	const string&	vif_name,
	const uint32_t&	vif_index,
	const IPv4&	source,
	const IPv4&	group) = 0;

    virtual XrlCmdError mld6igmp_client_0_1_add_membership6(
	// Input values,
	const string&	xrl_sender_name,
	const string&	vif_name,
	const uint32_t&	vif_index,
	const IPv6&	source,
	const IPv6&	group) = 0;

    virtual XrlCmdError mld6igmp_client_0_1_delete_membership4(
	// Input values,
	const string&	xrl_sender_name,
	const string&	vif_name,
	const uint32_t&	vif_index,
	const IPv4&	source,
	const IPv4&	group) = 0;

    virtual XrlCmdError mld6igmp_client_0_1_delete_membership6(
	// Input values,
	const string&	xrl_sender_name,
	const string&	vif_name,
	const uint32_t&	vif_index,
	const IPv6&	source,
	const IPv6&	group) = 0;

    /**
     *  Pure-virtual function that needs to be implemented to:
     *
     *  Enable/disable/start/stop a PIM vif interface.
     *
     *  @param vif_name the name of the vif to enable/disable/start/stop.
     *
     *  @param enable if true, then enable the vif, otherwise disable it.
     */
    virtual XrlCmdError pim_0_1_enable_vif(
	// Input values,
	const string&	vif_name,
	const bool&	enable) = 0;

    virtual XrlCmdError pim_0_1_start_vif(
	// Input values,
	const string&	vif_name) = 0;

    virtual XrlCmdError pim_0_1_stop_vif(
	// Input values,
	const string&	vif_name) = 0;

    /**
     *  Pure-virtual function that needs to be implemented to:
     *
     *  Enable/disable/start/stop all PIM vif interfaces.
     *
     *  @param enable if true, then enable the vifs, otherwise disable them.
     */
    virtual XrlCmdError pim_0_1_enable_all_vifs(
	// Input values,
	const bool&	enable) = 0;

    virtual XrlCmdError pim_0_1_start_all_vifs() = 0;

    virtual XrlCmdError pim_0_1_stop_all_vifs() = 0;

    /**
     *  Pure-virtual function that needs to be implemented to:
     *
     *  Enable/disable/start/stop the PIM protocol.
     *
     *  @param enable if true, then enable the PIM protocol, otherwise disable
     *  it.
     */
    virtual XrlCmdError pim_0_1_enable_pim(
	// Input values,
	const bool&	enable) = 0;

    virtual XrlCmdError pim_0_1_start_pim() = 0;

    virtual XrlCmdError pim_0_1_stop_pim() = 0;

    /**
     *  Pure-virtual function that needs to be implemented to:
     *
     *  Enable/disable/start/stop the PIM CLI access.
     *
     *  @param enable if true, then enable the PIM CLI access, otherwise
     *  disable it.
     */
    virtual XrlCmdError pim_0_1_enable_cli(
	// Input values,
	const bool&	enable) = 0;

    virtual XrlCmdError pim_0_1_start_cli() = 0;

    virtual XrlCmdError pim_0_1_stop_cli() = 0;

    /**
     *  Pure-virtual function that needs to be implemented to:
     *
     *  Enable/disable/start/stop BSR.
     *
     *  @param enable if true, then enable the BSR, otherwise disable it.
     */
    virtual XrlCmdError pim_0_1_enable_bsr(
	// Input values,
	const bool&	enable) = 0;

    virtual XrlCmdError pim_0_1_start_bsr() = 0;

    virtual XrlCmdError pim_0_1_stop_bsr() = 0;

    /**
     *  Pure-virtual function that needs to be implemented to:
     *
     *  Add/delete scope zone.
     *
     *  @param scope_zone_id the ID of the configured zone.
     *
     *  @param vif_name the name of the vif to use as a bondary of the scope
     *  zone.
     */
    virtual XrlCmdError pim_0_1_add_config_scope_zone_by_vif_name4(
	// Input values,
	const IPv4Net&	scope_zone_id,
	const string&	vif_name) = 0;

    virtual XrlCmdError pim_0_1_add_config_scope_zone_by_vif_name6(
	// Input values,
	const IPv6Net&	scope_zone_id,
	const string&	vif_name) = 0;

    virtual XrlCmdError pim_0_1_add_config_scope_zone_by_vif_addr4(
	// Input values,
	const IPv4Net&	scope_zone_id,
	const IPv4&	vif_addr) = 0;

    virtual XrlCmdError pim_0_1_add_config_scope_zone_by_vif_addr6(
	// Input values,
	const IPv6Net&	scope_zone_id,
	const IPv6&	vif_addr) = 0;

    virtual XrlCmdError pim_0_1_delete_config_scope_zone_by_vif_name4(
	// Input values,
	const IPv4Net&	scope_zone_id,
	const string&	vif_name) = 0;

    virtual XrlCmdError pim_0_1_delete_config_scope_zone_by_vif_name6(
	// Input values,
	const IPv6Net&	scope_zone_id,
	const string&	vif_name) = 0;

    virtual XrlCmdError pim_0_1_delete_config_scope_zone_by_vif_addr4(
	// Input values,
	const IPv4Net&	scope_zone_id,
	const IPv4&	vif_addr) = 0;

    virtual XrlCmdError pim_0_1_delete_config_scope_zone_by_vif_addr6(
	// Input values,
	const IPv6Net&	scope_zone_id,
	const IPv6&	vif_addr) = 0;

    /**
     *  Pure-virtual function that needs to be implemented to:
     *
     *  Add/delete candidate-BSR configuration.
     *
     *  @param scope_zone_id the ID of the configured zone.
     *
     *  @param is_scope_zone true if configuring administratively scoped zone.
     *
     *  @param vif_name the name of the vif to use its address as a
     *  candidate-BSR.
     *
     *  @param bsr_priority the BSR priority (larger is better).
     *
     *  @param hash_mask_len the hash mask length.
     */
    virtual XrlCmdError pim_0_1_add_config_cand_bsr_by_vif_name4(
	// Input values,
	const IPv4Net&	scope_zone_id,
	const bool&	is_scope_zone,
	const string&	vif_name,
	const uint32_t&	bsr_priority,
	const uint32_t&	hash_mask_len) = 0;

    virtual XrlCmdError pim_0_1_add_config_cand_bsr_by_vif_name6(
	// Input values,
	const IPv6Net&	scope_zone_id,
	const bool&	is_scope_zone,
	const string&	vif_name,
	const uint32_t&	bsr_priority,
	const uint32_t&	hash_mask_len) = 0;

    virtual XrlCmdError pim_0_1_add_config_cand_bsr_by_addr4(
	// Input values,
	const IPv4Net&	scope_zone_id,
	const bool&	is_scope_zone,
	const IPv4&	cand_bsr_addr,
	const uint32_t&	bsr_priority,
	const uint32_t&	hash_mask_len) = 0;

    virtual XrlCmdError pim_0_1_add_config_cand_bsr_by_addr6(
	// Input values,
	const IPv6Net&	scope_zone_id,
	const bool&	is_scope_zone,
	const IPv6&	cand_bsr_addr,
	const uint32_t&	bsr_priority,
	const uint32_t&	hash_mask_len) = 0;

    virtual XrlCmdError pim_0_1_delete_config_cand_bsr4(
	// Input values,
	const IPv4Net&	scope_zone_id,
	const bool&	is_scope_zone) = 0;

    virtual XrlCmdError pim_0_1_delete_config_cand_bsr6(
	// Input values,
	const IPv6Net&	scope_zone_id,
	const bool&	is_scope_zone) = 0;

    /**
     *  Pure-virtual function that needs to be implemented to:
     *
     *  Add/delete Candidate-RP configuration.
     *
     *  @param group_prefix the group prefix of the configured zone.
     *
     *  @param is_scope_zone true if configuring administratively scoped zone.
     *
     *  @param vif_name the name of the vif to use its address as a
     *  candidate-RP.
     *
     *  @param rp_priority the Cand-RP priority (smaller is better).
     *
     *  @param rp_holdtime the Cand-RP holdtime (in seconds).
     */
    virtual XrlCmdError pim_0_1_add_config_cand_rp_by_vif_name4(
	// Input values,
	const IPv4Net&	group_prefix,
	const bool&	is_scope_zone,
	const string&	vif_name,
	const uint32_t&	rp_priority,
	const uint32_t&	rp_holdtime) = 0;

    virtual XrlCmdError pim_0_1_add_config_cand_rp_by_vif_name6(
	// Input values,
	const IPv6Net&	group_prefix,
	const bool&	is_scope_zone,
	const string&	vif_name,
	const uint32_t&	rp_priority,
	const uint32_t&	rp_holdtime) = 0;

    virtual XrlCmdError pim_0_1_add_config_cand_rp_by_addr4(
	// Input values,
	const IPv4Net&	group_prefix,
	const bool&	is_scope_zone,
	const IPv4&	cand_rp_addr,
	const uint32_t&	rp_priority,
	const uint32_t&	rp_holdtime) = 0;

    virtual XrlCmdError pim_0_1_add_config_cand_rp_by_addr6(
	// Input values,
	const IPv6Net&	group_prefix,
	const bool&	is_scope_zone,
	const IPv6&	cand_rp_addr,
	const uint32_t&	rp_priority,
	const uint32_t&	rp_holdtime) = 0;

    virtual XrlCmdError pim_0_1_delete_config_cand_rp_by_vif_name4(
	// Input values,
	const IPv4Net&	group_prefix,
	const bool&	is_scope_zone,
	const string&	vif_name) = 0;

    virtual XrlCmdError pim_0_1_delete_config_cand_rp_by_vif_name6(
	// Input values,
	const IPv6Net&	group_prefix,
	const bool&	is_scope_zone,
	const string&	vif_name) = 0;

    virtual XrlCmdError pim_0_1_delete_config_cand_rp_by_addr4(
	// Input values,
	const IPv4Net&	group_prefix,
	const bool&	is_scope_zone,
	const IPv4&	cand_rp_addr) = 0;

    virtual XrlCmdError pim_0_1_delete_config_cand_rp_by_addr6(
	// Input values,
	const IPv6Net&	group_prefix,
	const bool&	is_scope_zone,
	const IPv6&	cand_rp_addr) = 0;

    /**
     *  Pure-virtual function that needs to be implemented to:
     *
     *  Add/delete/complete static RP configuration.
     *
     *  @param group_prefix the group prefix for the RP.
     *
     *  @param rp_addr the RP address.
     *
     *  @param rp_priority the RP priority (smaller is better).
     *
     *  @param hash_mask_len the hash mask length used in computing an RP for a
     *  group. It should be same across all RPs. If set to zero, the default
     *  one will be used.
     */
    virtual XrlCmdError pim_0_1_add_config_static_rp4(
	// Input values,
	const IPv4Net&	group_prefix,
	const IPv4&	rp_addr,
	const uint32_t&	rp_priority,
	const uint32_t&	hash_mask_len) = 0;

    virtual XrlCmdError pim_0_1_add_config_static_rp6(
	// Input values,
	const IPv6Net&	group_prefix,
	const IPv6&	rp_addr,
	const uint32_t&	rp_priority,
	const uint32_t&	hash_mask_len) = 0;

    virtual XrlCmdError pim_0_1_delete_config_static_rp4(
	// Input values,
	const IPv4Net&	group_prefix,
	const IPv4&	rp_addr) = 0;

    virtual XrlCmdError pim_0_1_delete_config_static_rp6(
	// Input values,
	const IPv6Net&	group_prefix,
	const IPv6&	rp_addr) = 0;

    virtual XrlCmdError pim_0_1_config_static_rp_done() = 0;

    /**
     *  Pure-virtual function that needs to be implemented to:
     *
     *  Configure PIM Hello-related metrics. The 'set_foo' XRLs set the
     *  particular values. The 'reset_foo' XRLs reset the metrics to their
     *  default values.
     *
     *  @param vif_name the name of the vif to configure.
     *
     *  @param proto_version the protocol version.
     */
    virtual XrlCmdError pim_0_1_get_vif_proto_version(
	// Input values,
	const string&	vif_name,
	// Output values,
	uint32_t&	proto_version) = 0;

    virtual XrlCmdError pim_0_1_set_vif_proto_version(
	// Input values,
	const string&	vif_name,
	const uint32_t&	proto_version) = 0;

    virtual XrlCmdError pim_0_1_reset_vif_proto_version(
	// Input values,
	const string&	vif_name) = 0;

    virtual XrlCmdError pim_0_1_get_vif_hello_triggered_delay(
	// Input values,
	const string&	vif_name,
	// Output values,
	uint32_t&	hello_triggered_delay) = 0;

    virtual XrlCmdError pim_0_1_set_vif_hello_triggered_delay(
	// Input values,
	const string&	vif_name,
	const uint32_t&	hello_triggered_delay) = 0;

    virtual XrlCmdError pim_0_1_reset_vif_hello_triggered_delay(
	// Input values,
	const string&	vif_name) = 0;

    virtual XrlCmdError pim_0_1_get_vif_hello_period(
	// Input values,
	const string&	vif_name,
	// Output values,
	uint32_t&	hello_period) = 0;

    virtual XrlCmdError pim_0_1_set_vif_hello_period(
	// Input values,
	const string&	vif_name,
	const uint32_t&	hello_period) = 0;

    virtual XrlCmdError pim_0_1_reset_vif_hello_period(
	// Input values,
	const string&	vif_name) = 0;

    virtual XrlCmdError pim_0_1_get_vif_hello_holdtime(
	// Input values,
	const string&	vif_name,
	// Output values,
	uint32_t&	hello_holdtime) = 0;

    virtual XrlCmdError pim_0_1_set_vif_hello_holdtime(
	// Input values,
	const string&	vif_name,
	const uint32_t&	hello_holdtime) = 0;

    virtual XrlCmdError pim_0_1_reset_vif_hello_holdtime(
	// Input values,
	const string&	vif_name) = 0;

    virtual XrlCmdError pim_0_1_get_vif_dr_priority(
	// Input values,
	const string&	vif_name,
	// Output values,
	uint32_t&	dr_priority) = 0;

    virtual XrlCmdError pim_0_1_set_vif_dr_priority(
	// Input values,
	const string&	vif_name,
	const uint32_t&	dr_priority) = 0;

    virtual XrlCmdError pim_0_1_reset_vif_dr_priority(
	// Input values,
	const string&	vif_name) = 0;

    virtual XrlCmdError pim_0_1_get_vif_lan_delay(
	// Input values,
	const string&	vif_name,
	// Output values,
	uint32_t&	lan_delay) = 0;

    virtual XrlCmdError pim_0_1_set_vif_lan_delay(
	// Input values,
	const string&	vif_name,
	const uint32_t&	lan_delay) = 0;

    virtual XrlCmdError pim_0_1_reset_vif_lan_delay(
	// Input values,
	const string&	vif_name) = 0;

    virtual XrlCmdError pim_0_1_get_vif_override_interval(
	// Input values,
	const string&	vif_name,
	// Output values,
	uint32_t&	override_interval) = 0;

    virtual XrlCmdError pim_0_1_set_vif_override_interval(
	// Input values,
	const string&	vif_name,
	const uint32_t&	override_interval) = 0;

    virtual XrlCmdError pim_0_1_reset_vif_override_interval(
	// Input values,
	const string&	vif_name) = 0;

    virtual XrlCmdError pim_0_1_get_vif_is_tracking_support_disabled(
	// Input values,
	const string&	vif_name,
	// Output values,
	bool&	is_tracking_support_disabled) = 0;

    virtual XrlCmdError pim_0_1_set_vif_is_tracking_support_disabled(
	// Input values,
	const string&	vif_name,
	const bool&	is_tracking_support_disabled) = 0;

    virtual XrlCmdError pim_0_1_reset_vif_is_tracking_support_disabled(
	// Input values,
	const string&	vif_name) = 0;

    virtual XrlCmdError pim_0_1_get_vif_accept_nohello_neighbors(
	// Input values,
	const string&	vif_name,
	// Output values,
	bool&	accept_nohello_neighbors) = 0;

    virtual XrlCmdError pim_0_1_set_vif_accept_nohello_neighbors(
	// Input values,
	const string&	vif_name,
	const bool&	accept_nohello_neighbors) = 0;

    virtual XrlCmdError pim_0_1_reset_vif_accept_nohello_neighbors(
	// Input values,
	const string&	vif_name) = 0;

    /**
     *  Pure-virtual function that needs to be implemented to:
     *
     *  Configure PIM Join/Prune-related metrics. The 'set_foo' XRLs set the
     *  particular values. The 'reset_foo' XRLs reset the metrics to their
     *  default values.
     *
     *  @param vif_name the name of the vif to configure.
     *
     *  @param join_prune_period the period between Join/Prune messages.
     */
    virtual XrlCmdError pim_0_1_get_vif_join_prune_period(
	// Input values,
	const string&	vif_name,
	// Output values,
	uint32_t&	join_prune_period) = 0;

    virtual XrlCmdError pim_0_1_set_vif_join_prune_period(
	// Input values,
	const string&	vif_name,
	const uint32_t&	join_prune_period) = 0;

    virtual XrlCmdError pim_0_1_reset_vif_join_prune_period(
	// Input values,
	const string&	vif_name) = 0;

    /**
     *  Pure-virtual function that needs to be implemented to:
     *
     *  Configure SPT-switch threshold. The 'set_foo' XRLs set the particular
     *  values. The 'reset_foo' XRLs reset the metrics to their default values.
     *
     *  @param is_enabled if true, enable SPT-switch, otherwise disable it.
     *
     *  @param interval_sec if the SPT-switch is enabled, the interval (in
     *  number of seconds) to measure the bandwidth to consider whether to
     *  switch to the SPT.
     */
    virtual XrlCmdError pim_0_1_get_switch_to_spt_threshold(
	// Output values,
	bool&	is_enabled,
	uint32_t&	interval_sec,
	uint32_t&	bytes) = 0;

    virtual XrlCmdError pim_0_1_set_switch_to_spt_threshold(
	// Input values,
	const bool&	is_enabled,
	const uint32_t&	interval_sec,
	const uint32_t&	bytes) = 0;

    virtual XrlCmdError pim_0_1_reset_switch_to_spt_threshold() = 0;

    /**
     *  Pure-virtual function that needs to be implemented to:
     *
     *  Add or delete an alternative subnet on a PIM vif. An alternative subnet
     *  is used to make incoming traffic with a non-local source address appear
     *  as it is coming from a local subnet. Note: add alternative subnets with
     *  extreme care, only if you know what you are really doing!
     *
     *  @param vif_name the name of the vif to add or delete an alternative
     *  subnet.
     *
     *  @param subnet the subnet address to add or delete.
     */
    virtual XrlCmdError pim_0_1_add_alternative_subnet4(
	// Input values,
	const string&	vif_name,
	const IPv4Net&	subnet) = 0;

    virtual XrlCmdError pim_0_1_add_alternative_subnet6(
	// Input values,
	const string&	vif_name,
	const IPv6Net&	subnet) = 0;

    virtual XrlCmdError pim_0_1_delete_alternative_subnet4(
	// Input values,
	const string&	vif_name,
	const IPv4Net&	subnet) = 0;

    virtual XrlCmdError pim_0_1_delete_alternative_subnet6(
	// Input values,
	const string&	vif_name,
	const IPv6Net&	subnet) = 0;

    virtual XrlCmdError pim_0_1_remove_all_alternative_subnets(
	// Input values,
	const string&	vif_name) = 0;

    /**
     *  Pure-virtual function that needs to be implemented to:
     *
     *  Enable/disable the PIM trace log for all operations.
     *
     *  @param enable if true, then enable the trace log, otherwise disable it.
     */
    virtual XrlCmdError pim_0_1_log_trace_all(
	// Input values,
	const bool&	enable) = 0;

    /**
     *  Pure-virtual function that needs to be implemented to:
     *
     *  Test-related methods: add Join/Prune entries, and send them to a
     *  neighbor.
     */
    virtual XrlCmdError pim_0_1_add_test_jp_entry4(
	// Input values,
	const IPv4&	source_addr,
	const IPv4&	group_addr,
	const uint32_t&	group_mask_len,
	const string&	mrt_entry_type,
	const string&	action_jp,
	const uint32_t&	holdtime,
	const bool&	new_group_bool) = 0;

    virtual XrlCmdError pim_0_1_add_test_jp_entry6(
	// Input values,
	const IPv6&	source_addr,
	const IPv6&	group_addr,
	const uint32_t&	group_mask_len,
	const string&	mrt_entry_type,
	const string&	action_jp,
	const uint32_t&	holdtime,
	const bool&	new_group_bool) = 0;

    virtual XrlCmdError pim_0_1_send_test_jp_entry4(
	// Input values,
	const IPv4&	nbr_addr) = 0;

    virtual XrlCmdError pim_0_1_send_test_jp_entry6(
	// Input values,
	const IPv6&	nbr_addr) = 0;

    /**
     *  Pure-virtual function that needs to be implemented to:
     *
     *  Test-related methods: send an Assert message on an interface.
     *
     *  @param vif_name the name of the vif to send the Assert on.
     *
     *  @param source_addr the source address inside the Assert message.
     *
     *  @param group_addr the group address inside the Assert message.
     *
     *  @param rpt_bit the RPT-bit inside the Assert message.
     *
     *  @param metric_preference the metric preference inside the Assert
     *  message.
     *
     *  @param metric the metric inside the Assert message.
     */
    virtual XrlCmdError pim_0_1_send_test_assert4(
	// Input values,
	const string&	vif_name,
	const IPv4&	source_addr,
	const IPv4&	group_addr,
	const bool&	rpt_bit,
	const uint32_t&	metric_preference,
	const uint32_t&	metric) = 0;

    virtual XrlCmdError pim_0_1_send_test_assert6(
	// Input values,
	const string&	vif_name,
	const IPv6&	source_addr,
	const IPv6&	group_addr,
	const bool&	rpt_bit,
	const uint32_t&	metric_preference,
	const uint32_t&	metric) = 0;

    /**
     *  Pure-virtual function that needs to be implemented to:
     *
     *  Test-related methods: send Bootstrap and Cand-RP-Adv messages.
     *
     *  @param zone_id_scope_zone_prefix the zone prefix of the zone ID.
     *
     *  @param zone_id_is_scope_zone true if the zone is scoped.
     *
     *  @param bsr_addr the address of the Bootstrap router.
     *
     *  @param bsr_priority the priority of the Bootstrap router.
     *
     *  @param hash_mask_len the hash mask length inside the Bootstrap
     *  messages.
     *
     *  @param fragment_tag the fragment tag inside the Bootstrap messages.
     */
    virtual XrlCmdError pim_0_1_add_test_bsr_zone4(
	// Input values,
	const IPv4Net&	zone_id_scope_zone_prefix,
	const bool&	zone_id_is_scope_zone,
	const IPv4&	bsr_addr,
	const uint32_t&	bsr_priority,
	const uint32_t&	hash_mask_len,
	const uint32_t&	fragment_tag) = 0;

    virtual XrlCmdError pim_0_1_add_test_bsr_zone6(
	// Input values,
	const IPv6Net&	zone_id_scope_zone_prefix,
	const bool&	zone_id_is_scope_zone,
	const IPv6&	bsr_addr,
	const uint32_t&	bsr_priority,
	const uint32_t&	hash_mask_len,
	const uint32_t&	fragment_tag) = 0;

    virtual XrlCmdError pim_0_1_add_test_bsr_group_prefix4(
	// Input values,
	const IPv4Net&	zone_id_scope_zone_prefix,
	const bool&	zone_id_is_scope_zone,
	const IPv4Net&	group_prefix,
	const bool&	is_scope_zone,
	const uint32_t&	expected_rp_count) = 0;

    virtual XrlCmdError pim_0_1_add_test_bsr_group_prefix6(
	// Input values,
	const IPv6Net&	zone_id_scope_zone_prefix,
	const bool&	zone_id_is_scope_zone,
	const IPv6Net&	group_prefix,
	const bool&	is_scope_zone,
	const uint32_t&	expected_rp_count) = 0;

    virtual XrlCmdError pim_0_1_add_test_bsr_rp4(
	// Input values,
	const IPv4Net&	zone_id_scope_zone_prefix,
	const bool&	zone_id_is_scope_zone,
	const IPv4Net&	group_prefix,
	const IPv4&	rp_addr,
	const uint32_t&	rp_priority,
	const uint32_t&	rp_holdtime) = 0;

    virtual XrlCmdError pim_0_1_add_test_bsr_rp6(
	// Input values,
	const IPv6Net&	zone_id_scope_zone_prefix,
	const bool&	zone_id_is_scope_zone,
	const IPv6Net&	group_prefix,
	const IPv6&	rp_addr,
	const uint32_t&	rp_priority,
	const uint32_t&	rp_holdtime) = 0;

    virtual XrlCmdError pim_0_1_send_test_bootstrap(
	// Input values,
	const string&	vif_name) = 0;

    virtual XrlCmdError pim_0_1_send_test_bootstrap_by_dest4(
	// Input values,
	const string&	vif_name,
	const IPv4&	dest_addr) = 0;

    virtual XrlCmdError pim_0_1_send_test_bootstrap_by_dest6(
	// Input values,
	const string&	vif_name,
	const IPv6&	dest_addr) = 0;

    virtual XrlCmdError pim_0_1_send_test_cand_rp_adv() = 0;

    /**
     *  Pure-virtual function that needs to be implemented to:
     *
     *  Retrieve information about all PIM neighbors.
     *
     *  @param nbrs_number the number of PIM neighbors
     *
     *  @param vifs the list of vif names for all neighbors (one vif name per
     *  neighbor).
     *
     *  @param pim_versions the list of PIM protocol versions for all neighbors
     *  (one number per neighbor).
     *
     *  @param dr_priorities the list of DR priorities of all neighbors (one
     *  number per neighbor).
     *
     *  @param holdtimes the list of configured holdtimes (in seconds) of all
     *  neighbors (one number per neighbor).
     *
     *  @param timeouts the list of timeout values (in seconds) of all
     *  neighbors (one number per neighbor).
     *
     *  @param uptimes the list of uptime values (in seconds) of all neighbors
     *  (one number per neighbor).
     */
    virtual XrlCmdError pim_0_1_pimstat_neighbors4(
	// Output values,
	uint32_t&	nbrs_number,
	XrlAtomList&	vifs,
	XrlAtomList&	addresses,
	XrlAtomList&	pim_versions,
	XrlAtomList&	dr_priorities,
	XrlAtomList&	holdtimes,
	XrlAtomList&	timeouts,
	XrlAtomList&	uptimes) = 0;

    virtual XrlCmdError pim_0_1_pimstat_neighbors6(
	// Output values,
	uint32_t&	nbrs_number,
	XrlAtomList&	vifs,
	XrlAtomList&	addresses,
	XrlAtomList&	pim_versions,
	XrlAtomList&	dr_priorities,
	XrlAtomList&	holdtimes,
	XrlAtomList&	timeouts,
	XrlAtomList&	uptimes) = 0;

    /**
     *  Pure-virtual function that needs to be implemented to:
     *
     *  Retrieve information about PIM interfaces.
     *
     *  @param vif_name the name of the vif to retrieve information about.
     *
     *  @param pim_version the PIM protocol version on that vif.
     *
     *  @param is_dr true if this router is the DR for the subnet the vif is
     *  connected to.
     *
     *  @param dr_priority the DR priority configured on that vif.
     *
     *  @param dr_address the address of the DR for the subnet the vif is
     *  connected to.
     *
     *  @param pim_nbrs_number the number of PIM neighbors on the subnet the
     *  vif is connected to.
     */
    virtual XrlCmdError pim_0_1_pimstat_interface4(
	// Input values,
	const string&	vif_name,
	// Output values,
	uint32_t&	pim_version,
	bool&	is_dr,
	uint32_t&	dr_priority,
	IPv4&	dr_address,
	uint32_t&	pim_nbrs_number) = 0;

    virtual XrlCmdError pim_0_1_pimstat_interface6(
	// Input values,
	const string&	vif_name,
	// Output values,
	uint32_t&	pim_version,
	bool&	is_dr,
	uint32_t&	dr_priority,
	IPv6&	dr_address,
	uint32_t&	pim_nbrs_number) = 0;

    /**
     *  Pure-virtual function that needs to be implemented to:
     *
     *  Retrieve information about the RP-Set.
     *
     *  @param rps_number the number of RPs in the RP-Set.
     *
     *  @param addresses the list of addresses of all RPs (one IPv4 or IPv6
     *  address per RP).
     *
     *  @param types the list of textual description about the origin of each
     *  RP (one keyword per RP: "bootstrap", "static" or "unknown").
     *
     *  @param priorities the list of RP priorities of all RPs (one number per
     *  RP).
     *
     *  @param holdtimes the list of configured holdtimes (in seconds) of all
     *  RPs (one number per RP).
     *
     *  @param timeouts the list of timeout values (in seconds) of all RPs (one
     *  number per RP).
     *
     *  @param group_prefixes the list of all group prefixes (one network
     *  IPv4Net or IPv6Net address per RP). Note that if an RP is configured
     *  for more than one group prefixes, there will be a number of entries for
     *  that RP: one per group prefix.
     */
    virtual XrlCmdError pim_0_1_pimstat_rps4(
	// Output values,
	uint32_t&	rps_number,
	XrlAtomList&	addresses,
	XrlAtomList&	types,
	XrlAtomList&	priorities,
	XrlAtomList&	holdtimes,
	XrlAtomList&	timeouts,
	XrlAtomList&	group_prefixes) = 0;

    virtual XrlCmdError pim_0_1_pimstat_rps6(
	// Output values,
	uint32_t&	rps_number,
	XrlAtomList&	addresses,
	XrlAtomList&	types,
	XrlAtomList&	priorities,
	XrlAtomList&	holdtimes,
	XrlAtomList&	timeouts,
	XrlAtomList&	group_prefixes) = 0;

    /**
     *  Pure-virtual function that needs to be implemented to:
     *
     *  Clear all statistics
     */
    virtual XrlCmdError pim_0_1_clear_pim_statistics() = 0;

    /**
     *  Pure-virtual function that needs to be implemented to:
     *
     *  Clear all statistics on a specific interface.
     *
     *  @param vif_name the interface to clear the statistics of.
     */
    virtual XrlCmdError pim_0_1_clear_pim_statistics_per_vif(
	// Input values,
	const string&	vif_name) = 0;

    /**
     *  Pure-virtual function that needs to be implemented to:
     *
     *  Statistics-related counters and values
     */
    virtual XrlCmdError pim_0_1_pimstat_hello_messages_received(
	// Output values,
	uint32_t&	value) = 0;

    virtual XrlCmdError pim_0_1_pimstat_hello_messages_sent(
	// Output values,
	uint32_t&	value) = 0;

    virtual XrlCmdError pim_0_1_pimstat_hello_messages_rx_errors(
	// Output values,
	uint32_t&	value) = 0;

    virtual XrlCmdError pim_0_1_pimstat_register_messages_received(
	// Output values,
	uint32_t&	value) = 0;

    virtual XrlCmdError pim_0_1_pimstat_register_messages_sent(
	// Output values,
	uint32_t&	value) = 0;

    virtual XrlCmdError pim_0_1_pimstat_register_messages_rx_errors(
	// Output values,
	uint32_t&	value) = 0;

    virtual XrlCmdError pim_0_1_pimstat_register_stop_messages_received(
	// Output values,
	uint32_t&	value) = 0;

    virtual XrlCmdError pim_0_1_pimstat_register_stop_messages_sent(
	// Output values,
	uint32_t&	value) = 0;

    virtual XrlCmdError pim_0_1_pimstat_register_stop_messages_rx_errors(
	// Output values,
	uint32_t&	value) = 0;

    virtual XrlCmdError pim_0_1_pimstat_join_prune_messages_received(
	// Output values,
	uint32_t&	value) = 0;

    virtual XrlCmdError pim_0_1_pimstat_join_prune_messages_sent(
	// Output values,
	uint32_t&	value) = 0;

    virtual XrlCmdError pim_0_1_pimstat_join_prune_messages_rx_errors(
	// Output values,
	uint32_t&	value) = 0;

    virtual XrlCmdError pim_0_1_pimstat_bootstrap_messages_received(
	// Output values,
	uint32_t&	value) = 0;

    virtual XrlCmdError pim_0_1_pimstat_bootstrap_messages_sent(
	// Output values,
	uint32_t&	value) = 0;

    virtual XrlCmdError pim_0_1_pimstat_bootstrap_messages_rx_errors(
	// Output values,
	uint32_t&	value) = 0;

    virtual XrlCmdError pim_0_1_pimstat_assert_messages_received(
	// Output values,
	uint32_t&	value) = 0;

    virtual XrlCmdError pim_0_1_pimstat_assert_messages_sent(
	// Output values,
	uint32_t&	value) = 0;

    virtual XrlCmdError pim_0_1_pimstat_assert_messages_rx_errors(
	// Output values,
	uint32_t&	value) = 0;

    virtual XrlCmdError pim_0_1_pimstat_graft_messages_received(
	// Output values,
	uint32_t&	value) = 0;

    virtual XrlCmdError pim_0_1_pimstat_graft_messages_sent(
	// Output values,
	uint32_t&	value) = 0;

    virtual XrlCmdError pim_0_1_pimstat_graft_messages_rx_errors(
	// Output values,
	uint32_t&	value) = 0;

    virtual XrlCmdError pim_0_1_pimstat_graft_ack_messages_received(
	// Output values,
	uint32_t&	value) = 0;

    virtual XrlCmdError pim_0_1_pimstat_graft_ack_messages_sent(
	// Output values,
	uint32_t&	value) = 0;

    virtual XrlCmdError pim_0_1_pimstat_graft_ack_messages_rx_errors(
	// Output values,
	uint32_t&	value) = 0;

    virtual XrlCmdError pim_0_1_pimstat_candidate_rp_messages_received(
	// Output values,
	uint32_t&	value) = 0;

    virtual XrlCmdError pim_0_1_pimstat_candidate_rp_messages_sent(
	// Output values,
	uint32_t&	value) = 0;

    virtual XrlCmdError pim_0_1_pimstat_candidate_rp_messages_rx_errors(
	// Output values,
	uint32_t&	value) = 0;

    virtual XrlCmdError pim_0_1_pimstat_unknown_type_messages(
	// Output values,
	uint32_t&	value) = 0;

    virtual XrlCmdError pim_0_1_pimstat_unknown_version_messages(
	// Output values,
	uint32_t&	value) = 0;

    virtual XrlCmdError pim_0_1_pimstat_neighbor_unknown_messages(
	// Output values,
	uint32_t&	value) = 0;

    virtual XrlCmdError pim_0_1_pimstat_bad_length_messages(
	// Output values,
	uint32_t&	value) = 0;

    virtual XrlCmdError pim_0_1_pimstat_bad_checksum_messages(
	// Output values,
	uint32_t&	value) = 0;

    virtual XrlCmdError pim_0_1_pimstat_bad_receive_interface_messages(
	// Output values,
	uint32_t&	value) = 0;

    virtual XrlCmdError pim_0_1_pimstat_rx_interface_disabled_messages(
	// Output values,
	uint32_t&	value) = 0;

    virtual XrlCmdError pim_0_1_pimstat_rx_register_not_rp(
	// Output values,
	uint32_t&	value) = 0;

    virtual XrlCmdError pim_0_1_pimstat_rp_filtered_source(
	// Output values,
	uint32_t&	value) = 0;

    virtual XrlCmdError pim_0_1_pimstat_unknown_register_stop(
	// Output values,
	uint32_t&	value) = 0;

    virtual XrlCmdError pim_0_1_pimstat_rx_join_prune_no_state(
	// Output values,
	uint32_t&	value) = 0;

    virtual XrlCmdError pim_0_1_pimstat_rx_graft_graft_ack_no_state(
	// Output values,
	uint32_t&	value) = 0;

    virtual XrlCmdError pim_0_1_pimstat_rx_graft_on_upstream_interface(
	// Output values,
	uint32_t&	value) = 0;

    virtual XrlCmdError pim_0_1_pimstat_rx_candidate_rp_not_bsr(
	// Output values,
	uint32_t&	value) = 0;

    virtual XrlCmdError pim_0_1_pimstat_rx_bsr_when_bsr(
	// Output values,
	uint32_t&	value) = 0;

    virtual XrlCmdError pim_0_1_pimstat_rx_bsr_not_rpf_interface(
	// Output values,
	uint32_t&	value) = 0;

    virtual XrlCmdError pim_0_1_pimstat_rx_unknown_hello_option(
	// Output values,
	uint32_t&	value) = 0;

    virtual XrlCmdError pim_0_1_pimstat_rx_data_no_state(
	// Output values,
	uint32_t&	value) = 0;

    virtual XrlCmdError pim_0_1_pimstat_rx_rp_no_state(
	// Output values,
	uint32_t&	value) = 0;

    virtual XrlCmdError pim_0_1_pimstat_rx_aggregate(
	// Output values,
	uint32_t&	value) = 0;

    virtual XrlCmdError pim_0_1_pimstat_rx_malformed_packet(
	// Output values,
	uint32_t&	value) = 0;

    virtual XrlCmdError pim_0_1_pimstat_no_rp(
	// Output values,
	uint32_t&	value) = 0;

    virtual XrlCmdError pim_0_1_pimstat_no_route_upstream(
	// Output values,
	uint32_t&	value) = 0;

    virtual XrlCmdError pim_0_1_pimstat_rp_mismatch(
	// Output values,
	uint32_t&	value) = 0;

    virtual XrlCmdError pim_0_1_pimstat_rpf_neighbor_unknown(
	// Output values,
	uint32_t&	value) = 0;

    virtual XrlCmdError pim_0_1_pimstat_rx_join_rp(
	// Output values,
	uint32_t&	value) = 0;

    virtual XrlCmdError pim_0_1_pimstat_rx_prune_rp(
	// Output values,
	uint32_t&	value) = 0;

    virtual XrlCmdError pim_0_1_pimstat_rx_join_wc(
	// Output values,
	uint32_t&	value) = 0;

    virtual XrlCmdError pim_0_1_pimstat_rx_prune_wc(
	// Output values,
	uint32_t&	value) = 0;

    virtual XrlCmdError pim_0_1_pimstat_rx_join_sg(
	// Output values,
	uint32_t&	value) = 0;

    virtual XrlCmdError pim_0_1_pimstat_rx_prune_sg(
	// Output values,
	uint32_t&	value) = 0;

    virtual XrlCmdError pim_0_1_pimstat_rx_join_sg_rpt(
	// Output values,
	uint32_t&	value) = 0;

    virtual XrlCmdError pim_0_1_pimstat_rx_prune_sg_rpt(
	// Output values,
	uint32_t&	value) = 0;

    virtual XrlCmdError pim_0_1_pimstat_hello_messages_received_per_vif(
	// Input values,
	const string&	vif_name,
	// Output values,
	uint32_t&	value) = 0;

    virtual XrlCmdError pim_0_1_pimstat_hello_messages_sent_per_vif(
	// Input values,
	const string&	vif_name,
	// Output values,
	uint32_t&	value) = 0;

    virtual XrlCmdError pim_0_1_pimstat_hello_messages_rx_errors_per_vif(
	// Input values,
	const string&	vif_name,
	// Output values,
	uint32_t&	value) = 0;

    virtual XrlCmdError pim_0_1_pimstat_register_messages_received_per_vif(
	// Input values,
	const string&	vif_name,
	// Output values,
	uint32_t&	value) = 0;

    virtual XrlCmdError pim_0_1_pimstat_register_messages_sent_per_vif(
	// Input values,
	const string&	vif_name,
	// Output values,
	uint32_t&	value) = 0;

    virtual XrlCmdError pim_0_1_pimstat_register_messages_rx_errors_per_vif(
	// Input values,
	const string&	vif_name,
	// Output values,
	uint32_t&	value) = 0;

    virtual XrlCmdError pim_0_1_pimstat_register_stop_messages_received_per_vif(
	// Input values,
	const string&	vif_name,
	// Output values,
	uint32_t&	value) = 0;

    virtual XrlCmdError pim_0_1_pimstat_register_stop_messages_sent_per_vif(
	// Input values,
	const string&	vif_name,
	// Output values,
	uint32_t&	value) = 0;

    virtual XrlCmdError pim_0_1_pimstat_register_stop_messages_rx_errors_per_vif(
	// Input values,
	const string&	vif_name,
	// Output values,
	uint32_t&	value) = 0;

    virtual XrlCmdError pim_0_1_pimstat_join_prune_messages_received_per_vif(
	// Input values,
	const string&	vif_name,
	// Output values,
	uint32_t&	value) = 0;

    virtual XrlCmdError pim_0_1_pimstat_join_prune_messages_sent_per_vif(
	// Input values,
	const string&	vif_name,
	// Output values,
	uint32_t&	value) = 0;

    virtual XrlCmdError pim_0_1_pimstat_join_prune_messages_rx_errors_per_vif(
	// Input values,
	const string&	vif_name,
	// Output values,
	uint32_t&	value) = 0;

    virtual XrlCmdError pim_0_1_pimstat_bootstrap_messages_received_per_vif(
	// Input values,
	const string&	vif_name,
	// Output values,
	uint32_t&	value) = 0;

    virtual XrlCmdError pim_0_1_pimstat_bootstrap_messages_sent_per_vif(
	// Input values,
	const string&	vif_name,
	// Output values,
	uint32_t&	value) = 0;

    virtual XrlCmdError pim_0_1_pimstat_bootstrap_messages_rx_errors_per_vif(
	// Input values,
	const string&	vif_name,
	// Output values,
	uint32_t&	value) = 0;

    virtual XrlCmdError pim_0_1_pimstat_assert_messages_received_per_vif(
	// Input values,
	const string&	vif_name,
	// Output values,
	uint32_t&	value) = 0;

    virtual XrlCmdError pim_0_1_pimstat_assert_messages_sent_per_vif(
	// Input values,
	const string&	vif_name,
	// Output values,
	uint32_t&	value) = 0;

    virtual XrlCmdError pim_0_1_pimstat_assert_messages_rx_errors_per_vif(
	// Input values,
	const string&	vif_name,
	// Output values,
	uint32_t&	value) = 0;

    virtual XrlCmdError pim_0_1_pimstat_graft_messages_received_per_vif(
	// Input values,
	const string&	vif_name,
	// Output values,
	uint32_t&	value) = 0;

    virtual XrlCmdError pim_0_1_pimstat_graft_messages_sent_per_vif(
	// Input values,
	const string&	vif_name,
	// Output values,
	uint32_t&	value) = 0;

    virtual XrlCmdError pim_0_1_pimstat_graft_messages_rx_errors_per_vif(
	// Input values,
	const string&	vif_name,
	// Output values,
	uint32_t&	value) = 0;

    virtual XrlCmdError pim_0_1_pimstat_graft_ack_messages_received_per_vif(
	// Input values,
	const string&	vif_name,
	// Output values,
	uint32_t&	value) = 0;

    virtual XrlCmdError pim_0_1_pimstat_graft_ack_messages_sent_per_vif(
	// Input values,
	const string&	vif_name,
	// Output values,
	uint32_t&	value) = 0;

    virtual XrlCmdError pim_0_1_pimstat_graft_ack_messages_rx_errors_per_vif(
	// Input values,
	const string&	vif_name,
	// Output values,
	uint32_t&	value) = 0;

    virtual XrlCmdError pim_0_1_pimstat_candidate_rp_messages_received_per_vif(
	// Input values,
	const string&	vif_name,
	// Output values,
	uint32_t&	value) = 0;

    virtual XrlCmdError pim_0_1_pimstat_candidate_rp_messages_sent_per_vif(
	// Input values,
	const string&	vif_name,
	// Output values,
	uint32_t&	value) = 0;

    virtual XrlCmdError pim_0_1_pimstat_candidate_rp_messages_rx_errors_per_vif(
	// Input values,
	const string&	vif_name,
	// Output values,
	uint32_t&	value) = 0;

    virtual XrlCmdError pim_0_1_pimstat_unknown_type_messages_per_vif(
	// Input values,
	const string&	vif_name,
	// Output values,
	uint32_t&	value) = 0;

    virtual XrlCmdError pim_0_1_pimstat_unknown_version_messages_per_vif(
	// Input values,
	const string&	vif_name,
	// Output values,
	uint32_t&	value) = 0;

    virtual XrlCmdError pim_0_1_pimstat_neighbor_unknown_messages_per_vif(
	// Input values,
	const string&	vif_name,
	// Output values,
	uint32_t&	value) = 0;

    virtual XrlCmdError pim_0_1_pimstat_bad_length_messages_per_vif(
	// Input values,
	const string&	vif_name,
	// Output values,
	uint32_t&	value) = 0;

    virtual XrlCmdError pim_0_1_pimstat_bad_checksum_messages_per_vif(
	// Input values,
	const string&	vif_name,
	// Output values,
	uint32_t&	value) = 0;

    virtual XrlCmdError pim_0_1_pimstat_bad_receive_interface_messages_per_vif(
	// Input values,
	const string&	vif_name,
	// Output values,
	uint32_t&	value) = 0;

    virtual XrlCmdError pim_0_1_pimstat_rx_interface_disabled_messages_per_vif(
	// Input values,
	const string&	vif_name,
	// Output values,
	uint32_t&	value) = 0;

    virtual XrlCmdError pim_0_1_pimstat_rx_register_not_rp_per_vif(
	// Input values,
	const string&	vif_name,
	// Output values,
	uint32_t&	value) = 0;

    virtual XrlCmdError pim_0_1_pimstat_rp_filtered_source_per_vif(
	// Input values,
	const string&	vif_name,
	// Output values,
	uint32_t&	value) = 0;

    virtual XrlCmdError pim_0_1_pimstat_unknown_register_stop_per_vif(
	// Input values,
	const string&	vif_name,
	// Output values,
	uint32_t&	value) = 0;

    virtual XrlCmdError pim_0_1_pimstat_rx_join_prune_no_state_per_vif(
	// Input values,
	const string&	vif_name,
	// Output values,
	uint32_t&	value) = 0;

    virtual XrlCmdError pim_0_1_pimstat_rx_graft_graft_ack_no_state_per_vif(
	// Input values,
	const string&	vif_name,
	// Output values,
	uint32_t&	value) = 0;

    virtual XrlCmdError pim_0_1_pimstat_rx_graft_on_upstream_interface_per_vif(
	// Input values,
	const string&	vif_name,
	// Output values,
	uint32_t&	value) = 0;

    virtual XrlCmdError pim_0_1_pimstat_rx_candidate_rp_not_bsr_per_vif(
	// Input values,
	const string&	vif_name,
	// Output values,
	uint32_t&	value) = 0;

    virtual XrlCmdError pim_0_1_pimstat_rx_bsr_when_bsr_per_vif(
	// Input values,
	const string&	vif_name,
	// Output values,
	uint32_t&	value) = 0;

    virtual XrlCmdError pim_0_1_pimstat_rx_bsr_not_rpf_interface_per_vif(
	// Input values,
	const string&	vif_name,
	// Output values,
	uint32_t&	value) = 0;

    virtual XrlCmdError pim_0_1_pimstat_rx_unknown_hello_option_per_vif(
	// Input values,
	const string&	vif_name,
	// Output values,
	uint32_t&	value) = 0;

    virtual XrlCmdError pim_0_1_pimstat_rx_data_no_state_per_vif(
	// Input values,
	const string&	vif_name,
	// Output values,
	uint32_t&	value) = 0;

    virtual XrlCmdError pim_0_1_pimstat_rx_rp_no_state_per_vif(
	// Input values,
	const string&	vif_name,
	// Output values,
	uint32_t&	value) = 0;

    virtual XrlCmdError pim_0_1_pimstat_rx_aggregate_per_vif(
	// Input values,
	const string&	vif_name,
	// Output values,
	uint32_t&	value) = 0;

    virtual XrlCmdError pim_0_1_pimstat_rx_malformed_packet_per_vif(
	// Input values,
	const string&	vif_name,
	// Output values,
	uint32_t&	value) = 0;

    virtual XrlCmdError pim_0_1_pimstat_no_rp_per_vif(
	// Input values,
	const string&	vif_name,
	// Output values,
	uint32_t&	value) = 0;

    virtual XrlCmdError pim_0_1_pimstat_no_route_upstream_per_vif(
	// Input values,
	const string&	vif_name,
	// Output values,
	uint32_t&	value) = 0;

    virtual XrlCmdError pim_0_1_pimstat_rp_mismatch_per_vif(
	// Input values,
	const string&	vif_name,
	// Output values,
	uint32_t&	value) = 0;

    virtual XrlCmdError pim_0_1_pimstat_rpf_neighbor_unknown_per_vif(
	// Input values,
	const string&	vif_name,
	// Output values,
	uint32_t&	value) = 0;

    virtual XrlCmdError pim_0_1_pimstat_rx_join_rp_per_vif(
	// Input values,
	const string&	vif_name,
	// Output values,
	uint32_t&	value) = 0;

    virtual XrlCmdError pim_0_1_pimstat_rx_prune_rp_per_vif(
	// Input values,
	const string&	vif_name,
	// Output values,
	uint32_t&	value) = 0;

    virtual XrlCmdError pim_0_1_pimstat_rx_join_wc_per_vif(
	// Input values,
	const string&	vif_name,
	// Output values,
	uint32_t&	value) = 0;

    virtual XrlCmdError pim_0_1_pimstat_rx_prune_wc_per_vif(
	// Input values,
	const string&	vif_name,
	// Output values,
	uint32_t&	value) = 0;

    virtual XrlCmdError pim_0_1_pimstat_rx_join_sg_per_vif(
	// Input values,
	const string&	vif_name,
	// Output values,
	uint32_t&	value) = 0;

    virtual XrlCmdError pim_0_1_pimstat_rx_prune_sg_per_vif(
	// Input values,
	const string&	vif_name,
	// Output values,
	uint32_t&	value) = 0;

    virtual XrlCmdError pim_0_1_pimstat_rx_join_sg_rpt_per_vif(
	// Input values,
	const string&	vif_name,
	// Output values,
	uint32_t&	value) = 0;

    virtual XrlCmdError pim_0_1_pimstat_rx_prune_sg_rpt_per_vif(
	// Input values,
	const string&	vif_name,
	// Output values,
	uint32_t&	value) = 0;

private:
    const XrlCmdError handle_common_0_1_get_target_name(const XrlArgs& in, XrlArgs* out);

    const XrlCmdError handle_common_0_1_get_version(const XrlArgs& in, XrlArgs* out);

    const XrlCmdError handle_common_0_1_get_status(const XrlArgs& in, XrlArgs* out);

    const XrlCmdError handle_common_0_1_shutdown(const XrlArgs& in, XrlArgs* out);

    const XrlCmdError handle_cli_processor_0_1_process_command(const XrlArgs& in, XrlArgs* out);

    const XrlCmdError handle_mfea_client_0_1_new_vif(const XrlArgs& in, XrlArgs* out);

    const XrlCmdError handle_mfea_client_0_1_delete_vif(const XrlArgs& in, XrlArgs* out);

    const XrlCmdError handle_mfea_client_0_1_add_vif_addr4(const XrlArgs& in, XrlArgs* out);

    const XrlCmdError handle_mfea_client_0_1_add_vif_addr6(const XrlArgs& in, XrlArgs* out);

    const XrlCmdError handle_mfea_client_0_1_delete_vif_addr4(const XrlArgs& in, XrlArgs* out);

    const XrlCmdError handle_mfea_client_0_1_delete_vif_addr6(const XrlArgs& in, XrlArgs* out);

    const XrlCmdError handle_mfea_client_0_1_set_vif_flags(const XrlArgs& in, XrlArgs* out);

    const XrlCmdError handle_mfea_client_0_1_set_all_vifs_done(const XrlArgs& in, XrlArgs* out);

    const XrlCmdError handle_mfea_client_0_1_is_vif_setup_completed(const XrlArgs& in, XrlArgs* out);

    const XrlCmdError handle_mfea_client_0_1_recv_protocol_message4(const XrlArgs& in, XrlArgs* out);

    const XrlCmdError handle_mfea_client_0_1_recv_protocol_message6(const XrlArgs& in, XrlArgs* out);

    const XrlCmdError handle_mfea_client_0_1_recv_kernel_signal_message4(const XrlArgs& in, XrlArgs* out);

    const XrlCmdError handle_mfea_client_0_1_recv_kernel_signal_message6(const XrlArgs& in, XrlArgs* out);

    const XrlCmdError handle_mfea_client_0_1_add_mrib4(const XrlArgs& in, XrlArgs* out);

    const XrlCmdError handle_mfea_client_0_1_add_mrib6(const XrlArgs& in, XrlArgs* out);

    const XrlCmdError handle_mfea_client_0_1_delete_mrib4(const XrlArgs& in, XrlArgs* out);

    const XrlCmdError handle_mfea_client_0_1_delete_mrib6(const XrlArgs& in, XrlArgs* out);

    const XrlCmdError handle_mfea_client_0_1_set_mrib_done(const XrlArgs& in, XrlArgs* out);

    const XrlCmdError handle_mfea_client_0_1_recv_dataflow_signal4(const XrlArgs& in, XrlArgs* out);

    const XrlCmdError handle_mfea_client_0_1_recv_dataflow_signal6(const XrlArgs& in, XrlArgs* out);

    const XrlCmdError handle_redist_transaction4_0_1_start_transaction(const XrlArgs& in, XrlArgs* out);

    const XrlCmdError handle_redist_transaction4_0_1_commit_transaction(const XrlArgs& in, XrlArgs* out);

    const XrlCmdError handle_redist_transaction4_0_1_abort_transaction(const XrlArgs& in, XrlArgs* out);

    const XrlCmdError handle_redist_transaction4_0_1_add_route(const XrlArgs& in, XrlArgs* out);

    const XrlCmdError handle_redist_transaction4_0_1_delete_route(const XrlArgs& in, XrlArgs* out);

    const XrlCmdError handle_redist_transaction6_0_1_start_transaction(const XrlArgs& in, XrlArgs* out);

    const XrlCmdError handle_redist_transaction6_0_1_commit_transaction(const XrlArgs& in, XrlArgs* out);

    const XrlCmdError handle_redist_transaction6_0_1_abort_transaction(const XrlArgs& in, XrlArgs* out);

    const XrlCmdError handle_redist_transaction6_0_1_add_route(const XrlArgs& in, XrlArgs* out);

    const XrlCmdError handle_redist_transaction6_0_1_delete_route(const XrlArgs& in, XrlArgs* out);

    const XrlCmdError handle_mld6igmp_client_0_1_add_membership4(const XrlArgs& in, XrlArgs* out);

    const XrlCmdError handle_mld6igmp_client_0_1_add_membership6(const XrlArgs& in, XrlArgs* out);

    const XrlCmdError handle_mld6igmp_client_0_1_delete_membership4(const XrlArgs& in, XrlArgs* out);

    const XrlCmdError handle_mld6igmp_client_0_1_delete_membership6(const XrlArgs& in, XrlArgs* out);

    const XrlCmdError handle_pim_0_1_enable_vif(const XrlArgs& in, XrlArgs* out);

    const XrlCmdError handle_pim_0_1_start_vif(const XrlArgs& in, XrlArgs* out);

    const XrlCmdError handle_pim_0_1_stop_vif(const XrlArgs& in, XrlArgs* out);

    const XrlCmdError handle_pim_0_1_enable_all_vifs(const XrlArgs& in, XrlArgs* out);

    const XrlCmdError handle_pim_0_1_start_all_vifs(const XrlArgs& in, XrlArgs* out);

    const XrlCmdError handle_pim_0_1_stop_all_vifs(const XrlArgs& in, XrlArgs* out);

    const XrlCmdError handle_pim_0_1_enable_pim(const XrlArgs& in, XrlArgs* out);

    const XrlCmdError handle_pim_0_1_start_pim(const XrlArgs& in, XrlArgs* out);

    const XrlCmdError handle_pim_0_1_stop_pim(const XrlArgs& in, XrlArgs* out);

    const XrlCmdError handle_pim_0_1_enable_cli(const XrlArgs& in, XrlArgs* out);

    const XrlCmdError handle_pim_0_1_start_cli(const XrlArgs& in, XrlArgs* out);

    const XrlCmdError handle_pim_0_1_stop_cli(const XrlArgs& in, XrlArgs* out);

    const XrlCmdError handle_pim_0_1_enable_bsr(const XrlArgs& in, XrlArgs* out);

    const XrlCmdError handle_pim_0_1_start_bsr(const XrlArgs& in, XrlArgs* out);

    const XrlCmdError handle_pim_0_1_stop_bsr(const XrlArgs& in, XrlArgs* out);

    const XrlCmdError handle_pim_0_1_add_config_scope_zone_by_vif_name4(const XrlArgs& in, XrlArgs* out);

    const XrlCmdError handle_pim_0_1_add_config_scope_zone_by_vif_name6(const XrlArgs& in, XrlArgs* out);

    const XrlCmdError handle_pim_0_1_add_config_scope_zone_by_vif_addr4(const XrlArgs& in, XrlArgs* out);

    const XrlCmdError handle_pim_0_1_add_config_scope_zone_by_vif_addr6(const XrlArgs& in, XrlArgs* out);

    const XrlCmdError handle_pim_0_1_delete_config_scope_zone_by_vif_name4(const XrlArgs& in, XrlArgs* out);

    const XrlCmdError handle_pim_0_1_delete_config_scope_zone_by_vif_name6(const XrlArgs& in, XrlArgs* out);

    const XrlCmdError handle_pim_0_1_delete_config_scope_zone_by_vif_addr4(const XrlArgs& in, XrlArgs* out);

    const XrlCmdError handle_pim_0_1_delete_config_scope_zone_by_vif_addr6(const XrlArgs& in, XrlArgs* out);

    const XrlCmdError handle_pim_0_1_add_config_cand_bsr_by_vif_name4(const XrlArgs& in, XrlArgs* out);

    const XrlCmdError handle_pim_0_1_add_config_cand_bsr_by_vif_name6(const XrlArgs& in, XrlArgs* out);

    const XrlCmdError handle_pim_0_1_add_config_cand_bsr_by_addr4(const XrlArgs& in, XrlArgs* out);

    const XrlCmdError handle_pim_0_1_add_config_cand_bsr_by_addr6(const XrlArgs& in, XrlArgs* out);

    const XrlCmdError handle_pim_0_1_delete_config_cand_bsr4(const XrlArgs& in, XrlArgs* out);

    const XrlCmdError handle_pim_0_1_delete_config_cand_bsr6(const XrlArgs& in, XrlArgs* out);

    const XrlCmdError handle_pim_0_1_add_config_cand_rp_by_vif_name4(const XrlArgs& in, XrlArgs* out);

    const XrlCmdError handle_pim_0_1_add_config_cand_rp_by_vif_name6(const XrlArgs& in, XrlArgs* out);

    const XrlCmdError handle_pim_0_1_add_config_cand_rp_by_addr4(const XrlArgs& in, XrlArgs* out);

    const XrlCmdError handle_pim_0_1_add_config_cand_rp_by_addr6(const XrlArgs& in, XrlArgs* out);

    const XrlCmdError handle_pim_0_1_delete_config_cand_rp_by_vif_name4(const XrlArgs& in, XrlArgs* out);

    const XrlCmdError handle_pim_0_1_delete_config_cand_rp_by_vif_name6(const XrlArgs& in, XrlArgs* out);

    const XrlCmdError handle_pim_0_1_delete_config_cand_rp_by_addr4(const XrlArgs& in, XrlArgs* out);

    const XrlCmdError handle_pim_0_1_delete_config_cand_rp_by_addr6(const XrlArgs& in, XrlArgs* out);

    const XrlCmdError handle_pim_0_1_add_config_static_rp4(const XrlArgs& in, XrlArgs* out);

    const XrlCmdError handle_pim_0_1_add_config_static_rp6(const XrlArgs& in, XrlArgs* out);

    const XrlCmdError handle_pim_0_1_delete_config_static_rp4(const XrlArgs& in, XrlArgs* out);

    const XrlCmdError handle_pim_0_1_delete_config_static_rp6(const XrlArgs& in, XrlArgs* out);

    const XrlCmdError handle_pim_0_1_config_static_rp_done(const XrlArgs& in, XrlArgs* out);

    const XrlCmdError handle_pim_0_1_get_vif_proto_version(const XrlArgs& in, XrlArgs* out);

    const XrlCmdError handle_pim_0_1_set_vif_proto_version(const XrlArgs& in, XrlArgs* out);

    const XrlCmdError handle_pim_0_1_reset_vif_proto_version(const XrlArgs& in, XrlArgs* out);

    const XrlCmdError handle_pim_0_1_get_vif_hello_triggered_delay(const XrlArgs& in, XrlArgs* out);

    const XrlCmdError handle_pim_0_1_set_vif_hello_triggered_delay(const XrlArgs& in, XrlArgs* out);

    const XrlCmdError handle_pim_0_1_reset_vif_hello_triggered_delay(const XrlArgs& in, XrlArgs* out);

    const XrlCmdError handle_pim_0_1_get_vif_hello_period(const XrlArgs& in, XrlArgs* out);

    const XrlCmdError handle_pim_0_1_set_vif_hello_period(const XrlArgs& in, XrlArgs* out);

    const XrlCmdError handle_pim_0_1_reset_vif_hello_period(const XrlArgs& in, XrlArgs* out);

    const XrlCmdError handle_pim_0_1_get_vif_hello_holdtime(const XrlArgs& in, XrlArgs* out);

    const XrlCmdError handle_pim_0_1_set_vif_hello_holdtime(const XrlArgs& in, XrlArgs* out);

    const XrlCmdError handle_pim_0_1_reset_vif_hello_holdtime(const XrlArgs& in, XrlArgs* out);

    const XrlCmdError handle_pim_0_1_get_vif_dr_priority(const XrlArgs& in, XrlArgs* out);

    const XrlCmdError handle_pim_0_1_set_vif_dr_priority(const XrlArgs& in, XrlArgs* out);

    const XrlCmdError handle_pim_0_1_reset_vif_dr_priority(const XrlArgs& in, XrlArgs* out);

    const XrlCmdError handle_pim_0_1_get_vif_lan_delay(const XrlArgs& in, XrlArgs* out);

    const XrlCmdError handle_pim_0_1_set_vif_lan_delay(const XrlArgs& in, XrlArgs* out);

    const XrlCmdError handle_pim_0_1_reset_vif_lan_delay(const XrlArgs& in, XrlArgs* out);

    const XrlCmdError handle_pim_0_1_get_vif_override_interval(const XrlArgs& in, XrlArgs* out);

    const XrlCmdError handle_pim_0_1_set_vif_override_interval(const XrlArgs& in, XrlArgs* out);

    const XrlCmdError handle_pim_0_1_reset_vif_override_interval(const XrlArgs& in, XrlArgs* out);

    const XrlCmdError handle_pim_0_1_get_vif_is_tracking_support_disabled(const XrlArgs& in, XrlArgs* out);

    const XrlCmdError handle_pim_0_1_set_vif_is_tracking_support_disabled(const XrlArgs& in, XrlArgs* out);

    const XrlCmdError handle_pim_0_1_reset_vif_is_tracking_support_disabled(const XrlArgs& in, XrlArgs* out);

    const XrlCmdError handle_pim_0_1_get_vif_accept_nohello_neighbors(const XrlArgs& in, XrlArgs* out);

    const XrlCmdError handle_pim_0_1_set_vif_accept_nohello_neighbors(const XrlArgs& in, XrlArgs* out);

    const XrlCmdError handle_pim_0_1_reset_vif_accept_nohello_neighbors(const XrlArgs& in, XrlArgs* out);

    const XrlCmdError handle_pim_0_1_get_vif_join_prune_period(const XrlArgs& in, XrlArgs* out);

    const XrlCmdError handle_pim_0_1_set_vif_join_prune_period(const XrlArgs& in, XrlArgs* out);

    const XrlCmdError handle_pim_0_1_reset_vif_join_prune_period(const XrlArgs& in, XrlArgs* out);

    const XrlCmdError handle_pim_0_1_get_switch_to_spt_threshold(const XrlArgs& in, XrlArgs* out);

    const XrlCmdError handle_pim_0_1_set_switch_to_spt_threshold(const XrlArgs& in, XrlArgs* out);

    const XrlCmdError handle_pim_0_1_reset_switch_to_spt_threshold(const XrlArgs& in, XrlArgs* out);

    const XrlCmdError handle_pim_0_1_add_alternative_subnet4(const XrlArgs& in, XrlArgs* out);

    const XrlCmdError handle_pim_0_1_add_alternative_subnet6(const XrlArgs& in, XrlArgs* out);

    const XrlCmdError handle_pim_0_1_delete_alternative_subnet4(const XrlArgs& in, XrlArgs* out);

    const XrlCmdError handle_pim_0_1_delete_alternative_subnet6(const XrlArgs& in, XrlArgs* out);

    const XrlCmdError handle_pim_0_1_remove_all_alternative_subnets(const XrlArgs& in, XrlArgs* out);

    const XrlCmdError handle_pim_0_1_log_trace_all(const XrlArgs& in, XrlArgs* out);

    const XrlCmdError handle_pim_0_1_add_test_jp_entry4(const XrlArgs& in, XrlArgs* out);

    const XrlCmdError handle_pim_0_1_add_test_jp_entry6(const XrlArgs& in, XrlArgs* out);

    const XrlCmdError handle_pim_0_1_send_test_jp_entry4(const XrlArgs& in, XrlArgs* out);

    const XrlCmdError handle_pim_0_1_send_test_jp_entry6(const XrlArgs& in, XrlArgs* out);

    const XrlCmdError handle_pim_0_1_send_test_assert4(const XrlArgs& in, XrlArgs* out);

    const XrlCmdError handle_pim_0_1_send_test_assert6(const XrlArgs& in, XrlArgs* out);

    const XrlCmdError handle_pim_0_1_add_test_bsr_zone4(const XrlArgs& in, XrlArgs* out);

    const XrlCmdError handle_pim_0_1_add_test_bsr_zone6(const XrlArgs& in, XrlArgs* out);

    const XrlCmdError handle_pim_0_1_add_test_bsr_group_prefix4(const XrlArgs& in, XrlArgs* out);

    const XrlCmdError handle_pim_0_1_add_test_bsr_group_prefix6(const XrlArgs& in, XrlArgs* out);

    const XrlCmdError handle_pim_0_1_add_test_bsr_rp4(const XrlArgs& in, XrlArgs* out);

    const XrlCmdError handle_pim_0_1_add_test_bsr_rp6(const XrlArgs& in, XrlArgs* out);

    const XrlCmdError handle_pim_0_1_send_test_bootstrap(const XrlArgs& in, XrlArgs* out);

    const XrlCmdError handle_pim_0_1_send_test_bootstrap_by_dest4(const XrlArgs& in, XrlArgs* out);

    const XrlCmdError handle_pim_0_1_send_test_bootstrap_by_dest6(const XrlArgs& in, XrlArgs* out);

    const XrlCmdError handle_pim_0_1_send_test_cand_rp_adv(const XrlArgs& in, XrlArgs* out);

    const XrlCmdError handle_pim_0_1_pimstat_neighbors4(const XrlArgs& in, XrlArgs* out);

    const XrlCmdError handle_pim_0_1_pimstat_neighbors6(const XrlArgs& in, XrlArgs* out);

    const XrlCmdError handle_pim_0_1_pimstat_interface4(const XrlArgs& in, XrlArgs* out);

    const XrlCmdError handle_pim_0_1_pimstat_interface6(const XrlArgs& in, XrlArgs* out);

    const XrlCmdError handle_pim_0_1_pimstat_rps4(const XrlArgs& in, XrlArgs* out);

    const XrlCmdError handle_pim_0_1_pimstat_rps6(const XrlArgs& in, XrlArgs* out);

    const XrlCmdError handle_pim_0_1_clear_pim_statistics(const XrlArgs& in, XrlArgs* out);

    const XrlCmdError handle_pim_0_1_clear_pim_statistics_per_vif(const XrlArgs& in, XrlArgs* out);

    const XrlCmdError handle_pim_0_1_pimstat_hello_messages_received(const XrlArgs& in, XrlArgs* out);

    const XrlCmdError handle_pim_0_1_pimstat_hello_messages_sent(const XrlArgs& in, XrlArgs* out);

    const XrlCmdError handle_pim_0_1_pimstat_hello_messages_rx_errors(const XrlArgs& in, XrlArgs* out);

    const XrlCmdError handle_pim_0_1_pimstat_register_messages_received(const XrlArgs& in, XrlArgs* out);

    const XrlCmdError handle_pim_0_1_pimstat_register_messages_sent(const XrlArgs& in, XrlArgs* out);

    const XrlCmdError handle_pim_0_1_pimstat_register_messages_rx_errors(const XrlArgs& in, XrlArgs* out);

    const XrlCmdError handle_pim_0_1_pimstat_register_stop_messages_received(const XrlArgs& in, XrlArgs* out);

    const XrlCmdError handle_pim_0_1_pimstat_register_stop_messages_sent(const XrlArgs& in, XrlArgs* out);

    const XrlCmdError handle_pim_0_1_pimstat_register_stop_messages_rx_errors(const XrlArgs& in, XrlArgs* out);

    const XrlCmdError handle_pim_0_1_pimstat_join_prune_messages_received(const XrlArgs& in, XrlArgs* out);

    const XrlCmdError handle_pim_0_1_pimstat_join_prune_messages_sent(const XrlArgs& in, XrlArgs* out);

    const XrlCmdError handle_pim_0_1_pimstat_join_prune_messages_rx_errors(const XrlArgs& in, XrlArgs* out);

    const XrlCmdError handle_pim_0_1_pimstat_bootstrap_messages_received(const XrlArgs& in, XrlArgs* out);

    const XrlCmdError handle_pim_0_1_pimstat_bootstrap_messages_sent(const XrlArgs& in, XrlArgs* out);

    const XrlCmdError handle_pim_0_1_pimstat_bootstrap_messages_rx_errors(const XrlArgs& in, XrlArgs* out);

    const XrlCmdError handle_pim_0_1_pimstat_assert_messages_received(const XrlArgs& in, XrlArgs* out);

    const XrlCmdError handle_pim_0_1_pimstat_assert_messages_sent(const XrlArgs& in, XrlArgs* out);

    const XrlCmdError handle_pim_0_1_pimstat_assert_messages_rx_errors(const XrlArgs& in, XrlArgs* out);

    const XrlCmdError handle_pim_0_1_pimstat_graft_messages_received(const XrlArgs& in, XrlArgs* out);

    const XrlCmdError handle_pim_0_1_pimstat_graft_messages_sent(const XrlArgs& in, XrlArgs* out);

    const XrlCmdError handle_pim_0_1_pimstat_graft_messages_rx_errors(const XrlArgs& in, XrlArgs* out);

    const XrlCmdError handle_pim_0_1_pimstat_graft_ack_messages_received(const XrlArgs& in, XrlArgs* out);

    const XrlCmdError handle_pim_0_1_pimstat_graft_ack_messages_sent(const XrlArgs& in, XrlArgs* out);

    const XrlCmdError handle_pim_0_1_pimstat_graft_ack_messages_rx_errors(const XrlArgs& in, XrlArgs* out);

    const XrlCmdError handle_pim_0_1_pimstat_candidate_rp_messages_received(const XrlArgs& in, XrlArgs* out);

    const XrlCmdError handle_pim_0_1_pimstat_candidate_rp_messages_sent(const XrlArgs& in, XrlArgs* out);

    const XrlCmdError handle_pim_0_1_pimstat_candidate_rp_messages_rx_errors(const XrlArgs& in, XrlArgs* out);

    const XrlCmdError handle_pim_0_1_pimstat_unknown_type_messages(const XrlArgs& in, XrlArgs* out);

    const XrlCmdError handle_pim_0_1_pimstat_unknown_version_messages(const XrlArgs& in, XrlArgs* out);

    const XrlCmdError handle_pim_0_1_pimstat_neighbor_unknown_messages(const XrlArgs& in, XrlArgs* out);

    const XrlCmdError handle_pim_0_1_pimstat_bad_length_messages(const XrlArgs& in, XrlArgs* out);

    const XrlCmdError handle_pim_0_1_pimstat_bad_checksum_messages(const XrlArgs& in, XrlArgs* out);

    const XrlCmdError handle_pim_0_1_pimstat_bad_receive_interface_messages(const XrlArgs& in, XrlArgs* out);

    const XrlCmdError handle_pim_0_1_pimstat_rx_interface_disabled_messages(const XrlArgs& in, XrlArgs* out);

    const XrlCmdError handle_pim_0_1_pimstat_rx_register_not_rp(const XrlArgs& in, XrlArgs* out);

    const XrlCmdError handle_pim_0_1_pimstat_rp_filtered_source(const XrlArgs& in, XrlArgs* out);

    const XrlCmdError handle_pim_0_1_pimstat_unknown_register_stop(const XrlArgs& in, XrlArgs* out);

    const XrlCmdError handle_pim_0_1_pimstat_rx_join_prune_no_state(const XrlArgs& in, XrlArgs* out);

    const XrlCmdError handle_pim_0_1_pimstat_rx_graft_graft_ack_no_state(const XrlArgs& in, XrlArgs* out);

    const XrlCmdError handle_pim_0_1_pimstat_rx_graft_on_upstream_interface(const XrlArgs& in, XrlArgs* out);

    const XrlCmdError handle_pim_0_1_pimstat_rx_candidate_rp_not_bsr(const XrlArgs& in, XrlArgs* out);

    const XrlCmdError handle_pim_0_1_pimstat_rx_bsr_when_bsr(const XrlArgs& in, XrlArgs* out);

    const XrlCmdError handle_pim_0_1_pimstat_rx_bsr_not_rpf_interface(const XrlArgs& in, XrlArgs* out);

    const XrlCmdError handle_pim_0_1_pimstat_rx_unknown_hello_option(const XrlArgs& in, XrlArgs* out);

    const XrlCmdError handle_pim_0_1_pimstat_rx_data_no_state(const XrlArgs& in, XrlArgs* out);

    const XrlCmdError handle_pim_0_1_pimstat_rx_rp_no_state(const XrlArgs& in, XrlArgs* out);

    const XrlCmdError handle_pim_0_1_pimstat_rx_aggregate(const XrlArgs& in, XrlArgs* out);

    const XrlCmdError handle_pim_0_1_pimstat_rx_malformed_packet(const XrlArgs& in, XrlArgs* out);

    const XrlCmdError handle_pim_0_1_pimstat_no_rp(const XrlArgs& in, XrlArgs* out);

    const XrlCmdError handle_pim_0_1_pimstat_no_route_upstream(const XrlArgs& in, XrlArgs* out);

    const XrlCmdError handle_pim_0_1_pimstat_rp_mismatch(const XrlArgs& in, XrlArgs* out);

    const XrlCmdError handle_pim_0_1_pimstat_rpf_neighbor_unknown(const XrlArgs& in, XrlArgs* out);

    const XrlCmdError handle_pim_0_1_pimstat_rx_join_rp(const XrlArgs& in, XrlArgs* out);

    const XrlCmdError handle_pim_0_1_pimstat_rx_prune_rp(const XrlArgs& in, XrlArgs* out);

    const XrlCmdError handle_pim_0_1_pimstat_rx_join_wc(const XrlArgs& in, XrlArgs* out);

    const XrlCmdError handle_pim_0_1_pimstat_rx_prune_wc(const XrlArgs& in, XrlArgs* out);

    const XrlCmdError handle_pim_0_1_pimstat_rx_join_sg(const XrlArgs& in, XrlArgs* out);

    const XrlCmdError handle_pim_0_1_pimstat_rx_prune_sg(const XrlArgs& in, XrlArgs* out);

    const XrlCmdError handle_pim_0_1_pimstat_rx_join_sg_rpt(const XrlArgs& in, XrlArgs* out);

    const XrlCmdError handle_pim_0_1_pimstat_rx_prune_sg_rpt(const XrlArgs& in, XrlArgs* out);

    const XrlCmdError handle_pim_0_1_pimstat_hello_messages_received_per_vif(const XrlArgs& in, XrlArgs* out);

    const XrlCmdError handle_pim_0_1_pimstat_hello_messages_sent_per_vif(const XrlArgs& in, XrlArgs* out);

    const XrlCmdError handle_pim_0_1_pimstat_hello_messages_rx_errors_per_vif(const XrlArgs& in, XrlArgs* out);

    const XrlCmdError handle_pim_0_1_pimstat_register_messages_received_per_vif(const XrlArgs& in, XrlArgs* out);

    const XrlCmdError handle_pim_0_1_pimstat_register_messages_sent_per_vif(const XrlArgs& in, XrlArgs* out);

    const XrlCmdError handle_pim_0_1_pimstat_register_messages_rx_errors_per_vif(const XrlArgs& in, XrlArgs* out);

    const XrlCmdError handle_pim_0_1_pimstat_register_stop_messages_received_per_vif(const XrlArgs& in, XrlArgs* out);

    const XrlCmdError handle_pim_0_1_pimstat_register_stop_messages_sent_per_vif(const XrlArgs& in, XrlArgs* out);

    const XrlCmdError handle_pim_0_1_pimstat_register_stop_messages_rx_errors_per_vif(const XrlArgs& in, XrlArgs* out);

    const XrlCmdError handle_pim_0_1_pimstat_join_prune_messages_received_per_vif(const XrlArgs& in, XrlArgs* out);

    const XrlCmdError handle_pim_0_1_pimstat_join_prune_messages_sent_per_vif(const XrlArgs& in, XrlArgs* out);

    const XrlCmdError handle_pim_0_1_pimstat_join_prune_messages_rx_errors_per_vif(const XrlArgs& in, XrlArgs* out);

    const XrlCmdError handle_pim_0_1_pimstat_bootstrap_messages_received_per_vif(const XrlArgs& in, XrlArgs* out);

    const XrlCmdError handle_pim_0_1_pimstat_bootstrap_messages_sent_per_vif(const XrlArgs& in, XrlArgs* out);

    const XrlCmdError handle_pim_0_1_pimstat_bootstrap_messages_rx_errors_per_vif(const XrlArgs& in, XrlArgs* out);

    const XrlCmdError handle_pim_0_1_pimstat_assert_messages_received_per_vif(const XrlArgs& in, XrlArgs* out);

    const XrlCmdError handle_pim_0_1_pimstat_assert_messages_sent_per_vif(const XrlArgs& in, XrlArgs* out);

    const XrlCmdError handle_pim_0_1_pimstat_assert_messages_rx_errors_per_vif(const XrlArgs& in, XrlArgs* out);

    const XrlCmdError handle_pim_0_1_pimstat_graft_messages_received_per_vif(const XrlArgs& in, XrlArgs* out);

    const XrlCmdError handle_pim_0_1_pimstat_graft_messages_sent_per_vif(const XrlArgs& in, XrlArgs* out);

    const XrlCmdError handle_pim_0_1_pimstat_graft_messages_rx_errors_per_vif(const XrlArgs& in, XrlArgs* out);

    const XrlCmdError handle_pim_0_1_pimstat_graft_ack_messages_received_per_vif(const XrlArgs& in, XrlArgs* out);

    const XrlCmdError handle_pim_0_1_pimstat_graft_ack_messages_sent_per_vif(const XrlArgs& in, XrlArgs* out);

    const XrlCmdError handle_pim_0_1_pimstat_graft_ack_messages_rx_errors_per_vif(const XrlArgs& in, XrlArgs* out);

    const XrlCmdError handle_pim_0_1_pimstat_candidate_rp_messages_received_per_vif(const XrlArgs& in, XrlArgs* out);

    const XrlCmdError handle_pim_0_1_pimstat_candidate_rp_messages_sent_per_vif(const XrlArgs& in, XrlArgs* out);

    const XrlCmdError handle_pim_0_1_pimstat_candidate_rp_messages_rx_errors_per_vif(const XrlArgs& in, XrlArgs* out);

    const XrlCmdError handle_pim_0_1_pimstat_unknown_type_messages_per_vif(const XrlArgs& in, XrlArgs* out);

    const XrlCmdError handle_pim_0_1_pimstat_unknown_version_messages_per_vif(const XrlArgs& in, XrlArgs* out);

    const XrlCmdError handle_pim_0_1_pimstat_neighbor_unknown_messages_per_vif(const XrlArgs& in, XrlArgs* out);

    const XrlCmdError handle_pim_0_1_pimstat_bad_length_messages_per_vif(const XrlArgs& in, XrlArgs* out);

    const XrlCmdError handle_pim_0_1_pimstat_bad_checksum_messages_per_vif(const XrlArgs& in, XrlArgs* out);

    const XrlCmdError handle_pim_0_1_pimstat_bad_receive_interface_messages_per_vif(const XrlArgs& in, XrlArgs* out);

    const XrlCmdError handle_pim_0_1_pimstat_rx_interface_disabled_messages_per_vif(const XrlArgs& in, XrlArgs* out);

    const XrlCmdError handle_pim_0_1_pimstat_rx_register_not_rp_per_vif(const XrlArgs& in, XrlArgs* out);

    const XrlCmdError handle_pim_0_1_pimstat_rp_filtered_source_per_vif(const XrlArgs& in, XrlArgs* out);

    const XrlCmdError handle_pim_0_1_pimstat_unknown_register_stop_per_vif(const XrlArgs& in, XrlArgs* out);

    const XrlCmdError handle_pim_0_1_pimstat_rx_join_prune_no_state_per_vif(const XrlArgs& in, XrlArgs* out);

    const XrlCmdError handle_pim_0_1_pimstat_rx_graft_graft_ack_no_state_per_vif(const XrlArgs& in, XrlArgs* out);

    const XrlCmdError handle_pim_0_1_pimstat_rx_graft_on_upstream_interface_per_vif(const XrlArgs& in, XrlArgs* out);

    const XrlCmdError handle_pim_0_1_pimstat_rx_candidate_rp_not_bsr_per_vif(const XrlArgs& in, XrlArgs* out);

    const XrlCmdError handle_pim_0_1_pimstat_rx_bsr_when_bsr_per_vif(const XrlArgs& in, XrlArgs* out);

    const XrlCmdError handle_pim_0_1_pimstat_rx_bsr_not_rpf_interface_per_vif(const XrlArgs& in, XrlArgs* out);

    const XrlCmdError handle_pim_0_1_pimstat_rx_unknown_hello_option_per_vif(const XrlArgs& in, XrlArgs* out);

    const XrlCmdError handle_pim_0_1_pimstat_rx_data_no_state_per_vif(const XrlArgs& in, XrlArgs* out);

    const XrlCmdError handle_pim_0_1_pimstat_rx_rp_no_state_per_vif(const XrlArgs& in, XrlArgs* out);

    const XrlCmdError handle_pim_0_1_pimstat_rx_aggregate_per_vif(const XrlArgs& in, XrlArgs* out);

    const XrlCmdError handle_pim_0_1_pimstat_rx_malformed_packet_per_vif(const XrlArgs& in, XrlArgs* out);

    const XrlCmdError handle_pim_0_1_pimstat_no_rp_per_vif(const XrlArgs& in, XrlArgs* out);

    const XrlCmdError handle_pim_0_1_pimstat_no_route_upstream_per_vif(const XrlArgs& in, XrlArgs* out);

    const XrlCmdError handle_pim_0_1_pimstat_rp_mismatch_per_vif(const XrlArgs& in, XrlArgs* out);

    const XrlCmdError handle_pim_0_1_pimstat_rpf_neighbor_unknown_per_vif(const XrlArgs& in, XrlArgs* out);

    const XrlCmdError handle_pim_0_1_pimstat_rx_join_rp_per_vif(const XrlArgs& in, XrlArgs* out);

    const XrlCmdError handle_pim_0_1_pimstat_rx_prune_rp_per_vif(const XrlArgs& in, XrlArgs* out);

    const XrlCmdError handle_pim_0_1_pimstat_rx_join_wc_per_vif(const XrlArgs& in, XrlArgs* out);

    const XrlCmdError handle_pim_0_1_pimstat_rx_prune_wc_per_vif(const XrlArgs& in, XrlArgs* out);

    const XrlCmdError handle_pim_0_1_pimstat_rx_join_sg_per_vif(const XrlArgs& in, XrlArgs* out);

    const XrlCmdError handle_pim_0_1_pimstat_rx_prune_sg_per_vif(const XrlArgs& in, XrlArgs* out);

    const XrlCmdError handle_pim_0_1_pimstat_rx_join_sg_rpt_per_vif(const XrlArgs& in, XrlArgs* out);

    const XrlCmdError handle_pim_0_1_pimstat_rx_prune_sg_rpt_per_vif(const XrlArgs& in, XrlArgs* out);

    void add_handlers();
    void remove_handlers();
};

#endif /* __XRL_INTERFACES_PIM_BASE_HH__ */
