/*
 * Copyright (c) 2001-2004 International Computer Science Institute
 * See LICENSE file for licensing, conditions, and warranties on use.
 *
 * DO NOT EDIT THIS FILE - IT IS PROGRAMMATICALLY GENERATED
 *
 * Generated by 'clnt-gen'.
 *
 * $XORP: xorp/xrl/interfaces/mfea_xif.hh,v 1.15 2004/06/10 22:42:02 hodson Exp $
 */

#ifndef __XRL_INTERFACES_MFEA_XIF_HH__
#define __XRL_INTERFACES_MFEA_XIF_HH__

#undef XORP_LIBRARY_NAME
#define XORP_LIBRARY_NAME "XifMfea"

#include "libxorp/xlog.h"
#include "libxorp/callback.hh"

#include "libxipc/xrl.hh"
#include "libxipc/xrl_error.hh"
#include "libxipc/xrl_sender.hh"


class XrlMfeaV0p1Client {
public:
    XrlMfeaV0p1Client(XrlSender* s) : _sender(s) {}
    virtual ~XrlMfeaV0p1Client() {}

    typedef XorpCallback2<void, const XrlError&, const bool*>::RefPtr HaveMulticastRouting4CB;
    /**
     *  Send Xrl intended to:
     *
     *  Test if the underlying system supports IPv4 multicast routing.
     *
     *  @param tgt_name Xrl Target name
     */
    bool send_have_multicast_routing4(
	const char*	target_name,
	const HaveMulticastRouting4CB&	cb
    );

    typedef XorpCallback2<void, const XrlError&, const bool*>::RefPtr HaveMulticastRouting6CB;
    /**
     *  Send Xrl intended to:
     *
     *  Test if the underlying system supports IPv6 multicast routing.
     *
     *  @param tgt_name Xrl Target name
     */
    bool send_have_multicast_routing6(
	const char*	target_name,
	const HaveMulticastRouting6CB&	cb
    );

    typedef XorpCallback1<void, const XrlError&>::RefPtr AddProtocol4CB;
    /**
     *  Send Xrl intended to:
     *
     *  Add/delete a protocol in the Multicast FEA.
     *
     *  @param tgt_name Xrl Target name
     *
     *  @param xrl_sender_name the XRL name of the originator of this XRL.
     *
     *  @param protocol_name the name of the protocol to add/delete.
     *
     *  @param protocol_id the ID of the protocol to add/delete (both sides
     *  must agree on the particular values).
     */
    bool send_add_protocol4(
	const char*	target_name,
	const string&	xrl_sender_name,
	const string&	protocol_name,
	const uint32_t&	protocol_id,
	const AddProtocol4CB&	cb
    );

    typedef XorpCallback1<void, const XrlError&>::RefPtr AddProtocol6CB;

    bool send_add_protocol6(
	const char*	target_name,
	const string&	xrl_sender_name,
	const string&	protocol_name,
	const uint32_t&	protocol_id,
	const AddProtocol6CB&	cb
    );

    typedef XorpCallback1<void, const XrlError&>::RefPtr DeleteProtocol4CB;

    bool send_delete_protocol4(
	const char*	target_name,
	const string&	xrl_sender_name,
	const string&	protocol_name,
	const uint32_t&	protocol_id,
	const DeleteProtocol4CB&	cb
    );

    typedef XorpCallback1<void, const XrlError&>::RefPtr DeleteProtocol6CB;

    bool send_delete_protocol6(
	const char*	target_name,
	const string&	xrl_sender_name,
	const string&	protocol_name,
	const uint32_t&	protocol_id,
	const DeleteProtocol6CB&	cb
    );

    typedef XorpCallback1<void, const XrlError&>::RefPtr StartProtocolVif4CB;
    /**
     *  Send Xrl intended to:
     *
     *  Start/stop a protocol on an interface in the Multicast FEA.
     *
     *  @param tgt_name Xrl Target name
     *
     *  @param xrl_sender_name the XRL name of the originator of this XRL.
     *
     *  @param protocol_name the name of the protocol to start/stop on the
     *  particular vif.
     *
     *  @param protocol_id the ID of the protocol to add/stop on the particular
     *  vif (both sides must agree on the particular values).
     *
     *  @param vif_name the name of the vif to start/stop for the particular
     *  protocol.
     *
     *  @param vif_index the index of the vif to start/stop for the particular
     *  protocol.
     */
    bool send_start_protocol_vif4(
	const char*	target_name,
	const string&	xrl_sender_name,
	const string&	protocol_name,
	const uint32_t&	protocol_id,
	const string&	vif_name,
	const uint32_t&	vif_index,
	const StartProtocolVif4CB&	cb
    );

    typedef XorpCallback1<void, const XrlError&>::RefPtr StartProtocolVif6CB;

    bool send_start_protocol_vif6(
	const char*	target_name,
	const string&	xrl_sender_name,
	const string&	protocol_name,
	const uint32_t&	protocol_id,
	const string&	vif_name,
	const uint32_t&	vif_index,
	const StartProtocolVif6CB&	cb
    );

    typedef XorpCallback1<void, const XrlError&>::RefPtr StopProtocolVif4CB;

    bool send_stop_protocol_vif4(
	const char*	target_name,
	const string&	xrl_sender_name,
	const string&	protocol_name,
	const uint32_t&	protocol_id,
	const string&	vif_name,
	const uint32_t&	vif_index,
	const StopProtocolVif4CB&	cb
    );

    typedef XorpCallback1<void, const XrlError&>::RefPtr StopProtocolVif6CB;

    bool send_stop_protocol_vif6(
	const char*	target_name,
	const string&	xrl_sender_name,
	const string&	protocol_name,
	const uint32_t&	protocol_id,
	const string&	vif_name,
	const uint32_t&	vif_index,
	const StopProtocolVif6CB&	cb
    );

    typedef XorpCallback1<void, const XrlError&>::RefPtr AllowSignalMessagesCB;
    /**
     *  Send Xrl intended to:
     *
     *  Enable/disable the receiving of kernel-originated signal messages.
     *
     *  @param tgt_name Xrl Target name
     *
     *  @param xrl_sender_name the XRL name of the originator of this XRL.
     *
     *  @param protocol_name the name of the protocol to add.
     *
     *  @param protocol_id the ID of the protocol to add (both sides must agree
     *  on the particular values).
     *
     *  @param is_allow if true, enable the receiving of kernel-originated
     *  signal messages by protocol 'protocol_name'.
     */
    bool send_allow_signal_messages(
	const char*	target_name,
	const string&	xrl_sender_name,
	const string&	protocol_name,
	const uint32_t&	protocol_id,
	const bool&	is_allow,
	const AllowSignalMessagesCB&	cb
    );

    typedef XorpCallback1<void, const XrlError&>::RefPtr AllowMribMessagesCB;
    /**
     *  Send Xrl intended to:
     *
     *  Enable/disable the receiving of Multicast Routing Information Base
     *  information.
     *
     *  @param tgt_name Xrl Target name
     *
     *  @param xrl_sender_name the XRL name of the originator of this XRL.
     *
     *  @param protocol_name the name of the protocol to add.
     *
     *  @param protocol_id the ID of the protocol to add (both sides must agree
     *  on the particular values).
     *
     *  @param is_allow if true, enable the receiving of MRIB information
     *  messages by protocol 'protocol_name'.
     */
    bool send_allow_mrib_messages(
	const char*	target_name,
	const string&	xrl_sender_name,
	const string&	protocol_name,
	const uint32_t&	protocol_id,
	const bool&	is_allow,
	const AllowMribMessagesCB&	cb
    );

    typedef XorpCallback1<void, const XrlError&>::RefPtr JoinMulticastGroup4CB;
    /**
     *  Send Xrl intended to:
     *
     *  Join/leave a multicast group.
     *
     *  @param tgt_name Xrl Target name
     *
     *  @param xrl_sender_name the XRL name of the originator of this XRL.
     *
     *  @param protocol_name the name of the protocol that joins/leave the
     *  group.
     *
     *  @param protocol_id the ID of the protocol that joins/leave the group
     *  (both sides must agree on the particular values).
     *
     *  @param vif_name the name of the vif to join/leave the multicast group.
     *
     *  @param vif_index the index of the vif to join/leave the multicast
     *  group.
     *
     *  @param group_address the multicast group to join/leave.
     */
    bool send_join_multicast_group4(
	const char*	target_name,
	const string&	xrl_sender_name,
	const string&	protocol_name,
	const uint32_t&	protocol_id,
	const string&	vif_name,
	const uint32_t&	vif_index,
	const IPv4&	group_address,
	const JoinMulticastGroup4CB&	cb
    );

    typedef XorpCallback1<void, const XrlError&>::RefPtr JoinMulticastGroup6CB;

    bool send_join_multicast_group6(
	const char*	target_name,
	const string&	xrl_sender_name,
	const string&	protocol_name,
	const uint32_t&	protocol_id,
	const string&	vif_name,
	const uint32_t&	vif_index,
	const IPv6&	group_address,
	const JoinMulticastGroup6CB&	cb
    );

    typedef XorpCallback1<void, const XrlError&>::RefPtr LeaveMulticastGroup4CB;

    bool send_leave_multicast_group4(
	const char*	target_name,
	const string&	xrl_sender_name,
	const string&	protocol_name,
	const uint32_t&	protocol_id,
	const string&	vif_name,
	const uint32_t&	vif_index,
	const IPv4&	group_address,
	const LeaveMulticastGroup4CB&	cb
    );

    typedef XorpCallback1<void, const XrlError&>::RefPtr LeaveMulticastGroup6CB;

    bool send_leave_multicast_group6(
	const char*	target_name,
	const string&	xrl_sender_name,
	const string&	protocol_name,
	const uint32_t&	protocol_id,
	const string&	vif_name,
	const uint32_t&	vif_index,
	const IPv6&	group_address,
	const LeaveMulticastGroup6CB&	cb
    );

    typedef XorpCallback1<void, const XrlError&>::RefPtr AddMfc4CB;
    /**
     *  Send Xrl intended to:
     *
     *  Add/delete a Multicast Forwarding Cache with the kernel.
     *
     *  @param tgt_name Xrl Target name
     *
     *  @param xrl_sender_name the XRL name of the originator of this XRL.
     *
     *  @param source_address the source address of the MFC to add/delete.
     *
     *  @param group_address the group address of the MFC to add/delete.
     *
     *  @param iif_vif_index the index of the vif that is the incoming
     *  interface.
     *
     *  @param oiflist the bit-vector with the set of outgoing interfaces.
     *
     *  @param oiflist_disable_wrongvif the bit-vector with the set of outgoing
     *  interfaces to disable WRONGVIF kernel signal.
     *
     *  @param max_vifs_oiflist the number of vifs covered by oiflist or
     *  oiflist_disable_wrongvif .
     *
     *  @param rp_address the RP address of the MFC to add.
     */
    bool send_add_mfc4(
	const char*	target_name,
	const string&	xrl_sender_name,
	const IPv4&	source_address,
	const IPv4&	group_address,
	const uint32_t&	iif_vif_index,
	const vector<uint8_t>&	oiflist,
	const vector<uint8_t>&	oiflist_disable_wrongvif,
	const uint32_t&	max_vifs_oiflist,
	const IPv4&	rp_address,
	const AddMfc4CB&	cb
    );

    typedef XorpCallback1<void, const XrlError&>::RefPtr AddMfc6CB;

    bool send_add_mfc6(
	const char*	target_name,
	const string&	xrl_sender_name,
	const IPv6&	source_address,
	const IPv6&	group_address,
	const uint32_t&	iif_vif_index,
	const vector<uint8_t>&	oiflist,
	const vector<uint8_t>&	oiflist_disable_wrongvif,
	const uint32_t&	max_vifs_oiflist,
	const IPv6&	rp_address,
	const AddMfc6CB&	cb
    );

    typedef XorpCallback1<void, const XrlError&>::RefPtr DeleteMfc4CB;

    bool send_delete_mfc4(
	const char*	target_name,
	const string&	xrl_sender_name,
	const IPv4&	source_address,
	const IPv4&	group_address,
	const DeleteMfc4CB&	cb
    );

    typedef XorpCallback1<void, const XrlError&>::RefPtr DeleteMfc6CB;

    bool send_delete_mfc6(
	const char*	target_name,
	const string&	xrl_sender_name,
	const IPv6&	source_address,
	const IPv6&	group_address,
	const DeleteMfc6CB&	cb
    );

    typedef XorpCallback1<void, const XrlError&>::RefPtr SendProtocolMessage4CB;
    /**
     *  Send Xrl intended to:
     *
     *  Send a protocol message to the MFEA.
     *
     *  @param tgt_name Xrl Target name
     *
     *  @param xrl_sender_name the XRL name of the originator of this XRL.
     *
     *  @param protocol_name the name of the protocol that sends a message.
     *
     *  @param protocol_id the ID of the protocol that sends a message (both
     *  sides must agree on the particular values).
     *
     *  @param vif_name the name of the vif to send the message.
     *
     *  @param vif_index the vif index of the vif to send the message.
     *
     *  @param source_address the address of the sender.
     *
     *  @param dest_address the destination address.
     *
     *  @param ip_ttl the TTL of the IP packet to send. If it has a negative
     *  value, the TTL will be set by the lower layers.
     *
     *  @param ip_tos the TOS of the IP packet to send. If it has a negative
     *  value, the TOS will be set by the lower layers.
     *
     *  @param is_router_alert set/reset the IP Router Alert option in the IP
     *  packet to send (when applicable).
     */
    bool send_send_protocol_message4(
	const char*	target_name,
	const string&	xrl_sender_name,
	const string&	protocol_name,
	const uint32_t&	protocol_id,
	const string&	vif_name,
	const uint32_t&	vif_index,
	const IPv4&	source_address,
	const IPv4&	dest_address,
	const int32_t&	ip_ttl,
	const int32_t&	ip_tos,
	const bool&	is_router_alert,
	const vector<uint8_t>&	protocol_message,
	const SendProtocolMessage4CB&	cb
    );

    typedef XorpCallback1<void, const XrlError&>::RefPtr SendProtocolMessage6CB;

    bool send_send_protocol_message6(
	const char*	target_name,
	const string&	xrl_sender_name,
	const string&	protocol_name,
	const uint32_t&	protocol_id,
	const string&	vif_name,
	const uint32_t&	vif_index,
	const IPv6&	source_address,
	const IPv6&	dest_address,
	const int32_t&	ip_ttl,
	const int32_t&	ip_tos,
	const bool&	is_router_alert,
	const vector<uint8_t>&	protocol_message,
	const SendProtocolMessage6CB&	cb
    );

    typedef XorpCallback1<void, const XrlError&>::RefPtr AddDataflowMonitor4CB;
    /**
     *  Send Xrl intended to:
     *
     *  Add/delete a dataflow monitor with the MFEA.
     *
     *  @param tgt_name Xrl Target name
     *
     *  @param xrl_sender_name the XRL name of the originator of this XRL.
     *
     *  @param source_address the source address of the dataflow to start/stop
     *  monitoring.
     *
     *  @param group_address the group address of the dataflow to start/stop
     *  monitoring.
     *
     *  @param threshold_interval_sec the number of seconds in the interval to
     *  measure.
     *
     *  @param threshold_interval_usec the number of microseconds in the
     *  interval to measure.
     *
     *  @param threshold_packets the threshold (in number of packets) to
     *  compare against.
     *
     *  @param threshold_bytes the threshold (in number of bytes) to compare
     *  against.
     *
     *  @param is_threshold_in_packets if true, threshold_packets is valid.
     *
     *  @param is_threshold_in_bytes if true, threshold_bytes is valid.
     *
     *  @param is_geq_upcall if true, the operation for comparison is ">=".
     *
     *  @param is_leq_upcall if true, the operation for comparison is "<=".
     */
    bool send_add_dataflow_monitor4(
	const char*	target_name,
	const string&	xrl_sender_name,
	const IPv4&	source_address,
	const IPv4&	group_address,
	const uint32_t&	threshold_interval_sec,
	const uint32_t&	threshold_interval_usec,
	const uint32_t&	threshold_packets,
	const uint32_t&	threshold_bytes,
	const bool&	is_threshold_in_packets,
	const bool&	is_threshold_in_bytes,
	const bool&	is_geq_upcall,
	const bool&	is_leq_upcall,
	const AddDataflowMonitor4CB&	cb
    );

    typedef XorpCallback1<void, const XrlError&>::RefPtr AddDataflowMonitor6CB;

    bool send_add_dataflow_monitor6(
	const char*	target_name,
	const string&	xrl_sender_name,
	const IPv6&	source_address,
	const IPv6&	group_address,
	const uint32_t&	threshold_interval_sec,
	const uint32_t&	threshold_interval_usec,
	const uint32_t&	threshold_packets,
	const uint32_t&	threshold_bytes,
	const bool&	is_threshold_in_packets,
	const bool&	is_threshold_in_bytes,
	const bool&	is_geq_upcall,
	const bool&	is_leq_upcall,
	const AddDataflowMonitor6CB&	cb
    );

    typedef XorpCallback1<void, const XrlError&>::RefPtr DeleteDataflowMonitor4CB;

    bool send_delete_dataflow_monitor4(
	const char*	target_name,
	const string&	xrl_sender_name,
	const IPv4&	source_address,
	const IPv4&	group_address,
	const uint32_t&	threshold_interval_sec,
	const uint32_t&	threshold_interval_usec,
	const uint32_t&	threshold_packets,
	const uint32_t&	threshold_bytes,
	const bool&	is_threshold_in_packets,
	const bool&	is_threshold_in_bytes,
	const bool&	is_geq_upcall,
	const bool&	is_leq_upcall,
	const DeleteDataflowMonitor4CB&	cb
    );

    typedef XorpCallback1<void, const XrlError&>::RefPtr DeleteDataflowMonitor6CB;

    bool send_delete_dataflow_monitor6(
	const char*	target_name,
	const string&	xrl_sender_name,
	const IPv6&	source_address,
	const IPv6&	group_address,
	const uint32_t&	threshold_interval_sec,
	const uint32_t&	threshold_interval_usec,
	const uint32_t&	threshold_packets,
	const uint32_t&	threshold_bytes,
	const bool&	is_threshold_in_packets,
	const bool&	is_threshold_in_bytes,
	const bool&	is_geq_upcall,
	const bool&	is_leq_upcall,
	const DeleteDataflowMonitor6CB&	cb
    );

    typedef XorpCallback1<void, const XrlError&>::RefPtr DeleteAllDataflowMonitor4CB;

    bool send_delete_all_dataflow_monitor4(
	const char*	target_name,
	const string&	xrl_sender_name,
	const IPv4&	source_address,
	const IPv4&	group_address,
	const DeleteAllDataflowMonitor4CB&	cb
    );

    typedef XorpCallback1<void, const XrlError&>::RefPtr DeleteAllDataflowMonitor6CB;

    bool send_delete_all_dataflow_monitor6(
	const char*	target_name,
	const string&	xrl_sender_name,
	const IPv6&	source_address,
	const IPv6&	group_address,
	const DeleteAllDataflowMonitor6CB&	cb
    );

    typedef XorpCallback1<void, const XrlError&>::RefPtr EnableVifCB;
    /**
     *  Send Xrl intended to:
     *
     *  Enable/disable/start/stop a MFEA vif interface.
     *
     *  @param tgt_name Xrl Target name
     *
     *  @param vif_name the name of the vif to enable/disable/start/stop.
     *
     *  @param enable if true, then enable the vif, otherwise disable it.
     */
    bool send_enable_vif(
	const char*	target_name,
	const string&	vif_name,
	const bool&	enable,
	const EnableVifCB&	cb
    );

    typedef XorpCallback1<void, const XrlError&>::RefPtr StartVifCB;

    bool send_start_vif(
	const char*	target_name,
	const string&	vif_name,
	const StartVifCB&	cb
    );

    typedef XorpCallback1<void, const XrlError&>::RefPtr StopVifCB;

    bool send_stop_vif(
	const char*	target_name,
	const string&	vif_name,
	const StopVifCB&	cb
    );

    typedef XorpCallback1<void, const XrlError&>::RefPtr EnableAllVifsCB;
    /**
     *  Send Xrl intended to:
     *
     *  Enable/disable/start/stop all MFEA vif interfaces.
     *
     *  @param tgt_name Xrl Target name
     *
     *  @param enable if true, then enable the vifs, otherwise disable them.
     */
    bool send_enable_all_vifs(
	const char*	target_name,
	const bool&	enable,
	const EnableAllVifsCB&	cb
    );

    typedef XorpCallback1<void, const XrlError&>::RefPtr StartAllVifsCB;

    bool send_start_all_vifs(
	const char*	target_name,
	const StartAllVifsCB&	cb
    );

    typedef XorpCallback1<void, const XrlError&>::RefPtr StopAllVifsCB;

    bool send_stop_all_vifs(
	const char*	target_name,
	const StopAllVifsCB&	cb
    );

    typedef XorpCallback1<void, const XrlError&>::RefPtr EnableMfeaCB;
    /**
     *  Send Xrl intended to:
     *
     *  Enable/disable/start/stop the MFEA.
     *
     *  @param tgt_name Xrl Target name
     *
     *  @param enable if true, then enable the MFEA, otherwise disable it.
     */
    bool send_enable_mfea(
	const char*	target_name,
	const bool&	enable,
	const EnableMfeaCB&	cb
    );

    typedef XorpCallback1<void, const XrlError&>::RefPtr StartMfeaCB;

    bool send_start_mfea(
	const char*	target_name,
	const StartMfeaCB&	cb
    );

    typedef XorpCallback1<void, const XrlError&>::RefPtr StopMfeaCB;

    bool send_stop_mfea(
	const char*	target_name,
	const StopMfeaCB&	cb
    );

    typedef XorpCallback1<void, const XrlError&>::RefPtr EnableCliCB;
    /**
     *  Send Xrl intended to:
     *
     *  Enable/disable/start/stop the MFEA CLI access.
     *
     *  @param tgt_name Xrl Target name
     *
     *  @param enable if true, then enable the MFEA CLI access, otherwise
     *  disable it.
     */
    bool send_enable_cli(
	const char*	target_name,
	const bool&	enable,
	const EnableCliCB&	cb
    );

    typedef XorpCallback1<void, const XrlError&>::RefPtr StartCliCB;

    bool send_start_cli(
	const char*	target_name,
	const StartCliCB&	cb
    );

    typedef XorpCallback1<void, const XrlError&>::RefPtr StopCliCB;

    bool send_stop_cli(
	const char*	target_name,
	const StopCliCB&	cb
    );

    typedef XorpCallback1<void, const XrlError&>::RefPtr LogTraceAllCB;
    /**
     *  Send Xrl intended to:
     *
     *  Enable/disable the MFEA trace log for all operations.
     *
     *  @param tgt_name Xrl Target name
     *
     *  @param enable if true, then enable the trace log, otherwise disable it.
     */
    bool send_log_trace_all(
	const char*	target_name,
	const bool&	enable,
	const LogTraceAllCB&	cb
    );

    typedef XorpCallback2<void, const XrlError&, const uint32_t*>::RefPtr GetMribTableDefaultMetricPreferenceCB;
    /**
     *  Send Xrl intended to:
     *
     *  Configure MFEA MRIB-related parameters. The 'set_foo' XRLs set the
     *  particular values. The 'reset_foo' XRLs reset the metrics to their
     *  default values.
     *
     *  @param tgt_name Xrl Target name
     */
    bool send_get_mrib_table_default_metric_preference(
	const char*	target_name,
	const GetMribTableDefaultMetricPreferenceCB&	cb
    );

    typedef XorpCallback1<void, const XrlError&>::RefPtr SetMribTableDefaultMetricPreferenceCB;

    bool send_set_mrib_table_default_metric_preference(
	const char*	target_name,
	const uint32_t&	metric_preference,
	const SetMribTableDefaultMetricPreferenceCB&	cb
    );

    typedef XorpCallback1<void, const XrlError&>::RefPtr ResetMribTableDefaultMetricPreferenceCB;

    bool send_reset_mrib_table_default_metric_preference(
	const char*	target_name,
	const ResetMribTableDefaultMetricPreferenceCB&	cb
    );

    typedef XorpCallback2<void, const XrlError&, const uint32_t*>::RefPtr GetMribTableDefaultMetricCB;

    bool send_get_mrib_table_default_metric(
	const char*	target_name,
	const GetMribTableDefaultMetricCB&	cb
    );

    typedef XorpCallback1<void, const XrlError&>::RefPtr SetMribTableDefaultMetricCB;

    bool send_set_mrib_table_default_metric(
	const char*	target_name,
	const uint32_t&	metric,
	const SetMribTableDefaultMetricCB&	cb
    );

    typedef XorpCallback1<void, const XrlError&>::RefPtr ResetMribTableDefaultMetricCB;

    bool send_reset_mrib_table_default_metric(
	const char*	target_name,
	const ResetMribTableDefaultMetricCB&	cb
    );

protected:
    XrlSender* _sender;

private:
    void unmarshall_have_multicast_routing4(
	const XrlError&	e,
	XrlArgs*	a,
	HaveMulticastRouting4CB		cb
    );

    void unmarshall_have_multicast_routing6(
	const XrlError&	e,
	XrlArgs*	a,
	HaveMulticastRouting6CB		cb
    );

    void unmarshall_add_protocol4(
	const XrlError&	e,
	XrlArgs*	a,
	AddProtocol4CB		cb
    );

    void unmarshall_add_protocol6(
	const XrlError&	e,
	XrlArgs*	a,
	AddProtocol6CB		cb
    );

    void unmarshall_delete_protocol4(
	const XrlError&	e,
	XrlArgs*	a,
	DeleteProtocol4CB		cb
    );

    void unmarshall_delete_protocol6(
	const XrlError&	e,
	XrlArgs*	a,
	DeleteProtocol6CB		cb
    );

    void unmarshall_start_protocol_vif4(
	const XrlError&	e,
	XrlArgs*	a,
	StartProtocolVif4CB		cb
    );

    void unmarshall_start_protocol_vif6(
	const XrlError&	e,
	XrlArgs*	a,
	StartProtocolVif6CB		cb
    );

    void unmarshall_stop_protocol_vif4(
	const XrlError&	e,
	XrlArgs*	a,
	StopProtocolVif4CB		cb
    );

    void unmarshall_stop_protocol_vif6(
	const XrlError&	e,
	XrlArgs*	a,
	StopProtocolVif6CB		cb
    );

    void unmarshall_allow_signal_messages(
	const XrlError&	e,
	XrlArgs*	a,
	AllowSignalMessagesCB		cb
    );

    void unmarshall_allow_mrib_messages(
	const XrlError&	e,
	XrlArgs*	a,
	AllowMribMessagesCB		cb
    );

    void unmarshall_join_multicast_group4(
	const XrlError&	e,
	XrlArgs*	a,
	JoinMulticastGroup4CB		cb
    );

    void unmarshall_join_multicast_group6(
	const XrlError&	e,
	XrlArgs*	a,
	JoinMulticastGroup6CB		cb
    );

    void unmarshall_leave_multicast_group4(
	const XrlError&	e,
	XrlArgs*	a,
	LeaveMulticastGroup4CB		cb
    );

    void unmarshall_leave_multicast_group6(
	const XrlError&	e,
	XrlArgs*	a,
	LeaveMulticastGroup6CB		cb
    );

    void unmarshall_add_mfc4(
	const XrlError&	e,
	XrlArgs*	a,
	AddMfc4CB		cb
    );

    void unmarshall_add_mfc6(
	const XrlError&	e,
	XrlArgs*	a,
	AddMfc6CB		cb
    );

    void unmarshall_delete_mfc4(
	const XrlError&	e,
	XrlArgs*	a,
	DeleteMfc4CB		cb
    );

    void unmarshall_delete_mfc6(
	const XrlError&	e,
	XrlArgs*	a,
	DeleteMfc6CB		cb
    );

    void unmarshall_send_protocol_message4(
	const XrlError&	e,
	XrlArgs*	a,
	SendProtocolMessage4CB		cb
    );

    void unmarshall_send_protocol_message6(
	const XrlError&	e,
	XrlArgs*	a,
	SendProtocolMessage6CB		cb
    );

    void unmarshall_add_dataflow_monitor4(
	const XrlError&	e,
	XrlArgs*	a,
	AddDataflowMonitor4CB		cb
    );

    void unmarshall_add_dataflow_monitor6(
	const XrlError&	e,
	XrlArgs*	a,
	AddDataflowMonitor6CB		cb
    );

    void unmarshall_delete_dataflow_monitor4(
	const XrlError&	e,
	XrlArgs*	a,
	DeleteDataflowMonitor4CB		cb
    );

    void unmarshall_delete_dataflow_monitor6(
	const XrlError&	e,
	XrlArgs*	a,
	DeleteDataflowMonitor6CB		cb
    );

    void unmarshall_delete_all_dataflow_monitor4(
	const XrlError&	e,
	XrlArgs*	a,
	DeleteAllDataflowMonitor4CB		cb
    );

    void unmarshall_delete_all_dataflow_monitor6(
	const XrlError&	e,
	XrlArgs*	a,
	DeleteAllDataflowMonitor6CB		cb
    );

    void unmarshall_enable_vif(
	const XrlError&	e,
	XrlArgs*	a,
	EnableVifCB		cb
    );

    void unmarshall_start_vif(
	const XrlError&	e,
	XrlArgs*	a,
	StartVifCB		cb
    );

    void unmarshall_stop_vif(
	const XrlError&	e,
	XrlArgs*	a,
	StopVifCB		cb
    );

    void unmarshall_enable_all_vifs(
	const XrlError&	e,
	XrlArgs*	a,
	EnableAllVifsCB		cb
    );

    void unmarshall_start_all_vifs(
	const XrlError&	e,
	XrlArgs*	a,
	StartAllVifsCB		cb
    );

    void unmarshall_stop_all_vifs(
	const XrlError&	e,
	XrlArgs*	a,
	StopAllVifsCB		cb
    );

    void unmarshall_enable_mfea(
	const XrlError&	e,
	XrlArgs*	a,
	EnableMfeaCB		cb
    );

    void unmarshall_start_mfea(
	const XrlError&	e,
	XrlArgs*	a,
	StartMfeaCB		cb
    );

    void unmarshall_stop_mfea(
	const XrlError&	e,
	XrlArgs*	a,
	StopMfeaCB		cb
    );

    void unmarshall_enable_cli(
	const XrlError&	e,
	XrlArgs*	a,
	EnableCliCB		cb
    );

    void unmarshall_start_cli(
	const XrlError&	e,
	XrlArgs*	a,
	StartCliCB		cb
    );

    void unmarshall_stop_cli(
	const XrlError&	e,
	XrlArgs*	a,
	StopCliCB		cb
    );

    void unmarshall_log_trace_all(
	const XrlError&	e,
	XrlArgs*	a,
	LogTraceAllCB		cb
    );

    void unmarshall_get_mrib_table_default_metric_preference(
	const XrlError&	e,
	XrlArgs*	a,
	GetMribTableDefaultMetricPreferenceCB		cb
    );

    void unmarshall_set_mrib_table_default_metric_preference(
	const XrlError&	e,
	XrlArgs*	a,
	SetMribTableDefaultMetricPreferenceCB		cb
    );

    void unmarshall_reset_mrib_table_default_metric_preference(
	const XrlError&	e,
	XrlArgs*	a,
	ResetMribTableDefaultMetricPreferenceCB		cb
    );

    void unmarshall_get_mrib_table_default_metric(
	const XrlError&	e,
	XrlArgs*	a,
	GetMribTableDefaultMetricCB		cb
    );

    void unmarshall_set_mrib_table_default_metric(
	const XrlError&	e,
	XrlArgs*	a,
	SetMribTableDefaultMetricCB		cb
    );

    void unmarshall_reset_mrib_table_default_metric(
	const XrlError&	e,
	XrlArgs*	a,
	ResetMribTableDefaultMetricCB		cb
    );

};

#endif /* __XRL_INTERFACES_MFEA_XIF_HH__ */
