/*
 * Copyright (c) 2001-2004 International Computer Science Institute
 * See LICENSE file for licensing, conditions, and warranties on use.
 *
 * DO NOT EDIT THIS FILE - IT IS PROGRAMMATICALLY GENERATED
 *
 * Generated by 'clnt-gen'.
 */

#ident "$XORP: xorp/xrl/interfaces/fti_xif.cc,v 1.8 2004/06/10 22:42:01 hodson Exp $"

#include "fti_xif.hh"

bool
XrlFtiV0p2Client::send_start_transaction(
	const char*	the_tgt,
	const StartTransactionCB&	cb
)
{
    Xrl x(the_tgt, "fti/0.2/start_transaction");
    return _sender->send(x, callback(this, &XrlFtiV0p2Client::unmarshall_start_transaction, cb));
}


/* Unmarshall start_transaction */
void
XrlFtiV0p2Client::unmarshall_start_transaction(
	const XrlError&	e,
	XrlArgs*	a,
	StartTransactionCB		cb
)
{
    if (e != XrlError::OKAY()) {
	cb->dispatch(e, 0);
	return;
    } else if (a && a->size() != 1) {
	XLOG_ERROR("Wrong number of arguments (%u != %u)", (uint32_t)a->size(), 1);
	cb->dispatch(XrlError::BAD_ARGS(), 0);
	return;
    }
    uint32_t tid;
    try {
	a->get("tid", tid);
    } catch (const XrlArgs::XrlAtomNotFound&) {
	XLOG_ERROR("Atom not found");
	cb->dispatch(XrlError::BAD_ARGS(), 0);
	return;
    }
    cb->dispatch(e, &tid);
}

bool
XrlFtiV0p2Client::send_commit_transaction(
	const char*	the_tgt,
	const uint32_t&	tid,
	const CommitTransactionCB&	cb
)
{
    Xrl x(the_tgt, "fti/0.2/commit_transaction");
    x.args().add("tid", tid);
    return _sender->send(x, callback(this, &XrlFtiV0p2Client::unmarshall_commit_transaction, cb));
}


/* Unmarshall commit_transaction */
void
XrlFtiV0p2Client::unmarshall_commit_transaction(
	const XrlError&	e,
	XrlArgs*	a,
	CommitTransactionCB		cb
)
{
    if (e != XrlError::OKAY()) {
	cb->dispatch(e);
	return;
    } else if (a && a->size() != 0) {
	XLOG_ERROR("Wrong number of arguments (%u != %u)", (uint32_t)a->size(), 0);
	cb->dispatch(XrlError::BAD_ARGS());
	return;
    }
    cb->dispatch(e);
}

bool
XrlFtiV0p2Client::send_abort_transaction(
	const char*	the_tgt,
	const uint32_t&	tid,
	const AbortTransactionCB&	cb
)
{
    Xrl x(the_tgt, "fti/0.2/abort_transaction");
    x.args().add("tid", tid);
    return _sender->send(x, callback(this, &XrlFtiV0p2Client::unmarshall_abort_transaction, cb));
}


/* Unmarshall abort_transaction */
void
XrlFtiV0p2Client::unmarshall_abort_transaction(
	const XrlError&	e,
	XrlArgs*	a,
	AbortTransactionCB		cb
)
{
    if (e != XrlError::OKAY()) {
	cb->dispatch(e);
	return;
    } else if (a && a->size() != 0) {
	XLOG_ERROR("Wrong number of arguments (%u != %u)", (uint32_t)a->size(), 0);
	cb->dispatch(XrlError::BAD_ARGS());
	return;
    }
    cb->dispatch(e);
}

bool
XrlFtiV0p2Client::send_add_entry4(
	const char*	the_tgt,
	const uint32_t&	tid,
	const IPv4Net&	dst,
	const IPv4&	gateway,
	const string&	ifname,
	const string&	vifname,
	const uint32_t&	metric,
	const uint32_t&	admin_distance,
	const string&	protocol_origin,
	const AddEntry4CB&	cb
)
{
    Xrl x(the_tgt, "fti/0.2/add_entry4");
    x.args().add("tid", tid);
    x.args().add("dst", dst);
    x.args().add("gateway", gateway);
    x.args().add("ifname", ifname);
    x.args().add("vifname", vifname);
    x.args().add("metric", metric);
    x.args().add("admin_distance", admin_distance);
    x.args().add("protocol_origin", protocol_origin);
    return _sender->send(x, callback(this, &XrlFtiV0p2Client::unmarshall_add_entry4, cb));
}


/* Unmarshall add_entry4 */
void
XrlFtiV0p2Client::unmarshall_add_entry4(
	const XrlError&	e,
	XrlArgs*	a,
	AddEntry4CB		cb
)
{
    if (e != XrlError::OKAY()) {
	cb->dispatch(e);
	return;
    } else if (a && a->size() != 0) {
	XLOG_ERROR("Wrong number of arguments (%u != %u)", (uint32_t)a->size(), 0);
	cb->dispatch(XrlError::BAD_ARGS());
	return;
    }
    cb->dispatch(e);
}

bool
XrlFtiV0p2Client::send_add_entry6(
	const char*	the_tgt,
	const uint32_t&	tid,
	const IPv6Net&	dst,
	const IPv6&	gateway,
	const string&	ifname,
	const string&	vifname,
	const uint32_t&	metric,
	const uint32_t&	admin_distance,
	const string&	protocol_origin,
	const AddEntry6CB&	cb
)
{
    Xrl x(the_tgt, "fti/0.2/add_entry6");
    x.args().add("tid", tid);
    x.args().add("dst", dst);
    x.args().add("gateway", gateway);
    x.args().add("ifname", ifname);
    x.args().add("vifname", vifname);
    x.args().add("metric", metric);
    x.args().add("admin_distance", admin_distance);
    x.args().add("protocol_origin", protocol_origin);
    return _sender->send(x, callback(this, &XrlFtiV0p2Client::unmarshall_add_entry6, cb));
}


/* Unmarshall add_entry6 */
void
XrlFtiV0p2Client::unmarshall_add_entry6(
	const XrlError&	e,
	XrlArgs*	a,
	AddEntry6CB		cb
)
{
    if (e != XrlError::OKAY()) {
	cb->dispatch(e);
	return;
    } else if (a && a->size() != 0) {
	XLOG_ERROR("Wrong number of arguments (%u != %u)", (uint32_t)a->size(), 0);
	cb->dispatch(XrlError::BAD_ARGS());
	return;
    }
    cb->dispatch(e);
}

bool
XrlFtiV0p2Client::send_delete_entry4(
	const char*	the_tgt,
	const uint32_t&	tid,
	const IPv4Net&	dst,
	const DeleteEntry4CB&	cb
)
{
    Xrl x(the_tgt, "fti/0.2/delete_entry4");
    x.args().add("tid", tid);
    x.args().add("dst", dst);
    return _sender->send(x, callback(this, &XrlFtiV0p2Client::unmarshall_delete_entry4, cb));
}


/* Unmarshall delete_entry4 */
void
XrlFtiV0p2Client::unmarshall_delete_entry4(
	const XrlError&	e,
	XrlArgs*	a,
	DeleteEntry4CB		cb
)
{
    if (e != XrlError::OKAY()) {
	cb->dispatch(e);
	return;
    } else if (a && a->size() != 0) {
	XLOG_ERROR("Wrong number of arguments (%u != %u)", (uint32_t)a->size(), 0);
	cb->dispatch(XrlError::BAD_ARGS());
	return;
    }
    cb->dispatch(e);
}

bool
XrlFtiV0p2Client::send_delete_entry6(
	const char*	the_tgt,
	const uint32_t&	tid,
	const IPv6Net&	dst,
	const DeleteEntry6CB&	cb
)
{
    Xrl x(the_tgt, "fti/0.2/delete_entry6");
    x.args().add("tid", tid);
    x.args().add("dst", dst);
    return _sender->send(x, callback(this, &XrlFtiV0p2Client::unmarshall_delete_entry6, cb));
}


/* Unmarshall delete_entry6 */
void
XrlFtiV0p2Client::unmarshall_delete_entry6(
	const XrlError&	e,
	XrlArgs*	a,
	DeleteEntry6CB		cb
)
{
    if (e != XrlError::OKAY()) {
	cb->dispatch(e);
	return;
    } else if (a && a->size() != 0) {
	XLOG_ERROR("Wrong number of arguments (%u != %u)", (uint32_t)a->size(), 0);
	cb->dispatch(XrlError::BAD_ARGS());
	return;
    }
    cb->dispatch(e);
}

bool
XrlFtiV0p2Client::send_delete_all_entries(
	const char*	the_tgt,
	const uint32_t&	tid,
	const DeleteAllEntriesCB&	cb
)
{
    Xrl x(the_tgt, "fti/0.2/delete_all_entries");
    x.args().add("tid", tid);
    return _sender->send(x, callback(this, &XrlFtiV0p2Client::unmarshall_delete_all_entries, cb));
}


/* Unmarshall delete_all_entries */
void
XrlFtiV0p2Client::unmarshall_delete_all_entries(
	const XrlError&	e,
	XrlArgs*	a,
	DeleteAllEntriesCB		cb
)
{
    if (e != XrlError::OKAY()) {
	cb->dispatch(e);
	return;
    } else if (a && a->size() != 0) {
	XLOG_ERROR("Wrong number of arguments (%u != %u)", (uint32_t)a->size(), 0);
	cb->dispatch(XrlError::BAD_ARGS());
	return;
    }
    cb->dispatch(e);
}

bool
XrlFtiV0p2Client::send_delete_all_entries4(
	const char*	the_tgt,
	const uint32_t&	tid,
	const DeleteAllEntries4CB&	cb
)
{
    Xrl x(the_tgt, "fti/0.2/delete_all_entries4");
    x.args().add("tid", tid);
    return _sender->send(x, callback(this, &XrlFtiV0p2Client::unmarshall_delete_all_entries4, cb));
}


/* Unmarshall delete_all_entries4 */
void
XrlFtiV0p2Client::unmarshall_delete_all_entries4(
	const XrlError&	e,
	XrlArgs*	a,
	DeleteAllEntries4CB		cb
)
{
    if (e != XrlError::OKAY()) {
	cb->dispatch(e);
	return;
    } else if (a && a->size() != 0) {
	XLOG_ERROR("Wrong number of arguments (%u != %u)", (uint32_t)a->size(), 0);
	cb->dispatch(XrlError::BAD_ARGS());
	return;
    }
    cb->dispatch(e);
}

bool
XrlFtiV0p2Client::send_delete_all_entries6(
	const char*	the_tgt,
	const uint32_t&	tid,
	const DeleteAllEntries6CB&	cb
)
{
    Xrl x(the_tgt, "fti/0.2/delete_all_entries6");
    x.args().add("tid", tid);
    return _sender->send(x, callback(this, &XrlFtiV0p2Client::unmarshall_delete_all_entries6, cb));
}


/* Unmarshall delete_all_entries6 */
void
XrlFtiV0p2Client::unmarshall_delete_all_entries6(
	const XrlError&	e,
	XrlArgs*	a,
	DeleteAllEntries6CB		cb
)
{
    if (e != XrlError::OKAY()) {
	cb->dispatch(e);
	return;
    } else if (a && a->size() != 0) {
	XLOG_ERROR("Wrong number of arguments (%u != %u)", (uint32_t)a->size(), 0);
	cb->dispatch(XrlError::BAD_ARGS());
	return;
    }
    cb->dispatch(e);
}

bool
XrlFtiV0p2Client::send_lookup_route4(
	const char*	the_tgt,
	const IPv4&	dst,
	const LookupRoute4CB&	cb
)
{
    Xrl x(the_tgt, "fti/0.2/lookup_route4");
    x.args().add("dst", dst);
    return _sender->send(x, callback(this, &XrlFtiV0p2Client::unmarshall_lookup_route4, cb));
}


/* Unmarshall lookup_route4 */
void
XrlFtiV0p2Client::unmarshall_lookup_route4(
	const XrlError&	e,
	XrlArgs*	a,
	LookupRoute4CB		cb
)
{
    if (e != XrlError::OKAY()) {
	cb->dispatch(e, 0, 0, 0, 0, 0, 0, 0);
	return;
    } else if (a && a->size() != 7) {
	XLOG_ERROR("Wrong number of arguments (%u != %u)", (uint32_t)a->size(), 7);
	cb->dispatch(XrlError::BAD_ARGS(), 0, 0, 0, 0, 0, 0, 0);
	return;
    }
    IPv4Net netmask;
    IPv4 gateway;
    string ifname;
    string vifname;
    uint32_t metric;
    uint32_t admin_distance;
    string protocol_origin;
    try {
	a->get("netmask", netmask);
	a->get("gateway", gateway);
	a->get("ifname", ifname);
	a->get("vifname", vifname);
	a->get("metric", metric);
	a->get("admin_distance", admin_distance);
	a->get("protocol_origin", protocol_origin);
    } catch (const XrlArgs::XrlAtomNotFound&) {
	XLOG_ERROR("Atom not found");
	cb->dispatch(XrlError::BAD_ARGS(), 0, 0, 0, 0, 0, 0, 0);
	return;
    }
    cb->dispatch(e, &netmask, &gateway, &ifname, &vifname, &metric, &admin_distance, &protocol_origin);
}

bool
XrlFtiV0p2Client::send_lookup_route6(
	const char*	the_tgt,
	const IPv6&	dst,
	const LookupRoute6CB&	cb
)
{
    Xrl x(the_tgt, "fti/0.2/lookup_route6");
    x.args().add("dst", dst);
    return _sender->send(x, callback(this, &XrlFtiV0p2Client::unmarshall_lookup_route6, cb));
}


/* Unmarshall lookup_route6 */
void
XrlFtiV0p2Client::unmarshall_lookup_route6(
	const XrlError&	e,
	XrlArgs*	a,
	LookupRoute6CB		cb
)
{
    if (e != XrlError::OKAY()) {
	cb->dispatch(e, 0, 0, 0, 0, 0, 0, 0);
	return;
    } else if (a && a->size() != 7) {
	XLOG_ERROR("Wrong number of arguments (%u != %u)", (uint32_t)a->size(), 7);
	cb->dispatch(XrlError::BAD_ARGS(), 0, 0, 0, 0, 0, 0, 0);
	return;
    }
    IPv6Net netmask;
    IPv6 gateway;
    string ifname;
    string vifname;
    uint32_t metric;
    uint32_t admin_distance;
    string protocol_origin;
    try {
	a->get("netmask", netmask);
	a->get("gateway", gateway);
	a->get("ifname", ifname);
	a->get("vifname", vifname);
	a->get("metric", metric);
	a->get("admin_distance", admin_distance);
	a->get("protocol_origin", protocol_origin);
    } catch (const XrlArgs::XrlAtomNotFound&) {
	XLOG_ERROR("Atom not found");
	cb->dispatch(XrlError::BAD_ARGS(), 0, 0, 0, 0, 0, 0, 0);
	return;
    }
    cb->dispatch(e, &netmask, &gateway, &ifname, &vifname, &metric, &admin_distance, &protocol_origin);
}

bool
XrlFtiV0p2Client::send_lookup_entry4(
	const char*	the_tgt,
	const IPv4Net&	dst,
	const LookupEntry4CB&	cb
)
{
    Xrl x(the_tgt, "fti/0.2/lookup_entry4");
    x.args().add("dst", dst);
    return _sender->send(x, callback(this, &XrlFtiV0p2Client::unmarshall_lookup_entry4, cb));
}


/* Unmarshall lookup_entry4 */
void
XrlFtiV0p2Client::unmarshall_lookup_entry4(
	const XrlError&	e,
	XrlArgs*	a,
	LookupEntry4CB		cb
)
{
    if (e != XrlError::OKAY()) {
	cb->dispatch(e, 0, 0, 0, 0, 0, 0);
	return;
    } else if (a && a->size() != 6) {
	XLOG_ERROR("Wrong number of arguments (%u != %u)", (uint32_t)a->size(), 6);
	cb->dispatch(XrlError::BAD_ARGS(), 0, 0, 0, 0, 0, 0);
	return;
    }
    IPv4 gateway;
    string ifname;
    string vifname;
    uint32_t metric;
    uint32_t admin_distance;
    string protocol_origin;
    try {
	a->get("gateway", gateway);
	a->get("ifname", ifname);
	a->get("vifname", vifname);
	a->get("metric", metric);
	a->get("admin_distance", admin_distance);
	a->get("protocol_origin", protocol_origin);
    } catch (const XrlArgs::XrlAtomNotFound&) {
	XLOG_ERROR("Atom not found");
	cb->dispatch(XrlError::BAD_ARGS(), 0, 0, 0, 0, 0, 0);
	return;
    }
    cb->dispatch(e, &gateway, &ifname, &vifname, &metric, &admin_distance, &protocol_origin);
}

bool
XrlFtiV0p2Client::send_lookup_entry6(
	const char*	the_tgt,
	const IPv6Net&	dst,
	const LookupEntry6CB&	cb
)
{
    Xrl x(the_tgt, "fti/0.2/lookup_entry6");
    x.args().add("dst", dst);
    return _sender->send(x, callback(this, &XrlFtiV0p2Client::unmarshall_lookup_entry6, cb));
}


/* Unmarshall lookup_entry6 */
void
XrlFtiV0p2Client::unmarshall_lookup_entry6(
	const XrlError&	e,
	XrlArgs*	a,
	LookupEntry6CB		cb
)
{
    if (e != XrlError::OKAY()) {
	cb->dispatch(e, 0, 0, 0, 0, 0, 0);
	return;
    } else if (a && a->size() != 6) {
	XLOG_ERROR("Wrong number of arguments (%u != %u)", (uint32_t)a->size(), 6);
	cb->dispatch(XrlError::BAD_ARGS(), 0, 0, 0, 0, 0, 0);
	return;
    }
    IPv6 gateway;
    string ifname;
    string vifname;
    uint32_t metric;
    uint32_t admin_distance;
    string protocol_origin;
    try {
	a->get("gateway", gateway);
	a->get("ifname", ifname);
	a->get("vifname", vifname);
	a->get("metric", metric);
	a->get("admin_distance", admin_distance);
	a->get("protocol_origin", protocol_origin);
    } catch (const XrlArgs::XrlAtomNotFound&) {
	XLOG_ERROR("Atom not found");
	cb->dispatch(XrlError::BAD_ARGS(), 0, 0, 0, 0, 0, 0);
	return;
    }
    cb->dispatch(e, &gateway, &ifname, &vifname, &metric, &admin_distance, &protocol_origin);
}

bool
XrlFtiV0p2Client::send_have_ipv4(
	const char*	the_tgt,
	const HaveIpv4CB&	cb
)
{
    Xrl x(the_tgt, "fti/0.2/have_ipv4");
    return _sender->send(x, callback(this, &XrlFtiV0p2Client::unmarshall_have_ipv4, cb));
}


/* Unmarshall have_ipv4 */
void
XrlFtiV0p2Client::unmarshall_have_ipv4(
	const XrlError&	e,
	XrlArgs*	a,
	HaveIpv4CB		cb
)
{
    if (e != XrlError::OKAY()) {
	cb->dispatch(e, 0);
	return;
    } else if (a && a->size() != 1) {
	XLOG_ERROR("Wrong number of arguments (%u != %u)", (uint32_t)a->size(), 1);
	cb->dispatch(XrlError::BAD_ARGS(), 0);
	return;
    }
    bool result;
    try {
	a->get("result", result);
    } catch (const XrlArgs::XrlAtomNotFound&) {
	XLOG_ERROR("Atom not found");
	cb->dispatch(XrlError::BAD_ARGS(), 0);
	return;
    }
    cb->dispatch(e, &result);
}

bool
XrlFtiV0p2Client::send_have_ipv6(
	const char*	the_tgt,
	const HaveIpv6CB&	cb
)
{
    Xrl x(the_tgt, "fti/0.2/have_ipv6");
    return _sender->send(x, callback(this, &XrlFtiV0p2Client::unmarshall_have_ipv6, cb));
}


/* Unmarshall have_ipv6 */
void
XrlFtiV0p2Client::unmarshall_have_ipv6(
	const XrlError&	e,
	XrlArgs*	a,
	HaveIpv6CB		cb
)
{
    if (e != XrlError::OKAY()) {
	cb->dispatch(e, 0);
	return;
    } else if (a && a->size() != 1) {
	XLOG_ERROR("Wrong number of arguments (%u != %u)", (uint32_t)a->size(), 1);
	cb->dispatch(XrlError::BAD_ARGS(), 0);
	return;
    }
    bool result;
    try {
	a->get("result", result);
    } catch (const XrlArgs::XrlAtomNotFound&) {
	XLOG_ERROR("Atom not found");
	cb->dispatch(XrlError::BAD_ARGS(), 0);
	return;
    }
    cb->dispatch(e, &result);
}

bool
XrlFtiV0p2Client::send_get_unicast_forwarding_enabled4(
	const char*	the_tgt,
	const GetUnicastForwardingEnabled4CB&	cb
)
{
    Xrl x(the_tgt, "fti/0.2/get_unicast_forwarding_enabled4");
    return _sender->send(x, callback(this, &XrlFtiV0p2Client::unmarshall_get_unicast_forwarding_enabled4, cb));
}


/* Unmarshall get_unicast_forwarding_enabled4 */
void
XrlFtiV0p2Client::unmarshall_get_unicast_forwarding_enabled4(
	const XrlError&	e,
	XrlArgs*	a,
	GetUnicastForwardingEnabled4CB		cb
)
{
    if (e != XrlError::OKAY()) {
	cb->dispatch(e, 0);
	return;
    } else if (a && a->size() != 1) {
	XLOG_ERROR("Wrong number of arguments (%u != %u)", (uint32_t)a->size(), 1);
	cb->dispatch(XrlError::BAD_ARGS(), 0);
	return;
    }
    bool enabled;
    try {
	a->get("enabled", enabled);
    } catch (const XrlArgs::XrlAtomNotFound&) {
	XLOG_ERROR("Atom not found");
	cb->dispatch(XrlError::BAD_ARGS(), 0);
	return;
    }
    cb->dispatch(e, &enabled);
}

bool
XrlFtiV0p2Client::send_get_unicast_forwarding_enabled6(
	const char*	the_tgt,
	const GetUnicastForwardingEnabled6CB&	cb
)
{
    Xrl x(the_tgt, "fti/0.2/get_unicast_forwarding_enabled6");
    return _sender->send(x, callback(this, &XrlFtiV0p2Client::unmarshall_get_unicast_forwarding_enabled6, cb));
}


/* Unmarshall get_unicast_forwarding_enabled6 */
void
XrlFtiV0p2Client::unmarshall_get_unicast_forwarding_enabled6(
	const XrlError&	e,
	XrlArgs*	a,
	GetUnicastForwardingEnabled6CB		cb
)
{
    if (e != XrlError::OKAY()) {
	cb->dispatch(e, 0);
	return;
    } else if (a && a->size() != 1) {
	XLOG_ERROR("Wrong number of arguments (%u != %u)", (uint32_t)a->size(), 1);
	cb->dispatch(XrlError::BAD_ARGS(), 0);
	return;
    }
    bool enabled;
    try {
	a->get("enabled", enabled);
    } catch (const XrlArgs::XrlAtomNotFound&) {
	XLOG_ERROR("Atom not found");
	cb->dispatch(XrlError::BAD_ARGS(), 0);
	return;
    }
    cb->dispatch(e, &enabled);
}

bool
XrlFtiV0p2Client::send_set_unicast_forwarding_enabled4(
	const char*	the_tgt,
	const bool&	enabled,
	const SetUnicastForwardingEnabled4CB&	cb
)
{
    Xrl x(the_tgt, "fti/0.2/set_unicast_forwarding_enabled4");
    x.args().add("enabled", enabled);
    return _sender->send(x, callback(this, &XrlFtiV0p2Client::unmarshall_set_unicast_forwarding_enabled4, cb));
}


/* Unmarshall set_unicast_forwarding_enabled4 */
void
XrlFtiV0p2Client::unmarshall_set_unicast_forwarding_enabled4(
	const XrlError&	e,
	XrlArgs*	a,
	SetUnicastForwardingEnabled4CB		cb
)
{
    if (e != XrlError::OKAY()) {
	cb->dispatch(e);
	return;
    } else if (a && a->size() != 0) {
	XLOG_ERROR("Wrong number of arguments (%u != %u)", (uint32_t)a->size(), 0);
	cb->dispatch(XrlError::BAD_ARGS());
	return;
    }
    cb->dispatch(e);
}

bool
XrlFtiV0p2Client::send_set_unicast_forwarding_enabled6(
	const char*	the_tgt,
	const bool&	enabled,
	const SetUnicastForwardingEnabled6CB&	cb
)
{
    Xrl x(the_tgt, "fti/0.2/set_unicast_forwarding_enabled6");
    x.args().add("enabled", enabled);
    return _sender->send(x, callback(this, &XrlFtiV0p2Client::unmarshall_set_unicast_forwarding_enabled6, cb));
}


/* Unmarshall set_unicast_forwarding_enabled6 */
void
XrlFtiV0p2Client::unmarshall_set_unicast_forwarding_enabled6(
	const XrlError&	e,
	XrlArgs*	a,
	SetUnicastForwardingEnabled6CB		cb
)
{
    if (e != XrlError::OKAY()) {
	cb->dispatch(e);
	return;
    } else if (a && a->size() != 0) {
	XLOG_ERROR("Wrong number of arguments (%u != %u)", (uint32_t)a->size(), 0);
	cb->dispatch(XrlError::BAD_ARGS());
	return;
    }
    cb->dispatch(e);
}
