#ifndef XDNDCLASS
#define XDNDCLASS

#include "globals.h"     //Common headers
#include <X11/Xlib.h>
#include <X11/Xutil.h>
#include <X11/Xatom.h>

//////////////////////////Defines//////////////////////////
#define XDND_VERSION 3


#define XDND_MESTYPE(e)                 ((e)->xclient.message_type)

/* XdndEnter */
#define XDND_THREE 3
#define XDND_ENTER_SOURCE_WIN(e)	((e)->xclient.data.l[0])
#define XDND_ENTER_THREE_TYPES(e)	(((e)->xclient.data.l[1] & 0x1UL) == 0)
#define XDND_ENTER_THREE_TYPES_SET(e,b)	(e)->xclient.data.l[1] = ((e)->xclient.data.l[1] & ~0x1UL) | (((b) == 0) ? 0 : 0x1UL)
#define XDND_ENTER_VERSION(e)		((e)->xclient.data.l[1] >> 24)
#define XDND_ENTER_VERSION_SET(e,v)	(e)->xclient.data.l[1] = ((e)->xclient.data.l[1] & ~(0xFF << 24)) | ((v) << 24)
#define XDND_ENTER_TYPE(e,i)		((e)->xclient.data.l[2 + i])	/* i => (0, 1, 2) */

/* XdndPosition */
#define XDND_POSITION_SOURCE_WIN(e)	((e)->xclient.data.l[0])
#define XDND_POSITION_ROOT_X(e)		((e)->xclient.data.l[2] >> 16)
#define XDND_POSITION_ROOT_Y(e)		((e)->xclient.data.l[2] & 0xFFFFUL)
#define XDND_POSITION_ROOT_SET(e,x,y)	(e)->xclient.data.l[2]  = ((x) << 16) | ((y) & 0xFFFFUL)
#define XDND_POSITION_TIME(e)		((e)->xclient.data.l[3])
#define XDND_POSITION_ACTION(e)		((e)->xclient.data.l[4])

/* XdndStatus */
#define XDND_STATUS_TARGET_WIN(e)	((e)->xclient.data.l[0])
#define XDND_STATUS_WILL_ACCEPT(e)	((e)->xclient.data.l[1] & 0x1L)
#define XDND_STATUS_WILL_ACCEPT_SET(e,b) (e)->xclient.data.l[1] = ((e)->xclient.data.l[1] & ~0x1UL) | (((b) == 0) ? 0 : 0x1UL)
#define XDND_STATUS_WANT_POSITION(e)	((e)->xclient.data.l[1] & 0x2UL)
#define XDND_STATUS_WANT_POSITION_SET(e,b) (e)->xclient.data.l[1] = ((e)->xclient.data.l[1] & ~0x2UL) | (((b) == 0) ? 0 : 0x2UL)
#define XDND_STATUS_RECT_X(e)		((e)->xclient.data.l[2] >> 16)
#define XDND_STATUS_RECT_Y(e)		((e)->xclient.data.l[2] & 0xFFFFL)
#define XDND_STATUS_RECT_WIDTH(e)	((e)->xclient.data.l[3] >> 16)
#define XDND_STATUS_RECT_HEIGHT(e)	((e)->xclient.data.l[3] & 0xFFFFL)
#define XDND_STATUS_RECT_SET(e,x,y,w,h)	{(e)->xclient.data.l[2] = ((x) << 16) | ((y) & 0xFFFFUL); (e)->xclient.data.l[3] = ((w) << 16) | ((h) & 0xFFFFUL); }
#define XDND_STATUS_ACTION(e)		((e)->xclient.data.l[4])

/* XdndLeave */
#define XDND_LEAVE_SOURCE_WIN(e)	((e)->xclient.data.l[0])

/* XdndDrop */
#define XDND_DROP_SOURCE_WIN(e)		((e)->xclient.data.l[0])
#define XDND_DROP_TIME(e)		((e)->xclient.data.l[2])

/* XdndFinished */
#define XDND_FINISHED_TARGET_WIN(e)	((e)->xclient.data.l[0])



///////////////////////Classes//////////////////////////////////////

const int MAX_WINS=            100; //Maximum number or dnd windows.
const int MAX_TYPES=            20; //Maximum number of different types supported by app
const int MAX_TYPES_PER_ITEM=   10; //Maximum number of different types for each app window

class DndManager;
class DndObject;

struct DndData
{
  char*  data;
  int    len;
  Atom   type;
  char** file_list;
  int    file_listlen;
  DndData(char* idata, int ilen,Atom itype)
  {
    len=ilen;
    data=new char[len+1];
    strncpy(data,idata,len);
    data[len]=0;
    type=itype;
    file_list=0;
    file_listlen=0;
  };
  ~DndData() { delete data; free_file_list();};
  int break_to_filelist();
  void free_file_list();
  int  calc_entries(char* dat, char sym);
  void show_filelist();
};


struct DndWin
{
  Window        w;
  DndManager*   man;
  DndObject*    obj;
  int           rx,ry;
  uint          l,h;
  Atom*         typelist;

  DndWin(DndManager* iman,Window iw, DndObject *o, int ix, int iy, uint il, uint ih);
  DndWin(DndManager* iman,Window iw, int ix, int iy, uint il, uint ih);
  ~DndWin() {delete typelist;};
  
  void add_type(char*);
  int  check_type(Atom);
  
};

class DndObject
{
 protected:
  DndWin*       dndwin;
  DndManager*   dndman;
 public:
  DndObject() { dndwin=0;dndman=0;};

  virtual void  dnd_init(DndWin* iwin, DndManager* iman) { dndwin=iwin; dndman=iman;};

  virtual int   dnd_enter(XEvent*, int x, int y);
  virtual int   dnd_leave(XEvent*, int x, int y);
  virtual int   dnd_position(XEvent*, int newx, int newy);
  virtual int   dnd_drop(DndData*, int x, int y, Atom action);
};

class DndManager
{
 protected:
  int             version;


  Display*        disp;
  Window          rootw;

  Window          srcwin;    //source window that provides the data
  int             curtype;   //current input type of data 
  int             curx, cury;
  Atom            curaction;
  DndWin*         curwin;

  DndWin**        winar;

  Atom*           typelist;
  Atom*           our_in_typelist;
  
  Atom            XdndAware;
  Atom            XdndSelection;
  Atom            XdndEnter;
  Atom            XdndLeave;
  Atom            XdndPosition;
  Atom            XdndDrop;
  Atom            XdndFinished;
  Atom            XdndStatus;
  Atom            XdndActionCopy;
  Atom            XdndActionMove;
  Atom            XdndActionLink;
  Atom            XdndActionAsk;
  Atom            XdndActionPrivate;
  Atom            XdndTypeList;
  Atom            XdndActionList;
  Atom            XdndActionDescription;
  
  Atom            dnd_data_atom;
  char*           dnd_data;

  void            make_dnd_aware();
  int             find_win_idx(Window);
  DndWin*         find_dnd_win(int rx, int ry, Atom action);
  int             new_idx();
  void            trace_win_geom(Window w, int& x, int& y, uint& l, uint& h);
  int             process_XdndEnter(XEvent* ev, Window srcw, int version);
  int             process_XdndPosition(XEvent* ev, Window srcw);
  int             process_XdndLeave(XEvent*);
  int             process_XdndDrop(XEvent* ev);
  int             build_bigtype_list(XEvent* ev,Window srcw);
  int             build_threetype_list(XEvent* ev,Window srcw);
  int             check_type_list(XEvent* ev);
  int             data_ready_get_it();
  int             try_convert_drag_data(XEvent* ev,Window srcw);
  int             send_status(int will_accept,Atom action=None,
			      int want_position=0, int x=0, int y=0, 
			      uint l=0, uint h=0);
  int             send_finished();
  void            send_event(XEvent& ev);
  DndWin*         add_dnd_win(Window w);


 public:
    DndManager(Display*,Window);
    ~DndManager();
    
    DndWin*         add_dnd_object(DndObject* o, Window w);
    void            del_dnd_win(Window w);
    int             process_event(XEvent* e);
    void            add_in_type(Atom intype);
    void            add_in_type(char* intypename);
    void            debug_atom(Atom);
    void            update_geoms();
    int             move_to_top(Window w);
    void            global2win_coords(Window w, int fromx, int fromy, int& x, int& y);
    Display*        display() { return disp;};
};

extern DndManager* default_dnd_man;

#endif
/* ------------ End of file -------------- */

