#ifndef XH_H
#define XH_H

#include "globals.h"

#include <X11/Xlib.h>
#include <X11/Xutil.h>
#include <X11/Xatom.h>
#include <X11/Xresource.h>
#ifdef HAVE_X11_EXTENSIONS_SHAPE_H
#include <X11/extensions/shape.h>
#endif
#include <X11/keysym.h>

#include <X11/Xlocale.h>

#include "systemfuncs.h"

#define BDWIDTH   1
#define XNC_DIR "/usr/local/lib"
extern char host[];
typedef struct X_PAR
{
 char *name;
 char *cname;
 char *pstr;
} X_PAR;

extern char 
     bgchr[],
     fgchr[],
     fontchr[],
     kbgchr[],
     *dispchr,
     selectchr[],
     editname[],
     viewname[];

extern int viewx,viewy;
extern int ScreenL,ScreenH;
extern uint viewh,viewl;
extern char rfile[80];
extern char tmppath[];
extern char ver[];
extern char **menunames,**menucom;
extern int menumax;
extern int extmax;
extern int centerx,centery,vcenterx,vcentery, wm_y_correction;
extern char magic_file_location[];

//global vars for comand line options.
extern int margc;
extern char** margv;
extern int allow_t_raising;
  
extern unsigned long keyscol[];
extern unsigned long cols[];
extern unsigned long skincol[];

extern XFontStruct *fontstr;
extern XFontStruct *lfontstr;
extern XFontStruct *fixfontstr;
extern XFontStruct *vfontstr;
extern XFontStruct *mfixfontstr;
extern unsigned long bgpix,fgpix,selectpix;
extern int  init_starts, xnc_starts;

extern XWMHints         *pxwmh;
extern XSizeHints       *pxsh;
extern XClassHint       *pch;
extern XTextProperty    wname;
extern XTextProperty    iname;
extern Display          *disp;
extern Window           Main;
extern GC               gc;
extern XGCValues        gcv;
extern XEvent           ev;
extern XColor           color;
extern Colormap         defcmp;
extern int              scr;
extern int allow_animation;
extern int allow_bookmark;
extern int allow_dir_icon;
extern int allow_file_icon;
extern int              done;
extern char home_files_dir[];
extern char syspath[];
extern int              Mainl,Mainh,Mainx,Mainy;

#include "gui.h"

struct List
{
 Gui *obj;
 Window w;
 List *next,*prev;
 List() {next=prev=NULL;obj=NULL;};
};

extern int        use_prompt;
extern int        term_sticky;

extern int        option_bits;

extern List el, l_exp;
extern char **extcom;
extern Gui* find(Window ww);
extern Gui* findexp(Window ww);
extern void addto_el(Gui* o,Window w);
extern void addto_exp(Gui* o,Window w);
extern void delall_el();
extern void delall_exp();
extern void delfrom_el(Gui*);
extern void delfrom_exp(Gui*);
extern int   ext_find(char*);
extern int   ext_find2(char*,int);
extern void load_ext();
extern void load_menu();
extern int findmenukey(KeySym);
extern int getps();
extern int getdf(Panel*);
extern int getfree(Panel*);
extern void delps(int);
extern void man_page();
 
/////////////////////////////////////////////////////////////////////////

extern unsigned long gencol(XColor& col,int per);
extern void InitXClient(int argc,char** argv,int wx,int wy,int wl,int wh,char* winname=NULL);
extern Window create_win(char*,int,int,int,int,int,int=1);
extern void DeinitXClient();
extern void msg(char*,char*,int,FList *o=NULL);
extern void find_panel(int=540);
extern "C" void tt_printf(char *fmt,...);
extern "C" void tt_write(unsigned char *buf, int count);
extern "C" int psystem(char *);
extern "C" void process_x_event(XEvent *);
extern "C" void set_cmdchild_signal();
extern "C" int is_term_on();
extern int str_casecmp(char*,char*);

extern void XEVENT();

extern int is_new_version();

//////////////////////////////////End of file/////////////////////////////
#endif
        
